/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.messaging.ID;
import weblogic.messaging.common.IDFactory;
import weblogic.messaging.common.MessagingUtilities;

public class IDImpl
implements ID {
    static final long serialVersionUID = 1531949956170006912L;
    private static final byte WL6_VERSION = 1;
    private static final byte EXTVERSION = 2;
    private static final int SEED_SHIFT = 45;
    private static final long SEED_MASK = 262143L;
    private static final long TIMESTAMP_MASK = 0x1FFFFFFFFFFFL;
    protected long unique;
    protected int counter;

    public IDImpl(IDFactory iDFactory) {
        iDFactory.initId(this);
    }

    public IDImpl(long l, int n, int n2) {
        this.init(l, n, n2);
    }

    void init(long l, int n, int n2) {
        this.unique = ((long)n & 0x3FFFFL) << 45 | l;
        this.counter = n2;
    }

    public long getTimestamp() {
        return this.unique & 0x1FFFFFFFFFFFL;
    }

    public int getSeed() {
        return (int)(this.unique >> 45);
    }

    public int getCounter() {
        return this.counter;
    }

    public IDImpl() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(2);
        objectOutput.writeLong(this.unique);
        objectOutput.writeInt(this.counter);
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        byte by = objectInput.readByte();
        if (by == 1) {
            this.unique = objectInput.readLong();
            int n = objectInput.readInt();
            this.unique |= ((long)n & 0x3FFFFL) << 45;
            objectInput.readInt();
            objectInput.readInt();
            this.counter = objectInput.readInt();
        } else if (by == 2) {
            this.unique = objectInput.readLong();
            this.counter = objectInput.readInt();
        } else {
            throw MessagingUtilities.versionIOException(by, 1, 2);
        }
    }

    public String toString() {
        return "<" + this.unique + "." + this.counter + ">";
    }

    public boolean equals(Object object) {
        IDImpl iDImpl = (IDImpl)object;
        return this.counter == iDImpl.counter && this.unique == iDImpl.unique;
    }

    public int compareTo(Object object) {
        IDImpl iDImpl = (IDImpl)object;
        if (this.unique < iDImpl.unique) {
            return -1;
        }
        if (this.unique > iDImpl.unique) {
            return 1;
        }
        if (this.counter < iDImpl.counter) {
            return -1;
        }
        if (this.counter > iDImpl.counter) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(this.unique ^ (long)this.counter);
    }
}

