/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.CrossDomainUtil;

public class CrossDomainManager {
    private static final String T3CLIENT_UTIL_CLASS = "weblogic.messaging.dispatcher.T3ClientCrossDomainUtil";
    private static final String IIOPCLIENT_UTIL_CLASS = "weblogic.messaging.dispatcher.IIOPClientCrossDomainUtil";
    private static final String SERVER_UTIL_CLASS = "weblogic.messaging.dispatcher.ServerCrossDomainUtil";
    private static CrossDomainUtil util;

    static void ensureInitialized() {
        Class<?> clazz;
        if (KernelStatus.isServer()) {
            try {
                clazz = Class.forName(SERVER_UTIL_CLASS, true, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        try {
            clazz = Class.forName(T3CLIENT_UTIL_CLASS, true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(IIOPCLIENT_UTIL_CLASS, true, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new AssertionError((Object)classNotFoundException2);
            }
        }
        try {
            util = (CrossDomainUtil)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
    }

    public static CrossDomainUtil getCrossDomainUtil() {
        return util;
    }

    static {
        CrossDomainManager.ensureInitialized();
    }
}

