/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.messaging.common.MessagingUtilities;

public class DispatcherId
implements Externalizable,
Comparable {
    static final long serialVersionUID = 2503587581403689795L;
    private String name;
    private String id;
    private int hashCode;
    private transient int counter;
    private static final byte EXTVERSION0 = 0;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION = 2;
    private static final int VERSION_MASK = 15;
    private static final int ID_FLAG = 16;

    public DispatcherId(String string, String string2) {
        this.name = string;
        this.id = string2;
        String string3 = string + string2;
        this.hashCode = string3.hashCode();
    }

    public DispatcherId(DispatcherId dispatcherId, int n) {
        this.name = dispatcherId.name;
        this.id = dispatcherId.id;
        this.hashCode = dispatcherId.hashCode();
        this.counter = n;
    }

    public final int compareTo(Object object) {
        DispatcherId dispatcherId = (DispatcherId)object;
        int n = dispatcherId.hashCode;
        if (this.hashCode < n) {
            return -1;
        }
        if (this.hashCode > n) {
            return 1;
        }
        if (this.name.length() < dispatcherId.name.length()) {
            return -1;
        }
        if (this.name.length() > dispatcherId.name.length()) {
            return 1;
        }
        int n2 = this.name.compareTo(dispatcherId.name);
        if (n2 != 0) {
            return n2;
        }
        if (this.id != null && dispatcherId.id != null) {
            if (this.id.length() < dispatcherId.id.length()) {
                return -1;
            }
            if (this.id.length() > dispatcherId.id.length()) {
                return 1;
            }
            n2 = this.id.compareTo(dispatcherId.id);
            if (n2 != 0) {
                return n2;
            }
        }
        if (this.counter == dispatcherId.counter) {
            return 0;
        }
        if (this.counter < dispatcherId.counter) {
            return -1;
        }
        return 1;
    }

    public final String getName() {
        return this.name;
    }

    public final String getId() {
        return this.id;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DispatcherId)) {
            return false;
        }
        return this.internalEquals((DispatcherId)object, true);
    }

    public final boolean isSameServer(Object object) {
        if (!(object instanceof DispatcherId)) {
            return false;
        }
        return this.internalEquals((DispatcherId)object, false);
    }

    private boolean internalEquals(DispatcherId dispatcherId, boolean bl) {
        if (this == dispatcherId) {
            return true;
        }
        if (this.hashCode != dispatcherId.hashCode) {
            return false;
        }
        if (bl && this.counter != dispatcherId.counter) {
            return false;
        }
        return this.name.equals(dispatcherId.name) && (this.id == null || dispatcherId.id == null || this.id != null && dispatcherId.id != null && this.id.equals(dispatcherId.id));
    }

    public final String toString() {
        return this.name;
    }

    public DispatcherId() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getVersion(objectOutput);
        if (n == 2) {
            if (this.id != null) {
                objectOutput.writeByte(18);
            } else {
                objectOutput.writeByte(2);
            }
            objectOutput.writeUTF(this.name);
            objectOutput.writeInt(this.hashCode);
            if (this.id != null) {
                objectOutput.writeUTF(this.id);
            }
        } else {
            objectOutput.writeByte(1);
            objectOutput.writeUTF(this.name);
            objectOutput.writeInt(this.hashCode);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0xF);
        if (by2 != 1 && by2 != 2) {
            throw MessagingUtilities.versionIOException(by2, 1, 2);
        }
        this.name = objectInput.readUTF();
        this.hashCode = objectInput.readInt();
        if ((by & 0x10) != 0) {
            this.id = objectInput.readUTF();
        }
    }

    protected int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            int n = peerInfo.getMajor();
            if (n <= 8) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    public final String getHostAddress() {
        try {
            int n = this.name.indexOf(":");
            if (n != -1) {
                String string = this.name.substring(n + 1, this.name.length());
                string = string.substring(0, string.indexOf(":"));
                return InetAddress.getByName(string).getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0.0.0.0";
    }

    public String getDetail() {
        return "id = " + this.id + ", name = " + this.name + ", counter=" + this.counter + ", hashcode = " + this.hashCode;
    }
}

