/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.transaction.Transaction;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.common.JMSDebug;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherOneWay;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.FastDispatcherImpl;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.work.WorkManager;

public class DispatcherImpl
implements Dispatcher,
DispatcherRemote,
DispatcherOneWay,
InteropWriteReplaceable {
    private final String name;
    private final DispatcherId dispatcherId;
    private static final ClientTransactionManager tm = TransactionHelper.getTransactionHelper().getTransactionManager();
    public static final boolean TESTXA = false;
    private Object fastDispatcher;
    private final WorkManager workManager;
    private final WorkManager oneWayWorkManager;
    private final String objectHandlerClassName;
    private static final boolean FASTDISPATCH = DispatcherImpl.fastDispatchEnabled();

    protected DispatcherImpl(String string, DispatcherId dispatcherId, WorkManager workManager, WorkManager workManager2, String string2) {
        this.name = string;
        this.workManager = workManager;
        this.oneWayWorkManager = workManager2;
        this.objectHandlerClassName = string2;
        this.dispatcherId = dispatcherId;
    }

    public String getName() {
        return this.name;
    }

    WorkManager getWorkManager() {
        return this.workManager;
    }

    WorkManager getOneWayWorkManager() {
        return this.oneWayWorkManager;
    }

    String getObjectHandlerClassName() {
        return this.objectHandlerClassName;
    }

    void export() {
        try {
            PortableRemoteObject.exportObject(this);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void unexport() {
        try {
            PortableRemoteObject.unexportObject(this);
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)remoteException);
        }
    }

    public DispatcherId getId() {
        return this.dispatcherId;
    }

    public boolean isLocal() {
        return true;
    }

    public void dispatchAsync(Request request) {
        block2: {
            request.setTranInfo(2);
            try {
                DispatcherImpl.dispatchAsyncInternal(request, tm.getTransaction(), true);
            }
            catch (Exception exception) {
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) break block2;
                JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsync(): " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void dispatchAsyncInternal(Request request, Transaction transaction, boolean bl) {
        try {
            try {
                request.wrappedFiniteStateMachine();
            }
            catch (Throwable throwable) {
                request.notifyResult(throwable, false);
                Object var5_4 = null;
                if (!bl) return;
                DispatcherImpl.cautiousResume(request, transaction);
                return;
            }
            Object var5_3 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!bl) throw throwable;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void cautiousResume(Object object, Transaction transaction) {
        try {
            Transaction transaction2 = tm.forceSuspend();
            if (transaction2 != null && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("DispatcherImpl.cautiousResume(): " + object + " retained " + transaction2);
            }
            Object var4_3 = null;
            if (transaction != null) {
                tm.forceResume(transaction);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (transaction != null) {
                tm.forceResume(transaction);
            }
            throw throwable;
        }
    }

    public void dispatchNoReply(Request request) {
        Transaction transaction = tm.forceSuspend();
        DispatcherImpl.dispatchAsyncInternal(request, transaction, true);
    }

    public void dispatchNoReplyWithId(Request request, int n) {
        Transaction transaction = tm.forceSuspend();
        DispatcherImpl.dispatchAsyncInternal(request, transaction, true);
    }

    private Response syncRequest(Request request) throws DispatcherException {
        try {
            Response response = request.wrappedFiniteStateMachine();
            if (response != request) {
                return response;
            }
            return request.getResult();
        }
        catch (RuntimeException runtimeException) {
            request.complete(runtimeException, false);
            throw runtimeException;
        }
        catch (Error error) {
            request.complete(error, false);
            throw error;
        }
        catch (DispatcherException dispatcherException) {
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
        catch (Throwable throwable) {
            DispatcherException dispatcherException = new DispatcherException(throwable);
            request.complete(dispatcherException, false);
            throw dispatcherException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSync(Request request) throws DispatcherException {
        Response response;
        Transaction transaction = null;
        transaction = tm.forceSuspend();
        request.setTranInfo(2);
        request.setSyncRequest(true);
        try {
            response = this.syncRequest(request);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSyncTran(Request request) throws DispatcherException {
        Response response;
        Transaction transaction = null;
        try {
            transaction = tm.getTransaction();
        }
        catch (Exception exception) {
            throw new DispatcherException(exception);
        }
        request.setTranInfo(2);
        request.setSyncRequest(true);
        try {
            response = this.syncRequest(request);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
        return response;
    }

    public Response dispatchSyncFuture(Request request) throws RemoteException {
        throw new Error("compiler error");
    }

    public void dispatchSyncFuture(Request request, FutureResponse futureResponse) {
        request.setTranInfo(0);
        request.setFutureResponse(futureResponse);
        request.setSyncRequest(true);
        DispatcherImpl.dispatchAsyncInternal(request, null, false);
    }

    public Response dispatchSyncTranFuture(Request request) throws RemoteException {
        throw new Error("compiler error");
    }

    public Response dispatchSyncTranFutureWithId(Request request, int n) throws RemoteException {
        throw new Error("compiler error");
    }

    public void dispatchSyncTranFuture(Request request, FutureResponse futureResponse) {
        request.setTranInfo(2);
        request.setFutureResponse(futureResponse);
        request.setSyncRequest(true);
        DispatcherImpl.dispatchAsyncInternal(request, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSyncNoTran(Request request) throws DispatcherException {
        Response response;
        Transaction transaction = tm.forceSuspend();
        request.setSyncRequest(true);
        try {
            response = this.syncRequest(request);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dispatchSyncNoTranWithId(Request request, int n) throws DispatcherException {
        Response response;
        Transaction transaction = tm.forceSuspend();
        request.setSyncRequest(true);
        try {
            response = this.syncRequest(request);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
        return response;
    }

    public Response dispatchSyncNoTranFuture(Request request) throws RemoteException {
        throw new Error("compiler error");
    }

    public void dispatchSyncNoTranFuture(Request request, FutureResponse futureResponse) {
        request.setTranInfo(0);
        request.setFutureResponse(futureResponse);
        request.setSyncRequest(true);
        DispatcherImpl.dispatchAsyncInternal(request, null, false);
    }

    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult) {
        throw new Error("compiler error");
    }

    public void dispatchAsyncFuture(Request request, AsyncResult asyncResult, FutureResponse futureResponse) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncFuture() : " + request);
        }
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(futureResponse);
        DispatcherImpl.dispatchAsyncInternal(request, null, false);
    }

    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult) {
        throw new AssertionError((Object)"compiler error");
    }

    public void dispatchAsyncTranFuture(Request request, AsyncResult asyncResult, FutureResponse futureResponse) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("DispatcherImpl.dispatchAsyncFuture() : " + request);
        }
        request.setTranInfo(2);
        request.setAsyncResult(asyncResult);
        request.setFutureResponse(futureResponse);
        DispatcherImpl.dispatchAsyncInternal(request, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOneWayWithId(Request request, int n) {
        Transaction transaction = tm.forceSuspend();
        try {
            DispatcherImpl.dispatchAsyncInternal(request, transaction, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOneWay(Request request) {
        Transaction transaction = tm.forceSuspend();
        try {
            DispatcherImpl.dispatchAsyncInternal(request, transaction, true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DispatcherImpl.cautiousResume(request, transaction);
            throw throwable;
        }
        DispatcherImpl.cautiousResume(request, transaction);
    }

    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener dispatcherPeerGoneListener) {
        return null;
    }

    public void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener dispatcherPeerGoneListener) {
    }

    public final int hashCode() {
        return this.dispatcherId.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DispatcherImpl) {
            DispatcherImpl dispatcherImpl = (DispatcherImpl)object;
            return this == dispatcherImpl || (this.dispatcherId == dispatcherImpl.getId() || this.dispatcherId.equals(dispatcherImpl.getId())) && (this.name == dispatcherImpl.getName() || this.name.equals(dispatcherImpl.getName()));
        }
        return false;
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (FASTDISPATCH && peerInfo.compareTo(PeerInfo.VERSION_DIABLO) >= 0 && !KernelStatus.isApplet()) {
            if (this.fastDispatcher == null) {
                this.fastDispatcher = new FastDispatcherImpl(this.name, this.dispatcherId, this);
            }
            return this.fastDispatcher;
        }
        return this;
    }

    static boolean fastDispatchEnabled() {
        String string = "JMSFastDispatchEnabled";
        try {
            boolean bl;
            String string2 = System.getProperty(string);
            boolean bl2 = bl = string2 == null || !string2.equalsIgnoreCase("false");
            if (string2 != null) {
                System.out.println("\n\n *** -D" + string + "=" + bl + " *** \n\n");
            }
            return bl;
        }
        catch (Throwable throwable) {
            new RuntimeException("error processing " + string).printStackTrace();
            return true;
        }
    }
}

