/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.util.HashMap;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Invocable;

public abstract class InvocableManager {
    private HashMap[] INVOCABLE_MAPS;
    private String[] INVOCABLE_STRINGS;
    private int[] invocablesHighCount;
    private int[] invocablesTotalCount;
    private Invocable[] managers;
    public int INVOCABLE_TYPE_MASK;
    public int INVOCABLE_METHOD_MASK;
    public static final int DISPATCHER_MANAGER = 0;
    public static final int DSP_HANDSHAKE_HELLO = 15872;
    public static final int DSP_HANDSHAKE_METHOD_MASK = 0xFFFF00;

    protected InvocableManager(HashMap[] hashMapArray, String[] stringArray, int[] nArray, int[] nArray2, int n, int n2, Invocable[] invocableArray) {
        this.INVOCABLE_MAPS = hashMapArray;
        this.INVOCABLE_STRINGS = stringArray;
        this.invocablesHighCount = nArray;
        this.invocablesTotalCount = nArray2;
        this.INVOCABLE_TYPE_MASK = n;
        this.INVOCABLE_METHOD_MASK = n2;
        this.managers = invocableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocableAdd(int n, Invocable invocable) throws Exception {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = this.INVOCABLE_MAPS[n];
        synchronized (hashMap2) {
            Invocable invocable2 = hashMap.put(invocable.getId(), invocable);
            if (invocable2 == null) {
                if (hashMap.size() > this.invocablesHighCount[n]) {
                    this.invocablesHighCount[n] = hashMap.size();
                }
                int n2 = n;
                this.invocablesTotalCount[n2] = this.invocablesTotalCount[n2] + 1;
                return;
            }
            if (invocable == invocable2) {
                return;
            }
            hashMap.put(invocable2.getId(), invocable2);
        }
        throw new Exception(this.INVOCABLE_STRINGS[n] + " already exists");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invocable invocableFind(int n, ID iD) throws Exception {
        HashMap hashMap = this.INVOCABLE_MAPS[n];
        if (hashMap != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                Invocable invocable = (Invocable)hashMap.get(iD);
                if (invocable != null) {
                    return invocable;
                }
            }
        } else if (this.isManager(n)) {
            return this.managers[n];
        }
        throw new Exception(this.INVOCABLE_STRINGS[n] + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invocable invocableRemove(int n, ID iD) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = this.INVOCABLE_MAPS[n];
        synchronized (hashMap2) {
            return (Invocable)hashMap.remove(iD);
        }
    }

    public HashMap getInvocableMap(int n) {
        return this.INVOCABLE_MAPS[n];
    }

    public int getInvocablesCurrentCount(int n) {
        return this.INVOCABLE_MAPS[n].size();
    }

    public int getInvocablesHighCount(int n) {
        return this.invocablesHighCount[n];
    }

    public int getInvocablesTotalCount(int n) {
        return this.invocablesTotalCount[n];
    }

    protected abstract boolean isManager(int var1);

    public void addManager(int n, Invocable invocable) {
        this.managers[n] = invocable;
    }
}

