/*
 * Decompiled with CFR 0.152.
 */
package weblogic.messaging.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.jms.common.JMSDebug;
import weblogic.messaging.ID;
import weblogic.messaging.common.IDImpl;
import weblogic.messaging.common.MessagingUtilities;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InteropJMSVoidResponsePreDiablo;
import weblogic.messaging.dispatcher.Invocable;
import weblogic.messaging.dispatcher.InvocableManager;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.dispatcher.VoidResponse;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public abstract class Request
extends Response
implements Runnable,
AsyncResultListener,
Externalizable {
    static final long serialVersionUID = -3580248041850964617L;
    protected ID invocableId;
    protected int methodId;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int INVOCABLE_ID_MASK = 256;
    private static final int CORRELATION_ID_MASK = 512;
    public static final int START = 0;
    public static final int FINISH = 2;
    public static final int COMPLETED = Integer.MAX_VALUE;
    public static final int REMOTE = -42;
    private int state;
    private Response result;
    private Throwable throwableResponse;
    private Request parent;
    private Request child;
    protected Request next;
    private int numWaiting;
    private int numChildren;
    private boolean isCollocated;
    private boolean running;
    private WorkManager workManager;
    private boolean isSyncRequest;
    private AsyncResult asyncResult;
    private FutureResponse futureResponse;
    private boolean needFillInStackTrace;
    private int tranInfo;
    public static final int NO_TRAN = 0;
    public static final int HAVE_TRAN = 1;
    public static final int DONT_KNOW_IF_TRAN = 2;
    private Transaction transaction;
    private Invocable invocable;
    private InvocableMonitor invocableMonitor;
    private InvocableManager appInvocableManager;
    private InteropJMSVoidResponsePreDiablo appVoidResponse;
    private boolean shortened;
    private volatile boolean parentResumeNewThread;
    private CompletionListener completionListener;
    private static WorkManager workManagerDefault = WorkManagerFactory.getInstance().getSystem();
    static boolean TODOSAGREMOVEreportOnce = true;
    static SimpleDateFormat sdf = new SimpleDateFormat("(EEEMMMdd,HH:mm:ss)");
    public static final int RMI_TRANSACTION = 1;
    public static final int RMI_FUTURE_RESPONSE = 2;
    public static final int RMI_SYNC = 16;
    public static final int RMI_ASYNC_RESULT = 32;
    public static final int RMI_ONEWAY = 64;

    public Request(ID iD, int n, InvocableManager invocableManager) {
        this(iD, n, new VoidResponse(), invocableManager);
    }

    public Request(ID iD, int n, InteropJMSVoidResponsePreDiablo interopJMSVoidResponsePreDiablo, InvocableManager invocableManager) {
        this.invocableId = iD;
        this.methodId = n;
        this.result = this;
        this.isCollocated = true;
        this.appVoidResponse = interopJMSVoidResponsePreDiablo;
        this.appInvocableManager = invocableManager;
    }

    public final void setAppVoidResponse(InteropJMSVoidResponsePreDiablo interopJMSVoidResponsePreDiablo) {
        this.appVoidResponse = interopJMSVoidResponsePreDiablo;
    }

    public final void setAppInvocableManager(InvocableManager invocableManager) {
        this.appInvocableManager = invocableManager;
    }

    InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public final void setInvocableId(ID iD) {
        this.invocableId = iD;
    }

    public final ID getInvocableId() {
        return this.invocableId;
    }

    public final void setMethodId(int n) {
        this.methodId = n;
    }

    public final int getMethodId() {
        return this.methodId;
    }

    public final void clearResult() {
        this.result = this;
        this.throwableResponse = null;
    }

    public final void clearState() {
        this.result = this;
        this.throwableResponse = null;
        this.setNumChildren(0);
    }

    private int getNumChildren() {
        return this.numChildren;
    }

    private void setNumChildren(int n) {
        this.numChildren = n;
    }

    int incNumChildren() {
        return ++this.numChildren;
    }

    private int decNumChildren() {
        return --this.numChildren;
    }

    protected WorkManager getWorkManager() {
        if (this.workManager != null) {
            return this.workManager;
        }
        return this.getDefaultWorkManager();
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    protected WorkManager getDefaultWorkManager() {
        return workManagerDefault;
    }

    public final boolean hasResults() {
        return this.result != this || this.throwableResponse != null;
    }

    public final void setResult(Response response) {
        this.result = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyResult(Throwable throwable, boolean bl) {
        InvocableMonitor invocableMonitor;
        boolean bl2;
        Request request;
        Request request2 = this;
        synchronized (request2) {
            request = this.childResult(throwable, bl);
            bl2 = this.parentResumeNewThread;
            invocableMonitor = this.invocableMonitor;
        }
        this.doExecute(request, bl2, invocableMonitor);
    }

    private void doExecute(Request request, boolean bl, InvocableMonitor invocableMonitor) {
        if (invocableMonitor != null) {
            this.clearInvocableMonitor();
        }
        if (request == this) {
            if (bl) {
                this.getWorkManager().schedule(this);
            } else {
                this.run();
            }
        } else if (request != null) {
            request.resumeExecution(bl);
        }
    }

    Request childResult(Response response) {
        if (this.throwableResponse == null && (this.result == this || this.result == null && response != null || this.result instanceof InteropJMSVoidResponsePreDiablo && !(response instanceof InteropJMSVoidResponsePreDiablo))) {
            this.setResult(response);
        }
        return this.decrementNumChildren();
    }

    private Request childResult(Throwable throwable, boolean bl) {
        if (this.throwableResponse == null) {
            this.throwableResponse = throwable;
            this.needFillInStackTrace = bl;
            if (this.getNumChildren() > 1 || this.futureResponse != null) {
                this.setNumChildren(1);
            }
        }
        return this.decrementNumChildren();
    }

    void complete(Throwable throwable, boolean bl) {
        this.setParentResumeNewThread(true);
        this.notifyResult(throwable, bl);
    }

    private Request decrementNumChildren() {
        if (this.getNumChildren() > 0) {
            if (this.decNumChildren() == 0) {
                if (this.numWaiting > 0) {
                    this.notifyAll();
                }
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    JMSDebug.JMSDispatcher.debug("Request():: decrementNumChildren/true ZERO numChildren=" + this.getNumChildren() + " state=" + this.dbgState(this.state) + " running=" + this.isRunning() + " this=" + this + " parent=" + this.parent);
                }
                if (this.state == -42) {
                    this.setState(Integer.MAX_VALUE);
                    this.doCompletionListener(true);
                    return this.parent;
                }
                if (this.isRunning()) {
                    return null;
                }
                return this;
            }
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Request():: decrementNumChildren/true POSITIVE numChildren=" + this.getNumChildren() + " state=" + this.dbgState(this.state) + " running=" + this.isRunning() + " " + this);
            }
        } else {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Request():: decrementNumChildren/true IGNORED numChildren=" + this.getNumChildren() + " state=" + this.dbgState(this.state) + " running=" + this.isRunning() + " " + this);
            }
            this.notifyAll();
        }
        return null;
    }

    boolean hasListener() {
        return this.completionListener != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCompletionListener(boolean bl) {
        Throwable throwable;
        Response response;
        CompletionListener completionListener;
        Request request = this;
        synchronized (request) {
            if (this.completionListener == null) {
                return;
            }
            completionListener = this.completionListener;
            this.completionListener = null;
            response = this.result;
            throwable = this.throwableResponse;
            if (bl) {
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        Request.runCompletionListener(completionListener, throwable, response);
                    }
                });
                return;
            }
        }
        Request.runCompletionListener(completionListener, throwable, response);
    }

    public void rememberChild(Request request) {
        if (this.child != null) {
            if (this.child.throwableResponse != null) {
                return;
            }
            if (request.throwableResponse == null && (this.child.result != null && request.result == null || this.child.result instanceof InteropJMSVoidResponsePreDiablo && !(request.result instanceof InteropJMSVoidResponsePreDiablo))) {
                return;
            }
        }
        this.child = request;
    }

    public Request getChild() {
        return this.child;
    }

    public synchronized void waitForNotRunningResult() {
        if (!(!this.hasResults() || this.isRunning() || this.getState() != Integer.MAX_VALUE && this.getState() != -42 || this.throwableResponse == null && this.getNumChildren() != 0)) {
            return;
        }
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("Request():: waitForNotRunningResult() state=" + this.dbgState(this.state) + ", numChildren=" + this.getNumChildren() + " running=" + this.isRunning() + " " + this);
        }
        this.sleepTillNotified(true);
    }

    private String dbgState(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "START:" + n;
                break;
            }
            case 0x7FFFFFFF: {
                string = "COMPLETED:" + n;
                break;
            }
            case -42: {
                string = "REMOTE:" + n;
                break;
            }
            case 1: {
                string = "CONTINUE:" + n;
                break;
            }
            case 2: {
                string = "TRY || FINISH:" + n;
                break;
            }
            case 3: {
                string = "RETRY:" + n;
                break;
            }
            case 4: {
                string = "AFTER_START_IP:" + n;
                break;
            }
            case 5: {
                string = "AFTER_POST_AUTH_IP:" + n;
                break;
            }
            case 6: {
                string = "RETURN_FROM_START_IP:" + n;
                break;
            }
            case 7: {
                string = "RETURN_FROM_POST_AUTH_IP:" + n;
                break;
            }
            case 8: {
                string = "RELEASE_FANOUT:" + n;
                break;
            }
            case 1101: {
                string = "BEExtension.SEND_WAIT_FOR_COMPLETE:" + n;
                break;
            }
            case 1102: {
                string = "SEND_ISSUE_MESSAGE";
                break;
            }
            case 1103: {
                string = "SEND_COMPLETE:" + n;
                break;
            }
            case 1104: {
                string = "SEND_UNKNOWN:" + n;
                break;
            }
            default: {
                string = "unk:" + n;
            }
        }
        return string;
    }

    public synchronized Response getResult() throws Throwable {
        while (this.result == this && this.throwableResponse == null) {
            this.sleepTillNotified(true);
        }
        if (this.throwableResponse != null) {
            Throwable throwable;
            if (this.throwableResponse instanceof DispatcherException && (throwable = this.throwableResponse.getCause()) != null) {
                this.throwableResponse = throwable;
            }
            if (this.needFillInStackTrace) {
                this.needFillInStackTrace = false;
                this.throwableResponse = StackTraceUtilsClient.getThrowableWithCause(this.throwableResponse);
            }
            throw this.throwableResponse;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void sleepTillNotified(boolean bl) {
        if (bl ? this.hasResults() : this.getNumChildren() < 1) {
            return;
        }
        ++this.numWaiting;
        try {
            try {
                if (this.tranInfo == 1 && this.transaction == null) {
                    this.forceSuspendTransaction();
                }
                while (true) {
                    this.wait();
                    if (bl) {
                        if (!this.hasResults()) continue;
                        Object var5_2 = null;
                        --this.numWaiting;
                        try {
                            if (this.transaction != null) {
                                this.resumeTransaction();
                            }
                            Object var7_5 = null;
                            if (this.numWaiting <= 0) return;
                            this.notify();
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var7_6 = null;
                            if (this.numWaiting <= 0) throw throwable;
                            this.notify();
                            throw throwable;
                        }
                    }
                    if (this.getNumChildren() < 1) break;
                }
                Object var5_3 = null;
                --this.numWaiting;
            }
            catch (InterruptedException interruptedException) {
                RuntimeException runtimeException = new RuntimeException(interruptedException);
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) throw runtimeException;
                JMSDebug.JMSDispatcher.debug(runtimeException.getMessage(), runtimeException);
                throw runtimeException;
            }
            try {}
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (this.numWaiting <= 0) throw throwable;
                this.notify();
                throw throwable;
            }
            if (this.transaction != null) {
                this.resumeTransaction();
            }
            Object var7_7 = null;
            if (this.numWaiting <= 0) return;
            this.notify();
            return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            --this.numWaiting;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                if (this.numWaiting <= 0) throw throwable2;
                this.notify();
                throw throwable2;
            }
            if (this.transaction != null) {
                this.resumeTransaction();
            }
            Object var7_9 = null;
            if (this.numWaiting <= 0) throw throwable;
            this.notify();
            throw throwable;
        }
    }

    public final synchronized void setState(int n) {
        this.state = n;
    }

    public final int getState() {
        return this.state;
    }

    public final void resumeRequest(Throwable throwable, boolean bl) {
        this.notifyResult(throwable, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resumeRequest(Response response) {
        boolean bl;
        Request request;
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("Request():: resumeRequest() " + this + ", has completionListener " + this.completionListener);
        }
        Request request2 = this;
        synchronized (request2) {
            request = this.childResult(response);
            bl = this.parentResumeNewThread;
        }
        this.doExecute(request, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resumeExecution(boolean bl) {
        Request request;
        Request request2 = this;
        synchronized (request2) {
            request = this.decrementNumChildren();
        }
        this.doExecute(request, bl |= this.parentResumeNewThread, null);
    }

    protected abstract Throwable getAppException(String var1, Throwable var2);

    public final void handleResult(AsyncResult asyncResult) {
        Throwable throwable;
        Response response = null;
        Object object = null;
        try {
            object = asyncResult.getObject();
            response = (Response)object;
            throwable = null;
        }
        catch (ClassCastException classCastException) {
            throwable = object instanceof Throwable ? (Throwable)object : this.getAppException("Unexpected remote response" + response, classCastException);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (!this.getParentResumeNewThread()) {
            this.setParentResumeNewThread(true);
            if (TODOSAGREMOVEreportOnce) {
                TODOSAGREMOVEreportOnce = false;
                new Exception("messaging.Request TODOSAGREMOVEreportOnce " + this).printStackTrace();
            }
        }
        if (throwable != null) {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Request.handleResult() : " + this + " " + response);
            }
            this.notifyResult(throwable, true);
        } else {
            this.resumeRequest(response);
        }
    }

    public final synchronized void needOutsideResult() {
        this.incNumChildren();
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("needOutside numChildren = " + this.getNumChildren() + " on " + this);
        }
    }

    public final synchronized boolean fanoutComplete(boolean bl) {
        if (this.decNumChildren() == 0) {
            if (!this.hasResults() && bl) {
                this.setResult((Response)((Object)this.appVoidResponse));
            }
            return false;
        }
        return true;
    }

    public final synchronized boolean fanoutCompleteSuspendIfHaveChildren(boolean bl) {
        if (this.decNumChildren() == 0) {
            if (!this.hasResults() && bl) {
                this.setResult((Response)((Object)this.appVoidResponse));
            }
            return false;
        }
        if (this.transaction == null) {
            this.forceSuspendTransaction();
        }
        return true;
    }

    final void setFutureResponse(FutureResponse futureResponse) {
        this.futureResponse = futureResponse;
    }

    public final void setNext(Request request) {
        this.next = request;
    }

    public final Request getNext() {
        return this.next;
    }

    final Request getParent() {
        return this.parent;
    }

    public boolean isCollocated() {
        return this.isCollocated;
    }

    boolean isSyncRequest() {
        return this.isSyncRequest;
    }

    void setSyncRequest(boolean bl) {
        this.isSyncRequest = bl;
    }

    void setRunning(boolean bl) {
        this.running = bl;
    }

    private boolean isRunning() {
        return this.running;
    }

    public void setListener(CompletionListener completionListener) {
        this.completionListener = completionListener;
    }

    final void setAsyncResult(AsyncResult asyncResult) {
        this.asyncResult = asyncResult;
    }

    public static String timeString() {
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public String TODORemoveName() {
        return this.TODORemove() + " " + this.getClass().getName() + ", numChildren= " + this.getNumChildren() + ", " + ", hasResults()=" + this.hasResults() + ", " + this;
    }

    public String TODORemove() {
        return "@_" + Request.timeString() + " TODO SAG REMOVE Request Thread:" + Thread.currentThread().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final Response wrappedFiniteStateMachine() throws Exception {
        FutureResponse futureResponse;
        AsyncResult asyncResult;
        int n;
        Response response;
        CompletionListener completionListener;
        boolean bl;
        Request request;
        Response response2;
        Throwable throwable;
        block53: {
            block50: {
                block52: {
                    block51: {
                        InvocableMonitor invocableMonitor;
                        block49: {
                            throwable = null;
                            response2 = this;
                            request = null;
                            bl = false;
                            completionListener = null;
                            invocableMonitor = null;
                            response = this;
                            // MONITORENTER : response
                            if (this.isRunning()) {
                                // MONITOREXIT : response
                                return this;
                            }
                            if (this.state == -42) {
                                if (this.throwableResponse != null || this.getNumChildren() == 0 && this.hasResults()) {
                                    n = Integer.MAX_VALUE;
                                    this.setState(Integer.MAX_VALUE);
                                    break block49;
                                } else {
                                    // MONITOREXIT : response
                                    return this;
                                }
                            }
                            if (this.state == Integer.MAX_VALUE || this.throwableResponse != null && (this.futureResponse != null || this.asyncResult != null)) {
                                n = Integer.MAX_VALUE;
                                invocableMonitor = this.invocableMonitor;
                            }
                        }
                        if (this.transaction != null) {
                            this.resumeTransaction();
                        }
                        this.setRunning(true);
                        Request request2 = this.parent;
                        n = -42;
                        // MONITOREXIT : response
                        Request request3 = this;
                        while (request3.isCollocated && request3.parent != null) {
                            if (this == request3) {
                                request3 = request2;
                                continue;
                            }
                            request3 = request3.parent;
                        }
                        while (true) {
                            request = null;
                            try {
                                if (this.invocable == null) {
                                    this.invocable = this.appInvocableManager.invocableFind(this.methodId & this.appInvocableManager.INVOCABLE_TYPE_MASK, this.invocableId);
                                    if (invocableMonitor == null && (invocableMonitor = this.invocable.getInvocableMonitor()) != null) {
                                        invocableMonitor.increment();
                                        response = this;
                                        // MONITORENTER : response
                                        this.invocableMonitor = invocableMonitor;
                                        // MONITOREXIT : response
                                    }
                                }
                                n = this.invocable.invoke(this);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                n = Integer.MAX_VALUE;
                            }
                            response = this;
                            // MONITORENTER : response
                            if (this.state == -42) {
                                if (this.throwableResponse != null || this.getNumChildren() == 0 && this.hasResults()) {
                                    n = Integer.MAX_VALUE;
                                    this.setState(Integer.MAX_VALUE);
                                    this.setRunning(false);
                                } else {
                                    this.setRunning(false);
                                    if (this.transaction == null && (this.tranInfo != 0 || this.hasTransaction())) {
                                        this.forceSuspendTransaction();
                                    }
                                    // MONITOREXIT : response
                                    return this;
                                }
                            }
                            if (n == Integer.MAX_VALUE || this.state == Integer.MAX_VALUE || this.throwableResponse != null) break;
                            if (this.getNumChildren() == 0) {
                                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                                    JMSDebug.JMSDispatcher.debug(" *** run the fsm of " + this + " again ***");
                                }
                                if (this.transaction != null) {
                                    this.resumeTransaction();
                                }
                                // MONITOREXIT : response
                                continue;
                            }
                            if (!request3.isCollocated || !request3.isSyncRequest) break;
                            this.sleepTillNotified(false);
                            if (this.state == Integer.MAX_VALUE || this.throwableResponse != null) break;
                            // MONITOREXIT : response
                        }
                        if (n != Integer.MAX_VALUE && this.state != Integer.MAX_VALUE && this.throwableResponse == null) break block50;
                        n = Integer.MAX_VALUE;
                        this.setState(Integer.MAX_VALUE);
                        this.setRunning(false);
                        asyncResult = this.asyncResult;
                        this.asyncResult = null;
                        futureResponse = this.futureResponse;
                        this.futureResponse = null;
                        completionListener = this.completionListener;
                        this.completionListener = null;
                        if (throwable == null) break block51;
                        if (this.throwableResponse != null) {
                            throwable = this.throwableResponse;
                            break block52;
                        } else {
                            this.throwableResponse = throwable;
                            if (this.getNumChildren() > 0) {
                                this.setNumChildren(0);
                            }
                        }
                        break block52;
                    }
                    if (this.throwableResponse != null) {
                        throwable = this.throwableResponse;
                    } else {
                        response2 = this.result;
                    }
                }
                if (throwable != null) {
                    Throwable throwable3;
                    if (throwable instanceof DispatcherException && (throwable3 = throwable.getCause()) != null) {
                        this.throwableResponse = throwable = throwable3;
                    }
                    if (this.needFillInStackTrace) {
                        this.needFillInStackTrace = false;
                        throwable = StackTraceUtilsClient.getThrowableWithCause(throwable);
                    }
                }
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    JMSDebug.JMSDispatcher.debug("     -- COMPLETED " + this + "--");
                }
                if (this.parent != null) {
                    request = this.parent;
                    bl = this.parentResumeNewThread;
                }
                if (this.numWaiting > 0) {
                    this.notifyAll();
                }
                // MONITOREXIT : response
                break block53;
            }
            if (this.transaction == null && (this.tranInfo != 0 || this.hasTransaction())) {
                this.forceSuspendTransaction();
            }
            this.setRunning(false);
            asyncResult = null;
            futureResponse = null;
            // MONITOREXIT : response
        }
        if (n != Integer.MAX_VALUE) {
            return response2;
        }
        if (request != null) {
            request.resumeExecution(bl || request.parentResumeNewThread);
        }
        if (n != Integer.MAX_VALUE) {
            return response2;
        }
        try {
            Request.runCompletionListener(completionListener, throwable, response2);
            if (asyncResult == null && futureResponse == null) {
                if (throwable != null) {
                    try {
                        response = this.getResult();
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Error error) {
                        throw error;
                    }
                    catch (Throwable throwable4) {
                        throw (Exception)throwable4;
                    }
                    Object var17_18 = null;
                    this.clearInvocableMonitor();
                    return response;
                }
                response = response2;
                Object var17_19 = null;
                this.clearInvocableMonitor();
                return response;
            }
            response = Request.doRMIResponse(this, throwable, response2, asyncResult, futureResponse);
            Object var17_20 = null;
            this.clearInvocableMonitor();
            return response;
        }
        catch (Throwable throwable5) {
            Object var17_21 = null;
            this.clearInvocableMonitor();
            throw throwable5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearInvocableMonitor() {
        InvocableMonitor invocableMonitor;
        Request request = this;
        synchronized (request) {
            if (this.invocableMonitor == null) {
                return;
            }
            invocableMonitor = this.invocableMonitor;
            this.invocableMonitor = null;
        }
        invocableMonitor.decrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response doRMIResponse(Request request, Throwable throwable, Response response, AsyncResult asyncResult, FutureResponse futureResponse) {
        block17: {
            try {
                if (throwable != null && futureResponse != null) {
                    futureResponse.sendThrowable(new DispatcherException(throwable));
                    break block17;
                }
                if (asyncResult != null) {
                    try {
                        if (throwable != null) {
                            asyncResult.setResult(new DispatcherException(throwable));
                        } else {
                            asyncResult.setResult(response);
                        }
                        futureResponse.send();
                    }
                    catch (Exception exception) {
                        if (throwable == null) {
                            Request request2 = request;
                            synchronized (request2) {
                                request.throwableResponse = throwable = exception;
                            }
                        }
                        futureResponse.sendThrowable(new DispatcherException(throwable));
                    }
                    break block17;
                }
                if (futureResponse != null) {
                    if (throwable != null) {
                        futureResponse.sendThrowable(new DispatcherException(throwable));
                    } else {
                        futureResponse.getMsgOutput().writeObject(response, response.getClass());
                        futureResponse.send();
                    }
                }
            }
            catch (RemoteException remoteException) {
                if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                    remoteException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                if (!JMSDebug.JMSDispatcher.isDebugEnabled()) break block17;
                iOException.printStackTrace();
            }
        }
        return response;
    }

    private static void runCompletionListener(CompletionListener completionListener, Throwable throwable, Response response) {
        if (completionListener != null) {
            if (throwable != null) {
                completionListener.onException(throwable);
            } else {
                completionListener.onCompletion(response);
            }
        }
    }

    public abstract int remoteSignature();

    public abstract Response createResponse();

    final synchronized void setParentResumeNewThread(boolean bl) {
        this.parentResumeNewThread = bl;
    }

    public final boolean getParentResumeNewThread() {
        return this.parentResumeNewThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchAsync(Dispatcher dispatcher, Request request) throws DispatcherException {
        Request request2 = this;
        synchronized (request2) {
            request.parent = this;
            this.incNumChildren();
        }
        dispatcher.dispatchAsync(request);
    }

    public Request() {
        this.result = this;
        this.isCollocated = true;
    }

    void writeShortened(ObjectOutput objectOutput) throws IOException {
        this.shortened = true;
        this.writeExternal(objectOutput);
        this.shortened = false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (!this.shortened && this.invocableId != null) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        if (!this.shortened && this.invocableId != null) {
            this.invocableId.writeExternal(objectOutput);
        }
        objectOutput.writeInt(this.methodId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternal(objectInput, new IDImpl(), this.appInvocableManager);
    }

    protected final void readExternal(ObjectInput objectInput, ID iD, InvocableManager invocableManager) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        this.appInvocableManager = invocableManager;
        if (n2 != 1) {
            throw MessagingUtilities.versionIOException(n2, 1, 1);
        }
        if ((n & 0x100) != 0) {
            this.invocableId = iD;
            this.invocableId.readExternal(objectInput);
        }
        if ((n & 0x200) != 0) {
            objectInput.readLong();
        }
        this.methodId = objectInput.readInt();
        this.isCollocated = false;
    }

    private boolean hasTransaction() {
        if (this.tranInfo == 2) {
            try {
                this.tranInfo = (this.remoteSignature() & 1) != 0 && Request.getTranManager().getTransaction() != null ? 1 : 0;
            }
            catch (SystemException systemException) {
                this.tranInfo = 0;
            }
        }
        return this.tranInfo == 1;
    }

    public final void setTranInfo(int n) {
        this.tranInfo = n;
    }

    private synchronized boolean forceSuspendTransaction() {
        if (this.transaction != null) {
            throw new Error("transaction suspended twice");
        }
        this.transaction = Request.getTranManager().forceSuspend();
        if (this.transaction == null) {
            this.tranInfo = 0;
            return false;
        }
        this.tranInfo = 1;
        return true;
    }

    private static ClientTransactionManager getTranManager() {
        return TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    private synchronized void resumeTransaction() {
        if (this.transaction == null) {
            throw new Error("transaction resumed twice");
        }
        Request.getTranManager().forceResume(this.transaction);
        this.transaction = null;
    }

    static {
        sdf.setTimeZone(TimeZone.getDefault());
    }
}

