/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store;

import weblogic.i18n.logging.CatalogMessage;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerRegistry;
import weblogic.i18n.logging.MessageLoggerRegistryListener;
import weblogic.logging.Loggable;

public class StoreLogger {
    private static final String LOCALIZER_CLASS = "weblogic.store.StoreLogLocalizer";

    private static MessageLogger findMessageLogger() {
        return MessageLoggerRegistry.findMessageLogger(StoreLogger.class.getName());
    }

    public static String logOpeningPersistentStore(String string, String string2, String string3, boolean bl, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, bl, string4};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280008", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280008";
    }

    public static Loggable logOpeningPersistentStoreLoggable(String string, String string2, String string3, boolean bl, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, bl, string4};
        return new Loggable("280008", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logPersistentStoreOpened(String string, String string2, int n, String string3, boolean bl, int n2) {
        Object[] objectArray = new Object[]{string, string2, new Integer(n), string3, bl, new Integer(n2)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280009", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280009";
    }

    public static Loggable logPersistentStoreOpenedLoggable(String string, String string2, int n, String string3, boolean bl, int n2) {
        Object[] objectArray = new Object[]{string, string2, new Integer(n), string3, bl, new Integer(n2)};
        return new Loggable("280009", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logRecoveryNotComplete() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280012", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280012";
    }

    public static Loggable logRecoveryNotCompleteLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280012", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logRecordTooLong(Number number) {
        Object[] objectArray = new Object[]{number};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280013", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280013";
    }

    public static Loggable logRecordTooLongLoggable(Number number) {
        Object[] objectArray = new Object[]{number};
        return new Loggable("280013", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logErrorWritingToFile() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280019", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280019";
    }

    public static Loggable logErrorWritingToFileLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280019", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logErrorReadingFromFile() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280020", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280020";
    }

    public static Loggable logErrorReadingFromFileLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280020", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logErrorOpeningFile(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280021", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280021";
    }

    public static Loggable logErrorOpeningFileLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280021", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logErrorCreatingFile(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280024", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280024";
    }

    public static Loggable logErrorCreatingFileLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280024", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logNoAccessToFile(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280026", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280026";
    }

    public static Loggable logNoAccessToFileLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280026", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreRecordNotFound(long l) {
        Object[] objectArray = new Object[]{new Long(l)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280029", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280029";
    }

    public static Loggable logStoreRecordNotFoundLoggable(long l) {
        Object[] objectArray = new Object[]{new Long(l)};
        return new Loggable("280029", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreNotOpen(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280031", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280031";
    }

    public static Loggable logStoreNotOpenLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280031", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreFatalError() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280032", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280032";
    }

    public static Loggable logStoreFatalErrorLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280032", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logCantAccessDirectory(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280035", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280035";
    }

    public static Loggable logCantAccessDirectoryLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280035", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logMissingFile(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280036", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280036";
    }

    public static Loggable logMissingFileLoggable(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return new Loggable("280036", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logTooManyFilesCreated(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280037", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280037";
    }

    public static Loggable logTooManyFilesCreatedLoggable(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return new Loggable("280037", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logErrorFlushingFile() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280038", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280038";
    }

    public static Loggable logErrorFlushingFileLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280038", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidRecordHandle(long l) {
        Object[] objectArray = new Object[]{new Long(l)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280039", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280039";
    }

    public static Loggable logInvalidRecordHandleLoggable(long l) {
        Object[] objectArray = new Object[]{new Long(l)};
        return new Loggable("280039", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidStoreRecord(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280040", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280040";
    }

    public static Loggable logInvalidStoreRecordLoggable(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return new Loggable("280040", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidStoreRecordVersion(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280041", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280041";
    }

    public static Loggable logInvalidStoreRecordVersionLoggable(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return new Loggable("280041", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logFileIsADirectory(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280042", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280042";
    }

    public static Loggable logFileIsADirectoryLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280042", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logDirectoryNotFound(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280044", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280044";
    }

    public static Loggable logDirectoryNotFoundLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280044", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logDirectoryNotADirectory(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280045", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280045";
    }

    public static Loggable logDirectoryNotADirectoryLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280045", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logNoAccessToDirectory(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280046", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280046";
    }

    public static Loggable logNoAccessToDirectoryLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280046", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logCreateFailed() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280051", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280051";
    }

    public static Loggable logCreateFailedLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280051", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logReadFailed() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280052", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280052";
    }

    public static Loggable logReadFailedLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280052", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidWritePolicy(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280055", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280055";
    }

    public static Loggable logInvalidWritePolicyLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280055", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logPersistentStoreException(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280056", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280056";
    }

    public static Loggable logPersistentStoreExceptionLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280056", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreAlreadyOpen(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280057", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280057";
    }

    public static Loggable logStoreAlreadyOpenLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280057", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidStoreConnectionName(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280059", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280059";
    }

    public static Loggable logInvalidStoreConnectionNameLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280059", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logFatalExceptionEncountered(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280060", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280060";
    }

    public static Loggable logFatalExceptionEncounteredLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280060", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreDeploymentFailed(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280061", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280061";
    }

    public static Loggable logStoreDeploymentFailedLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280061", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreShutdownFailed(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280062", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280062";
    }

    public static Loggable logStoreShutdownFailedLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280062", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidTableReference(String string, String string2, String string3, int n) {
        Object[] objectArray = new Object[]{string, string2, string3, new Integer(n)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280063", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280063";
    }

    public static Loggable logInvalidTableReferenceLoggable(String string, String string2, String string3, int n) {
        Object[] objectArray = new Object[]{string, string2, string3, new Integer(n)};
        return new Loggable("280063", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreException(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280064", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280064";
    }

    public static Loggable logJDBCStoreExceptionLoggable(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        return new Loggable("280064", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logWrappedJDBCStoreException(String string, String string2, String string3, String string4, String string5) {
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280065", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280065";
    }

    public static Loggable logWrappedJDBCStoreExceptionLoggable(String string, String string2, String string3, String string4, String string5) {
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        return new Loggable("280065", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidTableReference2(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280066", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280066";
    }

    public static Loggable logInvalidTableReference2Loggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280066", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreTableCreateSuccess(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280067", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280067";
    }

    public static Loggable logJDBCStoreTableCreateSuccessLoggable(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        return new Loggable("280067", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreTableCreateFailed(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280068", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280068";
    }

    public static Loggable logJDBCStoreTableCreateFailedLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280068", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreCreateUnknownDatabase(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280069", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280069";
    }

    public static Loggable logJDBCStoreCreateUnknownDatabaseLoggable(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return new Loggable("280069", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreCreateDDLFileNotFound(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280070", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280070";
    }

    public static Loggable logJDBCStoreCreateDDLFileNotFoundLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280070", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreOpened(String string, String string2, long l) {
        Object[] objectArray = new Object[]{string, string2, new Long(l)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280071", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280071";
    }

    public static Loggable logJDBCStoreOpenedLoggable(String string, String string2, long l) {
        Object[] objectArray = new Object[]{string, string2, new Long(l)};
        return new Loggable("280071", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreOpenFailed(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280072", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280072";
    }

    public static Loggable logJDBCStoreOpenFailedLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280072", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidFileVersion(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280073", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280073";
    }

    public static Loggable logInvalidFileVersionLoggable(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        return new Loggable("280073", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logUnresolvableTransaction(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280074", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280074";
    }

    public static Loggable logUnresolvableTransactionLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280074", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreTableOwnershipRefreshFailed(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280075", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280075";
    }

    public static Loggable logJDBCStoreTableOwnershipRefreshFailedLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280075", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreTableOwnershipWait(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280076", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280076";
    }

    public static Loggable logJDBCStoreTableOwnershipWaitLoggable(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        return new Loggable("280076", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logJDBCStoreTableUnexpectedOwner(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280077", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280077";
    }

    public static Loggable logJDBCStoreTableUnexpectedOwnerLoggable(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        return new Loggable("280077", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logWrongConnectionForHandle() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280078", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280078";
    }

    public static Loggable logWrongConnectionForHandleLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280078", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreDescription() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280079", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280079";
    }

    public static Loggable getStoreDescriptionLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280079", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreCreateCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280080", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280080";
    }

    public static Loggable getStoreCreateCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280080", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreReadCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280081", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280081";
    }

    public static Loggable getStoreReadCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280081", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreUpdateCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280082", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280082";
    }

    public static Loggable getStoreUpdateCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280082", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreDeleteCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280083", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280083";
    }

    public static Loggable getStoreDeleteCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280083", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreObjectCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280084", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280084";
    }

    public static Loggable getStoreObjectCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280084", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStorePhysicalWriteCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280085", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280085";
    }

    public static Loggable getStorePhysicalWriteCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280085", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreConnectionDescription() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280086", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280086";
    }

    public static Loggable getStoreConnectionDescriptionLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280086", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreConnectionCreateCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280087", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280087";
    }

    public static Loggable getStoreConnectionCreateCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280087", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreConnectionReadCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280088", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280088";
    }

    public static Loggable getStoreConnectionReadCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280088", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreConnectionUpdateCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280089", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280089";
    }

    public static Loggable getStoreConnectionUpdateCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280089", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreConnectionDeleteCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280090", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280090";
    }

    public static Loggable getStoreConnectionDeleteCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280090", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String getStoreConnectionObjectCountAttribute() {
        Object[] objectArray = new Object[]{};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280091", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280091";
    }

    public static Loggable getStoreConnectionObjectCountAttributeLoggable() {
        Object[] objectArray = new Object[]{};
        return new Loggable("280091", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidIntegerProperty(String string, String string2, int n) {
        Object[] objectArray = new Object[]{string, string2, new Integer(n)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280092", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280092";
    }

    public static Loggable logInvalidIntegerPropertyLoggable(String string, String string2, int n) {
        Object[] objectArray = new Object[]{string, string2, new Integer(n)};
        return new Loggable("280092", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logOutOfBlockSizeRange(String string, int n, int n2, int n3, int n4) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280093", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280093";
    }

    public static Loggable logOutOfBlockSizeRangeLoggable(String string, int n, int n2, int n3, int n4) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)};
        return new Loggable("280093", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logSizeNotPowerOfTwo(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280094", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280094";
    }

    public static Loggable logSizeNotPowerOfTwoLoggable(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        return new Loggable("280094", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logBlockSizeIgnored(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280095", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280095";
    }

    public static Loggable logBlockSizeIgnoredLoggable(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return new Loggable("280095", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logInvalidDirectModeIgnored(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280096", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280096";
    }

    public static Loggable logInvalidDirectModeIgnoredLoggable(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        return new Loggable("280096", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logDualHandleOpenFailed(String string, Throwable throwable) {
        Object[] objectArray = new Object[]{string, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280097", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280097";
    }

    public static Loggable logDualHandleOpenFailedLoggable(String string, Throwable throwable) {
        Object[] objectArray = new Object[]{string, throwable};
        return new Loggable("280097", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logWritePolicyDowngraded(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280101", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280101";
    }

    public static Loggable logWritePolicyDowngradedLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280101", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logCacheSignatureVerificationFailed(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280102", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280102";
    }

    public static Loggable logCacheSignatureVerificationFailedLoggable(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        return new Loggable("280102", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logCacheInfo(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280103", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280103";
    }

    public static Loggable logCacheInfoLoggable(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return new Loggable("280103", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logIncompatibleDirectIOAlignment(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280104", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280104";
    }

    public static Loggable logIncompatibleDirectIOAlignmentLoggable(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        return new Loggable("280104", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logFileOpenError(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280105", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280105";
    }

    public static Loggable logFileOpenErrorLoggable(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        return new Loggable("280105", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logFileMappingError(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280106", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280106";
    }

    public static Loggable logFileMappingErrorLoggable(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, throwable};
        return new Loggable("280106", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreRecordAlreadyDeleted(long l, String string, String string2) {
        Object[] objectArray = new Object[]{new Long(l), string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280107", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280107";
    }

    public static Loggable logStoreRecordAlreadyDeletedLoggable(long l, String string, String string2) {
        Object[] objectArray = new Object[]{new Long(l), string, string2};
        return new Loggable("280107", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logStoreRecordAlreadyExists(long l, String string, String string2) {
        Object[] objectArray = new Object[]{new Long(l), string, string2};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280108", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280108";
    }

    public static Loggable logStoreRecordAlreadyExistsLoggable(long l, String string, String string2) {
        Object[] objectArray = new Object[]{new Long(l), string, string2};
        return new Loggable("280108", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    public static String logNativeDriverLoadFailure(String string) {
        Object[] objectArray = new Object[]{string};
        MessageLoggerInitializer.INSTANCE.messageLogger.log(new CatalogMessage("280109", objectArray, LOCALIZER_CLASS, StoreLogger.class.getClassLoader()));
        return "280109";
    }

    public static Loggable logNativeDriverLoadFailureLoggable(String string) {
        Object[] objectArray = new Object[]{string};
        return new Loggable("280109", objectArray, LOCALIZER_CLASS, MessageLoggerInitializer.INSTANCE.messageLogger, StoreLogger.class.getClassLoader());
    }

    private static final class MessageLoggerInitializer
    implements MessageLoggerRegistryListener {
        private static final MessageLoggerInitializer INSTANCE = new MessageLoggerInitializer();
        private MessageLogger messageLogger = StoreLogger.access$000();

        private MessageLoggerInitializer() {
            MessageLoggerRegistry.addMessageLoggerRegistryListener(this);
        }

        public void messageLoggerRegistryUpdated() {
            this.messageLogger = StoreLogger.findMessageLogger();
        }
    }
}

