/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.Arrays;
import java.util.Set;
import weblogic.timers.CancelTimerListener;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.StopTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.internal.TimerContext;
import weblogic.timers.internal.TimerManagerImpl;
import weblogic.utils.collections.WeakConcurrentHashMap;

public class TimerImpl
implements Timer,
Comparable,
Runnable {
    private static final WeakConcurrentHashMap timerMap = new WeakConcurrentHashMap(100);
    private TimerManagerImpl timerManager;
    private TimerListener listener;
    private long timeout;
    private long period;
    private long counter;
    boolean stopped;
    boolean cancelled;
    private TimerContext context;
    private static final int HISTORY_SIZE = 100;
    private HistoryMany history;
    private static final long UNUSED_HISTORY = -1L;
    private long oneExpirationTime = -1L;

    TimerImpl(TimerManagerImpl timerManagerImpl, TimerListener timerListener, long l, long l2) {
        this.timerManager = timerManagerImpl;
        this.listener = timerListener;
        this.timeout = l;
        this.period = l2;
        if (!(timerListener instanceof NakedTimerListener)) {
            try {
                Class<?> clazz = Class.forName("weblogic.timers.internal.J2EETimerContextImpl");
                this.context = (TimerContext)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        timerMap.put(this, (Object)null);
    }

    void cleanup() {
        timerMap.remove(this);
    }

    static TimerImpl[] getTimers() {
        Set set = timerMap.keySet();
        if (set == null || set.isEmpty()) {
            return null;
        }
        TimerImpl[] timerImplArray = new TimerImpl[set.size()];
        return set.toArray(timerImplArray);
    }

    TimerManagerImpl getTimerManager() {
        return this.timerManager;
    }

    void setCounter(long l) {
        this.counter = l;
    }

    void setStopped() {
        this.stopped = true;
    }

    void setTimeout(long l) {
        this.timeout = l;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimerListener getListener() {
        return this.listener;
    }

    public long getScheduledExecutionTime() throws IllegalStateException {
        return this.timeout;
    }

    public boolean cancel() {
        return this.timerManager.cancel(this);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            if (this.context != null) {
                this.context.push();
            }
            if (this.stopped) {
                if (this.listener instanceof StopTimerListener) {
                    ((StopTimerListener)this.listener).timerStopped(this);
                }
            } else if (this.cancelled) {
                if (this.listener instanceof CancelTimerListener) {
                    ((CancelTimerListener)this.listener).timerCancelled(this);
                }
            } else {
                this.recordExpirationTime();
                this.listener.timerExpired(this);
            }
        }
        finally {
            if (this.context != null) {
                this.context.pop();
            }
            this.timerManager.complete(this);
        }
    }

    boolean isExpired() {
        return this.timeout <= System.currentTimeMillis();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public int compareTo(Object object) {
        TimerImpl timerImpl = (TimerImpl)object;
        if (this.timeout > timerImpl.timeout) {
            return 1;
        }
        if (this.timeout < timerImpl.timeout) {
            return -1;
        }
        if (this.counter > timerImpl.counter) {
            return 1;
        }
        if (this.counter < timerImpl.counter) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "" + this.timeout + "." + this.counter + "(" + this.period + ")";
    }

    private void recordExpirationTime() {
        HistoryMany historyMany = this.history;
        if (historyMany == null) {
            if (this.oneExpirationTime == -1L) {
                this.oneExpirationTime = System.currentTimeMillis();
                return;
            }
            this.history = historyMany = new HistoryMany();
            historyMany.recordExpirationTime(this.oneExpirationTime);
        }
        historyMany.recordExpirationTime(System.currentTimeMillis());
    }

    long[] sortedExpirationTimes() {
        HistoryMany historyMany = this.history;
        if (historyMany == null) {
            if (this.oneExpirationTime == -1L) {
                return new long[0];
            }
            long[] lArray = new long[]{this.oneExpirationTime};
            return lArray;
        }
        return historyMany.sortedExpirationTimes();
    }

    private static final class HistoryMany {
        private int historyIndex = 0;
        private long[] pastExpirationTimes = new long[100];

        private HistoryMany() {
        }

        private void recordExpirationTime(long l) {
            this.pastExpirationTimes[this.historyIndex] = l;
            this.historyIndex = this.historyIndex == 99 ? 0 : ++this.historyIndex;
        }

        private long[] sortedExpirationTimes() {
            int n;
            long[] lArray = new long[this.pastExpirationTimes.length];
            System.arraycopy(this.pastExpirationTimes, 0, lArray, 0, lArray.length);
            Arrays.sort(lArray);
            for (n = 0; n < lArray.length && lArray[n] <= 0L; ++n) {
            }
            if (n > 0) {
                long[] lArray2 = new long[lArray.length - n];
                System.arraycopy(lArray, n, lArray2, 0, lArray2.length);
                return lArray2;
            }
            return lArray;
        }
    }
}

