/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.timers.internal.TimerManagerImpl;
import weblogic.timers.internal.commonj.TimerManagerImpl;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class TimerManagerFactoryImpl
extends TimerManagerFactory {
    private static final String DEFAULT_TIMER_MANAGER = "weblogic.timers.DefaultTimerManager";
    private TimerManager defaultTimerManager;

    public synchronized TimerManager getDefaultTimerManager() {
        if (this.defaultTimerManager == null) {
            this.defaultTimerManager = weblogic.timers.internal.TimerManagerImpl.getTimerManager(DEFAULT_TIMER_MANAGER, new WorkManagerExecutor(WorkManagerFactory.getInstance().getDefault()));
        }
        return this.defaultTimerManager;
    }

    public TimerManager getTimerManager(String string, String string2) {
        WorkManager workManager = WorkManagerFactory.getInstance().find(string2);
        if (workManager == null) {
            throw new IllegalArgumentException("No work manager for policy " + string2);
        }
        return this.getTimerManager(string, workManager);
    }

    public TimerManager getTimerManager(String string, WorkManager workManager) {
        if (DEFAULT_TIMER_MANAGER.equals(string)) {
            if (workManager == WorkManagerFactory.getInstance().getDefault()) {
                return this.getDefaultTimerManager();
            }
            throw new IllegalArgumentException("Existing manager has different policy");
        }
        if (workManager == null) {
            workManager = WorkManagerFactory.getInstance().getDefault();
        }
        return weblogic.timers.internal.TimerManagerImpl.getTimerManager(string, new WorkManagerExecutor(workManager));
    }

    public TimerManager getTimerManager(String string) {
        return this.getTimerManager(string, (WorkManager)null);
    }

    public commonj.timers.TimerManager getCommonjTimerManager(String string, WorkManager workManager) {
        return this.getCommonjTimerManager(this.getTimerManager(string, workManager));
    }

    public commonj.timers.TimerManager getCommonjTimerManager(TimerManager timerManager) {
        return new TimerManagerImpl(timerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllTimers() {
        TimerManagerFactoryImpl timerManagerFactoryImpl = this;
        synchronized (timerManagerFactoryImpl) {
            if (this.defaultTimerManager != null) {
                this.defaultTimerManager.stop();
            }
        }
        weblogic.timers.internal.TimerManagerImpl.stopAllTimers();
    }

    class WorkManagerExecutor
    implements TimerManagerImpl.Executor {
        private final WorkManager workManager;

        WorkManagerExecutor(WorkManager workManager) {
            this.workManager = workManager;
        }

        public void execute(Runnable runnable) {
            this.workManager.schedule(runnable);
        }

        public boolean equals(TimerManagerImpl.Executor executor) {
            if (!(executor instanceof WorkManagerExecutor)) {
                return false;
            }
            return this.workManager == ((WorkManagerExecutor)executor).workManager;
        }
    }
}

