/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import weblogic.kernel.QueueFullException;
import weblogic.timers.CancelTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.internal.TimerImpl;
import weblogic.timers.internal.TimerThread;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.work.WorkManager;

public class TimerManagerImpl
implements TimerManager {
    private static final int STOPPING = 1;
    private static final int STOPPED = 2;
    private static final int SUSPENDING = 3;
    private static final int SUSPENDED = 4;
    private static final int RUNNING = 5;
    private static HashMap timerManagers = new HashMap();
    private TimerImpl timerRegisteredInTimerThread;
    private TimerThread timerThread;
    private String name;
    private final Executor executor;
    private int executing;
    private int state;
    private final TreeMap tree = new TreeMap();

    TimerManagerImpl(TimerThread timerThread, String string, Executor executor) {
        this.timerThread = timerThread;
        this.name = string;
        this.executor = executor;
        this.state = 5;
    }

    public void stop() {
        try {
            this.waitForStop(0L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized boolean isStopped() {
        return this.state == 2 || this.timerThread.isStopped();
    }

    public synchronized boolean isStopping() {
        return this.state == 1 || this.isStopped();
    }

    public synchronized boolean isSuspended() {
        return this.state == 4;
    }

    public synchronized boolean isSuspending() {
        return this.state == 3 || this.isSuspended();
    }

    public void suspend() {
        try {
            this.waitForSuspend(0L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSuspend(long l) throws InterruptedException, IllegalStateException, IllegalArgumentException {
        TimerThread timerThread = this.timerThread;
        synchronized (timerThread) {
            if (this.state == 2) {
                throw new IllegalArgumentException("Cannot suspend a TimerManager that is in STOPPED state");
            }
            this.state = 3;
            this.update();
            long l2 = l;
            long l3 = System.currentTimeMillis();
            while (this.isExecuting()) {
                this.timerThread.wait(l2);
                if (l2 > 0L) {
                    long l4 = System.currentTimeMillis();
                    long l5 = l4 - l3;
                    if (l5 >= l2) {
                        if (this.isExecuting()) {
                            return false;
                        }
                        this.state = 4;
                        return true;
                    }
                    l2 -= l5;
                    l3 = l4;
                }
                if (this.state == 3) continue;
                throw new IllegalStateException("TimerManager state changed to " + this.state + " while suspending. waitForSuspend is aborted.");
            }
            this.state = 4;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForStop(long l) throws InterruptedException, IllegalArgumentException {
        TimerThread timerThread = this.timerThread;
        synchronized (timerThread) {
            this.state = 1;
            this.update();
            while (!this.tree.isEmpty()) {
                TimerImpl timerImpl = (TimerImpl)this.tree.firstKey();
                this.tree.remove(timerImpl);
                timerImpl.setStopped();
                try {
                    ++this.executing;
                    this.executor.execute(timerImpl);
                }
                catch (QueueFullException queueFullException) {
                    this.complete(timerImpl);
                }
                catch (UnsyncCircularQueue.FullQueueException fullQueueException) {
                    this.complete(timerImpl);
                }
            }
            long l2 = l;
            long l3 = System.currentTimeMillis();
            try {
                while (this.isExecuting()) {
                    this.timerThread.wait(l2);
                    if (l2 > 0L) {
                        long l4 = System.currentTimeMillis();
                        long l5 = l4 - l3;
                        if (l5 >= l2) {
                            if (this.isExecuting()) {
                                boolean bl = false;
                                return bl;
                            }
                            this.state = 2;
                            boolean bl = true;
                            return bl;
                        }
                        l2 -= l5;
                        l3 = l4;
                    }
                    if (this.state == 1) continue;
                    throw new IllegalStateException();
                }
            }
            finally {
                timerManagers.remove(this.name);
            }
            this.state = 2;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        TimerThread timerThread = this.timerThread;
        synchronized (timerThread) {
            if (this.state == 5) {
                return;
            }
            if (this.state == 2) {
                throw new IllegalArgumentException("Cannot resume a TimerManager that is in STOPPED state");
            }
            this.state = 5;
            this.update();
            this.timerThread.notifyAll();
        }
    }

    public Timer schedule(TimerListener timerListener, long l) {
        return this.schedule(timerListener, l, 0L);
    }

    public Timer schedule(TimerListener timerListener, Date date) {
        return this.schedule(timerListener, date, 0L);
    }

    public Timer schedule(TimerListener timerListener, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Delay is negative.");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        if (this.state == 2) {
            throw new IllegalArgumentException("TimerManager is in STOPPED state");
        }
        return this.add(new TimerImpl(this, timerListener, this.normalizeTimeout(l), -l2));
    }

    private long normalizeTimeout(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        if (l3 < l2) {
            return 9223372036854773807L;
        }
        return l3;
    }

    public Timer schedule(TimerListener timerListener, Date date, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        if (this.state == 2) {
            throw new IllegalArgumentException("TimerManager is in STOPPED state");
        }
        return this.add(new TimerImpl(this, timerListener, date.getTime(), -l));
    }

    public Timer scheduleAtFixedRate(TimerListener timerListener, Date date, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        return this.add(new TimerImpl(this, timerListener, date.getTime(), l));
    }

    public Timer scheduleAtFixedRate(TimerListener timerListener, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Delay is negative.");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Period is negative.");
        }
        return this.add(new TimerImpl(this, timerListener, this.normalizeTimeout(l), l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(TimerImpl timerImpl) {
        TimerThread timerThread = this.timerThread;
        synchronized (timerThread) {
            if (timerImpl.isCancelled()) {
                return false;
            }
            timerImpl.setCancelled(true);
            timerImpl = (TimerImpl)this.tree.remove(timerImpl);
            if (timerImpl == null) {
                return false;
            }
            ++this.executing;
            TimerListener timerListener = timerImpl.getListener();
            if (timerListener instanceof CancelTimerListener) {
                try {
                    this.executor.execute(timerImpl);
                }
                catch (UnsyncCircularQueue.FullQueueException fullQueueException) {
                    this.complete(timerImpl);
                }
            } else {
                this.complete(timerImpl);
            }
            this.update();
        }
        return true;
    }

    private void update() {
        TimerImpl timerImpl;
        TimerImpl timerImpl2 = timerImpl = this.tree.isEmpty() ? null : (TimerImpl)this.tree.firstKey();
        if ((this.state != 5 || this.timerRegisteredInTimerThread != timerImpl) && this.timerRegisteredInTimerThread != null) {
            this.timerThread.remove(this.timerRegisteredInTimerThread);
            this.timerRegisteredInTimerThread = null;
        }
        if (this.state == 5 && this.timerRegisteredInTimerThread != timerImpl && timerImpl != null) {
            this.timerThread.add(timerImpl);
            this.timerRegisteredInTimerThread = timerImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer add(TimerImpl timerImpl) {
        TimerThread timerThread = this.timerThread;
        synchronized (timerThread) {
            if (this.isStopped()) {
                throw new IllegalStateException();
            }
            timerImpl.setCounter(this.timerThread.getNextCounter());
            this.tree.put(timerImpl, timerImpl);
            this.update();
        }
        return timerImpl;
    }

    void execute() {
        this.timerRegisteredInTimerThread = null;
        TimerImpl timerImpl = (TimerImpl)this.tree.firstKey();
        for (int i = 0; timerImpl.isExpired() && i < 64; ++i) {
            this.tree.remove(timerImpl);
            if (this.isStopped()) {
                timerImpl.setStopped();
            }
            try {
                ++this.executing;
                this.executor.execute(timerImpl);
            }
            catch (QueueFullException queueFullException) {
                this.complete(timerImpl);
            }
            catch (UnsyncCircularQueue.FullQueueException fullQueueException) {
                this.complete(timerImpl);
            }
            if (this.tree.isEmpty()) {
                return;
            }
            timerImpl = (TimerImpl)this.tree.firstKey();
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(TimerImpl timerImpl) {
        TimerThread timerThread = this.timerThread;
        synchronized (timerThread) {
            --this.executing;
            if (this.state != 5 && this.executing == 0) {
                this.timerThread.notifyAll();
            }
            if (timerImpl.isCancelled()) {
                timerImpl.cleanup();
                return;
            }
            long l = timerImpl.getPeriod();
            if (l == 0L) {
                timerImpl.cleanup();
                return;
            }
            long l2 = System.currentTimeMillis();
            if (l > 0L) {
                long l3;
                long l4 = l3 = timerImpl.getTimeout();
                do {
                    if ((l3 += l) >= l4) continue;
                    l3 = this.normalizeTimeout(l);
                    break;
                } while (l3 < l2);
                timerImpl.setTimeout(l3);
            } else {
                timerImpl.setTimeout(this.normalizeTimeout(-l));
            }
            if (this.isStopped()) {
                timerImpl.cleanup();
            } else {
                this.add(timerImpl);
            }
        }
    }

    private boolean isExecuting() {
        return this.executing > 0;
    }

    Executor getExecutor() {
        return this.executor;
    }

    public String getExecutorName() {
        if (this.executor instanceof WorkManager) {
            return ((WorkManager)((Object)this.executor)).getName();
        }
        return "" + this.executor;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerManagerImpl getTimerManager(String string, Executor executor) {
        TimerThread timerThread;
        if (executor == null) {
            throw new IllegalArgumentException("executor == null");
        }
        TimerThread timerThread2 = timerThread = TimerThread.getTimerThread();
        synchronized (timerThread2) {
            TimerManagerImpl timerManagerImpl = (TimerManagerImpl)timerManagers.get(string);
            if (timerManagerImpl != null) {
                if (executor == null && timerManagerImpl.getExecutor() == null) {
                    return timerManagerImpl;
                }
                if (executor.equals(timerManagerImpl.getExecutor())) {
                    return timerManagerImpl;
                }
                throw new IllegalArgumentException("Existing timer manager has different work manager.\nTimerManager requested: " + string + "\n" + "TimerManager  obtained: " + timerManagerImpl.getName() + "\n" + "WorkManager  requested: " + executor + "\n" + "WorkManager   obtained: " + timerManagerImpl.getExecutor());
            }
            timerManagerImpl = new TimerManagerImpl(timerThread, string, executor);
            timerManagers.put(string, timerManagerImpl);
            return timerManagerImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopAllTimers() {
        TimerThread timerThread;
        TimerThread timerThread2 = timerThread = TimerThread.getTimerThread();
        synchronized (timerThread2) {
            TimerManager[] timerManagerArray = timerManagers.values().toArray(new TimerManager[timerManagers.size()]);
            for (int i = 0; i < timerManagerArray.length; ++i) {
                timerManagerArray[i].stop();
            }
        }
    }

    public String toString() {
        return "TimerManager '" + this.getName() + "' that uses WorkManager '" + this.executor + "'";
    }

    public static interface Executor {
        public void execute(Runnable var1);

        public boolean equals(Executor var1);
    }
}

