/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.TreeMap;
import weblogic.kernel.KernelStatus;
import weblogic.timers.Timer;
import weblogic.timers.internal.TimerImpl;
import weblogic.timers.internal.TimerManagerImpl;

class TimerThread {
    static final int STARTED = 0;
    static final int STOPPED = 1;
    static final int HALTED = 2;
    private static TimerThread singleton;
    private Thread thread;
    private long counter;
    private int state;
    private TreeMap timerTree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerThread() {
        Class<TimerThread> clazz = TimerThread.class;
        synchronized (TimerThread.class) {
            if (singleton != null) {
                throw new IllegalStateException();
            }
            if (!KernelStatus.isInitialized()) {
                String string = "weblogic.kernel.Kernel";
                try {
                    Class.forName(string, true, ClassLoader.getSystemClassLoader());
                    throw new AssertionError((Object)"Kernel needs to be initialized before starting TimerThread.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            this.timerTree = new TreeMap();
            this.thread = new Thread(this);
            this.thread.start();
            singleton = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    synchronized void stop() {
        this.state = 1;
    }

    synchronized void start() {
        this.state = 0;
        this.notifyAll();
    }

    synchronized void halt() {
        this.state = 2;
        this.notifyAll();
    }

    void add(Timer timer) {
        this.timerTree.put(timer, timer);
        if (this.state != 0) {
            return;
        }
        if (this.timerTree.firstKey() == timer) {
            this.notifyAll();
        }
    }

    Timer remove(Timer timer) {
        return (Timer)this.timerTree.remove(timer);
    }

    long getNextCounter() {
        return ++this.counter;
    }

    boolean isStarted() {
        return this.state == 0;
    }

    boolean isStopped() {
        return this.state == 1;
    }

    boolean isHalted() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TimerThread getTimerThread() {
        Class<TimerThread> clazz = TimerThread.class;
        synchronized (TimerThread.class) {
            if (singleton != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new TimerThread();
        }
    }

    class Thread
    extends java.lang.Thread {
        private TimerThread timerThread;

        public Thread(TimerThread timerThread2) {
            this.timerThread = timerThread2;
            this.setName("weblogic.timers.TimerThread");
            this.setPriority(9);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                TimerThread timerThread = this.timerThread;
                synchronized (timerThread) {
                    if (this.timerThread.isStopped()) {
                        try {
                            this.timerThread.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (TimerThread.this.timerTree.isEmpty()) {
                        if (this.timerThread.isHalted()) {
                            break;
                        }
                        try {
                            this.timerThread.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        TimerImpl timerImpl = (TimerImpl)TimerThread.this.timerTree.firstKey();
                        if (this.timerThread.isHalted()) {
                            TimerThread.this.timerTree.remove(timerImpl);
                            TimerManagerImpl timerManagerImpl = timerImpl.getTimerManager();
                            if (!timerManagerImpl.isStopped()) {
                                timerManagerImpl.stop();
                            }
                            continue;
                        }
                        long l = System.currentTimeMillis();
                        if (timerImpl.getTimeout() > l) {
                            try {
                                this.timerThread.wait(timerImpl.getTimeout() - l);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        TimerThread.this.timerTree.remove(timerImpl);
                        timerImpl.getTimerManager().execute();
                    }
                }
            }
        }
    }
}

