/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import weblogic.utils.collections.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionedConcurrentPool<E>
implements Pool<E> {
    private static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    private static final int MAX_TRY = 2;
    private final ArrayBlockingQueue[] pools;
    private AtomicInteger nextAdd = new AtomicInteger();
    private AtomicInteger nextRemove = new AtomicInteger();

    public PartitionedConcurrentPool(int n) {
        this(n, DEFAULT_POOL_SIZE);
    }

    public PartitionedConcurrentPool(int n, int n2) {
        int n3 = n2 < DEFAULT_POOL_SIZE ? DEFAULT_POOL_SIZE : n2;
        this.pools = new ArrayBlockingQueue[n3];
        int n4 = n / n3 + 1;
        for (int i = 0; i < n3; ++i) {
            this.pools[i] = new ArrayBlockingQueue(n4);
        }
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.pools.length; ++i) {
            n += this.pools[i].size();
        }
        return n;
    }

    private int advanceAddPosition() {
        return (this.nextAdd.incrementAndGet() & Integer.MAX_VALUE) % this.pools.length;
    }

    private int advanceRemovePosition() {
        return (this.nextRemove.incrementAndGet() & Integer.MAX_VALUE) % this.pools.length;
    }

    @Override
    public boolean add(E e) {
        int n = this.advanceAddPosition();
        for (int i = 0; i < this.pools.length; ++i) {
            if (this.pools[n].offer(e)) {
                return true;
            }
            n = (n + 1) % this.pools.length;
        }
        return false;
    }

    @Override
    public E remove() {
        int n = this.advanceRemovePosition();
        for (int i = 0; i < 2 && i < this.pools.length; ++i) {
            Object e = this.pools[n].poll();
            if (e != null) {
                return e;
            }
            n = (n + 1) % this.pools.length;
        }
        return null;
    }
}

