/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer currentBuffer;
    private ByteBuffer[] buffers;
    private int currentIndex;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this(new ByteBuffer[]{byteBuffer});
    }

    public ByteBufferInputStream(ByteBuffer[] byteBufferArray) {
        this.buffers = byteBufferArray;
        this.currentIndex = 0;
        this.currentBuffer = byteBufferArray[this.currentIndex];
    }

    public int read() throws IOException {
        do {
            if (this.currentBuffer.remaining() < 1) continue;
            return this.currentBuffer.get() & 0xFF;
        } while (this.advance());
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2;
        do {
            int n5 = this.currentBuffer.remaining();
            n3 = Math.min(n5, n2);
            this.currentBuffer.get(byArray, n, n3);
            n += n3;
        } while ((n2 -= n3) > 0 && this.advance());
        if (n4 == n2) {
            return -1;
        }
        return n4 - n2;
    }

    private final boolean advance() {
        if (++this.currentIndex < this.buffers.length) {
            this.currentBuffer = this.buffers[this.currentIndex];
            return true;
        }
        return false;
    }

    public int available() throws IOException {
        int n = 0;
        for (int i = this.currentIndex; i < this.buffers.length; ++i) {
            n += this.buffers[i].remaining();
        }
        return n;
    }
}

