/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import weblogic.utils.Hex;
import weblogic.utils.collections.PartitionedConcurrentPool;
import weblogic.utils.collections.Pool;

public final class Chunk {
    private static final int DEFAULT_CHUNK_SIZE = 4080;
    private static final int DEFAULT_PARTITION_SIZE = 4;
    private static final int DEFAULT_CHUNK_POOL_SIZE = 2048;
    public static final int CHUNK_SIZE = Chunk.getChunkSize();
    private static final Pool chunkPool = new PartitionedConcurrentPool(Chunk.getPoolSize(), Chunk.getPartitionSize());
    private static boolean memoryLow = false;
    private static final ArrayList memoryManagedList = new ArrayList();
    boolean readOnlySharedBuf;
    public final byte[] buf;
    public int end;
    public Chunk next;
    private ByteBuffer byteBuf;

    private static int getChunkSize() {
        Integer n = null;
        try {
            n = Integer.getInteger("weblogic.Chunksize");
            if (n == null) {
                n = Integer.getInteger("weblogic.utils.io.Chunk.ChunkSize");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (n == null) {
            n = new Integer(4080);
        }
        return n;
    }

    private static int getPartitionSize() {
        Integer n = null;
        try {
            n = Integer.getInteger("weblogic.PartitionSize");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (n == null) {
            n = new Integer(4);
        }
        return n;
    }

    private static int getPoolSize() {
        Integer n = null;
        try {
            n = Integer.getInteger("weblogic.utils.io.chunkpoolsize");
            if (n == null) {
                n = Integer.getInteger("weblogic.utils.io.Chunk.PoolSize");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (n == null) {
            n = new Integer(2048);
        }
        return n;
    }

    public static Chunk getChunk() {
        Chunk chunk = (Chunk)chunkPool.remove();
        if (chunk == null) {
            chunk = new Chunk();
        }
        return chunk;
    }

    public static void replaceStolenChunks(int n) {
        while (n > 0 && chunkPool.add(new Chunk())) {
            --n;
        }
    }

    public static void releaseChunk(Chunk chunk) {
        if (chunk.readOnlySharedBuf) {
            return;
        }
        chunk.end = 0;
        chunk.next = null;
        chunk.byteBuf.clear();
        chunkPool.add(chunk);
    }

    public static void releaseChunks(Chunk chunk) {
        while (chunk != null) {
            Chunk chunk2 = chunk.next;
            Chunk.releaseChunk(chunk);
            chunk = chunk2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalLowMemoryCondition() {
        ArrayList arrayList = memoryManagedList;
        synchronized (arrayList) {
            memoryLow = true;
            memoryManagedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLowMemoryCondition() {
        ArrayList arrayList = memoryManagedList;
        synchronized (arrayList) {
            memoryLow = false;
        }
    }

    public static int size(Chunk chunk) {
        int n = 0;
        while (chunk != null) {
            n += chunk.end;
            chunk = chunk.next;
        }
        return n;
    }

    public static Chunk tail(Chunk chunk) {
        Chunk chunk2 = chunk;
        while (chunk2.next != null) {
            chunk2 = chunk2.next;
        }
        return chunk2;
    }

    public static Chunk ensureCapacity(Chunk chunk) {
        if (CHUNK_SIZE == chunk.end) {
            chunk.next = Chunk.getChunk();
            return chunk.next;
        }
        return chunk;
    }

    public static int chunkFully(Chunk chunk, InputStream inputStream) throws IOException {
        Chunk chunk2 = Chunk.tail(chunk);
        int n = 0;
        while (true) {
            chunk2 = Chunk.ensureCapacity(chunk2);
            int n2 = inputStream.read(chunk2.buf, chunk2.end, CHUNK_SIZE - chunk2.end);
            if (n2 == -1) break;
            chunk2.end += n2;
            n += n2;
        }
        return n;
    }

    public static int chunk(Chunk chunk, InputStream inputStream, int n) throws IOException {
        Chunk chunk2 = Chunk.tail(chunk);
        int n2 = n;
        while (n > 0) {
            chunk2 = Chunk.ensureCapacity(chunk2);
            int n3 = Math.min(n, CHUNK_SIZE - chunk2.end);
            int n4 = inputStream.read(chunk2.buf, chunk2.end, n3);
            if (n4 == -1) {
                return n2 - n;
            }
            chunk2.end += n4;
            n -= n4;
        }
        return n2;
    }

    public static Chunk split(Chunk chunk, int n) {
        Chunk chunk2;
        int n2 = 0;
        while (n2 < n) {
            if ((n2 += chunk.end) >= n) continue;
            chunk = chunk.next;
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            chunk2 = chunk.next;
        } else {
            chunk2 = Chunk.getChunk();
            System.arraycopy(chunk.buf, chunk.end - n3, chunk2.buf, 0, n3);
            chunk.end -= n3;
            chunk2.end = n3;
            chunk2.next = chunk.next;
        }
        chunk.next = null;
        return chunk2;
    }

    private Chunk() {
        this(new byte[CHUNK_SIZE], 0);
    }

    public Chunk(int n) {
        this(new byte[n], 0);
    }

    private Chunk(byte[] byArray, int n) {
        this.buf = byArray;
        this.end = n;
        this.next = null;
        this.byteBuf = ByteBuffer.wrap(byArray);
    }

    public String toString() {
        return super.toString() + " - end: '" + this.end + "', buf: '" + Hex.dump(this.buf) + "', next: '" + this.next + "'";
    }

    public ByteBuffer getReadByteBuffer() {
        this.byteBuf.limit(this.byteBuf.capacity());
        this.byteBuf.position(this.end);
        return this.byteBuf;
    }

    public ByteBuffer getWriteByteBuffer() {
        this.byteBuf.position(0);
        this.byteBuf.limit(this.end);
        return this.byteBuf;
    }

    public ByteBuffer wrapAsReadOnlyByteBuffer() {
        this.readOnlySharedBuf = true;
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.end).asReadOnlyBuffer();
        return byteBuffer;
    }

    public boolean isReadOnlySharedBuf() {
        return this.readOnlySharedBuf;
    }

    public static Chunk createSharedChunk(byte[] byArray, int n) {
        Chunk chunk = new Chunk(byArray, n);
        chunk.readOnlySharedBuf = true;
        return chunk;
    }

    public Chunk createOneSharedChunk() {
        if (!this.readOnlySharedBuf && this.buf.length == CHUNK_SIZE) {
            Chunk.replaceStolenChunks(1);
        }
        Chunk chunk = new Chunk(this.buf, this.end);
        this.readOnlySharedBuf = true;
        chunk.readOnlySharedBuf = true;
        return chunk;
    }

    public static Chunk createOneSharedChunk(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        Chunk chunk = new Chunk(byArray, n);
        chunk.readOnlySharedBuf = true;
        return chunk;
    }

    public Chunk getSharedBeforeTailCopy(Chunk chunk) {
        Chunk chunk2;
        Chunk chunk3 = null;
        Chunk chunk4 = null;
        Chunk chunk5 = this;
        while (chunk5 != chunk && chunk5.next != null) {
            if (chunk5.end == 0) {
                chunk5 = chunk5.next;
                continue;
            }
            Chunk chunk6 = chunk5.createOneSharedChunk();
            if (chunk4 == null) {
                chunk3 = chunk6;
            } else {
                chunk4.next = chunk6;
            }
            chunk4 = chunk6;
            chunk5 = chunk5.next;
        }
        if (chunk5.end <= CHUNK_SIZE) {
            chunk2 = Chunk.getChunk();
            chunk2.end = chunk5.end;
            System.arraycopy(chunk5.buf, 0, chunk2.buf, 0, chunk2.end);
        } else {
            if (!chunk5.readOnlySharedBuf && chunk5.next == null) {
                chunk5.next = Chunk.getChunk();
            }
            chunk2 = chunk5.createOneSharedChunk();
            chunk2.next = Chunk.getChunk();
        }
        if (chunk3 == null) {
            return chunk2;
        }
        chunk4.next = chunk2;
        return chunk3;
    }

    public int setShareBuffer() {
        Chunk chunk = this;
        int n = 0;
        while (true) {
            if (!chunk.readOnlySharedBuf) {
                chunk.readOnlySharedBuf = true;
                ++n;
            }
            if (chunk.next == null) {
                return n;
            }
            chunk = chunk.next;
        }
    }
}

