/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInput;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringInput;

public class ChunkedDataInputStream
extends ChunkedInputStream
implements DataInput,
StringInput,
ChunkInput {
    private boolean hasBackingInputStream = false;

    protected ChunkedDataInputStream() {
    }

    public ChunkedDataInputStream(Chunk chunk, int n) {
        super(chunk, n);
    }

    public ChunkedDataInputStream(Chunk chunk, int n, InputStream inputStream) throws IOException {
        super(chunk, n, inputStream);
        this.hasBackingInputStream = true;
    }

    public final void readFully(byte[] byArray) throws IOException {
        DataIO.readFully(this, byArray);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        DataIO.readFully(this, byArray, n, n2);
    }

    public final int skipBytes(int n) throws IOException {
        return DataIO.skipBytes(this, n);
    }

    public final boolean readBoolean() throws IOException {
        return DataIO.readBoolean(this);
    }

    public byte readByte() throws IOException {
        Chunk chunk = this.head;
        if (this.chunkPos + 1 <= chunk.end) {
            return chunk.buf[this.chunkPos++];
        }
        return DataIO.readByte(this);
    }

    public final int readUnsignedByte() throws IOException {
        return DataIO.readUnsignedByte(this);
    }

    public short readShort() throws IOException {
        int n = this.chunkPos;
        Chunk chunk = this.head;
        if (n + 2 <= chunk.end) {
            byte[] byArray = chunk.buf;
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            this.chunkPos = n;
            return (short)((n2 << 8) + (n3 << 0));
        }
        return DataIO.readShort(this);
    }

    public int readUnsignedShort() throws IOException {
        int n = this.chunkPos;
        Chunk chunk = this.head;
        if (n + 2 <= chunk.end) {
            byte[] byArray = chunk.buf;
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            this.chunkPos = n;
            return (n2 << 8) + (n3 << 0);
        }
        return DataIO.readUnsignedShort(this);
    }

    public char readChar() throws IOException {
        int n = this.chunkPos;
        Chunk chunk = this.head;
        if (n + 2 <= chunk.end) {
            byte[] byArray = chunk.buf;
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            this.chunkPos = n;
            return (char)((n2 << 8) + (n3 << 0));
        }
        return DataIO.readChar(this);
    }

    public int readInt() throws IOException {
        int n = this.chunkPos;
        Chunk chunk = this.head;
        if (n + 4 <= chunk.end) {
            byte[] byArray = chunk.buf;
            int n2 = byArray[n++] & 0xFF;
            int n3 = byArray[n++] & 0xFF;
            int n4 = byArray[n++] & 0xFF;
            int n5 = byArray[n++] & 0xFF;
            this.chunkPos = n;
            return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
        }
        return DataIO.readInt(this);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readLength() throws IOException {
        int n = this.chunkPos;
        Chunk chunk = this.head;
        if (n + 5 <= chunk.end) {
            int n2;
            if ((n2 = chunk.buf[n++] & 0xFF) < 254) {
                this.chunkPos = n;
                return n2;
            }
            if (n2 == 254) {
                byte[] byArray = chunk.buf;
                int n3 = byArray[n++] & 0xFF;
                int n4 = byArray[n++] & 0xFF;
                this.chunkPos = n;
                return (n3 << 8) + n4;
            }
            byte[] byArray = chunk.buf;
            int n5 = byArray[n++] & 0xFF;
            int n6 = byArray[n++] & 0xFF;
            int n7 = byArray[n++] & 0xFF;
            int n8 = byArray[n++] & 0xFF;
            this.chunkPos = n;
            return (n5 << 24) + (n6 << 16) + (n7 << 8) + (n8 << 0);
        }
        return DataIO.readLength(this);
    }

    public final String readASCII() throws IOException {
        int n = this.readLength();
        this.ensureAvailable(n);
        byte[] byArray = new byte[n];
        this.read(byArray);
        return StringUtils.getString(byArray);
    }

    public final String readLine() throws IOException {
        return DataIO.readLine(this);
    }

    public final String readUTF() throws IOException {
        int n;
        if (this.hasBackingInputStream) {
            return DataIO.readUTF(this);
        }
        int n2 = this.readUnsignedShort();
        char[] cArray = new char[n2];
        int[] nArray = new int[1];
        for (int i = 0; i < n2; i += n) {
            n = this.readUTFFromChunk(cArray, i, n2 - i, nArray);
        }
        return new String(cArray, 0, nArray[0]);
    }

    private int readUTFFromChunk(char[] cArray, int n, int n2, int[] nArray) throws IOException {
        int n3;
        int n4;
        int n5 = this.head.end - this.chunkPos;
        int n6 = 0;
        boolean bl = false;
        if (n5 < n2) {
            n4 = n5;
        } else {
            n4 = n2;
            bl = true;
        }
        while (n6 < n4) {
            if ((n3 = this.head.buf[this.chunkPos++] & 0xFF) > 127) {
                --this.chunkPos;
                break;
            }
            ++n6;
            cArray[n++] = (char)n3;
            nArray[0] = nArray[0] + 1;
        }
        block6: while (n6 < n4) {
            n3 = this.head.buf[this.chunkPos++] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n6;
                    cArray[n++] = (char)n3;
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    int n7;
                    int n8;
                    n6 += 2;
                    if (bl) {
                        if (n6 > n4) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                    } else if (n6 > n4) {
                        if (!this.advanceChunk()) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        n8 = this.head.end - this.chunkPos;
                        if (n8 < 1) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                    }
                    if (((n7 = this.head.buf[this.chunkPos++] & 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n++] = (char)((n3 & 0x1F) << 6 | n7 & 0x3F);
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
                case 14: {
                    int n9;
                    int n7;
                    int n8;
                    n6 += 3;
                    if (bl) {
                        if (n6 > n4) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        n7 = this.head.buf[this.chunkPos++] & 0xFF;
                        n9 = this.head.buf[this.chunkPos++] & 0xFF;
                    } else if (n6 > n4) {
                        if (n6 - n4 == 1) {
                            n7 = this.head.buf[this.chunkPos++] & 0xFF;
                            if (!this.advanceChunk()) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            n8 = this.head.end - this.chunkPos;
                            if (n8 < 1) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            n9 = this.head.buf[this.chunkPos++] & 0xFF;
                        } else {
                            if (!this.advanceChunk()) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            n8 = this.head.end - this.chunkPos;
                            if (n8 < 2) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            n7 = this.head.buf[this.chunkPos++] & 0xFF;
                            n9 = this.head.buf[this.chunkPos++] & 0xFF;
                        }
                    } else {
                        n7 = this.head.buf[this.chunkPos++] & 0xFF;
                        n9 = this.head.buf[this.chunkPos++] & 0xFF;
                    }
                    if ((n7 & 0xC0) != 128 || (n9 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n++] = (char)((n3 & 0xF) << 12 | (n7 & 0x3F) << 6 | (n9 & 0x3F) << 0);
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
            }
            throw new UTFDataFormatException();
        }
        this.advanceChunk();
        return n6;
    }

    private boolean advanceChunk() {
        if (this.chunkPos == this.head.end && this.head.next != null) {
            this.advanceList();
            return true;
        }
        return false;
    }

    public final int peekInt() throws IOException {
        return this.peekInt(0);
    }

    protected void ensureAvailable(int n) throws IOException {
    }

    public final String readUTF8() throws IOException {
        int n;
        int n2 = this.readInt();
        this.ensureAvailable(n2);
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2; i += n - this.chunkPos) {
            int n4;
            while (this.head.end - this.chunkPos < 3 && i < n2) {
                n4 = this.pos();
                cArray[n3++] = this.readUTF8wchar();
                i += this.pos() - n4;
            }
            n4 = Math.min(this.head.end - this.chunkPos - 2, n2 - i);
            n = this.chunkPos;
            while (n < this.chunkPos + n4) {
                int n5;
                if (((n5 = this.head.buf[n++] & 0xFF) & 0x80) != 0) {
                    int n6;
                    if ((n5 & 0xE0) == 192) {
                        n6 = this.head.buf[n++] & 0xFF;
                        n5 = ((n5 & 0x1F) << 6) + (n6 & 0x3F);
                    } else {
                        n6 = this.head.buf[n++] & 0xFF;
                        int n7 = this.head.buf[n++] & 0xFF;
                        n5 = ((n5 & 0xF) << 12) + ((n6 & 0x3F) << 6) + (n7 & 0x3F);
                    }
                }
                cArray[n3++] = (char)n5;
            }
            this.chunkPos = n;
        }
        return StringUtils.getString(cArray, 0, n3);
    }

    private final char readUTF8wchar() throws IOException {
        int n = this.read() & 0xFF;
        if ((n & 0x80) != 0) {
            if ((n & 0xE0) == 192) {
                int n2 = this.read() & 0xFF;
                n = ((n & 0x1F) << 6) + (n2 & 0x3F);
            } else {
                int n3 = this.read() & 0xFF;
                int n4 = this.read() & 0xFF;
                n = ((n & 0xF) << 12) + ((n3 & 0x3F) << 6) + (n4 & 0x3F);
            }
        }
        return (char)n;
    }

    public final Chunk readChunks() throws IOException {
        Chunk chunk;
        int n = this.readInt();
        if (n > this.head.end - this.chunkPos) {
            Chunk chunk2;
            chunk = Chunk.split(this.head, this.chunkPos);
            this.head.next = chunk2 = Chunk.split(chunk, n);
        } else {
            chunk = Chunk.getChunk();
            System.arraycopy(this.head.buf, this.chunkPos, chunk.buf, 0, n);
            chunk.end += n;
            this.chunkPos += n;
        }
        return chunk;
    }

    public final int peekInt(int n) throws IOException {
        int n2 = this.peek(n);
        if (n2 < 0) {
            throw new EOFException();
        }
        int n3 = this.peek(n + 1);
        if (n3 < 0) {
            throw new EOFException();
        }
        int n4 = this.peek(n + 2);
        if (n4 < 0) {
            throw new EOFException();
        }
        int n5 = this.peek(n + 3);
        if (n5 < 0) {
            throw new EOFException();
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public final short peekShort() throws IOException {
        return this.peekShort(0);
    }

    public final short peekShort(int n) throws IOException {
        int n2 = this.peek(n);
        if (n2 < 0) {
            throw new EOFException();
        }
        int n3 = this.peek(n + 1);
        if (n3 < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n3 << 0));
    }

    public final int peekLength() throws IOException {
        return this.peekLength(0);
    }

    public final int peekLength(int n) throws IOException {
        int n2 = this.peek();
        if (n2 < 0) {
            throw new EOFException();
        }
        if (n2 < 254) {
            return n2;
        }
        if (n2 == 254) {
            return this.peekShort(n + 1);
        }
        return this.peekInt(n + 1);
    }
}

