/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.Debug;
import weblogic.utils.Hex;
import weblogic.utils.io.Chunk;

public class ChunkedOutputStream
extends OutputStream {
    private static final boolean ASSERT = false;
    protected static final boolean READONLY_CHECK = true;
    protected Chunk head;
    protected Chunk current;
    protected int chunkPos;
    protected int streamPos;
    private boolean written = false;

    public ChunkedOutputStream() {
        this.init(Chunk.getChunk());
    }

    protected ChunkedOutputStream(Chunk chunk) {
        this.init(chunk);
    }

    protected final void init(Chunk chunk) {
        this.head = this.current = chunk;
        this.chunkPos = 0;
        this.streamPos = 0;
        this.written = false;
    }

    public final void write(int n) {
        this.checkWritable();
        if (this.chunkPos == Chunk.CHUNK_SIZE) {
            this.advance();
            this.checkWritable();
        }
        this.current.buf[this.chunkPos++] = (byte)n;
    }

    protected final void advance() {
        if (this.current.next == null) {
            this.current.next = Chunk.getChunk();
        }
        this.current.end = this.chunkPos;
        this.current = this.current.next;
        this.streamPos += this.chunkPos;
        this.chunkPos = 0;
    }

    public final void write(byte[] byArray, int n, int n2) {
        this.checkWritable();
        while (n2 > 0) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
                this.checkWritable();
            }
            int n3 = Math.min(Chunk.CHUNK_SIZE - this.chunkPos, n2);
            System.arraycopy(byArray, n, this.current.buf, this.chunkPos, n3);
            n += n3;
            n2 -= n3;
            this.chunkPos += n3;
        }
    }

    protected void checkWritable() {
        if (this.current.readOnlySharedBuf) {
            throw new AssertionError();
        }
    }

    public Chunk getChunks() {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        this.streamPos = 0;
        this.chunkPos = 0;
        Chunk chunk = this.head;
        this.current = null;
        this.head = null;
        this.written = true;
        return chunk;
    }

    public Chunk getSharedBeforeCopyTail() {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        Chunk chunk = this.head;
        while (chunk != null && chunk != this.current) {
            chunk = chunk.next;
        }
        if (chunk != this.current) {
            throw new AssertionError();
        }
        return this.head.getSharedBeforeTailCopy(this.current);
    }

    public String dumpBuf() {
        byte[] byArray = this.getBuffer();
        return Hex.dump(byArray, 0, byArray.length);
    }

    public byte[] getBuffer() {
        byte[] byArray = new byte[this.getSize()];
        Chunk chunk = this.head;
        int n = 0;
        while (chunk != null) {
            System.arraycopy(chunk.buf, 0, byArray, n, chunk.end);
            n += chunk.end;
            chunk = chunk.next;
        }
        return byArray;
    }

    public final int getSize() {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        Chunk chunk = this.head;
        int n = 0;
        while (chunk != null) {
            n += chunk.end;
            chunk = chunk.next;
        }
        return n;
    }

    public final int getPosition() {
        return this.streamPos + this.chunkPos;
    }

    public int getChunkPos() {
        return this.chunkPos;
    }

    public Chunk getCurrentChunk() {
        return this.current;
    }

    protected final void check() {
        Debug.assertion(!this.written);
    }

    public final void setPosition(int n) {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        this.current = this.head;
        this.streamPos = n;
        while (n > this.current.end) {
            if (this.current.next == null) {
                this.current.next = Chunk.getChunk();
                this.current.end = Math.min(Chunk.CHUNK_SIZE, n);
            }
            n -= this.current.end;
            this.current = this.current.next;
        }
        this.chunkPos = n;
        this.streamPos -= this.chunkPos;
    }

    public final void skip(int n) {
        while (n > 0) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
            }
            int n2 = Math.min(Chunk.CHUNK_SIZE - this.chunkPos, n);
            n -= n2;
            this.chunkPos += n2;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        while (this.head != null) {
            if (this.head.end > 0) {
                outputStream.write(this.head.buf, 0, this.head.end);
            }
            Chunk chunk = this.head;
            this.head = this.head.next;
            Chunk.releaseChunk(chunk);
        }
        this.written = true;
    }

    public void reset() {
        if (this.head != null && this.head.next != null) {
            Chunk.releaseChunks(this.head.next);
            this.head.next = null;
        }
        if (this.head == null || this.head.readOnlySharedBuf) {
            this.head = Chunk.getChunk();
        }
        this.init(this.head);
    }

    public byte[] getBytesSince(Chunk chunk, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = 0;
            if (chunk.end == 0) {
                n4 = n2;
            } else {
                n4 = chunk.end - n;
                if (n2 < n4) {
                    n4 = n2;
                }
            }
            System.arraycopy(chunk.buf, n, byArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            chunk = chunk.next;
            n = 0;
        }
        return byArray;
    }

    public String toString() {
        return super.toString() + " - chunkPos: '" + this.chunkPos + "', currentChunk: '" + this.current + "'";
    }
}

