/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.kernel.AuditableThread;
import weblogic.kernel.KernelStatus;
import weblogic.work.WorkManagerLite;

public class ExecuteThreadLite
extends AuditableThread {
    private WorkManagerLite wm;
    private int hashcode;
    private Runnable runnable;
    private boolean started;

    ExecuteThreadLite(int n, WorkManagerLite workManagerLite, ThreadGroup threadGroup) {
        super(threadGroup, "ExecuteThread: '" + n + "' for queue: '" + workManagerLite.getName() + "'");
        this.init(workManagerLite);
    }

    protected void init(WorkManagerLite workManagerLite) {
        this.wm = workManagerLite;
        this.hashcode = this.getName().hashCode();
        this.setDaemon(true);
    }

    public int hashCode() {
        return this.hashcode;
    }

    synchronized void notifyRequest(Runnable runnable) {
        this.runnable = runnable;
        this.notify();
    }

    void setRequest(Runnable runnable) {
        this.runnable = runnable;
    }

    private synchronized void waitForRequest() {
        while (this.runnable == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ExecuteThreadLite executeThreadLite = this;
        synchronized (executeThreadLite) {
            this.started = true;
            this.readyToRun();
            this.notify();
        }
        while (true) {
            try {
                while (true) {
                    if (this.runnable != null) {
                        this.execute(this.runnable);
                    }
                    this.reset();
                    this.wm.registerIdle(this);
                    if (this.runnable != null) continue;
                    this.waitForRequest();
                }
            }
            catch (ThreadDeath threadDeath) {
                if (!KernelStatus.isServer()) continue;
                throw threadDeath;
            }
            break;
        }
    }

    void execute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected final void reset() {
        super.reset();
        this.runnable = null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public WorkManagerLite getWorkManager() {
        return this.wm;
    }
}

