/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerLite;

public class WorkManagerFactory {
    public static final int UNSPECIFIED = -1;
    public static final int HIGH_FAIR_SHARE = 100;
    protected static WorkManagerFactory SINGLETON;
    protected WorkManager DEFAULT;
    protected WorkManager SYSTEM;
    protected WorkManager REJECTOR;
    final Map byName = Collections.synchronizedMap(new HashMap());

    protected WorkManagerFactory() {
    }

    public static synchronized boolean isInitialized() {
        return SINGLETON != null;
    }

    protected static synchronized void set(WorkManagerFactory workManagerFactory) {
        if (SINGLETON != null) {
            throw new AssertionError((Object)"Duplicate initialization of WorkManager");
        }
        SINGLETON = workManagerFactory;
    }

    public static WorkManagerFactory getInstance() {
        if (SINGLETON != null) {
            return SINGLETON;
        }
        WorkManagerFactory.initDelegate();
        return SINGLETON;
    }

    public final WorkManager getDefault() {
        return this.DEFAULT;
    }

    public final WorkManager getSystem() {
        return this.SYSTEM;
    }

    final WorkManager getRejector() {
        return this.REJECTOR;
    }

    public final WorkManager findOrCreate(String string, int n, int n2, int n3) {
        WorkManager workManager;
        if (SINGLETON == null) {
            WorkManagerFactory.initDelegate();
        }
        if ((workManager = (WorkManager)this.byName.get(string)) != null) {
            return workManager;
        }
        workManager = this.findAppScoped(string, null, null, false);
        if (workManager != null && workManager.getName().equals(string)) {
            return workManager;
        }
        workManager = this.create(string, n, n2, n3);
        this.byName.put(string, workManager);
        return workManager;
    }

    public final WorkManager findOrCreateResponseTime(String string, int n, int n2, int n3) {
        WorkManager workManager = (WorkManager)this.byName.get(string);
        if (workManager != null) {
            return workManager;
        }
        workManager = this.createResponseTime(string, n, n2, n3);
        this.byName.put(string, workManager);
        return workManager;
    }

    public final WorkManager findOrCreate(String string, int n, int n2) {
        return this.findOrCreate(string, -1, n, n2);
    }

    public final WorkManager find(String string) {
        WorkManager workManager = (WorkManager)this.byName.get(string);
        if (workManager != null) {
            return workManager;
        }
        workManager = this.findAppScoped(string, null, null);
        return workManager != null ? workManager : this.DEFAULT;
    }

    public final WorkManager find(String string, String string2, String string3) {
        WorkManager workManager = (WorkManager)this.byName.get(string);
        if (workManager != null) {
            return workManager;
        }
        workManager = this.findAppScoped(string, string2, string3);
        return workManager != null ? workManager : this.DEFAULT;
    }

    private static synchronized void initDelegate() {
        if (SINGLETON != null) {
            return;
        }
        SINGLETON = new WorkManagerFactory();
        SINGLETON.initialize();
    }

    private void initialize() {
        this.SYSTEM = this.DEFAULT = new WorkManagerLite("default");
        this.byName.put("weblogic.kernel.Default", this.DEFAULT);
        this.byName.put("default", this.DEFAULT);
        this.byName.put("weblogic.kernel.System", this.SYSTEM);
        WorkManagerLite workManagerLite = new WorkManagerLite();
        this.byName.put("direct", workManagerLite);
    }

    protected WorkManager create(String string, int n, int n2, int n3) {
        return new WorkManagerLite(string, Math.max(n2, n3));
    }

    protected WorkManager createResponseTime(String string, int n, int n2, int n3) {
        return this.create(string, -1, n2, n3);
    }

    protected WorkManager findAppScoped(String string, String string2, String string3) {
        return this.findAppScoped(string, string2, string3, true);
    }

    protected WorkManager findAppScoped(String string, String string2, String string3, boolean bl) {
        return null;
    }

    public final void remove(String string) {
        WorkManager workManager = (WorkManager)this.byName.get(string);
        if (workManager != null) {
            this.byName.remove(string);
        }
    }
}

