/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.kernel.AuditableThread;
import weblogic.work.WorkManager;

public abstract class WorkManagerImpl
implements WorkManager {
    private static final ThreadGroup WEBLOGIC_DAEMON_GROUP = new ThreadGroup("Non-Pooled Threads");
    protected String wmName;
    protected String applicationName;
    protected String moduleName;
    protected boolean isInternal;

    public String getName() {
        return this.wmName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setInternal() {
        this.isInternal = true;
    }

    public void setInternal(boolean bl) {
        this.isInternal = bl;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setThreadCount(int n) throws IllegalStateException, SecurityException {
        throw new IllegalStateException("WorkManager [" + this.toString() + "] does not support setting thread count");
    }

    public static void executeDaemonTask(String string, int n, Runnable runnable) {
        AuditableThread auditableThread = new AuditableThread(WEBLOGIC_DAEMON_GROUP, runnable, string);
        auditableThread.setDaemon(true);
        auditableThread.setPriority(n);
        auditableThread.start();
    }

    public String toString() {
        return this.applicationName + "@" + this.moduleName + "@" + this.wmName;
    }
}

