/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.List;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.utils.collections.Stack;
import weblogic.work.ExecuteThreadLite;
import weblogic.work.WorkManagerImpl;

public final class WorkManagerLite
extends WorkManagerImpl {
    private static final ThreadGroup THREAD_GROUP = WorkManagerLite.initThreadGroup();
    private static final int THREAD_POOL_SIZE = WorkManagerLite.initThreadPoolSize();
    private final Stack idleThreads = new Stack();
    private final List threadPool = new ArrayList();
    private final UnsyncCircularQueue queue = new UnsyncCircularQueue();
    private static final String THREAD_POOL_SIZE_PROP = "weblogic.thinclient.kernel.ThreadPoolSize";
    private static final int DEFAULT_POOL_SIZE = 5;

    public String getName() {
        return this.wmName;
    }

    public String getApplicationName() {
        return null;
    }

    public String getModuleName() {
        return null;
    }

    public int getType() {
        return 2;
    }

    public int getConfiguredThreadCount() {
        return this.threadPool.size();
    }

    private static int initThreadPoolSize() {
        try {
            return Integer.getInteger(THREAD_POOL_SIZE_PROP, 5);
        }
        catch (SecurityException securityException) {
            return 5;
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }

    private static ThreadGroup initThreadGroup() {
        try {
            return new ThreadGroup("Pooled Threads");
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private ExecuteThreadLite create(int n) {
        return new ExecuteThreadLite(n, this, THREAD_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ExecuteThreadLite executeThreadLite) {
        executeThreadLite.start();
        ExecuteThreadLite executeThreadLite2 = executeThreadLite;
        synchronized (executeThreadLite2) {
            while (!executeThreadLite.isStarted()) {
                try {
                    executeThreadLite.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    WorkManagerLite() {
        this.wmName = "direct";
    }

    WorkManagerLite(String string) {
        this(string, THREAD_POOL_SIZE);
    }

    WorkManagerLite(String string, int n) {
        this.wmName = string;
        this.setThreadCount(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCount(int n) {
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            int n2;
            if (n <= this.threadPool.size()) {
                return;
            }
            for (int i = n2 = this.threadPool.size(); i < n; ++i) {
                ExecuteThreadLite executeThreadLite = this.create(i);
                this.threadPool.add(executeThreadLite);
                this.start(executeThreadLite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable runnable) {
        if ("direct" == this.wmName) {
            runnable.run();
            return;
        }
        ExecuteThreadLite executeThreadLite = null;
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            if (this.idleThreads.size() > 0) {
                executeThreadLite = (ExecuteThreadLite)this.idleThreads.pop();
            }
            if (executeThreadLite == null) {
                this.queue.put(runnable);
                return;
            }
        }
        executeThreadLite.notifyRequest(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIdle(ExecuteThreadLite executeThreadLite) {
        Runnable runnable = null;
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            runnable = (Runnable)this.queue.get();
            if (runnable == null) {
                this.idleThreads.push(executeThreadLite);
                return;
            }
        }
        executeThreadLite.setRequest(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeIfIdle(Runnable runnable) {
        ExecuteThreadLite executeThreadLite;
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            if (this.idleThreads.size() == 0) {
                return false;
            }
            executeThreadLite = (ExecuteThreadLite)this.idleThreads.pop();
        }
        executeThreadLite.notifyRequest(runnable);
        return true;
    }

    public boolean scheduleIfBusy(Runnable runnable) {
        if (this.getQueueDepth() > 0) {
            this.schedule(runnable);
            return true;
        }
        return false;
    }

    public int getQueueDepth() {
        return this.queue.size();
    }

    public boolean isThreadOwner(Thread thread) {
        if (!(thread instanceof ExecuteThreadLite)) {
            return false;
        }
        ExecuteThreadLite executeThreadLite = (ExecuteThreadLite)thread;
        return this == executeThreadLite.getWorkManager();
    }

    public void setInternal() {
    }

    public boolean isInternal() {
        return false;
    }
}

