/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea.utils;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

public final class WorkContextInputAdapter
implements WorkContextInput {
    private final ObjectInput oi;

    public WorkContextInputAdapter(ObjectInput objectInput) {
        this.oi = objectInput;
    }

    public String readASCII() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray, 0);
    }

    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        clazz = Thread.currentThread().getContextClassLoader() != null ? Class.forName(this.readASCII(), false, Thread.currentThread().getContextClassLoader()) : Class.forName(this.readASCII());
        try {
            WorkContext workContext = (WorkContext)clazz.newInstance();
            workContext.readContext(this);
            return workContext;
        }
        catch (InstantiationException instantiationException) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(illegalAccessException);
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        this.oi.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.oi.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.oi.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.oi.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.oi.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.oi.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.oi.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.oi.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.oi.readChar();
    }

    public int readInt() throws IOException {
        return this.oi.readInt();
    }

    public long readLong() throws IOException {
        return this.oi.readLong();
    }

    public float readFloat() throws IOException {
        return this.oi.readFloat();
    }

    public double readDouble() throws IOException {
        return this.oi.readDouble();
    }

    public String readLine() throws IOException {
        return this.oi.readLine();
    }

    public String readUTF() throws IOException {
        return this.oi.readUTF();
    }
}

