/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.dom;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DOMSerializer {
    public static void serialize(Node node, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        DOMSerializer.serialize(node, xMLStreamWriter, false, false);
    }

    public static void serialize(Node node, XMLStreamWriter xMLStreamWriter, boolean bl, boolean bl2) throws XMLStreamException {
        block0: while (node != null) {
            DOMSerializer.start(node, xMLStreamWriter, bl, bl2);
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                node = node2;
                continue;
            }
            node2 = node.getNextSibling();
            if (node2 != null) {
                DOMSerializer.end(node, xMLStreamWriter);
                node = node2;
                continue;
            }
            do {
                DOMSerializer.end(node, xMLStreamWriter);
                node = node.getParentNode();
                if (node == null || node.getNextSibling() == null) continue;
                DOMSerializer.end(node, xMLStreamWriter);
                node = node.getNextSibling();
                continue block0;
            } while (node != null);
        }
    }

    private static void start(Node node, XMLStreamWriter xMLStreamWriter, boolean bl, boolean bl2) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 1: {
                String string = node.getLocalName();
                if (string == null) {
                    string = node.getNodeName();
                }
                xMLStreamWriter.writeStartElement(node.getNamespaceURI(), string);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    String string2;
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string3 = attr.getNodeName();
                    if (string3.startsWith("xmlns")) {
                        string2 = "";
                        if (string3.length() >= 5 && string3.charAt(5) == ':') {
                            string2 = string3.substring(6);
                        }
                        xMLStreamWriter.writeNamespace(string2, attr.getValue());
                        continue;
                    }
                    string2 = attr.getNamespaceURI();
                    String string4 = attr.getLocalName();
                    if (string2 == null && string4 == null) {
                        string4 = string3;
                    }
                    xMLStreamWriter.writeAttribute(string2, string4, attr.getValue());
                }
                break;
            }
            case 3: {
                xMLStreamWriter.writeCharacters(node.getNodeValue());
                break;
            }
            case 8: {
                if (bl2) break;
                xMLStreamWriter.writeComment(node.getNodeValue());
                break;
            }
            case 7: {
                if (bl) break;
                xMLStreamWriter.writeProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 4: {
                xMLStreamWriter.writeCData(node.getNodeValue());
                break;
            }
            case 9: {
                xMLStreamWriter.writeStartDocument();
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                xMLStreamWriter.writeDTD("<!DOCTYPE " + documentType.getNodeName() + ">");
            }
        }
    }

    private static void end(Node node, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (node.getNodeType() == 1) {
            xMLStreamWriter.writeEndElement();
        } else if (node.getNodeType() == 9) {
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.close();
        }
    }
}

