/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stax.bin;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.stax.bin.BinaryXMLConstants;
import weblogic.xml.stax.util.NamespaceContextImpl;

public final class BinaryXMLStreamReader
implements XMLStreamReader {
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private final boolean v1;
    private int currentKind;
    private int currentEvent;
    private int nextKind;
    private final DataInput dis;
    private String version;
    private String encoding;
    private final ArrayList dict = new ArrayList();
    private NamespaceContextImpl context;
    private String localName;
    private String namespaceURI;
    private String strVal;
    private final ArrayList attributes = new ArrayList();
    private int numAttrs;
    private final ArrayList namespaces = new ArrayList();
    private int numNamespaces;
    private char[] tmpCharBuf = new char[0];
    private byte[] tmpByteBuf = new byte[0];

    public BinaryXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        this.dis = inputStream instanceof DataInput ? (DataInput)((Object)inputStream) : new DataInputStream(inputStream);
        byte[] byArray = new byte[BinaryXMLConstants.HEADERV2_BYTES.length];
        try {
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        if (Arrays.equals(BinaryXMLConstants.HEADERV2_BYTES, byArray)) {
            this.v1 = false;
        } else if (Arrays.equals(BinaryXMLConstants.HEADERV1_BYTES, byArray)) {
            this.v1 = true;
        } else {
            throw new XMLStreamException("Invalid token stream");
        }
        this.advance();
    }

    public int next() throws XMLStreamException {
        this.consumeDictionaryOps();
        switch (this.nextKind) {
            case 3: {
                this.version = this.readString();
                this.encoding = this.readString();
                this.advance();
                this.currentEvent = 7;
                return 7;
            }
            case 1: {
                if (this.context != null) {
                    this.context.openScope();
                }
                this.readQName();
                this.advance();
                this.consumeAttributesAndNamespaces();
                this.currentEvent = 1;
                return 1;
            }
            case 4: {
                if (this.context != null) {
                    this.context.closeScope(false);
                }
                this.advance();
                this.currentEvent = 2;
                return 2;
            }
            case 6: {
                this.advance();
                this.currentEvent = 8;
                return 8;
            }
            case 7: {
                this.strVal = this.readString();
                this.advance();
                this.currentEvent = 5;
                return 5;
            }
            case 10: {
                this.strVal = this.readString();
                this.advance();
                this.currentEvent = 4;
                return 4;
            }
            case 9: {
                this.readQName();
                this.strVal = this.readString();
                this.advance();
                this.currentEvent = 3;
                return 3;
            }
            case 50: {
                this.strVal = this.readString();
                this.readString();
                this.readString();
                this.advance();
                this.currentEvent = 11;
                return 11;
            }
            case 62: 
            case 1002: {
                this.currentEvent = 8;
                this.currentEvent = 8;
                return 8;
            }
        }
        throw new XMLStreamException("Unexpected token: " + this.nextKind);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return null;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.currentEvent == n && string != null && string.equals(this.getNamespaceURI()) && string2 != null && string2.equals(this.getLocalName())) {
            return;
        }
        throw new XMLStreamException();
    }

    public String getElementText() throws XMLStreamException {
        if (!this.isStartElement()) {
            throw new XMLStreamException("getElementText can only be called for START_ELEMENT");
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.isCharacters()) {
            stringBuffer.append(this.getText());
        }
        return stringBuffer.toString();
    }

    public int nextTag() throws XMLStreamException {
        return BinaryXMLStreamReader.convert(this.nextKind);
    }

    public boolean hasNext() throws XMLStreamException {
        return this.currentEvent != 8;
    }

    public String getNamespaceURI(String string) {
        if (this.context != null) {
            return this.context.getNamespaceURI(string);
        }
        return null;
    }

    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    public boolean isCharacters() {
        return this.currentEvent == 4;
    }

    public boolean isWhiteSpace() {
        if (!this.isCharacters()) {
            return false;
        }
        block3: for (int i = 0; i < this.strVal.length(); ++i) {
            switch (this.strVal.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public String getAttributeValue(String string, String string2) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        for (int i = 0; i < this.numAttrs; ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            if (attribute.uri != string && (attribute.uri == null || !attribute.uri.equals(string)) || attribute.localName != string2 && (attribute.localName == null || !attribute.localName.equals(string2))) continue;
            return attribute.val;
        }
        return "";
    }

    public void close() throws XMLStreamException {
        this.dict.clear();
    }

    public int getAttributeCount() {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        return this.numAttrs;
    }

    public QName getAttributeName(int n) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        return new QName(this.getAttributeNamespace(n), this.getAttributeLocalName(n), this.getAttributePrefix(n));
    }

    public String getAttributeNamespace(int n) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        Attribute attribute = (Attribute)this.attributes.get(n);
        return attribute.uri;
    }

    public String getAttributeLocalName(int n) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        Attribute attribute = (Attribute)this.attributes.get(n);
        return attribute.localName;
    }

    public String getAttributePrefix(int n) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        if (this.context == null) {
            return null;
        }
        return this.context.getPrefix(this.getAttributeNamespace(n));
    }

    public String getAttributeType(int n) {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attributes may only be accessed from START_ELEMENT event");
        }
        return "CDATA";
    }

    public String getAttributeValue(int n) {
        Attribute attribute = (Attribute)this.attributes.get(n);
        return attribute.val;
    }

    public boolean isAttributeSpecified(int n) {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return this.encoding;
    }

    public int getNamespaceCount() {
        return this.numNamespaces;
    }

    public String getNamespacePrefix(int n) {
        Namespace namespace = (Namespace)this.namespaces.get(n);
        return namespace.prefix;
    }

    public String getNamespaceURI(int n) {
        Namespace namespace = (Namespace)this.namespaces.get(n);
        return namespace.uri;
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public int getEventType() {
        return this.currentEvent;
    }

    public String getText() {
        switch (this.currentEvent) {
            case 3: 
            case 4: 
            case 5: {
                return this.strVal;
            }
        }
        throw new IllegalArgumentException();
    }

    public char[] getTextCharacters() {
        switch (this.currentEvent) {
            case 3: 
            case 4: 
            case 5: {
                return this.strVal.toCharArray();
            }
        }
        throw new IllegalStateException();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getTextCharacters().length;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean hasText() {
        switch (this.currentKind) {
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public Location getLocation() {
        return new Location(){

            public int getLineNumber() {
                return -1;
            }

            public int getColumnNumber() {
                return -1;
            }

            public int getCharacterOffset() {
                return -1;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
    }

    public String getLocalName() {
        switch (this.currentKind) {
            case 1: 
            case 2: {
                return this.localName;
            }
        }
        return null;
    }

    public boolean hasName() {
        switch (this.currentEvent) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public String getNamespaceURI() {
        switch (this.currentKind) {
            case 1: 
            case 4: {
                return this.namespaceURI;
            }
        }
        return null;
    }

    public String getPrefix() {
        if (this.context == null) {
            return null;
        }
        return this.context.getPrefix(this.getNamespaceURI());
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getPITarget() {
        if (this.currentEvent != 3) {
            throw new IllegalStateException("Current state must be XMLStreamConstants.PROCESSING_INSTRUCTION");
        }
        return this.localName;
    }

    public String getPIData() {
        if (this.currentEvent != 3) {
            throw new IllegalStateException("Current state must be XMLStreamConstants.PROCESSING_INSTRUCTION");
        }
        return this.strVal;
    }

    private void consumeDictionaryOps() throws XMLStreamException {
        while (true) {
            switch (this.nextKind) {
                case 60: 
                case 1000: {
                    String string = this.readString();
                    this.dict.add(string);
                    break;
                }
                case 61: 
                case 1001: {
                    this.dict.clear();
                    break;
                }
                default: {
                    return;
                }
            }
            this.nextKind = this.readInt();
        }
    }

    private void consumeAttributesAndNamespaces() throws XMLStreamException {
        this.numAttrs = 0;
        this.numNamespaces = 0;
        while (true) {
            this.consumeDictionaryOps();
            switch (this.nextKind) {
                case 2: {
                    this.consumeAttribute();
                    break;
                }
                case 8: {
                    this.consumeNamespace();
                    break;
                }
                default: {
                    return;
                }
            }
            this.nextKind = this.readInt();
        }
    }

    private void consumeNamespace() throws XMLStreamException {
        Namespace namespace;
        if (this.numNamespaces + 1 > this.namespaces.size()) {
            namespace = new Namespace();
            this.namespaces.add(namespace);
        } else {
            namespace = (Namespace)this.namespaces.get(this.numNamespaces);
        }
        ++this.numNamespaces;
        this.readNamespace(namespace);
    }

    private void readNamespace(Namespace namespace) throws XMLStreamException {
        namespace.prefix = this.readAbbrevString();
        namespace.uri = this.readAbbrevString();
        if (this.context == null) {
            this.context = new NamespaceContextImpl();
            this.context.bindNamespace("xmlns", XMLNS_NS);
        }
        this.context.bindNamespace(namespace.prefix, namespace.uri);
    }

    private void consumeAttribute() throws XMLStreamException {
        Attribute attribute;
        if (this.numAttrs + 1 > this.attributes.size()) {
            attribute = new Attribute();
            this.attributes.add(attribute);
        } else {
            attribute = (Attribute)this.attributes.get(this.numAttrs);
        }
        ++this.numAttrs;
        this.readAttribute(attribute);
    }

    private void readAttribute(Attribute attribute) throws XMLStreamException {
        attribute.localName = this.readAbbrevString();
        attribute.uri = this.readAbbrevString();
        this.nextKind = this.readInt();
        this.consumeDictionaryOps();
        if (this.nextKind == 5) {
            attribute.val = "";
            this.nextKind = this.readInt();
            return;
        }
        attribute.val = this.readPCDataString();
        this.nextKind = this.readInt();
        this.consumeDictionaryOps();
        if (this.nextKind != 5) {
            throw new XMLStreamException("Expected END_ATTRIBUTE");
        }
    }

    private static final int convert(int n) throws XMLStreamException {
        switch (n) {
            case 10: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 50: {
                return 11;
            }
            case 6: {
                return 8;
            }
            case 4: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 1: {
                return 1;
            }
        }
        throw new XMLStreamException("Unexpected kind: " + n);
    }

    private void advance() throws XMLStreamException {
        this.currentKind = this.nextKind;
        this.nextKind = (short)this.readInt();
    }

    private String readPCDataString() throws XMLStreamException {
        switch (this.nextKind) {
            case 83: {
                return this.readAbbrevString();
            }
            case 19: {
                return this.readString();
            }
        }
        throw new XMLStreamException("Expected PCDATA");
    }

    private void readQName() throws XMLStreamException {
        this.localName = this.readAbbrevString();
        this.namespaceURI = this.readAbbrevString();
    }

    private String readAbbrevString() throws XMLStreamException {
        int n = this.readInt();
        if (n == 0) {
            return null;
        }
        return (String)this.dict.get(n - 1);
    }

    private String readString() throws XMLStreamException {
        int n;
        if (this.v1) {
            try {
                n = this.dis.readChar();
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        } else {
            n = this.readInt();
        }
        if (n > this.tmpByteBuf.length) {
            this.tmpByteBuf = new byte[n];
        }
        try {
            this.dis.readFully(this.tmpByteBuf, 0, n);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        if (n > this.tmpCharBuf.length) {
            this.tmpCharBuf = new char[n];
        }
        int n2 = 0;
        int n3 = 0;
        block9: while (n2 < n) {
            int n4 = this.tmpByteBuf[n2] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    this.tmpCharBuf[n3++] = (char)n4;
                    continue block9;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new XMLStreamException("Malformed UTF data");
                    }
                    byte by = this.tmpByteBuf[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new XMLStreamException("Malformed UTF data");
                    }
                    this.tmpCharBuf[n3++] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    continue block9;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new XMLStreamException("Malformed UTF data");
                    }
                    byte by = this.tmpByteBuf[n2 - 2];
                    byte by2 = this.tmpByteBuf[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new XMLStreamException();
                    }
                    this.tmpCharBuf[n3++] = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    continue block9;
                }
            }
            throw new XMLStreamException("Malformed UTF data");
        }
        return new String(this.tmpCharBuf, 0, n3);
    }

    private int readInt() throws XMLStreamException {
        if (this.v1) {
            try {
                return this.dis.readInt();
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        }
        try {
            byte by;
            int n = 0;
            int n2 = 0;
            do {
                by = this.dis.readByte();
                n += (by & 0x7F) << n2;
                n2 += 7;
            } while ((by & 0x80) == 128);
            return n;
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private static final class Attribute {
        String localName;
        String uri;
        String val;

        private Attribute() {
        }
    }

    private static final class Namespace {
        String uri;
        String prefix;

        private Namespace() {
        }
    }
}

