/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stax.bin;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.stax.bin.BinaryXMLConstants;
import weblogic.xml.stax.util.NamespaceContextImpl;

public final class BinaryXMLStreamWriter
implements XMLStreamWriter {
    private static final String DEFAULT_NS = "";
    private static final int MAX_DICT_SIZE = 1024;
    private static final int MIN_DICT_ENTRY_SIZE = 8;
    final DataOutput dos;
    private final HashMap dict = new HashMap();
    private char[] charBuf;
    private boolean writingEmptyElement;
    private NamespaceContextImpl context = new NamespaceContextImpl();
    private HashSet needToWrite;
    private boolean startElementOpened;

    public BinaryXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        this.dos = outputStream instanceof DataOutput ? (DataOutput)((Object)outputStream) : new DataOutputStream(outputStream);
        try {
            this.dos.write(BinaryXMLConstants.HEADERV2_BYTES);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.openStartElement();
        int n = this.abbrevString(string);
        this.writeInt(1);
        this.writeInt(n);
        this.writeInt(0);
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.openStartElement();
        int n = this.abbrevString(string2);
        int n2 = this.abbrevString(string);
        this.writeInt(1);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.openStartElement();
        this.writeNamespace(string, string3);
        this.writeStartElement(string3, string2);
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(string, string2);
        this.writingEmptyElement = true;
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartElement(string, string2, string3);
        this.writingEmptyElement = true;
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeStartElement(string);
        this.writingEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        this.writingEmptyElement = false;
        this.context.closeScope(false);
        this.writeInt(4);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(6);
    }

    public void close() throws XMLStreamException {
        this.writeInt(62);
        this.dict.clear();
    }

    public void flush() throws XMLStreamException {
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        int n = this.abbrevString(string);
        this.writeInt(2);
        this.writeInt(n);
        this.writeInt(0);
        this.writePCDATA(string2);
        this.writeInt(5);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.writeNamespace(string, string2);
        this.writeAttribute(string2, string3, string4);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        int n = this.abbrevString(string2);
        int n2 = this.abbrevString(string);
        this.writeInt(2);
        this.writeInt(n);
        this.writeInt(n2);
        this.writePCDATA(string3);
        this.writeInt(5);
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        int n = this.abbrevString(string);
        int n2 = this.abbrevString(string2);
        this.writeInt(8);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.writeNamespace(DEFAULT_NS, string);
        this.setPrefix(DEFAULT_NS, string);
    }

    public void writeComment(String string) throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(7);
        this.writeString(string);
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, DEFAULT_NS);
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.closeStartElement();
        int n = this.abbrevString(string);
        this.writeInt(9);
        this.writeInt(n);
        this.writeInt(0);
        this.writeString(string2);
    }

    public void writeCData(String string) throws XMLStreamException {
        this.closeStartElement();
        this.writeCharacters(string);
    }

    public void writeDTD(String string) throws XMLStreamException {
        if (!string.startsWith("<!DOCTYPE") || !string.endsWith(">")) {
            throw new XMLStreamException("Invalid DTD");
        }
        int n = (string = string.substring(9, string.length() - 1).trim()).indexOf(" ");
        String string2 = n == -1 ? string : string.substring(0, n);
        this.writeInt(50);
        this.writeString(string2);
        this.writeString(DEFAULT_NS);
        this.writeString(DEFAULT_NS);
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.closeStartElement();
        throw new AssertionError((Object)"NYI");
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(DEFAULT_NS, DEFAULT_NS);
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument(DEFAULT_NS, string);
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.writeInt(3);
        this.writeString(string2);
        this.writeString(string);
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(10);
        this.writeString(string);
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.closeStartElement();
        this.writeInt(10);
        this.writeChars(cArray, n, n2);
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.context.getPrefix(string);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.needToWrite(string2);
        this.context.bindDefaultNameSpace(string2);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.needToWrite(string);
        this.context.bindDefaultNameSpace(string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        if (namespaceContext == null) {
            throw new NullPointerException("The namespace context may not be null");
        }
        this.context = new NamespaceContextImpl(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return null;
    }

    private final void closeStartElement() throws XMLStreamException {
        if (this.startElementOpened) {
            this.flushNamespace();
            if (this.writingEmptyElement) {
                this.writeEndElement();
            }
            this.startElementOpened = false;
        }
    }

    private final void openStartElement() throws XMLStreamException {
        if (this.startElementOpened) {
            this.flushNamespace();
            if (this.writingEmptyElement) {
                this.writeEndElement();
            }
        }
        this.startElementOpened = true;
        this.context.openScope();
    }

    private final void needToWrite(String string) {
        if (this.needToWrite == null) {
            this.needToWrite = new HashSet();
        }
        this.needToWrite.add(string);
    }

    protected final void flushNamespace() throws XMLStreamException {
        if (this.needToWrite == null || this.needToWrite.size() == 0) {
            return;
        }
        for (String string : this.needToWrite) {
            String string2 = this.context.getPrefix(string);
            if (string2 == null) {
                throw new XMLStreamException("Unable to default prefix with uri:" + string);
            }
            if (string == null) {
                throw new XMLStreamException("Attempt to write a null uri.");
            }
            this.writeNamespace(string2, string);
        }
        this.needToWrite.clear();
    }

    void writeString(String string) throws XMLStreamException {
        int n = string.length();
        if (this.charBuf == null || n > this.charBuf.length) {
            this.charBuf = new char[n * 2];
        }
        string.getChars(0, n, this.charBuf, 0);
        this.writeChars(this.charBuf, 0, n);
    }

    private void writeChars(char[] cArray, int n, int n2) throws XMLStreamException {
        int n3;
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 = cArray[i];
            if (n3 >= 1 && n3 <= 127) {
                ++n4;
                continue;
            }
            if (n3 > 2047) {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        this.writeInt(n4);
        byte[] byArray = new byte[n4];
        n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        try {
            this.dos.write(byArray);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    void writePCDATA(String string) throws XMLStreamException {
        int n = string.length();
        if (n > 8) {
            int n2 = this.abbrevString(string);
            this.writeInt(83);
            this.writeInt(n2);
        } else {
            this.writeInt(19);
            this.writeString(string);
        }
    }

    void writeInt(int n) throws XMLStreamException {
        try {
            do {
                int n2 = n & 0x7F;
                if ((n >>>= 7) != 0) {
                    n2 |= 0x80;
                }
                this.dos.write(n2);
            } while (n != 0);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    int abbrevString(String string) throws XMLStreamException {
        Integer n;
        if (string == null) {
            return 0;
        }
        if (this.dict.size() >= 1024) {
            this.writeInt(61);
            this.dict.clear();
        }
        if ((n = (Integer)this.dict.get(string)) != null) {
            return n;
        }
        int n2 = this.dict.size() + 1;
        this.dict.put(string, new Integer(n2));
        this.writeInt(60);
        this.writeString(string);
        return n2;
    }
}

