/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stax.util;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import weblogic.xml.babel.baseparser.SymbolTable;

public class NamespaceContextImpl
implements NamespaceContext {
    SymbolTable prefixTable = new SymbolTable();
    SymbolTable uriTable = new SymbolTable();
    NamespaceContext rootContext;

    public NamespaceContextImpl() {
        this.init();
    }

    public NamespaceContextImpl(NamespaceContext namespaceContext) {
        this.rootContext = namespaceContext;
        this.init();
    }

    public void init() {
        this.bindNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.bindNamespace("xmlns", "http://www.w3.org/XML/1998/namespace");
        this.bindNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public void openScope() {
        this.prefixTable.openScope();
        this.uriTable.openScope();
    }

    public final List closeScope(boolean bl) {
        this.uriTable.closeScope(false);
        return this.prefixTable.closeScope(bl);
    }

    public final List closeScope() {
        return this.closeScope(true);
    }

    public void bindNamespace(String string, String string2) {
        this.prefixTable.put(string, string2);
        this.uriTable.put(string2, string);
    }

    public int getDepth() {
        return this.prefixTable.getDepth();
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The prefix may not be null");
        }
        String string2 = this.prefixTable.get(string);
        if (string2 == null && this.rootContext != null) {
            return this.rootContext.getNamespaceURI(string);
        }
        return string2;
    }

    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The uri may not be null.");
        }
        String string2 = null;
        string2 = this.uriTable.get(string);
        if (string2 == null && this.rootContext != null) {
            return this.rootContext.getPrefix(string);
        }
        return string2;
    }

    public void bindDefaultNameSpace(String string) {
        this.bindNamespace("", string);
    }

    public void unbindDefaultNameSpace() {
        this.bindNamespace("", null);
    }

    public void unbindNamespace(String string, String string2) {
        this.prefixTable.put(string, null);
        this.prefixTable.put(string2, null);
    }

    public String getDefaultNameSpace() {
        return this.getNamespaceURI("");
    }

    public Iterator getPrefixes(String string) {
        return this.uriTable.getAll(string).iterator();
    }

    public static void main(String[] stringArray) throws Exception {
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        namespaceContextImpl.openScope();
        namespaceContextImpl.bindNamespace("a", "uri");
        namespaceContextImpl.bindNamespace("b", "uri");
        System.out.println("a=" + namespaceContextImpl.getNamespaceURI("a"));
        System.out.println("uri=" + namespaceContextImpl.getPrefix("uri"));
        Iterator iterator = namespaceContextImpl.getPrefixes("uri");
        while (iterator.hasNext()) {
            System.out.println("1 uri->" + iterator.next());
        }
        namespaceContextImpl.openScope();
        namespaceContextImpl.bindNamespace("a", "uri2");
        iterator = namespaceContextImpl.getPrefixes("uri");
        while (iterator.hasNext()) {
            System.out.println("2 uri->" + iterator.next());
        }
        namespaceContextImpl.closeScope();
        namespaceContextImpl.closeScope();
    }
}

