




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.security.audit.AuditorMBean;
import weblogic.management.security.authentication.AuthenticationProviderMBean;
import weblogic.management.security.authentication.PasswordValidatorMBean;
import weblogic.management.security.authentication.UserLockoutManagerMBean;
import weblogic.management.security.authorization.AdjudicatorMBean;
import weblogic.management.security.authorization.AuthorizerMBean;
import weblogic.management.security.authorization.RoleMapperMBean;
import weblogic.management.security.credentials.CredentialMapperMBean;
import weblogic.management.security.pk.CertPathBuilderMBean;
import weblogic.management.security.pk.CertPathProviderMBean;
import weblogic.management.utils.ErrorCollectionException;
import weblogic.management.VersionConstants;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;


/**
 * Corresponds to RealmMBean
 * (Interface=weblogic.management.security.RealmMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * <p>The MBean that represents configuration attributes for the
 security realm.</p>
 
 <p>A security realm contains a set of security configuration settings,
 including the list of security providers
 to use (for example, for authentication and authorization).</p>
 
 <p>Code using security can either use the default security realm
 for the domain or refer to a particular security realm by name
 (by using the JMX display name of the security realm).</p>
 
 <p>One security realm in the WebLogic domain must have the <code>DefaultRealm</code>
 attribute set to true. The security realm with the <code>DefaultRealm</code>
 attribute set to true is used as the default
 security realm for the WebLogic domain. Note that other available security realms
 must have the <code>DefaultRealm</code> attribute set to false.</p>
 
 <p>When WebLogic Server boots, it locates and uses the default security realm. The security realm is
 considered active since it is used when WebLogic Server runs.
 Any security realm that is not used when WebLogic Server runs is considered inactive.
 All active security realms must be configured before WebLogic Server is boots.</p>
 
 <p>Since security providers are scoped by realm, the
 <code>Realm</code> attribute on a security provider
 must be set to the realm that uses the provider.</p>
 *
 * referenceable
 * @xsdgen:complexType.typeName realmType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class RealmMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements RealmMBean, java.io.Serializable
{
  private weblogic.management.security.authorization.AdjudicatorMBean _Adjudicator;
  private String[] _AdjudicatorTypes;
  private String[] _AuditorTypes;
  private weblogic.management.security.audit.AuditorMBean[] _Auditors;
  private String _AuthMethods;
  private String[] _AuthenticationProviderTypes;
  private weblogic.management.security.authentication.AuthenticationProviderMBean[] _AuthenticationProviders;
  private String[] _AuthorizerTypes;
  private weblogic.management.security.authorization.AuthorizerMBean[] _Authorizers;
  private boolean _AutoRestartOnNonDynamicChanges;
  private weblogic.management.security.pk.CertPathBuilderMBean _CertPathBuilder;
  private String[] _CertPathProviderTypes;
  private weblogic.management.security.pk.CertPathProviderMBean[] _CertPathProviders;
  private boolean _CombinedRoleMappingEnabled;
  private String _CompatibilityObjectName;
  private String[] _CredentialMapperTypes;
  private weblogic.management.security.credentials.CredentialMapperMBean[] _CredentialMappers;
  private boolean _DefaultRealm;
  private boolean _DelegateMBeanAuthorization;
  private boolean _DeployCredentialMappingIgnored;
  private boolean _DeployPolicyIgnored;
  private boolean _DeployRoleIgnored;
  private boolean _DeployableProviderSynchronizationEnabled;
  private Integer _DeployableProviderSynchronizationTimeout;
  private boolean _EnableWebLogicPrincipalValidatorCache;
  private boolean _FullyDelegateAuthorization;
  private String _ManagementIdentityDomain;
  private Integer _MaxWebLogicPrincipalsInCache;
  private String _Name;
  private String[] _PasswordValidatorTypes;
  private weblogic.management.security.authentication.PasswordValidatorMBean[] _PasswordValidators;
  private RDBMSSecurityStoreMBean _RDBMSSecurityStore;
  private int _RetireTimeoutSeconds;
  private String[] _RoleMapperTypes;
  private weblogic.management.security.authorization.RoleMapperMBean[] _RoleMappers;
  private String _SecurityDDModel;
  private weblogic.management.security.authentication.UserLockoutManagerMBean _UserLockoutManager;
  private boolean _ValidateDDSecurityData;
  private transient RealmImpl _customizer;


  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=RealmMBeanImpl)
   *
   */
  public RealmMBeanImpl() {
    super();
    try {
      _customizer = new weblogic.management.security.RealmImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=RealmMBeanImpl)
   *
   */
  public RealmMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    try {
      _customizer = new weblogic.management.security.RealmImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=RealmMBeanImpl)
   *
   */
  public RealmMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    try {
      _customizer = new weblogic.management.security.RealmImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addAuditor)
   *
   */
  public void addAuditor(weblogic.management.security.audit.AuditorMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 2)) {
      weblogic.management.security.audit.AuditorMBean[] _new;
      if (_isSet(2)) {
        _new = (weblogic.management.security.audit.AuditorMBean[]) _getHelper()._extendArray(getAuditors(), weblogic.management.security.audit.AuditorMBean.class, param0);
      } else {
        _new = new weblogic.management.security.audit.AuditorMBean[] { param0 };
      }
      try {
        setAuditors(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Auditing providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuditors)
   *
   * @xsdgen:element.name auditor
   * @xsdgen:element.astype weblogic.management.security.audit.AuditorMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.audit.AuditorMBean[] getAuditors() {
    return _Auditors;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuditorsInherited)
   *
   * return true if the value of property Auditors is inherited from template
   */
  public boolean isAuditorsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuditorsSet)
   *
   * @xsdgen:isSetMethodFor auditor
   */
  public boolean isAuditorsSet() {
    return _isSet(2);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removeAuditor)
   *
   */
  public void removeAuditor(weblogic.management.security.audit.AuditorMBean param0) {
    destroyAuditor(param0);
  }

  /**
   * Changes the invocation order of this security realm's Auditing providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuditors)
   *
   */
  public void setAuditors(weblogic.management.security.audit.AuditorMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.audit.AuditorMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 2)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.audit.AuditorMBean[] _oldVal = _Auditors;
    _Auditors = param0;
    _postSet(2, _oldVal, param0);
  }

  /**
   * Returns the types of Auditing providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.audit.DefaultAuditor</code>.
 Use this method to find the available types to pass to <code>createAuditor</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuditorTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getAuditorTypes() {
    return _customizer.getAuditorTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuditorTypesInherited)
   *
   * return true if the value of property AuditorTypes is inherited from template
   */
  public boolean isAuditorTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuditorTypesSet)
   *
   * @xsdgen:isSetMethodFor auditor-type
   */
  public boolean isAuditorTypesSet() {
    return _isSet(3);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuditorTypes)
   *
   */
  public void setAuditorTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _AuditorTypes = param0;
  }

  /**
   * Creates an Auditing provider in this security realm.
 The new Auditing provider is added to the end of the list of
 Auditing providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuditor)
   *
   */
  public weblogic.management.security.audit.AuditorMBean createAuditor(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAuditor(param0, param1);
  }

  /**
   * Creates an Auditing provider in this security realm.
 The new Auditing provider is added to the end of the list of
 Auditing providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuditor)
   *
   */
  public weblogic.management.security.audit.AuditorMBean createAuditor(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAuditor(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuditor)
   *
   */
  public weblogic.management.security.audit.AuditorMBean createAuditor(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.audit.AuditorMBeanImpl _val = (weblogic.management.security.audit.AuditorMBeanImpl)_createChildBean(param0, -1);
    try {
      addAuditor(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuditor)
   *
   */
  public weblogic.management.security.audit.AuditorMBean createAuditor(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.audit.AuditorMBeanImpl _val = (weblogic.management.security.audit.AuditorMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addAuditor(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration for an Auditing provider in this security realm.
 It does not remove any persistent data for the Auditing provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Auditing providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyAuditor)
   *
   */
  public void destroyAuditor(weblogic.management.security.audit.AuditorMBean param0) {
    try {
      _checkIsPotentialChild(param0, 2);
      weblogic.management.security.audit.AuditorMBean[] _old = getAuditors();
      weblogic.management.security.audit.AuditorMBean[] _new = (weblogic.management.security.audit.AuditorMBean[])_getHelper()._removeElement(_old, weblogic.management.security.audit.AuditorMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setAuditors(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Finds an Auditing provider in this security realm.
 Returns null if this security realm has no Auditing provider of the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupAuditor)
   *
   */
  public weblogic.management.security.audit.AuditorMBean lookupAuditor(String param0) {
    Object[] aary = (Object[]) _Auditors;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.audit.AuditorMBeanImpl bean = (weblogic.management.security.audit.AuditorMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addAuthenticationProvider)
   *
   */
  public void addAuthenticationProvider(weblogic.management.security.authentication.AuthenticationProviderMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 4)) {
      weblogic.management.security.authentication.AuthenticationProviderMBean[] _new;
      if (_isSet(4)) {
        _new = (weblogic.management.security.authentication.AuthenticationProviderMBean[]) _getHelper()._extendArray(getAuthenticationProviders(), weblogic.management.security.authentication.AuthenticationProviderMBean.class, param0);
      } else {
        _new = new weblogic.management.security.authentication.AuthenticationProviderMBean[] { param0 };
      }
      try {
        setAuthenticationProviders(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Authentication providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuthenticationProviders)
   *
   * @xsdgen:element.name authentication-provider
   * @xsdgen:element.astype weblogic.management.security.authentication.AuthenticationProviderMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.authentication.AuthenticationProviderMBean[] getAuthenticationProviders() {
    return _AuthenticationProviders;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthenticationProvidersInherited)
   *
   * return true if the value of property AuthenticationProviders is inherited from template
   */
  public boolean isAuthenticationProvidersInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthenticationProvidersSet)
   *
   * @xsdgen:isSetMethodFor authentication-provider
   */
  public boolean isAuthenticationProvidersSet() {
    return _isSet(4);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removeAuthenticationProvider)
   *
   */
  public void removeAuthenticationProvider(weblogic.management.security.authentication.AuthenticationProviderMBean param0) {
    destroyAuthenticationProvider(param0);
  }

  /**
   * Changes the invocation order of this security realm's Authentication providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuthenticationProviders)
   *
   */
  public void setAuthenticationProviders(weblogic.management.security.authentication.AuthenticationProviderMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.authentication.AuthenticationProviderMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 4)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.authentication.AuthenticationProviderMBean[] _oldVal = _AuthenticationProviders;
    _AuthenticationProviders = param0;
    _postSet(4, _oldVal, param0);
  }

  /**
   * Returns the types of Authentication providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.authentication.DefaultAuthenticator</code>.
 Use this method to find the available types to pass to <code>createAuthenticationProvider</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuthenticationProviderTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getAuthenticationProviderTypes() {
    return _customizer.getAuthenticationProviderTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthenticationProviderTypesInherited)
   *
   * return true if the value of property AuthenticationProviderTypes is inherited from template
   */
  public boolean isAuthenticationProviderTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthenticationProviderTypesSet)
   *
   * @xsdgen:isSetMethodFor authentication-provider-type
   */
  public boolean isAuthenticationProviderTypesSet() {
    return _isSet(5);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuthenticationProviderTypes)
   *
   */
  public void setAuthenticationProviderTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _AuthenticationProviderTypes = param0;
  }

  /**
   * Creates an Authentication provider in this security realm.
 The new Authentication provider is added to the end of the list of
 Authentication providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthenticationProvider)
   *
   */
  public weblogic.management.security.authentication.AuthenticationProviderMBean createAuthenticationProvider(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAuthenticationProvider(param0, param1);
  }

  /**
   * Creates an Authentication provider in this security realm.
 The new Authentication provider is added to the end of the list of
 Authentication providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthenticationProvider)
   *
   */
  public weblogic.management.security.authentication.AuthenticationProviderMBean createAuthenticationProvider(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAuthenticationProvider(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthenticationProvider)
   *
   */
  public weblogic.management.security.authentication.AuthenticationProviderMBean createAuthenticationProvider(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.authentication.AuthenticationProviderMBeanImpl _val = (weblogic.management.security.authentication.AuthenticationProviderMBeanImpl)_createChildBean(param0, -1);
    try {
      addAuthenticationProvider(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthenticationProvider)
   *
   */
  public weblogic.management.security.authentication.AuthenticationProviderMBean createAuthenticationProvider(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.authentication.AuthenticationProviderMBeanImpl _val = (weblogic.management.security.authentication.AuthenticationProviderMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addAuthenticationProvider(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration for an Authentication provider in this security realm.
 It does not remove any persistent data for the Authentication provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Authentication providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyAuthenticationProvider)
   *
   */
  public void destroyAuthenticationProvider(weblogic.management.security.authentication.AuthenticationProviderMBean param0) {
    try {
      _checkIsPotentialChild(param0, 4);
      weblogic.management.security.authentication.AuthenticationProviderMBean[] _old = getAuthenticationProviders();
      weblogic.management.security.authentication.AuthenticationProviderMBean[] _new = (weblogic.management.security.authentication.AuthenticationProviderMBean[])_getHelper()._removeElement(_old, weblogic.management.security.authentication.AuthenticationProviderMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setAuthenticationProviders(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Finds an Authentication provider in this security realm.
 Returns null if this security realm has no Authentication provider of the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupAuthenticationProvider)
   *
   */
  public weblogic.management.security.authentication.AuthenticationProviderMBean lookupAuthenticationProvider(String param0) {
    Object[] aary = (Object[]) _AuthenticationProviders;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.authentication.AuthenticationProviderMBeanImpl bean = (weblogic.management.security.authentication.AuthenticationProviderMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addRoleMapper)
   *
   */
  public void addRoleMapper(weblogic.management.security.authorization.RoleMapperMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 6)) {
      weblogic.management.security.authorization.RoleMapperMBean[] _new;
      if (_isSet(6)) {
        _new = (weblogic.management.security.authorization.RoleMapperMBean[]) _getHelper()._extendArray(getRoleMappers(), weblogic.management.security.authorization.RoleMapperMBean.class, param0);
      } else {
        _new = new weblogic.management.security.authorization.RoleMapperMBean[] { param0 };
      }
      try {
        setRoleMappers(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Role Mapping providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getRoleMappers)
   *
   * @xsdgen:element.name role-mapper
   * @xsdgen:element.astype weblogic.management.security.authorization.RoleMapperMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.authorization.RoleMapperMBean[] getRoleMappers() {
    return _RoleMappers;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRoleMappersInherited)
   *
   * return true if the value of property RoleMappers is inherited from template
   */
  public boolean isRoleMappersInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRoleMappersSet)
   *
   * @xsdgen:isSetMethodFor role-mapper
   */
  public boolean isRoleMappersSet() {
    return _isSet(6);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removeRoleMapper)
   *
   */
  public void removeRoleMapper(weblogic.management.security.authorization.RoleMapperMBean param0) {
    destroyRoleMapper(param0);
  }

  /**
   * Changes the invocation order of this security realm's Role Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setRoleMappers)
   *
   */
  public void setRoleMappers(weblogic.management.security.authorization.RoleMapperMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.authorization.RoleMapperMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 6)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.authorization.RoleMapperMBean[] _oldVal = _RoleMappers;
    _RoleMappers = param0;
    _postSet(6, _oldVal, param0);
  }

  /**
   * Returns the types of Role Mapping providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.authorization.DefaultRoleMapper</code>.
 Use this method to find the available types to pass to <code>createRoleMapper</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getRoleMapperTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getRoleMapperTypes() {
    return _customizer.getRoleMapperTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRoleMapperTypesInherited)
   *
   * return true if the value of property RoleMapperTypes is inherited from template
   */
  public boolean isRoleMapperTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRoleMapperTypesSet)
   *
   * @xsdgen:isSetMethodFor role-mapper-type
   */
  public boolean isRoleMapperTypesSet() {
    return _isSet(7);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setRoleMapperTypes)
   *
   */
  public void setRoleMapperTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _RoleMapperTypes = param0;
  }

  /**
   * Creates a Role Mapping provider in this security realm.
 The new Role Mapping provider is added to the end of the list of
 Role Mapping providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createRoleMapper)
   *
   */
  public weblogic.management.security.authorization.RoleMapperMBean createRoleMapper(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createRoleMapper(param0, param1);
  }

  /**
   * Creates a Role Mapping provider in this security realm.
 The new Role Mapping provider is added to the end of the list of
 Role Mapping providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createRoleMapper)
   *
   */
  public weblogic.management.security.authorization.RoleMapperMBean createRoleMapper(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createRoleMapper(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createRoleMapper)
   *
   */
  public weblogic.management.security.authorization.RoleMapperMBean createRoleMapper(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.authorization.RoleMapperMBeanImpl _val = (weblogic.management.security.authorization.RoleMapperMBeanImpl)_createChildBean(param0, -1);
    try {
      addRoleMapper(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createRoleMapper)
   *
   */
  public weblogic.management.security.authorization.RoleMapperMBean createRoleMapper(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.authorization.RoleMapperMBeanImpl _val = (weblogic.management.security.authorization.RoleMapperMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addRoleMapper(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration for a Role Mapping provider in this security realm.
 It does not remove any persistent data for the Role Mapping provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Role Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyRoleMapper)
   *
   */
  public void destroyRoleMapper(weblogic.management.security.authorization.RoleMapperMBean param0) {
    try {
      _checkIsPotentialChild(param0, 6);
      weblogic.management.security.authorization.RoleMapperMBean[] _old = getRoleMappers();
      weblogic.management.security.authorization.RoleMapperMBean[] _new = (weblogic.management.security.authorization.RoleMapperMBean[])_getHelper()._removeElement(_old, weblogic.management.security.authorization.RoleMapperMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setRoleMappers(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Finds a Role Mapping provider in this security realm.
 Returns null if this security realm has no Role Mapping provider of the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupRoleMapper)
   *
   */
  public weblogic.management.security.authorization.RoleMapperMBean lookupRoleMapper(String param0) {
    Object[] aary = (Object[]) _RoleMappers;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.authorization.RoleMapperMBeanImpl bean = (weblogic.management.security.authorization.RoleMapperMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addAuthorizer)
   *
   */
  public void addAuthorizer(weblogic.management.security.authorization.AuthorizerMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 8)) {
      weblogic.management.security.authorization.AuthorizerMBean[] _new;
      if (_isSet(8)) {
        _new = (weblogic.management.security.authorization.AuthorizerMBean[]) _getHelper()._extendArray(getAuthorizers(), weblogic.management.security.authorization.AuthorizerMBean.class, param0);
      } else {
        _new = new weblogic.management.security.authorization.AuthorizerMBean[] { param0 };
      }
      try {
        setAuthorizers(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Authorization providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuthorizers)
   *
   * @xsdgen:element.name authorizer
   * @xsdgen:element.astype weblogic.management.security.authorization.AuthorizerMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.authorization.AuthorizerMBean[] getAuthorizers() {
    return _Authorizers;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthorizersInherited)
   *
   * return true if the value of property Authorizers is inherited from template
   */
  public boolean isAuthorizersInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthorizersSet)
   *
   * @xsdgen:isSetMethodFor authorizer
   */
  public boolean isAuthorizersSet() {
    return _isSet(8);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removeAuthorizer)
   *
   */
  public void removeAuthorizer(weblogic.management.security.authorization.AuthorizerMBean param0) {
    destroyAuthorizer(param0);
  }

  /**
   * Changes the invocation order of this security realm's Authorization providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuthorizers)
   *
   */
  public void setAuthorizers(weblogic.management.security.authorization.AuthorizerMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.authorization.AuthorizerMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 8)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.authorization.AuthorizerMBean[] _oldVal = _Authorizers;
    _Authorizers = param0;
    _postSet(8, _oldVal, param0);
  }

  /**
   * Returns the types of Authorization providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.authorization.DefaultAuthorizer</code>.
 Use this method to find the available types to pass to <code>createAuthorizer</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuthorizerTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getAuthorizerTypes() {
    return _customizer.getAuthorizerTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthorizerTypesInherited)
   *
   * return true if the value of property AuthorizerTypes is inherited from template
   */
  public boolean isAuthorizerTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthorizerTypesSet)
   *
   * @xsdgen:isSetMethodFor authorizer-type
   */
  public boolean isAuthorizerTypesSet() {
    return _isSet(9);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuthorizerTypes)
   *
   */
  public void setAuthorizerTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _AuthorizerTypes = param0;
  }

  /**
   * Creates an Authorization provider in this security realm.
 The new Authorization provider is added to the end of the list of
 Authorization providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthorizer)
   *
   */
  public weblogic.management.security.authorization.AuthorizerMBean createAuthorizer(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAuthorizer(param0, param1);
  }

  /**
   * Creates an Authorization provider in this security realm.
 The new Authorization provider is added to the end of the list of
 Authorization providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthorizer)
   *
   */
  public weblogic.management.security.authorization.AuthorizerMBean createAuthorizer(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAuthorizer(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthorizer)
   *
   */
  public weblogic.management.security.authorization.AuthorizerMBean createAuthorizer(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.authorization.AuthorizerMBeanImpl _val = (weblogic.management.security.authorization.AuthorizerMBeanImpl)_createChildBean(param0, -1);
    try {
      addAuthorizer(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAuthorizer)
   *
   */
  public weblogic.management.security.authorization.AuthorizerMBean createAuthorizer(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.authorization.AuthorizerMBeanImpl _val = (weblogic.management.security.authorization.AuthorizerMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addAuthorizer(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration for an Authorization provider in this security realm.
 It does not remove any persistent data for the Authorization provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Authorization providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyAuthorizer)
   *
   */
  public void destroyAuthorizer(weblogic.management.security.authorization.AuthorizerMBean param0) {
    try {
      _checkIsPotentialChild(param0, 8);
      weblogic.management.security.authorization.AuthorizerMBean[] _old = getAuthorizers();
      weblogic.management.security.authorization.AuthorizerMBean[] _new = (weblogic.management.security.authorization.AuthorizerMBean[])_getHelper()._removeElement(_old, weblogic.management.security.authorization.AuthorizerMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setAuthorizers(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Finds an Authorization provider in this security realm.
 Returns null if this security realm has no Authorization provider of the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupAuthorizer)
   *
   */
  public weblogic.management.security.authorization.AuthorizerMBean lookupAuthorizer(String param0) {
    Object[] aary = (Object[]) _Authorizers;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.authorization.AuthorizerMBeanImpl bean = (weblogic.management.security.authorization.AuthorizerMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * Returns the Adjudication provider for this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAdjudicator)
   *
   * @xsdgen:element.name adjudicator
   * @xsdgen:element.astype weblogic.management.security.authorization.AdjudicatorMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.authorization.AdjudicatorMBean getAdjudicator() {
    return _Adjudicator;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAdjudicatorInherited)
   *
   * return true if the value of property Adjudicator is inherited from template
   */
  public boolean isAdjudicatorInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAdjudicatorSet)
   *
   * @xsdgen:isSetMethodFor adjudicator
   */
  public boolean isAdjudicatorSet() {
    return _isSet(10);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAdjudicator)
   *
   */
  public void setAdjudicator(weblogic.management.security.authorization.AdjudicatorMBean param0)
    throws javax.management.InvalidAttributeValueException
  {
    if (param0 != null && getAdjudicator() != null && param0 != getAdjudicator()) {
      throw new BeanAlreadyExistsException(
        getAdjudicator() + " has already been created");
    }
    if (param0 != null) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
      if (_setParent(_child, this, 10)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.authorization.AdjudicatorMBean _oldVal = _Adjudicator;
    _Adjudicator = param0;
    _postSet(10, _oldVal, param0);
  }

  /**
   * Returns the types of Adjudication providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.authorization.DefaultAdjudicator</code>.
 Use this method to find the available types to pass to <code>createAdjudicator</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAdjudicatorTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getAdjudicatorTypes() {
    return _customizer.getAdjudicatorTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAdjudicatorTypesInherited)
   *
   * return true if the value of property AdjudicatorTypes is inherited from template
   */
  public boolean isAdjudicatorTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAdjudicatorTypesSet)
   *
   * @xsdgen:isSetMethodFor adjudicator-type
   */
  public boolean isAdjudicatorTypesSet() {
    return _isSet(11);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAdjudicatorTypes)
   *
   */
  public void setAdjudicatorTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _AdjudicatorTypes = param0;
  }

  /**
   * Creates an Adjudication provider in this security realm and removes
 this security realm's previous Adjudication provider.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAdjudicator)
   *
   */
  public weblogic.management.security.authorization.AdjudicatorMBean createAdjudicator(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAdjudicator(param0, param1);
  }

  /**
   * Creates an Adjudication provider in this security realm and removes
 this security realm's previous Adjudication provider.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAdjudicator)
   *
   */
  public weblogic.management.security.authorization.AdjudicatorMBean createAdjudicator(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createAdjudicator(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAdjudicator)
   *
   */
  public weblogic.management.security.authorization.AdjudicatorMBean createAdjudicator(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.authorization.AdjudicatorMBeanImpl _val = (weblogic.management.security.authorization.AdjudicatorMBeanImpl)_createChildBean(param0, -1);
    try {
      setAdjudicator(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createAdjudicator)
   *
   */
  public weblogic.management.security.authorization.AdjudicatorMBean createAdjudicator(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.authorization.AdjudicatorMBeanImpl _val = (weblogic.management.security.authorization.AdjudicatorMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      setAdjudicator(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration this security realm's Adjudication provider (if there is one).
 It does not remove any persistent data for the Adjudication provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Adjudication provider.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyAdjudicator)
   *
   */
  public void destroyAdjudicator() {
    try {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)_Adjudicator;
      if (_child == null) return;
      List _refs = _getReferenceManager().getResolvedReferences(_child);
      if (_refs != null && _refs.size() > 0) {
        throw new BeanRemoveRejectedException(_child, _refs);
      } else {
        _getReferenceManager().unregisterBean(_child);
        _markDestroyed(_child);
      }
      setAdjudicator(null);
      _unSet(10);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addCredentialMapper)
   *
   */
  public void addCredentialMapper(weblogic.management.security.credentials.CredentialMapperMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 12)) {
      weblogic.management.security.credentials.CredentialMapperMBean[] _new;
      if (_isSet(12)) {
        _new = (weblogic.management.security.credentials.CredentialMapperMBean[]) _getHelper()._extendArray(getCredentialMappers(), weblogic.management.security.credentials.CredentialMapperMBean.class, param0);
      } else {
        _new = new weblogic.management.security.credentials.CredentialMapperMBean[] { param0 };
      }
      try {
        setCredentialMappers(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Credential Mapping providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCredentialMappers)
   *
   * @xsdgen:element.name credential-mapper
   * @xsdgen:element.astype weblogic.management.security.credentials.CredentialMapperMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.credentials.CredentialMapperMBean[] getCredentialMappers() {
    return _CredentialMappers;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCredentialMappersInherited)
   *
   * return true if the value of property CredentialMappers is inherited from template
   */
  public boolean isCredentialMappersInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCredentialMappersSet)
   *
   * @xsdgen:isSetMethodFor credential-mapper
   */
  public boolean isCredentialMappersSet() {
    return _isSet(12);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removeCredentialMapper)
   *
   */
  public void removeCredentialMapper(weblogic.management.security.credentials.CredentialMapperMBean param0) {
    destroyCredentialMapper(param0);
  }

  /**
   * Changes the invocation order of this security realm's Credential Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCredentialMappers)
   *
   */
  public void setCredentialMappers(weblogic.management.security.credentials.CredentialMapperMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.credentials.CredentialMapperMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 12)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.credentials.CredentialMapperMBean[] _oldVal = _CredentialMappers;
    _CredentialMappers = param0;
    _postSet(12, _oldVal, param0);
  }

  /**
   * Returns the types of Credential Mapping providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.credentials.DefaultCredentialMapper</code>.
 Use this method to find the available types to pass to <code>createCredentialMapper</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCredentialMapperTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getCredentialMapperTypes() {
    return _customizer.getCredentialMapperTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCredentialMapperTypesInherited)
   *
   * return true if the value of property CredentialMapperTypes is inherited from template
   */
  public boolean isCredentialMapperTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCredentialMapperTypesSet)
   *
   * @xsdgen:isSetMethodFor credential-mapper-type
   */
  public boolean isCredentialMapperTypesSet() {
    return _isSet(13);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCredentialMapperTypes)
   *
   */
  public void setCredentialMapperTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _CredentialMapperTypes = param0;
  }

  /**
   * Creates a Credential Mapping provider in this security realm.
 The new Credential Mapping provider is added to the end of the list of
 Credential Mapping providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCredentialMapper)
   *
   */
  public weblogic.management.security.credentials.CredentialMapperMBean createCredentialMapper(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createCredentialMapper(param0, param1);
  }

  /**
   * Creates a Credential Mapping provider in this security realm.
 The new Credential Mapping provider is added to the end of the list of
 Credential Mapping providers  configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCredentialMapper)
   *
   */
  public weblogic.management.security.credentials.CredentialMapperMBean createCredentialMapper(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createCredentialMapper(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCredentialMapper)
   *
   */
  public weblogic.management.security.credentials.CredentialMapperMBean createCredentialMapper(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.credentials.CredentialMapperMBeanImpl _val = (weblogic.management.security.credentials.CredentialMapperMBeanImpl)_createChildBean(param0, -1);
    try {
      addCredentialMapper(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCredentialMapper)
   *
   */
  public weblogic.management.security.credentials.CredentialMapperMBean createCredentialMapper(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.credentials.CredentialMapperMBeanImpl _val = (weblogic.management.security.credentials.CredentialMapperMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addCredentialMapper(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration for a Credential Mapping provider in this security realm.
 It does not remove any persistent data for the Credential Mapping provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Credential Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyCredentialMapper)
   *
   */
  public void destroyCredentialMapper(weblogic.management.security.credentials.CredentialMapperMBean param0) {
    try {
      _checkIsPotentialChild(param0, 12);
      weblogic.management.security.credentials.CredentialMapperMBean[] _old = getCredentialMappers();
      weblogic.management.security.credentials.CredentialMapperMBean[] _new = (weblogic.management.security.credentials.CredentialMapperMBean[])_getHelper()._removeElement(_old, weblogic.management.security.credentials.CredentialMapperMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setCredentialMappers(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Finds a Credential Mapping provider in this security realm.
 Returns null if this security realm has no Credential Mapping provider of the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupCredentialMapper)
   *
   */
  public weblogic.management.security.credentials.CredentialMapperMBean lookupCredentialMapper(String param0) {
    Object[] aary = (Object[]) _CredentialMappers;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.credentials.CredentialMapperMBeanImpl bean = (weblogic.management.security.credentials.CredentialMapperMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addCertPathProvider)
   *
   */
  public void addCertPathProvider(weblogic.management.security.pk.CertPathProviderMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 14)) {
      weblogic.management.security.pk.CertPathProviderMBean[] _new;
      if (_isSet(14)) {
        _new = (weblogic.management.security.pk.CertPathProviderMBean[]) _getHelper()._extendArray(getCertPathProviders(), weblogic.management.security.pk.CertPathProviderMBean.class, param0);
      } else {
        _new = new weblogic.management.security.pk.CertPathProviderMBean[] { param0 };
      }
      try {
        setCertPathProviders(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Certification Path providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCertPathProviders)
   *
   * @xsdgen:element.name cert-path-provider
   * @xsdgen:element.astype weblogic.management.security.pk.CertPathProviderMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.pk.CertPathProviderMBean[] getCertPathProviders() {
    return _CertPathProviders;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCertPathProvidersInherited)
   *
   * return true if the value of property CertPathProviders is inherited from template
   */
  public boolean isCertPathProvidersInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCertPathProvidersSet)
   *
   * @xsdgen:isSetMethodFor cert-path-provider
   */
  public boolean isCertPathProvidersSet() {
    return _isSet(14);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removeCertPathProvider)
   *
   */
  public void removeCertPathProvider(weblogic.management.security.pk.CertPathProviderMBean param0) {
    destroyCertPathProvider(param0);
  }

  /**
   * Changes the invocation order of this security realm's Certification Path providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCertPathProviders)
   *
   */
  public void setCertPathProviders(weblogic.management.security.pk.CertPathProviderMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.pk.CertPathProviderMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 14)) {
        _getReferenceManager().registerBean(_child, true);
        _postCreate(_child);
      }
    }
    weblogic.management.security.pk.CertPathProviderMBean[] _oldVal = _CertPathProviders;
    _CertPathProviders = param0;
    _postSet(14, _oldVal, param0);
  }

  /**
   * Returns the types of Certification Path providers that may be created in this security realm,
 for example, <code>weblogic.security.providers.pk.WebLogicCertPathProvider</code>.
 Use this method to find the available types to pass to <code>createCertPathProvider</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCertPathProviderTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getCertPathProviderTypes() {
    return _customizer.getCertPathProviderTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCertPathProviderTypesInherited)
   *
   * return true if the value of property CertPathProviderTypes is inherited from template
   */
  public boolean isCertPathProviderTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCertPathProviderTypesSet)
   *
   * @xsdgen:isSetMethodFor cert-path-provider-type
   */
  public boolean isCertPathProviderTypesSet() {
    return _isSet(15);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCertPathProviderTypes)
   *
   */
  public void setCertPathProviderTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _CertPathProviderTypes = param0;
  }

  /**
   * Creates a Certification Path provider in this security realm.
 The new Certification Path provider is added to the end of the list of
 Certification Path providers  configured in this security realm.

 The active security realm must contain at least one Certification Path
 provider that is a CertPath Builder provider and at least one Certificate
 Path provider that is a CertPath Validator provider.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCertPathProvider)
   *
   */
  public weblogic.management.security.pk.CertPathProviderMBean createCertPathProvider(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createCertPathProvider(param0, param1);
  }

  /**
   * Creates a Certification Path provider in this security realm.
 The new Certification Path provider is added to the end of the list of
 Certification Path providers  configured in this security realm.
 <p>
 The active security realm must contain at least one Certification Path
 provider that is a CertPath Builder provider and at least one Certificate
 Path provider that is a CertPath Validator provider.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCertPathProvider)
   *
   */
  public weblogic.management.security.pk.CertPathProviderMBean createCertPathProvider(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createCertPathProvider(param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCertPathProvider)
   *
   */
  public weblogic.management.security.pk.CertPathProviderMBean createCertPathProvider(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.pk.CertPathProviderMBeanImpl _val = (weblogic.management.security.pk.CertPathProviderMBeanImpl)_createChildBean(param0, -1);
    try {
      addCertPathProvider(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=createCertPathProvider)
   *
   */
  public weblogic.management.security.pk.CertPathProviderMBean createCertPathProvider(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.pk.CertPathProviderMBeanImpl _val = (weblogic.management.security.pk.CertPathProviderMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addCertPathProvider(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Removes the configuration for a Certification Path provider in this security realm.
 It does not remove any persistent data for the Certification Path provider (such as databases or files).
 <code>weblogic.management.configuration.SecurityConfigurationMBean.destroyRealm</code>
 automatically removes the security realm's Certification Path providers.
 <p>
 If <code>certPathProvider</code> has been selected as this security realm's
 <code>CertPathBuilder</code>, then this security realm's will have no
 <code>CertPathBuilder</code>.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyCertPathProvider)
   *
   */
  public void destroyCertPathProvider(weblogic.management.security.pk.CertPathProviderMBean param0) {
    try {
      _checkIsPotentialChild(param0, 14);
      weblogic.management.security.pk.CertPathProviderMBean[] _old = getCertPathProviders();
      weblogic.management.security.pk.CertPathProviderMBean[] _new = (weblogic.management.security.pk.CertPathProviderMBean[])_getHelper()._removeElement(_old, weblogic.management.security.pk.CertPathProviderMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setCertPathProviders(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Finds a Certification Path provider in this security realm.
 Returns null if this security realm has no Certification Path provider of the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupCertPathProvider)
   *
   */
  public weblogic.management.security.pk.CertPathProviderMBean lookupCertPathProvider(String param0) {
    Object[] aary = (Object[]) _CertPathProviders;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.pk.CertPathProviderMBeanImpl bean = (weblogic.management.security.pk.CertPathProviderMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * Returns the CertPath Builder provider in this security realm that will be used
 by the security system to build certification paths.  Returns null if none has been
 selected.  The provider will be one of this security realm's <code>CertPathProviders</code>.
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCertPathBuilder)
   *
   * @xsdgen:element.exclude
   */
  public weblogic.management.security.pk.CertPathBuilderMBean getCertPathBuilder() {
    return _CertPathBuilder;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCertPathBuilderAsString)
   *
   * @xsdgen:element.name cert-path-builder
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   */
  public String getCertPathBuilderAsString() {
    AbstractDescriptorBean bean = (AbstractDescriptorBean)getCertPathBuilder();
    return (bean == null) ? null : bean._getKey().toString();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCertPathBuilderInherited)
   *
   * return true if the value of property CertPathBuilder is inherited from template
   */
  public boolean isCertPathBuilderInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCertPathBuilderSet)
   *
   * @xsdgen:isSetMethodFor cert-path-builder
   */
  public boolean isCertPathBuilderSet() {
    return _isSet(16);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCertPathBuilderAsString)
   *
   */
  public void setCertPathBuilderAsString(String param0) {
    if (param0 == null || param0.length() == 0) {
      weblogic.management.security.pk.CertPathBuilderMBean _oldVal = _CertPathBuilder;
      _initializeProperty(16);
      _postSet(16, _oldVal, _CertPathBuilder);
    } else {
      param0 = (param0 == null) ? null : param0.trim();
      _getReferenceManager().registerUnresolvedReference(
        param0, weblogic.management.security.pk.CertPathBuilderMBean.class,
        new Resolver(this, 16) {
          public void resolveReference(Object value) {
            try {
              setCertPathBuilder((weblogic.management.security.pk.CertPathBuilderMBean)value);
            } catch (RuntimeException e) {
              throw e;
            } catch (Exception e) {
              throw new AssertionError("Impossible exception: " + e);
            }
          }
        }
      );
    }
  }

  /**
   * Determines which of this security realm's <code>CertPathProviders</code> will be used
 by the security system to build certification paths.  The provider must implement
 <code>weblogic.management.security.pk.CertPathBuilder</code>.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCertPathBuilder)
   *
   */
  public void setCertPathBuilder(weblogic.management.security.pk.CertPathBuilderMBean param0)
    throws javax.management.InvalidAttributeValueException
  {
    if (param0 != null) {
      ResolvedReference _ref =
        new ResolvedReference(this, 16, (AbstractDescriptorBean)param0) {
          protected Object getPropertyValue() {
            return getCertPathBuilder();
          }
        };
      _getReferenceManager().registerResolvedReference(
        (AbstractDescriptorBean)param0, _ref
      );
    }
    weblogic.management.security.pk.CertPathBuilderMBean _oldVal = _CertPathBuilder;
    _CertPathBuilder = param0;
    _postSet(16, _oldVal, param0);
  }

  /**
   * Returns the User Lockout Manager for this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=getUserLockoutManager)
   *
   * @xsdgen:element.name user-lockout-manager
   * @xsdgen:element.astype weblogic.management.security.authentication.UserLockoutManagerMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.authentication.UserLockoutManagerMBean getUserLockoutManager() {
    return _UserLockoutManager;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isUserLockoutManagerInherited)
   *
   * return true if the value of property UserLockoutManager is inherited from template
   */
  public boolean isUserLockoutManagerInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isUserLockoutManagerSet)
   *
   * @xsdgen:isSetMethodFor user-lockout-manager
   */
  public boolean isUserLockoutManagerSet() {
    return _isSet(17) ||
      _isAnythingSet((AbstractDescriptorBean)getUserLockoutManager());
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setUserLockoutManager)
   *
   */
  public void setUserLockoutManager(weblogic.management.security.authentication.UserLockoutManagerMBean param0)
    throws javax.management.InvalidAttributeValueException
  {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
      if (_setParent(_child, this, 17)) {
        _postCreate(_child);
      }
    weblogic.management.security.authentication.UserLockoutManagerMBean _oldVal = _UserLockoutManager;
    _UserLockoutManager = param0;
    _postSet(17, _oldVal, param0);
  }

  /**
   * Returns whether role deployment calls on the security system
 are ignored or passed to the configured Role Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployRoleIgnored)
   *
   * @xsdgen:element.name deploy-role-ignored
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic true
   */
  public boolean isDeployRoleIgnored() {
    return _DeployRoleIgnored;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployRoleIgnoredInherited)
   *
   * return true if the value of property DeployRoleIgnored is inherited from template
   */
  public boolean isDeployRoleIgnoredInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployRoleIgnoredSet)
   *
   * @xsdgen:isSetMethodFor deploy-role-ignored
   */
  public boolean isDeployRoleIgnoredSet() {
    return _isSet(18);
  }

  /**
   * Sets whether role deployment calls on the security system
 are ignored or passed to the configured Role Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDeployRoleIgnored)
   *
   */
  public void setDeployRoleIgnored(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _DeployRoleIgnored;
    _DeployRoleIgnored = param0;
    _postSet(18, _oldVal, param0);
  }

  /**
   * Returns whether policy deployment calls on the security system
 are ignored or passed to the configured Authorization providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployPolicyIgnored)
   *
   * @xsdgen:element.name deploy-policy-ignored
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic true
   */
  public boolean isDeployPolicyIgnored() {
    return _DeployPolicyIgnored;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployPolicyIgnoredInherited)
   *
   * return true if the value of property DeployPolicyIgnored is inherited from template
   */
  public boolean isDeployPolicyIgnoredInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployPolicyIgnoredSet)
   *
   * @xsdgen:isSetMethodFor deploy-policy-ignored
   */
  public boolean isDeployPolicyIgnoredSet() {
    return _isSet(19);
  }

  /**
   * Sets whether policy deployment calls on the security system
 are ignored or passed to the configured Authorization providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDeployPolicyIgnored)
   *
   */
  public void setDeployPolicyIgnored(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _DeployPolicyIgnored;
    _DeployPolicyIgnored = param0;
    _postSet(19, _oldVal, param0);
  }

  /**
   * Returns whether credential mapping deployment calls on the security system
 are ignored or passed to the configured Credential Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployCredentialMappingIgnored)
   *
   * @xsdgen:element.name deploy-credential-mapping-ignored
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic true
   */
  public boolean isDeployCredentialMappingIgnored() {
    return _DeployCredentialMappingIgnored;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployCredentialMappingIgnoredInherited)
   *
   * return true if the value of property DeployCredentialMappingIgnored is inherited from template
   */
  public boolean isDeployCredentialMappingIgnoredInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployCredentialMappingIgnoredSet)
   *
   * @xsdgen:isSetMethodFor deploy-credential-mapping-ignored
   */
  public boolean isDeployCredentialMappingIgnoredSet() {
    return _isSet(20);
  }

  /**
   * Sets whether credential mapping deployment calls on the security system
 are ignored or passed to the configured Credential Mapping providers.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDeployCredentialMappingIgnored)
   *
   */
  public void setDeployCredentialMappingIgnored(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _DeployCredentialMappingIgnored;
    _DeployCredentialMappingIgnored = param0;
    _postSet(20, _oldVal, param0);
  }

  /**
   * Returns whether the Web and EJB containers should
 call the security framework on every access.
 <p>
 If false the containers are free to only call the security framework when
 security is set in the deployment descriptors.
   * (Interface=weblogic.management.security.RealmMBean Attribute=isFullyDelegateAuthorization)
   *
   * @xsdgen:element.name fully-delegate-authorization
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic false
   */
  public boolean isFullyDelegateAuthorization() {
    return _FullyDelegateAuthorization;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isFullyDelegateAuthorizationInherited)
   *
   * return true if the value of property FullyDelegateAuthorization is inherited from template
   */
  public boolean isFullyDelegateAuthorizationInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isFullyDelegateAuthorizationSet)
   *
   * @xsdgen:isSetMethodFor fully-delegate-authorization
   */
  public boolean isFullyDelegateAuthorizationSet() {
    return _isSet(21);
  }

  /**
   * Sets whether the Web and EJB containers should
 call the security framework on every access.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setFullyDelegateAuthorization)
   *
   */
  public void setFullyDelegateAuthorization(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _FullyDelegateAuthorization;
    _FullyDelegateAuthorization = param0;
    _postSet(21, _oldVal, param0);
  }

  /**
   * <p>Not used in this release.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=isValidateDDSecurityData)
   *
   * @xsdgen:element.name validate-dd-security-data
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic true
   */
  public boolean isValidateDDSecurityData() {
    return _ValidateDDSecurityData;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isValidateDDSecurityDataInherited)
   *
   * return true if the value of property ValidateDDSecurityData is inherited from template
   */
  public boolean isValidateDDSecurityDataInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isValidateDDSecurityDataSet)
   *
   * @xsdgen:isSetMethodFor validate-dd-security-data
   */
  public boolean isValidateDDSecurityDataSet() {
    return _isSet(22);
  }

  /**
   * Sets whether security data in the deployment descriptor is validated.
 This setting establishes the default value for applications deployed using the realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setValidateDDSecurityData)
   *
   */
  public void setValidateDDSecurityData(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _ValidateDDSecurityData;
    _ValidateDDSecurityData = param0;
    _postSet(22, _oldVal, param0);
  }

  /**
   * <p>Specifies the default security model for Web applications or EJBs
 that are secured by this security realm. You can override this default
 during deployment.</p>
 
 <p><b>Note:</b> If you deploy a module by modifying the domain's <code>config.xml</code> file
 and restarting the server, and if you do not specify a security model value
 for the module in <code>config.xml</code>, the module is secured with the default
 value of the <code>AppDeploymentMBean SecurityDDModel</code>  attribute
 (see {@link weblogic.management.configuration.AppDeploymentMBean#getSecurityDDModel() getSecurityDDModel}).</p>
 
 <p>Choose one of these security models:</p>
    <ul>
       <li><code>Deployment Descriptors Only (DDOnly)</code>
         <ul>
           <li>For EJBs and URL patterns, this model uses only the roles
           and policies in the J2EE deployment descriptors (DD); the Administration
           Console allows only read access for this data. With this model,
           EJBs and URL patterns are not protected by roles and policies of a broader
           scope (such as a policy scoped to an entire Web application). If an EJB or
           URL pattern is not protected by a role or policy in the DD, then it is
           unprotected: anyone can access it. </li>

           <li>For application-scoped <i>roles</i> in an EAR, this model uses only the roles
           defined in the WebLogic Server DD; the Administration Console allows only read
           access for this data. If the WebLogic Server DD does not define roles, then there
           will be no such scoped roles defined for this EAR.</li>

           <li>For all other types of resources, you can use the Administration Console to
           create roles or policies. For example, with this model, you can use the Administration
           Console to create application-scoped <i>policies</i> for an EAR.</li>


          <li>Applies for the life of the deployment. If you want to use a
           different model, you must delete the deployment and reinstall
           it.</li>
         </ul>
       </li>

       <li><code>Customize Roles Only (CustomRoles)</code>
         <ul>
           <li>For EJBs and URL patterns, this model uses only the <i>policies</i>
           in the J2EE deployment descriptors (DD). EJBs and URL
           patterns are not protected by policies of a broader scope (such as a
           policy scoped to an entire Web application). This model ignores any <i>roles</i>
           defined in the DDs; an administrator completes the role mappings using
           the Administration Console.</li>

           <li>For all other types of resources, you can use the Administration Console to
           create roles or policies. For example, with this model, you can use the Administration
           Console to create application-scoped policies or roles for an EAR.</li>

           <li>Applies for the life of the deployment. If you want to use a
           different model, you must delete the deployment and reinstall
           it.</li>
         </ul>
       </li>

       <li><code>Customize Roles and Policies (CustomRolesAndPolicies)</code>
         <ul>
           <li>Ignores any roles and policies defined in deployment
           descriptors. An administrator uses the Administration Console to
           secure the resources.</li>

           <li>Performs security checks for <b>all</b> URLs or EJB methods
           in the module.</li>

           <li>Applies for the life of the deployment. If you want to use a
           different model, you must delete the deployment and reinstall
           it.</li>
         </ul>
       </li>

       <li><code>Advanced (Advanced)</code>
       <p>You configure how this model behaves by setting values for
       the following options:</p>
         <ul>
           <li><code>When Deploying Web Applications or EJBs</code>
           <p><b>Note:</b> When using the WebLogic Scripting Tool or JMX APIs,
           there is no single MBean attribute for this setting. Instead,
            you must set the values for the <code>DeployPolicyIgnored</code> and
            <code>DeployRoleIgnored</code> attributes of <code>RealmMBean</code>.</p>
           </li>

           <li><code>Check Roles and Policies (FullyDelegateAuthorization)</code></li>

           <li><code>Combined Role Mapping Enabled (CombinedRoleMappingEnabled)</code></li>
         </ul>
         <p>You can change the configuration of this model. Any changes
       immediately apply to all modules that use the Advanced model. For
       example, you can specify that all modules using this model will copy
       roles and policies from their deployment descriptors into the
       appropriate provider databases upon deployment. After you deploy all
       of your modules, you can change this behavior to ignore roles and
       policies in deployment descriptors so that when you redeploy modules
       they will not re-copy roles and policies.</p>
           
      <p><b>Note:</b> Prior to WebLogic Server version 9.0 the Advanced model was
           the only security model available. Use this model if you want to
           continue to secure EJBs and Web Applications as in releases
           prior to 9.0.</p>
      </li>
     </ul>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getSecurityDDModel)
   *
   * @xsdgen:element.name security-dd-model
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.enumeration DDOnly
   * @xsdgen:element.enumeration CustomRoles
   * @xsdgen:element.enumeration CustomRolesAndPolicies
   * @xsdgen:element.enumeration Advanced
   * @dynamic true
   */
  public String getSecurityDDModel() {
    return _SecurityDDModel;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isSecurityDDModelInherited)
   *
   * return true if the value of property SecurityDDModel is inherited from template
   */
  public boolean isSecurityDDModelInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isSecurityDDModelSet)
   *
   * @xsdgen:isSetMethodFor security-dd-model
   */
  public boolean isSecurityDDModelSet() {
    return _isSet(23);
  }

  /**
   * Sets the default security deployment model for applications deployed in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setSecurityDDModel)
   *
   */
  public void setSecurityDDModel(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String[] _set = { DeploymentModel.DD_ONLY, DeploymentModel.CUSTOM_ROLES, DeploymentModel.CUSTOM_ROLES_POLICIES, DeploymentModel.ADVANCED };
    param0 = LegalChecks.checkInEnum("SecurityDDModel", param0, _set);
    String _oldVal = _SecurityDDModel;
    _SecurityDDModel = param0;
    _postSet(23, _oldVal, param0);
  }

  /**
   * <p>Determines how the role mappings in the Enterprise Application, Web
     application, and EJB containers interact. This setting is valid only
     for Web applications and EJBs that use the Advanced security model and
     that initialize roles from deployment descriptors.</p>
     <p>When enabled:</p>

     <ul>
       <li>Application role mappings are combined with EJB and Web
       application mappings so that all principal mappings are included.
       The Security Service combines the role mappings with a logical
       <code>OR</code> operator.</li>

       <li>If one or more policies in the <code>web.xml</code> file
       specify a role for which no mapping exists in the
       <code>weblogic.xml</code> file, the Web application container
       creates an empty map for the undefined role (that is, the role is
       explicitly defined as containing no principal). Therefore, no one
       can access URL patterns that are secured by such policies.</li>

       <li>If one or more policies in the <code>ejb-jar.xml</code> file
       specify a role for which no mapping exists in the
       <code>weblogic-ejb-jar.xml</code> file, the EJB container creates an
       empty map for the undefined role (that is, the role is explicitly
       defined as containing no principal). Therefore, no one can access
       methods that are secured by such policies.</li>
     </ul>

     <p>When disabled:</p>

     <ul>
       <li>Role mappings for each container are exclusive to other
       containers unless defined by the
       <code>&lt;externally-defined&gt;</code> descriptor element.</li>

       <li><p>If one or more policies in the <code>web.xml</code> file
       specify a role for which no role mapping exists in the
       <code>weblogic.xml</code> file, the Web application container
       assumes that the undefined role is the name of a principal. It
       therefore maps the assumed principal to the role name. For example,
       if the <code>web.xml</code> file contains the following stanza in
       one of its policies:</p>
       
       <p><code>&lt;auth-constraint&gt;<br>
       &lt;role-name&gt;PrivilegedUser&lt;/role-name&gt;<br>
       &lt;/auth-constraint&gt;</code></p>
       
       <p>but, if the <code>weblogic.xml</code> file has no role mapping for
       <code>PrivilegedUser</code>, then the Web application container
       creates an in-memory mapping that is equivalent to the following
       stanza:</p>
       
       <p><code>&lt;security-role-assignment&gt;<br>
       &lt;role-name&gt;PrivilegedUser&lt;/role-name&gt;<br>
       &lt;principal-name&gt;PrivilegedUser&lt;/principal-name&gt;<br>
       &lt;/security-role-assignment&gt;</code></p>
       </li>

       <li>Role mappings for EJB methods must be defined in the
       <code>weblogic-ejb-jar.xml</code> file. Role mappings defined in the
       other containers are not used unless defined by the
       <code>&lt;externally-defined&gt;</code> descriptor element.</li>
     </ul>

     <dl>
       <dt>Note:</dt>

       <dd>For all applications previously deployed in version 8.1 and
       upgraded to version 9.x, the combining role mapping is disabled by
       default.</dd>
     </dl>
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCombinedRoleMappingEnabled)
   *
   * @xsdgen:element.name combined-role-mapping-enabled
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default true
   * @dynamic true
   */
  public boolean isCombinedRoleMappingEnabled() {
    return _CombinedRoleMappingEnabled;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCombinedRoleMappingEnabledInherited)
   *
   * return true if the value of property CombinedRoleMappingEnabled is inherited from template
   */
  public boolean isCombinedRoleMappingEnabledInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCombinedRoleMappingEnabledSet)
   *
   * @xsdgen:isSetMethodFor combined-role-mapping-enabled
   */
  public boolean isCombinedRoleMappingEnabledSet() {
    return _isSet(24);
  }

  /**
   * Sets whether application role mappings are combined
 by the J2EE containers.
 <p>
 If false the containers need enternally defined mappings
 to use application role mappings.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCombinedRoleMappingEnabled)
   *
   */
  public void setCombinedRoleMappingEnabled(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _CombinedRoleMappingEnabled;
    _CombinedRoleMappingEnabled = param0;
    _postSet(24, _oldVal, param0);
  }

  /**
   * Checks that the realm is valid.
   * (Interface=weblogic.management.security.RealmMBean Attribute=validate)
   *
   */
  public void validate()
    throws ErrorCollectionException
  {
    try {
    _customizer.validate();
    } catch (weblogic.management.utils.ErrorCollectionException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Returns whether this security realm is the Default realm for the WebLogic domain.
 Deprecated in this release of WebLogic Server and replaced by
 <code>weblogic.management.configuration.SecurityConfigurationMBean.getDefaultRealm</code>.
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDefaultRealm)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public boolean isDefaultRealm() {
    return _customizer.isDefaultRealm();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDefaultRealmInherited)
   *
   * return true if the value of property DefaultRealm is inherited from template
   */
  public boolean isDefaultRealmInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDefaultRealmSet)
   *
   * @xsdgen:isSetMethodFor default-realm
   */
  public boolean isDefaultRealmSet() {
    return _isSet(25);
  }

  /**
   * Determines whether is security realm is the Default realm for the WebLogic domain.
 Deprecated in this release of WebLogic Server and replaced by
 <code>weblogic.management.configuration.SecurityConfigurationMBean.setDefautlRealm</code>.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDefaultRealm)
   *
   */
  public void setDefaultRealm(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    _customizer.setDefaultRealm(param0);
  }

  /**
   * <p>Returns whether the WebLogic Principal Validator caching is enabled.</p>
 
 <p>The Principal Validator is used by Oracle supplied authentication providers
 and may be used by custom authentication providers. If enabled, the default principal
 validator will cache WebLogic Principal signatures.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=isEnableWebLogicPrincipalValidatorCache)
   *
   * @xsdgen:element.name enable-web-logic-principal-validator-cache
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default true
   * @dynamic false
   */
  public boolean isEnableWebLogicPrincipalValidatorCache() {
    return _EnableWebLogicPrincipalValidatorCache;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isEnableWebLogicPrincipalValidatorCacheInherited)
   *
   * return true if the value of property EnableWebLogicPrincipalValidatorCache is inherited from template
   */
  public boolean isEnableWebLogicPrincipalValidatorCacheInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isEnableWebLogicPrincipalValidatorCacheSet)
   *
   * @xsdgen:isSetMethodFor enable-web-logic-principal-validator-cache
   */
  public boolean isEnableWebLogicPrincipalValidatorCacheSet() {
    return _isSet(26);
  }

  /**
   * Sets whether the WebLogic Principal Validator caching is enabled.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setEnableWebLogicPrincipalValidatorCache)
   *
   */
  public void setEnableWebLogicPrincipalValidatorCache(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _EnableWebLogicPrincipalValidatorCache;
    _EnableWebLogicPrincipalValidatorCache = param0;
    _postSet(26, _oldVal, param0);
  }

  /**
   * Returns the maximum size of the LRU cache for holding WebLogic Principal signatures.
 This value is only used if <code>EnableWebLogicPrincipalValidatorCache</code> is set
 to <code>true</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getMaxWebLogicPrincipalsInCache)
   *
   * @xsdgen:element.name max-web-logic-principals-in-cache
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public Integer getMaxWebLogicPrincipalsInCache() {
    return _MaxWebLogicPrincipalsInCache;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isMaxWebLogicPrincipalsInCacheInherited)
   *
   * return true if the value of property MaxWebLogicPrincipalsInCache is inherited from template
   */
  public boolean isMaxWebLogicPrincipalsInCacheInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isMaxWebLogicPrincipalsInCacheSet)
   *
   * @xsdgen:isSetMethodFor max-web-logic-principals-in-cache
   */
  public boolean isMaxWebLogicPrincipalsInCacheSet() {
    return _isSet(27);
  }

  /**
   * Sets the maximum size of the LRU cache for holding WebLogic Principal signatures.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setMaxWebLogicPrincipalsInCache)
   *
   */
  public void setMaxWebLogicPrincipalsInCache(Integer param0)
    throws javax.management.InvalidAttributeValueException
  {
    weblogic.management.security.RealmValidator.validateMaxWebLogicPrincipalsInCache(param0);
    Integer _oldVal = _MaxWebLogicPrincipalsInCache;
    _MaxWebLogicPrincipalsInCache = param0;
    _postSet(27, _oldVal, param0);
  }

  /**
   * The name of this configuration. WebLogic Server uses an MBean to
 implement and persist the configuration.
   * (Interface=weblogic.management.security.RealmMBean Attribute=getName)
   *
   * @xsdgen:element.name name
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default Realm
   * @dynamic false
   */
  public String getName() {
    return _Name;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isNameInherited)
   *
   * return true if the value of property Name is inherited from template
   */
  public boolean isNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isNameSet)
   *
   * @xsdgen:isSetMethodFor name
   */
  public boolean isNameSet() {
    return _isSet(28);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setName)
   *
   */
  public void setName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _Name;
    _Name = param0;
    _postSet(28, _oldVal, param0);
  }

  /**
   * <p>Configures the WebLogic Server MBean servers to use the security realm's Authorization providers
 to determine whether a JMX client has permission to access an MBean attribute or invoke an
 MBean operation.</p>
 <p>You can continue to use WebLogic Server's default security settings or modify
 the defaults to suit your needs.</p>
 <p>If you do not delegate authorization to the realm's Authorization providers, the WebLogic MBean servers
 allow access only to the four default security roles (Admin, Deployer, Operator, and Monitor) and only
 as specified by WebLogic Server's default security settings.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDelegateMBeanAuthorization)
   *
   * @xsdgen:element.name delegate-m-bean-authorization
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic false
   */
  public boolean isDelegateMBeanAuthorization() {
    return _DelegateMBeanAuthorization;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDelegateMBeanAuthorizationInherited)
   *
   * return true if the value of property DelegateMBeanAuthorization is inherited from template
   */
  public boolean isDelegateMBeanAuthorizationInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDelegateMBeanAuthorizationSet)
   *
   * @xsdgen:isSetMethodFor delegate-m-bean-authorization
   */
  public boolean isDelegateMBeanAuthorizationSet() {
    return _isSet(29);
  }

  /**
   * Sets the value of the DelegateMBeanAuthorization attribute.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDelegateMBeanAuthorization)
   *
   */
  public void setDelegateMBeanAuthorization(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _DelegateMBeanAuthorization;
    _DelegateMBeanAuthorization = param0;
    _postSet(29, _oldVal, param0);
  }

  /**
   * Returns a comma separated string of authentication methods that should be
 used when the Web application specifies "REALM" as its auth-method. The
 authentication methods will be applied in order in which they appear in
 the list.
   * (Interface=weblogic.management.security.RealmMBean Attribute=getAuthMethods)
   *
   * @xsdgen:element.name auth-methods
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getAuthMethods() {
    return _AuthMethods;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthMethodsInherited)
   *
   * return true if the value of property AuthMethods is inherited from template
   */
  public boolean isAuthMethodsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAuthMethodsSet)
   *
   * @xsdgen:isSetMethodFor auth-methods
   */
  public boolean isAuthMethodsSet() {
    return _isSet(30);
  }

  /**
   * Set the authentication methods that should be used when the Web
 application specifies "REALM" as its auth-method.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAuthMethods)
   *
   */
  public void setAuthMethods(String param0) {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _AuthMethods;
    _AuthMethods = param0;
    _postSet(30, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=getCompatibilityObjectName)
   *
   * @xsdgen:element.name compatibility-object-name
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getCompatibilityObjectName() {
    return _customizer.getCompatibilityObjectName();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCompatibilityObjectNameInherited)
   *
   * return true if the value of property CompatibilityObjectName is inherited from template
   */
  public boolean isCompatibilityObjectNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isCompatibilityObjectNameSet)
   *
   * @xsdgen:isSetMethodFor compatibility-object-name
   */
  public boolean isCompatibilityObjectNameSet() {
    return _isSet(31);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setCompatibilityObjectName)
   *
   */
  public void setCompatibilityObjectName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _CompatibilityObjectName;
    _CompatibilityObjectName = param0;
    _postSet(31, _oldVal, param0);
  }

  /**
   * Returns RDBMSSecurityStoreMBean for this realm, which is a singleton MBean describing RDBMS
 security store configuration.
   * (Interface=weblogic.management.security.RealmMBean Attribute=getRDBMSSecurityStore)
   *
   * @xsdgen:element.name rdbms-security-store
   * @xsdgen:element.astype weblogic.management.security.RDBMSSecurityStoreMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public RDBMSSecurityStoreMBean getRDBMSSecurityStore() {
    return _RDBMSSecurityStore;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRDBMSSecurityStoreInherited)
   *
   * return true if the value of property RDBMSSecurityStore is inherited from template
   */
  public boolean isRDBMSSecurityStoreInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRDBMSSecurityStoreSet)
   *
   * @xsdgen:isSetMethodFor rdbms-security-store
   */
  public boolean isRDBMSSecurityStoreSet() {
    return _isSet(32);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setRDBMSSecurityStore)
   *
   */
  public void setRDBMSSecurityStore(RDBMSSecurityStoreMBean param0)
    throws javax.management.InvalidAttributeValueException
  {
    if (param0 != null && getRDBMSSecurityStore() != null && param0 != getRDBMSSecurityStore()) {
      throw new BeanAlreadyExistsException(
        getRDBMSSecurityStore() + " has already been created");
    }
    if (param0 != null) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
      if (_setParent(_child, this, 32)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    RDBMSSecurityStoreMBean _oldVal = _RDBMSSecurityStore;
    _RDBMSSecurityStore = param0;
    _postSet(32, _oldVal, param0);
  }

  /**
   * Creates configuration for the RDBMS security store. This can be called only once unless the existing
 instance is destroyed by invoking <code>destroyRDBMSSecurityStore</code> operation. The new security store MBean
 will have this realm as its parent.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createRDBMSSecurityStore)
   *
   */
  public RDBMSSecurityStoreMBean createRDBMSSecurityStore()
    throws javax.management.JMException
  {
    RDBMSSecurityStoreMBeanImpl _val = new RDBMSSecurityStoreMBeanImpl(this, -1);
    try {
      setRDBMSSecurityStore(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Creates configuration for the RDBMS security store with the specified name. This can be called only once unless
 the existing instance is destroyed by invoking <code>destroyRDBMSSecurityStore</code> operation. The new security
 store MBean will have this realm as its parent.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createRDBMSSecurityStore)
   *
   */
  public RDBMSSecurityStoreMBean createRDBMSSecurityStore(String param0)
    throws javax.management.JMException
  {
    RDBMSSecurityStoreMBeanImpl _val = new RDBMSSecurityStoreMBeanImpl(this, -1);
    try {
      _val.setName(param0);
      setRDBMSSecurityStore(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Destroys and removes the existing RDBMS security store which is a child of this
 realm. It only removes the security store configuration, not any data persisted in the store.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyRDBMSSecurityStore)
   *
   */
  public void destroyRDBMSSecurityStore() {
    try {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)_RDBMSSecurityStore;
      if (_child == null) return;
      List _refs = _getReferenceManager().getResolvedReferences(_child);
      if (_refs != null && _refs.size() > 0) {
        throw new BeanRemoveRejectedException(_child, _refs);
      } else {
        _getReferenceManager().unregisterBean(_child);
        _markDestroyed(_child);
      }
      setRDBMSSecurityStore(null);
      _unSet(32);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Creates a Password Validator provider in this security
 The new Password Validator provider is added to the end of the list of
 Password Validator providers configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createPasswordValidator)
   *
   */
  public weblogic.management.security.authentication.PasswordValidatorMBean createPasswordValidator(Class param0)
    throws javax.management.JMException
  {
    weblogic.management.security.authentication.PasswordValidatorMBeanImpl _val = (weblogic.management.security.authentication.PasswordValidatorMBeanImpl)_createChildBean(param0, -1);
    try {
      addPasswordValidator(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Exclude from public API to be consistent with other provider creators. 
 Use createPasswordValidator(String, String) or createPasswordValidator(String) instead.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createPasswordValidator)
   *
   */
  public weblogic.management.security.authentication.PasswordValidatorMBean createPasswordValidator(Class param0, String param1)
    throws javax.management.JMException
  {
    weblogic.management.security.authentication.PasswordValidatorMBeanImpl _val = (weblogic.management.security.authentication.PasswordValidatorMBeanImpl)_createChildBean(param0, -1);
    try {
      _val.setName(param1);
      addPasswordValidator(_val);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      else if (e instanceof javax.management.JMException)
        throw (javax.management.JMException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    return _val;
  }

  /**
   * Creates a Password Validator provider in this security realm.
 The new Password Validator provider is added to the end of the list of
 Password Validator providers configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createPasswordValidator)
   *
   */
  public weblogic.management.security.authentication.PasswordValidatorMBean createPasswordValidator(String param0, String param1)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createPasswordValidator(param0, param1);
  }

  /**
   * Creates a Password Validator provider in this security realm.
 The new Password Validator provider is added to the end of the list of
 Password Validator providers configured in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=createPasswordValidator)
   *
   */
  public weblogic.management.security.authentication.PasswordValidatorMBean createPasswordValidator(String param0)
    throws ClassNotFoundException, javax.management.JMException
  {
    return _customizer.createPasswordValidator(param0);
  }

  /**
   * Returns the types of Password Validator providers that may be created in this security realm,
 for example, <code>com.bea.security.providers.authentication.passwordvalidator.SystemPasswordValidator</code>.
 Use this method to find the available types to pass to <code>createPasswordValidator</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getPasswordValidatorTypes)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getPasswordValidatorTypes() {
    return _customizer.getPasswordValidatorTypes();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isPasswordValidatorTypesInherited)
   *
   * return true if the value of property PasswordValidatorTypes is inherited from template
   */
  public boolean isPasswordValidatorTypesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isPasswordValidatorTypesSet)
   *
   * @xsdgen:isSetMethodFor password-validator-type
   */
  public boolean isPasswordValidatorTypesSet() {
    return _isSet(33);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=setPasswordValidatorTypes)
   *
   */
  public void setPasswordValidatorTypes(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _PasswordValidatorTypes = param0;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=addPasswordValidator)
   *
   */
  public void addPasswordValidator(weblogic.management.security.authentication.PasswordValidatorMBean param0) {
    _getHelper()._ensureNonNull(param0);
    if (!((AbstractDescriptorBean)param0).isChildProperty(this, 34)) {
      weblogic.management.security.authentication.PasswordValidatorMBean[] _new;
      if (_isSet(34)) {
        _new = (weblogic.management.security.authentication.PasswordValidatorMBean[]) _getHelper()._extendArray(getPasswordValidators(), weblogic.management.security.authentication.PasswordValidatorMBean.class, param0);
      } else {
        _new = new weblogic.management.security.authentication.PasswordValidatorMBean[] { param0 };
      }
      try {
        setPasswordValidators(_new);
      } catch (Exception e) {
        if (e instanceof RuntimeException)
          throw (RuntimeException)e;
        throw new java.lang.reflect.UndeclaredThrowableException(e);
      }
    }
  }

  /**
   * Returns the Password Validator providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=getPasswordValidators)
   *
   * @xsdgen:element.name password-validator
   * @xsdgen:element.astype weblogic.management.security.authentication.PasswordValidatorMBeanImpl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public weblogic.management.security.authentication.PasswordValidatorMBean[] getPasswordValidators() {
    return _PasswordValidators;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isPasswordValidatorsInherited)
   *
   * return true if the value of property PasswordValidators is inherited from template
   */
  public boolean isPasswordValidatorsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isPasswordValidatorsSet)
   *
   * @xsdgen:isSetMethodFor password-validator
   */
  public boolean isPasswordValidatorsSet() {
    return _isSet(34);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=removePasswordValidator)
   *
   */
  public void removePasswordValidator(weblogic.management.security.authentication.PasswordValidatorMBean param0) {
    destroyPasswordValidator(param0);
  }

  /**
   * Sets the Password Validator providers for this security realm (in invocation order).
   * (Interface=weblogic.management.security.RealmMBean Attribute=setPasswordValidators)
   *
   */
  public void setPasswordValidators(weblogic.management.security.authentication.PasswordValidatorMBean[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new weblogic.management.security.authentication.PasswordValidatorMBeanImpl[0] : param0;
    ProviderValidator.validateProviders((ProviderMBean[])param0);
    for (int i = 0; i < param0.length; i++) {
      AbstractDescriptorBean _child = (AbstractDescriptorBean)param0[i];
      if (_setParent(_child, this, 34)) {
        _getReferenceManager().registerBean(_child, false);
        _postCreate(_child);
      }
    }
    weblogic.management.security.authentication.PasswordValidatorMBean[] _oldVal = _PasswordValidators;
    _PasswordValidators = param0;
    _postSet(34, _oldVal, param0);
  }

  /**
   * Finds an Password Validator provider in this security realm.
 Returns null if this security realm has no Password Validator provider with the specified name.
   * (Interface=weblogic.management.security.RealmMBean Attribute=lookupPasswordValidator)
   *
   */
  public weblogic.management.security.authentication.PasswordValidatorMBean lookupPasswordValidator(String param0) {
    Object[] aary = (Object[]) _PasswordValidators;
    int size = aary.length;
    java.util.ListIterator it = java.util.Arrays.asList(aary).listIterator(size);
    while (it.hasPrevious()) {
      weblogic.management.security.authentication.PasswordValidatorMBeanImpl bean = (weblogic.management.security.authentication.PasswordValidatorMBeanImpl)it.previous();
      Object key = param0;
      if (bean.getName().equals(key)) {
        return bean;
      }
    }
    return null;
  }

  /**
   * Removes the configuration for a Password Validator provider in this security realm.
   * (Interface=weblogic.management.security.RealmMBean Attribute=destroyPasswordValidator)
   *
   */
  public void destroyPasswordValidator(weblogic.management.security.authentication.PasswordValidatorMBean param0) {
    try {
      _checkIsPotentialChild(param0, 34);
      weblogic.management.security.authentication.PasswordValidatorMBean[] _old = getPasswordValidators();
      weblogic.management.security.authentication.PasswordValidatorMBean[] _new = (weblogic.management.security.authentication.PasswordValidatorMBean[])_getHelper()._removeElement(_old, weblogic.management.security.authentication.PasswordValidatorMBean.class, param0);
      if (_old.length != _new.length) {
        _preDestroy((AbstractDescriptorBean)param0);
        try {
          AbstractDescriptorBean _child = (AbstractDescriptorBean)param0;
          if (_child == null) return;
          List _refs = _getReferenceManager().getResolvedReferences(_child);
          if (_refs != null && _refs.size() > 0) {
            throw new BeanRemoveRejectedException(_child, _refs);
          } else {
            _getReferenceManager().unregisterBean(_child);
            _markDestroyed(_child);
          }
          setPasswordValidators(_new);
        } catch (Exception e) {
          if (e instanceof RuntimeException)
            throw (RuntimeException)e;
          throw new java.lang.reflect.UndeclaredThrowableException(e);
        }
      }
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * <p>Specifies whether synchronization for deployable Authorization and Role Mapping providers is enabled.</p>
 
 <p>The Authorization and Role Mapping providers may or may not support parallel security policy and role modification,
 respectively, in the security provider database. If the security providers do not support parallel modification, 
 the WebLogic Security Framework enforces a synchronization mechanism that results in each application and module 
 being placed in a queue and deployed sequentially.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployableProviderSynchronizationEnabled)
   *
   * @xsdgen:element.name deployable-provider-synchronization-enabled
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic false
   */
  public boolean isDeployableProviderSynchronizationEnabled() {
    return _DeployableProviderSynchronizationEnabled;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployableProviderSynchronizationEnabledInherited)
   *
   * return true if the value of property DeployableProviderSynchronizationEnabled is inherited from template
   */
  public boolean isDeployableProviderSynchronizationEnabledInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployableProviderSynchronizationEnabledSet)
   *
   * @xsdgen:isSetMethodFor deployable-provider-synchronization-enabled
   */
  public boolean isDeployableProviderSynchronizationEnabledSet() {
    return _isSet(35);
  }

  /**
   * Specifies whether synchronization for deployable Authorization and Role Mapping providers is enabled.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDeployableProviderSynchronizationEnabled)
   *
   */
  public void setDeployableProviderSynchronizationEnabled(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _DeployableProviderSynchronizationEnabled;
    _DeployableProviderSynchronizationEnabled = param0;
    _postSet(35, _oldVal, param0);
  }

  /**
   * Returns the timeout value, in milliseconds, for the deployable security provider synchronization operation.
 This value is only used if <code>DeployableProviderSynchronizationEnabled</code> is set
 to <code>true</code>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getDeployableProviderSynchronizationTimeout)
   *
   * @xsdgen:element.name deployable-provider-synchronization-timeout
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public Integer getDeployableProviderSynchronizationTimeout() {
    return _DeployableProviderSynchronizationTimeout;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployableProviderSynchronizationTimeoutInherited)
   *
   * return true if the value of property DeployableProviderSynchronizationTimeout is inherited from template
   */
  public boolean isDeployableProviderSynchronizationTimeoutInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isDeployableProviderSynchronizationTimeoutSet)
   *
   * @xsdgen:isSetMethodFor deployable-provider-synchronization-timeout
   */
  public boolean isDeployableProviderSynchronizationTimeoutSet() {
    return _isSet(36);
  }

  /**
   * Specifies the timeout value, in milliseconds, for the deployable security provider synchronization operation.
   * (Interface=weblogic.management.security.RealmMBean Attribute=setDeployableProviderSynchronizationTimeout)
   *
   */
  public void setDeployableProviderSynchronizationTimeout(Integer param0)
    throws javax.management.InvalidAttributeValueException
  {
    Integer _oldVal = _DeployableProviderSynchronizationTimeout;
    _DeployableProviderSynchronizationTimeout = param0;
    _postSet(36, _oldVal, param0);
  }

  /**
   * <p>Specifies whether the Realm will be auto-restarted if
 non-dynamic changes are made to the realm or providers within the realm.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAutoRestartOnNonDynamicChanges)
   *
   * @xsdgen:element.name auto-restart-on-non-dynamic-changes
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic true
   */
  public boolean isAutoRestartOnNonDynamicChanges() {
    if (!_isSet(37)) {
     try {
       return isDefaultRealm() ? false : true;
     } catch (NullPointerException e) {
       // indicates that property in derived chain is not set
       // fall through
     }
    }
    return _AutoRestartOnNonDynamicChanges;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAutoRestartOnNonDynamicChangesInherited)
   *
   * return true if the value of property AutoRestartOnNonDynamicChanges is inherited from template
   */
  public boolean isAutoRestartOnNonDynamicChangesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isAutoRestartOnNonDynamicChangesSet)
   *
   * @xsdgen:isSetMethodFor auto-restart-on-non-dynamic-changes
   */
  public boolean isAutoRestartOnNonDynamicChangesSet() {
    return _isSet(37);
  }

  /**
   * <p>Sets the value of the AutoRestartOnNonDynamicChanges attribute.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=setAutoRestartOnNonDynamicChanges)
   *
   */
  public void setAutoRestartOnNonDynamicChanges(boolean param0) {
    boolean _oldVal = _AutoRestartOnNonDynamicChanges;
    _AutoRestartOnNonDynamicChanges = param0;
    _postSet(37, _oldVal, param0);
  }

  /**
   * <p>Specifies the retire timeout for a realm that is restarted. The old
 realm will be shutdown after the specified timeout period has elapsed.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getRetireTimeoutSeconds)
   *
   * @xsdgen:element.name retire-timeout-seconds
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 1
   * @xsdgen:element.default 60
   * @dynamic true
   */
  public int getRetireTimeoutSeconds() {
    return _RetireTimeoutSeconds;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRetireTimeoutSecondsInherited)
   *
   * return true if the value of property RetireTimeoutSeconds is inherited from template
   */
  public boolean isRetireTimeoutSecondsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isRetireTimeoutSecondsSet)
   *
   * @xsdgen:isSetMethodFor retire-timeout-seconds
   */
  public boolean isRetireTimeoutSecondsSet() {
    return _isSet(38);
  }

  /**
   * <p>Sets the value of the RetireTimeoutSeconds attribute.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=setRetireTimeoutSeconds)
   *
   */
  public void setRetireTimeoutSeconds(int param0) {
    LegalChecks.checkMin("RetireTimeoutSeconds", param0, 1);
    int _oldVal = _RetireTimeoutSeconds;
    _RetireTimeoutSeconds = param0;
    _postSet(38, _oldVal, param0);
  }

  /**
   * <p>Sets the Management Identity Domain value for the realm.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=getManagementIdentityDomain)
   *
   * @xsdgen:element.name management-identity-domain
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getManagementIdentityDomain() {
    return _ManagementIdentityDomain;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isManagementIdentityDomainInherited)
   *
   * return true if the value of property ManagementIdentityDomain is inherited from template
   */
  public boolean isManagementIdentityDomainInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=isManagementIdentityDomainSet)
   *
   * @xsdgen:isSetMethodFor management-identity-domain
   */
  public boolean isManagementIdentityDomainSet() {
    return _isSet(39);
  }

  /**
   * <p>Sets the value of the Management Identity Domain attribute. Partition administrators
 with this identity domain can invoke on a subset of management operations for the realm.
 This allows the Partition Administrator to manage the realm data including users, groups,
 roles, and policies.</p>
   * (Interface=weblogic.management.security.RealmMBean Attribute=setManagementIdentityDomain)
   *
   */
  public void setManagementIdentityDomain(String param0) {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _ManagementIdentityDomain;
    _ManagementIdentityDomain = param0;
    _postSet(39, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RealmMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }


  protected void _postCreate() {
    _customizer._postCreate();
  }


 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      || isUserLockoutManagerSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 10;
    }
    try {
      switch (idx) {
      case 10:
        _Adjudicator = null;
        if (initOne) break;
      case 11:
        _AdjudicatorTypes = new String[]{};
        if (initOne) break;
      case 3:
        _AuditorTypes = new String[]{};
        if (initOne) break;
      case 2:
        _Auditors = new weblogic.management.security.audit.AuditorMBean[]{};
        if (initOne) break;
      case 30:
        _AuthMethods = null;
        if (initOne) break;
      case 5:
        _AuthenticationProviderTypes = new String[]{};
        if (initOne) break;
      case 4:
        _AuthenticationProviders = new weblogic.management.security.authentication.AuthenticationProviderMBean[]{};
        if (initOne) break;
      case 9:
        _AuthorizerTypes = new String[]{};
        if (initOne) break;
      case 8:
        _Authorizers = new weblogic.management.security.authorization.AuthorizerMBean[]{};
        if (initOne) break;
      case 16:
        _CertPathBuilder = null;
        if (initOne) break;
      case 15:
        _CertPathProviderTypes = new String[]{};
        if (initOne) break;
      case 14:
        _CertPathProviders = new weblogic.management.security.pk.CertPathProviderMBean[]{};
        if (initOne) break;
      case 31:
        _CompatibilityObjectName = null;
        if (initOne) break;
      case 13:
        _CredentialMapperTypes = new String[]{};
        if (initOne) break;
      case 12:
        _CredentialMappers = new weblogic.management.security.credentials.CredentialMapperMBean[]{};
        if (initOne) break;
      case 36:
        _DeployableProviderSynchronizationTimeout = new Integer(60000);
        if (initOne) break;
      case 39:
        _ManagementIdentityDomain = null;
        if (initOne) break;
      case 27:
        _MaxWebLogicPrincipalsInCache = new Integer(500);
        if (initOne) break;
      case 28:
        _Name = "Realm";
        if (initOne) break;
      case 33:
        _PasswordValidatorTypes = new String[]{};
        if (initOne) break;
      case 34:
        _PasswordValidators = new weblogic.management.security.authentication.PasswordValidatorMBean[]{};
        if (initOne) break;
      case 32:
        _RDBMSSecurityStore = null;
        if (initOne) break;
      case 38:
        _RetireTimeoutSeconds = 60;
        if (initOne) break;
      case 7:
        _RoleMapperTypes = new String[]{};
        if (initOne) break;
      case 6:
        _RoleMappers = new weblogic.management.security.authorization.RoleMapperMBean[]{};
        if (initOne) break;
      case 23:
        _SecurityDDModel = DeploymentModel.DD_ONLY;
        if (initOne) break;
      case 17:
        _UserLockoutManager = new weblogic.management.security.authentication.UserLockoutManagerMBeanImpl(this, 17);
        _postCreate((AbstractDescriptorBean)_UserLockoutManager);
        if (initOne) break;
      case 37:
        _AutoRestartOnNonDynamicChanges = false;
        if (initOne) break;
      case 24:
        _CombinedRoleMappingEnabled = true;
        if (initOne) break;
      case 25:
        _customizer.setDefaultRealm(false);
        if (initOne) break;
      case 29:
        _DelegateMBeanAuthorization = false;
        if (initOne) break;
      case 20:
        _DeployCredentialMappingIgnored = false;
        if (initOne) break;
      case 19:
        _DeployPolicyIgnored = false;
        if (initOne) break;
      case 18:
        _DeployRoleIgnored = false;
        if (initOne) break;
      case 35:
        _DeployableProviderSynchronizationEnabled = false;
        if (initOne) break;
      case 26:
        _EnableWebLogicPrincipalValidatorCache = true;
        if (initOne) break;
      case 21:
        _FullyDelegateAuthorization = false;
        if (initOne) break;
      case 22:
        _ValidateDDSecurityData = false;
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private RealmMBeanImpl bean;

    protected Helper(RealmMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 10: return "Adjudicator";
      case 11: return "AdjudicatorTypes";
      case 3: return "AuditorTypes";
      case 2: return "Auditors";
      case 30: return "AuthMethods";
      case 5: return "AuthenticationProviderTypes";
      case 4: return "AuthenticationProviders";
      case 9: return "AuthorizerTypes";
      case 8: return "Authorizers";
      case 16: return "CertPathBuilder";
      case 15: return "CertPathProviderTypes";
      case 14: return "CertPathProviders";
      case 31: return "CompatibilityObjectName";
      case 13: return "CredentialMapperTypes";
      case 12: return "CredentialMappers";
      case 36: return "DeployableProviderSynchronizationTimeout";
      case 39: return "ManagementIdentityDomain";
      case 27: return "MaxWebLogicPrincipalsInCache";
      case 28: return "Name";
      case 33: return "PasswordValidatorTypes";
      case 34: return "PasswordValidators";
      case 32: return "RDBMSSecurityStore";
      case 38: return "RetireTimeoutSeconds";
      case 7: return "RoleMapperTypes";
      case 6: return "RoleMappers";
      case 23: return "SecurityDDModel";
      case 17: return "UserLockoutManager";
      case 37: return "AutoRestartOnNonDynamicChanges";
      case 24: return "CombinedRoleMappingEnabled";
      case 25: return "DefaultRealm";
      case 29: return "DelegateMBeanAuthorization";
      case 20: return "DeployCredentialMappingIgnored";
      case 19: return "DeployPolicyIgnored";
      case 18: return "DeployRoleIgnored";
      case 35: return "DeployableProviderSynchronizationEnabled";
      case 26: return "EnableWebLogicPrincipalValidatorCache";
      case 21: return "FullyDelegateAuthorization";
      case 22: return "ValidateDDSecurityData";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("Adjudicator")) return 10;
      else if (propName.equals("AdjudicatorTypes")) return 11;
      else if (propName.equals("AuditorTypes")) return 3;
      else if (propName.equals("Auditors")) return 2;
      else if (propName.equals("AuthMethods")) return 30;
      else if (propName.equals("AuthenticationProviderTypes")) return 5;
      else if (propName.equals("AuthenticationProviders")) return 4;
      else if (propName.equals("AuthorizerTypes")) return 9;
      else if (propName.equals("Authorizers")) return 8;
      else if (propName.equals("CertPathBuilder")) return 16;
      else if (propName.equals("CertPathProviderTypes")) return 15;
      else if (propName.equals("CertPathProviders")) return 14;
      else if (propName.equals("CompatibilityObjectName")) return 31;
      else if (propName.equals("CredentialMapperTypes")) return 13;
      else if (propName.equals("CredentialMappers")) return 12;
      else if (propName.equals("DeployableProviderSynchronizationTimeout")) return 36;
      else if (propName.equals("ManagementIdentityDomain")) return 39;
      else if (propName.equals("MaxWebLogicPrincipalsInCache")) return 27;
      else if (propName.equals("Name")) return 28;
      else if (propName.equals("PasswordValidatorTypes")) return 33;
      else if (propName.equals("PasswordValidators")) return 34;
      else if (propName.equals("RDBMSSecurityStore")) return 32;
      else if (propName.equals("RetireTimeoutSeconds")) return 38;
      else if (propName.equals("RoleMapperTypes")) return 7;
      else if (propName.equals("RoleMappers")) return 6;
      else if (propName.equals("SecurityDDModel")) return 23;
      else if (propName.equals("UserLockoutManager")) return 17;
      else if (propName.equals("AutoRestartOnNonDynamicChanges")) return 37;
      else if (propName.equals("CombinedRoleMappingEnabled")) return 24;
      else if (propName.equals("DefaultRealm")) return 25;
      else if (propName.equals("DelegateMBeanAuthorization")) return 29;
      else if (propName.equals("DeployCredentialMappingIgnored")) return 20;
      else if (propName.equals("DeployPolicyIgnored")) return 19;
      else if (propName.equals("DeployRoleIgnored")) return 18;
      else if (propName.equals("DeployableProviderSynchronizationEnabled")) return 35;
      else if (propName.equals("EnableWebLogicPrincipalValidatorCache")) return 26;
      else if (propName.equals("FullyDelegateAuthorization")) return 21;
      else if (propName.equals("ValidateDDSecurityData")) return 22;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      if (bean.getAdjudicator() != null) {
        iterators.add(new ArrayIterator(new weblogic.management.security.authorization.AdjudicatorMBean[] {bean.getAdjudicator()}));
      }
      iterators.add(new ArrayIterator(bean.getAuditors()));
      iterators.add(new ArrayIterator(bean.getAuthenticationProviders()));
      iterators.add(new ArrayIterator(bean.getAuthorizers()));
      iterators.add(new ArrayIterator(bean.getCertPathProviders()));
      iterators.add(new ArrayIterator(bean.getCredentialMappers()));
      iterators.add(new ArrayIterator(bean.getPasswordValidators()));
      if (bean.getRDBMSSecurityStore() != null) {
        iterators.add(new ArrayIterator(new RDBMSSecurityStoreMBean[] {bean.getRDBMSSecurityStore()}));
      }
      iterators.add(new ArrayIterator(bean.getRoleMappers()));
      if (bean.getUserLockoutManager() != null) {
        iterators.add(new ArrayIterator(new weblogic.management.security.authentication.UserLockoutManagerMBean[] {bean.getUserLockoutManager()}));
      }
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        childValue = computeChildHashValue(bean.getAdjudicator());
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isAdjudicatorTypesSet()){
          buf.append("AdjudicatorTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getAdjudicatorTypes())));
        }
        if (bean.isAuditorTypesSet()){
          buf.append("AuditorTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getAuditorTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getAuditors().length; i++){
          childValue ^= computeChildHashValue(bean.getAuditors()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isAuthMethodsSet()){
          buf.append("AuthMethods");
          buf.append(String.valueOf(bean.getAuthMethods()));
        }
        if (bean.isAuthenticationProviderTypesSet()){
          buf.append("AuthenticationProviderTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getAuthenticationProviderTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getAuthenticationProviders().length; i++){
          childValue ^= computeChildHashValue(bean.getAuthenticationProviders()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isAuthorizerTypesSet()){
          buf.append("AuthorizerTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getAuthorizerTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getAuthorizers().length; i++){
          childValue ^= computeChildHashValue(bean.getAuthorizers()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isCertPathBuilderSet()){
          buf.append("CertPathBuilder");
          buf.append(String.valueOf(bean.getCertPathBuilder()));
        }
        if (bean.isCertPathProviderTypesSet()){
          buf.append("CertPathProviderTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getCertPathProviderTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getCertPathProviders().length; i++){
          childValue ^= computeChildHashValue(bean.getCertPathProviders()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isCompatibilityObjectNameSet()){
          buf.append("CompatibilityObjectName");
          buf.append(String.valueOf(bean.getCompatibilityObjectName()));
        }
        if (bean.isCredentialMapperTypesSet()){
          buf.append("CredentialMapperTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getCredentialMapperTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getCredentialMappers().length; i++){
          childValue ^= computeChildHashValue(bean.getCredentialMappers()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isDeployableProviderSynchronizationTimeoutSet()){
          buf.append("DeployableProviderSynchronizationTimeout");
          buf.append(String.valueOf(bean.getDeployableProviderSynchronizationTimeout()));
        }
        if (bean.isManagementIdentityDomainSet()){
          buf.append("ManagementIdentityDomain");
          buf.append(String.valueOf(bean.getManagementIdentityDomain()));
        }
        if (bean.isMaxWebLogicPrincipalsInCacheSet()){
          buf.append("MaxWebLogicPrincipalsInCache");
          buf.append(String.valueOf(bean.getMaxWebLogicPrincipalsInCache()));
        }
        if (bean.isNameSet()){
          buf.append("Name");
          buf.append(String.valueOf(bean.getName()));
        }
        if (bean.isPasswordValidatorTypesSet()){
          buf.append("PasswordValidatorTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getPasswordValidatorTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getPasswordValidators().length; i++){
          childValue ^= computeChildHashValue(bean.getPasswordValidators()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        childValue = computeChildHashValue(bean.getRDBMSSecurityStore());
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isRetireTimeoutSecondsSet()){
          buf.append("RetireTimeoutSeconds");
          buf.append(String.valueOf(bean.getRetireTimeoutSeconds()));
        }
        if (bean.isRoleMapperTypesSet()){
          buf.append("RoleMapperTypes");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getRoleMapperTypes())));
        }
        childValue = 0;
        for (int i = 0 ; i < bean.getRoleMappers().length; i++){
          childValue ^= computeChildHashValue(bean.getRoleMappers()[i]);
        }
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isSecurityDDModelSet()){
          buf.append("SecurityDDModel");
          buf.append(String.valueOf(bean.getSecurityDDModel()));
        }
        childValue = computeChildHashValue(bean.getUserLockoutManager());
        if (childValue != 0) {
          buf.append(String.valueOf(childValue));
        }
        if (bean.isAutoRestartOnNonDynamicChangesSet()){
          buf.append("AutoRestartOnNonDynamicChanges");
          buf.append(String.valueOf(bean.isAutoRestartOnNonDynamicChanges()));
        }
        if (bean.isCombinedRoleMappingEnabledSet()){
          buf.append("CombinedRoleMappingEnabled");
          buf.append(String.valueOf(bean.isCombinedRoleMappingEnabled()));
        }
        if (bean.isDefaultRealmSet()){
          buf.append("DefaultRealm");
          buf.append(String.valueOf(bean.isDefaultRealm()));
        }
        if (bean.isDelegateMBeanAuthorizationSet()){
          buf.append("DelegateMBeanAuthorization");
          buf.append(String.valueOf(bean.isDelegateMBeanAuthorization()));
        }
        if (bean.isDeployCredentialMappingIgnoredSet()){
          buf.append("DeployCredentialMappingIgnored");
          buf.append(String.valueOf(bean.isDeployCredentialMappingIgnored()));
        }
        if (bean.isDeployPolicyIgnoredSet()){
          buf.append("DeployPolicyIgnored");
          buf.append(String.valueOf(bean.isDeployPolicyIgnored()));
        }
        if (bean.isDeployRoleIgnoredSet()){
          buf.append("DeployRoleIgnored");
          buf.append(String.valueOf(bean.isDeployRoleIgnored()));
        }
        if (bean.isDeployableProviderSynchronizationEnabledSet()){
          buf.append("DeployableProviderSynchronizationEnabled");
          buf.append(String.valueOf(bean.isDeployableProviderSynchronizationEnabled()));
        }
        if (bean.isEnableWebLogicPrincipalValidatorCacheSet()){
          buf.append("EnableWebLogicPrincipalValidatorCache");
          buf.append(String.valueOf(bean.isEnableWebLogicPrincipalValidatorCache()));
        }
        if (bean.isFullyDelegateAuthorizationSet()){
          buf.append("FullyDelegateAuthorization");
          buf.append(String.valueOf(bean.isFullyDelegateAuthorization()));
        }
        if (bean.isValidateDDSecurityDataSet()){
          buf.append("ValidateDDSecurityData");
          buf.append(String.valueOf(bean.isValidateDDSecurityData()));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      RealmMBeanImpl otherTyped = (RealmMBeanImpl)other;
            computeChildDiff("Adjudicator", bean.getAdjudicator(), otherTyped.getAdjudicator(), false);
            computeChildDiff("Auditors", bean.getAuditors(), otherTyped.getAuditors(), false, true);
      computeDiff("AuthMethods", bean.getAuthMethods(), otherTyped.getAuthMethods(), false);
            computeChildDiff("AuthenticationProviders", bean.getAuthenticationProviders(), otherTyped.getAuthenticationProviders(), false, true);
            computeChildDiff("Authorizers", bean.getAuthorizers(), otherTyped.getAuthorizers(), false, true);
      computeDiff("CertPathBuilder", bean.getCertPathBuilder(), otherTyped.getCertPathBuilder(), false);
            computeChildDiff("CertPathProviders", bean.getCertPathProviders(), otherTyped.getCertPathProviders(), false, true);
      computeDiff("CompatibilityObjectName", bean.getCompatibilityObjectName(), otherTyped.getCompatibilityObjectName(), false);
            computeChildDiff("CredentialMappers", bean.getCredentialMappers(), otherTyped.getCredentialMappers(), false, true);
      computeDiff("DeployableProviderSynchronizationTimeout", bean.getDeployableProviderSynchronizationTimeout(), otherTyped.getDeployableProviderSynchronizationTimeout(), false);
      computeDiff("ManagementIdentityDomain", bean.getManagementIdentityDomain(), otherTyped.getManagementIdentityDomain(), false);
      computeDiff("MaxWebLogicPrincipalsInCache", bean.getMaxWebLogicPrincipalsInCache(), otherTyped.getMaxWebLogicPrincipalsInCache(), false);
      computeDiff("Name", bean.getName(), otherTyped.getName(), false);
            computeChildDiff("PasswordValidators", bean.getPasswordValidators(), otherTyped.getPasswordValidators(), false, true);
            computeChildDiff("RDBMSSecurityStore", bean.getRDBMSSecurityStore(), otherTyped.getRDBMSSecurityStore(), false);
      computeDiff("RetireTimeoutSeconds", bean.getRetireTimeoutSeconds(), otherTyped.getRetireTimeoutSeconds(), true);
            computeChildDiff("RoleMappers", bean.getRoleMappers(), otherTyped.getRoleMappers(), false, true);
      computeDiff("SecurityDDModel", bean.getSecurityDDModel(), otherTyped.getSecurityDDModel(), true);
      computeSubDiff("UserLockoutManager", bean.getUserLockoutManager(), otherTyped.getUserLockoutManager());
      computeDiff("AutoRestartOnNonDynamicChanges", bean.isAutoRestartOnNonDynamicChanges(), otherTyped.isAutoRestartOnNonDynamicChanges(), true);
      computeDiff("CombinedRoleMappingEnabled", bean.isCombinedRoleMappingEnabled(), otherTyped.isCombinedRoleMappingEnabled(), true);
      computeDiff("DelegateMBeanAuthorization", bean.isDelegateMBeanAuthorization(), otherTyped.isDelegateMBeanAuthorization(), false);
      computeDiff("DeployCredentialMappingIgnored", bean.isDeployCredentialMappingIgnored(), otherTyped.isDeployCredentialMappingIgnored(), true);
      computeDiff("DeployPolicyIgnored", bean.isDeployPolicyIgnored(), otherTyped.isDeployPolicyIgnored(), true);
      computeDiff("DeployRoleIgnored", bean.isDeployRoleIgnored(), otherTyped.isDeployRoleIgnored(), true);
      computeDiff("DeployableProviderSynchronizationEnabled", bean.isDeployableProviderSynchronizationEnabled(), otherTyped.isDeployableProviderSynchronizationEnabled(), false);
      computeDiff("EnableWebLogicPrincipalValidatorCache", bean.isEnableWebLogicPrincipalValidatorCache(), otherTyped.isEnableWebLogicPrincipalValidatorCache(), false);
      computeDiff("FullyDelegateAuthorization", bean.isFullyDelegateAuthorization(), otherTyped.isFullyDelegateAuthorization(), false);
      computeDiff("ValidateDDSecurityData", bean.isValidateDDSecurityData(), otherTyped.isValidateDDSecurityData(), true);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        RealmMBeanImpl original = (RealmMBeanImpl)event.getSourceBean();
        RealmMBeanImpl proposed = (RealmMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("Adjudicator")) {
          if (type == PropertyUpdate.ADD) {
            original.setAdjudicator((weblogic.management.security.authorization.AdjudicatorMBean)
              createCopy((AbstractDescriptorBean)proposed.getAdjudicator())
            );
          } else if (type == PropertyUpdate.REMOVE) {
            original._destroySingleton("Adjudicator", (DescriptorBean)original.getAdjudicator());
          } else {
            throw new AssertionError("Invalid type: " + type);
          }
          original._conditionalUnset(update.isUnsetUpdate(), 10);
        } else
        if (prop.equals("AdjudicatorTypes")) {
        } else
        if (prop.equals("AuditorTypes")) {
        } else
        if (prop.equals("Auditors")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addAuditor((weblogic.management.security.audit.AuditorMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getAuditors(), proposed.getAuditors());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removeAuditor((weblogic.management.security.audit.AuditorMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getAuditors(), proposed.getAuditors());
          }
          if (original.getAuditors() == null || original.getAuditors().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 2);
          }
        } else
        if (prop.equals("AuthMethods")) {
          original.setAuthMethods(proposed.getAuthMethods());
          original._conditionalUnset(update.isUnsetUpdate(), 30);
        } else
        if (prop.equals("AuthenticationProviderTypes")) {
        } else
        if (prop.equals("AuthenticationProviders")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addAuthenticationProvider((weblogic.management.security.authentication.AuthenticationProviderMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getAuthenticationProviders(), proposed.getAuthenticationProviders());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removeAuthenticationProvider((weblogic.management.security.authentication.AuthenticationProviderMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getAuthenticationProviders(), proposed.getAuthenticationProviders());
          }
          if (original.getAuthenticationProviders() == null || original.getAuthenticationProviders().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 4);
          }
        } else
        if (prop.equals("AuthorizerTypes")) {
        } else
        if (prop.equals("Authorizers")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addAuthorizer((weblogic.management.security.authorization.AuthorizerMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getAuthorizers(), proposed.getAuthorizers());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removeAuthorizer((weblogic.management.security.authorization.AuthorizerMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getAuthorizers(), proposed.getAuthorizers());
          }
          if (original.getAuthorizers() == null || original.getAuthorizers().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 8);
          }
        } else
        if (prop.equals("CertPathBuilder")) {
          original.setCertPathBuilderAsString(proposed.getCertPathBuilderAsString());
          original._conditionalUnset(update.isUnsetUpdate(), 16);
        } else
        if (prop.equals("CertPathProviderTypes")) {
        } else
        if (prop.equals("CertPathProviders")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addCertPathProvider((weblogic.management.security.pk.CertPathProviderMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getCertPathProviders(), proposed.getCertPathProviders());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removeCertPathProvider((weblogic.management.security.pk.CertPathProviderMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getCertPathProviders(), proposed.getCertPathProviders());
          }
          if (original.getCertPathProviders() == null || original.getCertPathProviders().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 14);
          }
        } else
        if (prop.equals("CompatibilityObjectName")) {
          original._conditionalUnset(update.isUnsetUpdate(), 31);
        } else
        if (prop.equals("CredentialMapperTypes")) {
        } else
        if (prop.equals("CredentialMappers")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addCredentialMapper((weblogic.management.security.credentials.CredentialMapperMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getCredentialMappers(), proposed.getCredentialMappers());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removeCredentialMapper((weblogic.management.security.credentials.CredentialMapperMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getCredentialMappers(), proposed.getCredentialMappers());
          }
          if (original.getCredentialMappers() == null || original.getCredentialMappers().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 12);
          }
        } else
        if (prop.equals("DeployableProviderSynchronizationTimeout")) {
          original.setDeployableProviderSynchronizationTimeout(proposed.getDeployableProviderSynchronizationTimeout());
          original._conditionalUnset(update.isUnsetUpdate(), 36);
        } else
        if (prop.equals("ManagementIdentityDomain")) {
          original.setManagementIdentityDomain(proposed.getManagementIdentityDomain());
          original._conditionalUnset(update.isUnsetUpdate(), 39);
        } else
        if (prop.equals("MaxWebLogicPrincipalsInCache")) {
          original.setMaxWebLogicPrincipalsInCache(proposed.getMaxWebLogicPrincipalsInCache());
          original._conditionalUnset(update.isUnsetUpdate(), 27);
        } else
        if (prop.equals("Name")) {
          original.setName(proposed.getName());
          original._conditionalUnset(update.isUnsetUpdate(), 28);
        } else
        if (prop.equals("PasswordValidatorTypes")) {
        } else
        if (prop.equals("PasswordValidators")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addPasswordValidator((weblogic.management.security.authentication.PasswordValidatorMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getPasswordValidators(), proposed.getPasswordValidators());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removePasswordValidator((weblogic.management.security.authentication.PasswordValidatorMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getPasswordValidators(), proposed.getPasswordValidators());
          }
          if (original.getPasswordValidators() == null || original.getPasswordValidators().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 34);
          }
        } else
        if (prop.equals("RDBMSSecurityStore")) {
          if (type == PropertyUpdate.ADD) {
            original.setRDBMSSecurityStore((RDBMSSecurityStoreMBean)
              createCopy((AbstractDescriptorBean)proposed.getRDBMSSecurityStore())
            );
          } else if (type == PropertyUpdate.REMOVE) {
            original._destroySingleton("RDBMSSecurityStore", (DescriptorBean)original.getRDBMSSecurityStore());
          } else {
            throw new AssertionError("Invalid type: " + type);
          }
          original._conditionalUnset(update.isUnsetUpdate(), 32);
        } else
        if (prop.equals("RetireTimeoutSeconds")) {
          original.setRetireTimeoutSeconds(proposed.getRetireTimeoutSeconds());
          original._conditionalUnset(update.isUnsetUpdate(), 38);
        } else
        if (prop.equals("RoleMapperTypes")) {
        } else
        if (prop.equals("RoleMappers")) {
          if (type == PropertyUpdate.ADD) {
            if (!((AbstractDescriptorBean)update.getAddedObject())._isSynthetic()) {
              update.resetAddedObject(createCopy((AbstractDescriptorBean)update.getAddedObject()));
              original.addRoleMapper((weblogic.management.security.authorization.RoleMapperMBean)update.getAddedObject());
            }
            reorderArrayObjects(original.getRoleMappers(), proposed.getRoleMappers());
          } else if (type == PropertyUpdate.REMOVE) {
            original.removeRoleMapper((weblogic.management.security.authorization.RoleMapperMBean)update.getRemovedObject());
          } else {
            reorderArrayObjects(original.getRoleMappers(), proposed.getRoleMappers());
          }
          if (original.getRoleMappers() == null || original.getRoleMappers().length == 0) {
            original._conditionalUnset(update.isUnsetUpdate(), 6);
          }
        } else
        if (prop.equals("SecurityDDModel")) {
          original.setSecurityDDModel(proposed.getSecurityDDModel());
          original._conditionalUnset(update.isUnsetUpdate(), 23);
        } else
        if (prop.equals("UserLockoutManager")) {
          if (type == PropertyUpdate.ADD) {
            original.setUserLockoutManager((weblogic.management.security.authentication.UserLockoutManagerMBean)
              createCopy((AbstractDescriptorBean)proposed.getUserLockoutManager())
            );
          } else if (type == PropertyUpdate.REMOVE) {
            original._destroySingleton("UserLockoutManager", (DescriptorBean)original.getUserLockoutManager());
          } else {
            throw new AssertionError("Invalid type: " + type);
          }
          original._conditionalUnset(update.isUnsetUpdate(), 17);
        } else
        if (prop.equals("AutoRestartOnNonDynamicChanges")) {
          original.setAutoRestartOnNonDynamicChanges(proposed.isAutoRestartOnNonDynamicChanges());
          original._conditionalUnset(update.isUnsetUpdate(), 37);
        } else
        if (prop.equals("CombinedRoleMappingEnabled")) {
          original.setCombinedRoleMappingEnabled(proposed.isCombinedRoleMappingEnabled());
          original._conditionalUnset(update.isUnsetUpdate(), 24);
        } else
        if (prop.equals("DefaultRealm")) {
        } else
        if (prop.equals("DelegateMBeanAuthorization")) {
          original.setDelegateMBeanAuthorization(proposed.isDelegateMBeanAuthorization());
          original._conditionalUnset(update.isUnsetUpdate(), 29);
        } else
        if (prop.equals("DeployCredentialMappingIgnored")) {
          original.setDeployCredentialMappingIgnored(proposed.isDeployCredentialMappingIgnored());
          original._conditionalUnset(update.isUnsetUpdate(), 20);
        } else
        if (prop.equals("DeployPolicyIgnored")) {
          original.setDeployPolicyIgnored(proposed.isDeployPolicyIgnored());
          original._conditionalUnset(update.isUnsetUpdate(), 19);
        } else
        if (prop.equals("DeployRoleIgnored")) {
          original.setDeployRoleIgnored(proposed.isDeployRoleIgnored());
          original._conditionalUnset(update.isUnsetUpdate(), 18);
        } else
        if (prop.equals("DeployableProviderSynchronizationEnabled")) {
          original.setDeployableProviderSynchronizationEnabled(proposed.isDeployableProviderSynchronizationEnabled());
          original._conditionalUnset(update.isUnsetUpdate(), 35);
        } else
        if (prop.equals("EnableWebLogicPrincipalValidatorCache")) {
          original.setEnableWebLogicPrincipalValidatorCache(proposed.isEnableWebLogicPrincipalValidatorCache());
          original._conditionalUnset(update.isUnsetUpdate(), 26);
        } else
        if (prop.equals("FullyDelegateAuthorization")) {
          original.setFullyDelegateAuthorization(proposed.isFullyDelegateAuthorization());
          original._conditionalUnset(update.isUnsetUpdate(), 21);
        } else
        if (prop.equals("ValidateDDSecurityData")) {
          original.setValidateDDSecurityData(proposed.isValidateDDSecurityData());
          original._conditionalUnset(update.isUnsetUpdate(), 22);
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        RealmMBeanImpl copy = (RealmMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("Adjudicator")) && bean.isAdjudicatorSet()) {
          if (!copy._isSet(10)) {
            o = bean.getAdjudicator();
            copy.setAdjudicator(null); // required to avoid BeanAlreadyExistsEx
            copy.setAdjudicator((o == null) ? null : (weblogic.management.security.authorization.AdjudicatorMBean)createCopy((AbstractDescriptorBean)o, includeObsolete));
          }
        }
        if ((excludeProps == null || !excludeProps.contains("Auditors")) && bean.isAuditorsSet()) {
          if (!copy._isSet(2)) {
            weblogic.management.security.audit.AuditorMBean[] oldAuditors = bean.getAuditors();
            weblogic.management.security.audit.AuditorMBean[] newAuditors = new weblogic.management.security.audit.AuditorMBean[oldAuditors.length];
            for (int i = 0; i < newAuditors.length; i++) {
              newAuditors[i] = (weblogic.management.security.audit.AuditorMBean)(createCopy((AbstractDescriptorBean)oldAuditors[i], includeObsolete));
            }
            copy.setAuditors(newAuditors);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("AuthMethods")) && bean.isAuthMethodsSet()) {
          copy.setAuthMethods((String)bean.getAuthMethods());
        }
        if ((excludeProps == null || !excludeProps.contains("AuthenticationProviders")) && bean.isAuthenticationProvidersSet()) {
          if (!copy._isSet(4)) {
            weblogic.management.security.authentication.AuthenticationProviderMBean[] oldAuthenticationProviders = bean.getAuthenticationProviders();
            weblogic.management.security.authentication.AuthenticationProviderMBean[] newAuthenticationProviders = new weblogic.management.security.authentication.AuthenticationProviderMBean[oldAuthenticationProviders.length];
            for (int i = 0; i < newAuthenticationProviders.length; i++) {
              newAuthenticationProviders[i] = (weblogic.management.security.authentication.AuthenticationProviderMBean)(createCopy((AbstractDescriptorBean)oldAuthenticationProviders[i], includeObsolete));
            }
            copy.setAuthenticationProviders(newAuthenticationProviders);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("Authorizers")) && bean.isAuthorizersSet()) {
          if (!copy._isSet(8)) {
            weblogic.management.security.authorization.AuthorizerMBean[] oldAuthorizers = bean.getAuthorizers();
            weblogic.management.security.authorization.AuthorizerMBean[] newAuthorizers = new weblogic.management.security.authorization.AuthorizerMBean[oldAuthorizers.length];
            for (int i = 0; i < newAuthorizers.length; i++) {
              newAuthorizers[i] = (weblogic.management.security.authorization.AuthorizerMBean)(createCopy((AbstractDescriptorBean)oldAuthorizers[i], includeObsolete));
            }
            copy.setAuthorizers(newAuthorizers);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("CertPathBuilder")) && bean.isCertPathBuilderSet()) {
          copy._unSet(copy, 16);
          copy.setCertPathBuilderAsString(bean.getCertPathBuilderAsString());
        }
        if ((excludeProps == null || !excludeProps.contains("CertPathProviders")) && bean.isCertPathProvidersSet()) {
          if (!copy._isSet(14)) {
            weblogic.management.security.pk.CertPathProviderMBean[] oldCertPathProviders = bean.getCertPathProviders();
            weblogic.management.security.pk.CertPathProviderMBean[] newCertPathProviders = new weblogic.management.security.pk.CertPathProviderMBean[oldCertPathProviders.length];
            for (int i = 0; i < newCertPathProviders.length; i++) {
              newCertPathProviders[i] = (weblogic.management.security.pk.CertPathProviderMBean)(createCopy((AbstractDescriptorBean)oldCertPathProviders[i], includeObsolete));
            }
            copy.setCertPathProviders(newCertPathProviders);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("CompatibilityObjectName")) && bean.isCompatibilityObjectNameSet()) {
        }
        if ((excludeProps == null || !excludeProps.contains("CredentialMappers")) && bean.isCredentialMappersSet()) {
          if (!copy._isSet(12)) {
            weblogic.management.security.credentials.CredentialMapperMBean[] oldCredentialMappers = bean.getCredentialMappers();
            weblogic.management.security.credentials.CredentialMapperMBean[] newCredentialMappers = new weblogic.management.security.credentials.CredentialMapperMBean[oldCredentialMappers.length];
            for (int i = 0; i < newCredentialMappers.length; i++) {
              newCredentialMappers[i] = (weblogic.management.security.credentials.CredentialMapperMBean)(createCopy((AbstractDescriptorBean)oldCredentialMappers[i], includeObsolete));
            }
            copy.setCredentialMappers(newCredentialMappers);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("DeployableProviderSynchronizationTimeout")) && bean.isDeployableProviderSynchronizationTimeoutSet()) {
          copy.setDeployableProviderSynchronizationTimeout((Integer)bean.getDeployableProviderSynchronizationTimeout());
        }
        if ((excludeProps == null || !excludeProps.contains("ManagementIdentityDomain")) && bean.isManagementIdentityDomainSet()) {
          copy.setManagementIdentityDomain((String)bean.getManagementIdentityDomain());
        }
        if ((excludeProps == null || !excludeProps.contains("MaxWebLogicPrincipalsInCache")) && bean.isMaxWebLogicPrincipalsInCacheSet()) {
          copy.setMaxWebLogicPrincipalsInCache((Integer)bean.getMaxWebLogicPrincipalsInCache());
        }
        if ((excludeProps == null || !excludeProps.contains("Name")) && bean.isNameSet()) {
          copy.setName((String)bean.getName());
        }
        if ((excludeProps == null || !excludeProps.contains("PasswordValidators")) && bean.isPasswordValidatorsSet()) {
          if (!copy._isSet(34)) {
            weblogic.management.security.authentication.PasswordValidatorMBean[] oldPasswordValidators = bean.getPasswordValidators();
            weblogic.management.security.authentication.PasswordValidatorMBean[] newPasswordValidators = new weblogic.management.security.authentication.PasswordValidatorMBean[oldPasswordValidators.length];
            for (int i = 0; i < newPasswordValidators.length; i++) {
              newPasswordValidators[i] = (weblogic.management.security.authentication.PasswordValidatorMBean)(createCopy((AbstractDescriptorBean)oldPasswordValidators[i], includeObsolete));
            }
            copy.setPasswordValidators(newPasswordValidators);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("RDBMSSecurityStore")) && bean.isRDBMSSecurityStoreSet()) {
          if (!copy._isSet(32)) {
            o = bean.getRDBMSSecurityStore();
            copy.setRDBMSSecurityStore(null); // required to avoid BeanAlreadyExistsEx
            copy.setRDBMSSecurityStore((o == null) ? null : (RDBMSSecurityStoreMBean)createCopy((AbstractDescriptorBean)o, includeObsolete));
          }
        }
        if ((excludeProps == null || !excludeProps.contains("RetireTimeoutSeconds")) && bean.isRetireTimeoutSecondsSet()) {
          copy.setRetireTimeoutSeconds((int)bean.getRetireTimeoutSeconds());
        }
        if ((excludeProps == null || !excludeProps.contains("RoleMappers")) && bean.isRoleMappersSet()) {
          if (!copy._isSet(6)) {
            weblogic.management.security.authorization.RoleMapperMBean[] oldRoleMappers = bean.getRoleMappers();
            weblogic.management.security.authorization.RoleMapperMBean[] newRoleMappers = new weblogic.management.security.authorization.RoleMapperMBean[oldRoleMappers.length];
            for (int i = 0; i < newRoleMappers.length; i++) {
              newRoleMappers[i] = (weblogic.management.security.authorization.RoleMapperMBean)(createCopy((AbstractDescriptorBean)oldRoleMappers[i], includeObsolete));
            }
            copy.setRoleMappers(newRoleMappers);
          }
        }
        if ((excludeProps == null || !excludeProps.contains("SecurityDDModel")) && bean.isSecurityDDModelSet()) {
          copy.setSecurityDDModel((String)bean.getSecurityDDModel());
        }
        if ((excludeProps == null || !excludeProps.contains("UserLockoutManager")) && bean.isUserLockoutManagerSet()) {
          if (!copy._isSet(17)) {
            o = bean.getUserLockoutManager();
            copy.setUserLockoutManager(null); // required to avoid BeanAlreadyExistsEx
            copy.setUserLockoutManager((o == null) ? null : (weblogic.management.security.authentication.UserLockoutManagerMBean)createCopy((AbstractDescriptorBean)o, includeObsolete));
          }
        }
        if ((excludeProps == null || !excludeProps.contains("AutoRestartOnNonDynamicChanges")) && bean.isAutoRestartOnNonDynamicChangesSet()) {
          copy.setAutoRestartOnNonDynamicChanges((boolean)bean.isAutoRestartOnNonDynamicChanges());
        }
        if ((excludeProps == null || !excludeProps.contains("CombinedRoleMappingEnabled")) && bean.isCombinedRoleMappingEnabledSet()) {
          copy.setCombinedRoleMappingEnabled((boolean)bean.isCombinedRoleMappingEnabled());
        }
        if ((excludeProps == null || !excludeProps.contains("DelegateMBeanAuthorization")) && bean.isDelegateMBeanAuthorizationSet()) {
          copy.setDelegateMBeanAuthorization((boolean)bean.isDelegateMBeanAuthorization());
        }
        if ((excludeProps == null || !excludeProps.contains("DeployCredentialMappingIgnored")) && bean.isDeployCredentialMappingIgnoredSet()) {
          copy.setDeployCredentialMappingIgnored((boolean)bean.isDeployCredentialMappingIgnored());
        }
        if ((excludeProps == null || !excludeProps.contains("DeployPolicyIgnored")) && bean.isDeployPolicyIgnoredSet()) {
          copy.setDeployPolicyIgnored((boolean)bean.isDeployPolicyIgnored());
        }
        if ((excludeProps == null || !excludeProps.contains("DeployRoleIgnored")) && bean.isDeployRoleIgnoredSet()) {
          copy.setDeployRoleIgnored((boolean)bean.isDeployRoleIgnored());
        }
        if ((excludeProps == null || !excludeProps.contains("DeployableProviderSynchronizationEnabled")) && bean.isDeployableProviderSynchronizationEnabledSet()) {
          copy.setDeployableProviderSynchronizationEnabled((boolean)bean.isDeployableProviderSynchronizationEnabled());
        }
        if ((excludeProps == null || !excludeProps.contains("EnableWebLogicPrincipalValidatorCache")) && bean.isEnableWebLogicPrincipalValidatorCacheSet()) {
          copy.setEnableWebLogicPrincipalValidatorCache((boolean)bean.isEnableWebLogicPrincipalValidatorCache());
        }
        if ((excludeProps == null || !excludeProps.contains("FullyDelegateAuthorization")) && bean.isFullyDelegateAuthorizationSet()) {
          copy.setFullyDelegateAuthorization((boolean)bean.isFullyDelegateAuthorization());
        }
        if ((excludeProps == null || !excludeProps.contains("ValidateDDSecurityData")) && bean.isValidateDDSecurityDataSet()) {
          copy.setValidateDDSecurityData((boolean)bean.isValidateDDSecurityData());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
 		inferSubTree(bean.getAdjudicator(), clazz, annotation);
         		inferSubTree(bean.getAuditors(), clazz, annotation);
         		inferSubTree(bean.getAuthenticationProviders(), clazz, annotation);
      		inferSubTree(bean.getAuthorizers(), clazz, annotation);
   		inferSubTree(bean.getCertPathBuilder(), clazz, annotation);
      		inferSubTree(bean.getCertPathProviders(), clazz, annotation);
         		inferSubTree(bean.getCredentialMappers(), clazz, annotation);
                  		inferSubTree(bean.getPasswordValidators(), clazz, annotation);
   		inferSubTree(bean.getRDBMSSecurityStore(), clazz, annotation);
         		inferSubTree(bean.getRoleMappers(), clazz, annotation);
      		inferSubTree(bean.getUserLockoutManager(), clazz, annotation);
                                        }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 11:
        if (false) return -1;
        else if (s.equals("adjudicator"))
          return 10;
        else if (s.equals("role-mapper"))
          return 6;
        break;
      case 16:
        if (false) return -1;
        else if (s.equals("adjudicator-type"))
          return 11;
        else if (s.equals("role-mapper-type"))
          return 7;
        else if (s.equals("securitydd-model"))
          return 23;
        break;
      case 12:
        if (false) return -1;
        else if (s.equals("auditor-type"))
          return 3;
        else if (s.equals("auth-methods"))
          return 30;
        break;
      case 7:
        if (false) return -1;
        else if (s.equals("auditor"))
          return 2;
        break;
      case 28:
        if (false) return -1;
        else if (s.equals("authentication-provider-type"))
          return 5;
        else if (s.equals("delegatem-bean-authorization"))
          return 29;
        else if (s.equals("fully-delegate-authorization"))
          return 21;
        break;
      case 23:
        if (false) return -1;
        else if (s.equals("authentication-provider"))
          return 4;
        else if (s.equals("cert-path-provider-type"))
          return 15;
        else if (s.equals("password-validator-type"))
          return 33;
        break;
      case 15:
        if (false) return -1;
        else if (s.equals("authorizer-type"))
          return 9;
        break;
      case 10:
        if (false) return -1;
        else if (s.equals("authorizer"))
          return 8;
        break;
      case 17:
        if (false) return -1;
        else if (s.equals("cert-path-builder"))
          return 16;
        else if (s.equals("credential-mapper"))
          return 12;
        break;
      case 18:
        if (false) return -1;
        else if (s.equals("cert-path-provider"))
          return 14;
        else if (s.equals("password-validator"))
          return 34;
        break;
      case 25:
        if (false) return -1;
        else if (s.equals("compatibility-object-name"))
          return 31;
        break;
      case 22:
        if (false) return -1;
        else if (s.equals("credential-mapper-type"))
          return 13;
        else if (s.equals("retire-timeout-seconds"))
          return 38;
        break;
      case 43:
        if (false) return -1;
        else if (s.equals("deployable-provider-synchronization-timeout"))
          return 36;
        else if (s.equals("deployable-provider-synchronization-enabled"))
          return 35;
        break;
      case 26:
        if (false) return -1;
        else if (s.equals("management-identity-domain"))
          return 39;
        break;
      case 33:
        if (false) return -1;
        else if (s.equals("max-web-logic-principals-in-cache"))
          return 27;
        else if (s.equals("deploy-credential-mapping-ignored"))
          return 20;
        break;
      case 4:
        if (false) return -1;
        else if (s.equals("name"))
          return 28;
        break;
      case 20:
        if (false) return -1;
        else if (s.equals("rdbms-security-store"))
          return 32;
        else if (s.equals("user-lockout-manager"))
          return 17;
        break;
      case 35:
        if (false) return -1;
        else if (s.equals("auto-restart-on-non-dynamic-changes"))
          return 37;
        break;
      case 29:
        if (false) return -1;
        else if (s.equals("combined-role-mapping-enabled"))
          return 24;
        break;
      case 13:
        if (false) return -1;
        else if (s.equals("default-realm"))
          return 25;
        break;
      case 21:
        if (false) return -1;
        else if (s.equals("deploy-policy-ignored"))
          return 19;
        break;
      case 19:
        if (false) return -1;
        else if (s.equals("deploy-role-ignored"))
          return 18;
        break;
      case 42:
        if (false) return -1;
        else if (s.equals("enable-web-logic-principal-validator-cache"))
          return 26;
        break;
      case 24:
        if (false) return -1;
        else if (s.equals("validatedd-security-data"))
          return 22;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      case 10:
        return new weblogic.management.security.authorization.AdjudicatorMBeanImpl.SchemaHelper2();
      case 2:
        return new weblogic.management.security.audit.AuditorMBeanImpl.SchemaHelper2();
      case 4:
        return new weblogic.management.security.authentication.AuthenticationProviderMBeanImpl.SchemaHelper2();
      case 8:
        return new weblogic.management.security.authorization.AuthorizerMBeanImpl.SchemaHelper2();
      case 14:
        return new weblogic.management.security.pk.CertPathProviderMBeanImpl.SchemaHelper2();
      case 12:
        return new weblogic.management.security.credentials.CredentialMapperMBeanImpl.SchemaHelper2();
      case 34:
        return new weblogic.management.security.authentication.PasswordValidatorMBeanImpl.SchemaHelper2();
      case 32:
        return new RDBMSSecurityStoreMBeanImpl.SchemaHelper2();
      case 6:
        return new weblogic.management.security.authorization.RoleMapperMBeanImpl.SchemaHelper2();
      case 17:
        return new weblogic.management.security.authentication.UserLockoutManagerMBeanImpl.SchemaHelper2();
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 10: return "adjudicator";
        case 11: return "adjudicator-type";
        case 3: return "auditor-type";
        case 2: return "auditor";
        case 30: return "auth-methods";
        case 5: return "authentication-provider-type";
        case 4: return "authentication-provider";
        case 9: return "authorizer-type";
        case 8: return "authorizer";
        case 16: return "cert-path-builder";
        case 15: return "cert-path-provider-type";
        case 14: return "cert-path-provider";
        case 31: return "compatibility-object-name";
        case 13: return "credential-mapper-type";
        case 12: return "credential-mapper";
        case 36: return "deployable-provider-synchronization-timeout";
        case 39: return "management-identity-domain";
        case 27: return "max-web-logic-principals-in-cache";
        case 28: return "name";
        case 33: return "password-validator-type";
        case 34: return "password-validator";
        case 32: return "rdbms-security-store";
        case 38: return "retire-timeout-seconds";
        case 7: return "role-mapper-type";
        case 6: return "role-mapper";
        case 23: return "securitydd-model";
        case 17: return "user-lockout-manager";
        case 37: return "auto-restart-on-non-dynamic-changes";
        case 24: return "combined-role-mapping-enabled";
        case 25: return "default-realm";
        case 29: return "delegatem-bean-authorization";
        case 20: return "deploy-credential-mapping-ignored";
        case 19: return "deploy-policy-ignored";
        case 18: return "deploy-role-ignored";
        case 35: return "deployable-provider-synchronization-enabled";
        case 26: return "enable-web-logic-principal-validator-cache";
        case 21: return "fully-delegate-authorization";
        case 22: return "validatedd-security-data";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      case 11:
        return true;
      case 3:
        return true;
      case 2:
        return true;
      case 5:
        return true;
      case 4:
        return true;
      case 9:
        return true;
      case 8:
        return true;
      case 15:
        return true;
      case 14:
        return true;
      case 13:
        return true;
      case 12:
        return true;
      case 33:
        return true;
      case 34:
        return true;
      case 7:
        return true;
      case 6:
        return true;
      default:
        return super.isArray(propIndex);
      }
    }




    public boolean isBean(int propIndex) {
      switch(propIndex) {
      case 10:
        return true;
      case 2:
        return true;
      case 4:
        return true;
      case 8:
        return true;
      case 14:
        return true;
      case 12:
        return true;
      case 34:
        return true;
      case 32:
        return true;
      case 6:
        return true;
      case 17:
        return true;
      default:
        return super.isBean(propIndex);
      }
    }










  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.RealmMBean"; 
  }

}
