




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security.audit;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import javax.management.InvalidAttributeValueException;


/**
 * Corresponds to ContextHandlerMBean
 * (Interface=weblogic.management.security.audit.ContextHandlerMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * Provides a set of attributes for ContextHandler support.
 An Auditor provider MBean can optionally implement this MBean. The WebLogic
 Server Administration Console detects when an Auditor provider implements this
 MBean and automatically provides a tab for using these attributes.
 *
 * @xsdgen:complexType.typeName context-handlerType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class ContextHandlerMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements ContextHandlerMBean, java.io.Serializable
{
  private String[] _ActiveContextHandlerEntries;
  private String[] _SupportedContextHandlerEntries;
  private transient ContextHandlerImpl _customizer;


  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=ContextHandlerMBeanImpl)
   *
   */
  public ContextHandlerMBeanImpl() {
    super();
    try {
      _customizer = new weblogic.management.security.audit.ContextHandlerImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=ContextHandlerMBeanImpl)
   *
   */
  public ContextHandlerMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    try {
      _customizer = new weblogic.management.security.audit.ContextHandlerImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=ContextHandlerMBeanImpl)
   *
   */
  public ContextHandlerMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    try {
      _customizer = new weblogic.management.security.audit.ContextHandlerImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * Returns the list of all ContextHandler entries supported by the auditor.
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=getSupportedContextHandlerEntries)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getSupportedContextHandlerEntries() {
    return _SupportedContextHandlerEntries;
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=isSupportedContextHandlerEntriesInherited)
   *
   * return true if the value of property SupportedContextHandlerEntries is inherited from template
   */
  public boolean isSupportedContextHandlerEntriesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=isSupportedContextHandlerEntriesSet)
   *
   * @xsdgen:isSetMethodFor supported-context-handler-entry
   */
  public boolean isSupportedContextHandlerEntriesSet() {
    return _isSet(2);
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=setSupportedContextHandlerEntries)
   *
   */
  public void setSupportedContextHandlerEntries(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _SupportedContextHandlerEntries = param0;
  }

  /**
   * Returns the ContextHandler entries that the Audit provider is currently
 configured to process.
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=getActiveContextHandlerEntries)
   *
   * @xsdgen:element.name active-context-handler-entry
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic true
   */
  public String[] getActiveContextHandlerEntries() {
    return _ActiveContextHandlerEntries;
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=isActiveContextHandlerEntriesInherited)
   *
   * return true if the value of property ActiveContextHandlerEntries is inherited from template
   */
  public boolean isActiveContextHandlerEntriesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=isActiveContextHandlerEntriesSet)
   *
   * @xsdgen:isSetMethodFor active-context-handler-entry
   */
  public boolean isActiveContextHandlerEntriesSet() {
    return _isSet(3);
  }

  /**
   * Sets the ContextHandler entries that the Audit provider will process.
 Only entries from the Audit provider's <code>SupportedContextHandlerEntries</code>
 attribute may be specified.
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=setActiveContextHandlerEntries)
   *
   */
  public void setActiveContextHandlerEntries(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    String[] _oldVal = _ActiveContextHandlerEntries;
    _ActiveContextHandlerEntries = param0;
    _postSet(3, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.audit.ContextHandlerMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
    try { if (!(_customizer.validateActiveContextHandlerEntries(getActiveContextHandlerEntries()))) throw new IllegalArgumentException("The ContextHandler ActiveContextHandlerEntries attribute was set to an illegal value."); } catch (javax.management.InvalidAttributeValueException e) { throw new IllegalArgumentException(e.toString()); };
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 3;
    }
    try {
      switch (idx) {
      case 3:
        _ActiveContextHandlerEntries = new String[]{};
        if (initOne) break;
      case 2:
        _SupportedContextHandlerEntries = new String[]{};
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private ContextHandlerMBeanImpl bean;

    protected Helper(ContextHandlerMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 3: return "ActiveContextHandlerEntries";
      case 2: return "SupportedContextHandlerEntries";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("ActiveContextHandlerEntries")) return 3;
      else if (propName.equals("SupportedContextHandlerEntries")) return 2;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isActiveContextHandlerEntriesSet()){
          buf.append("ActiveContextHandlerEntries");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getActiveContextHandlerEntries())));
        }
        if (bean.isSupportedContextHandlerEntriesSet()){
          buf.append("SupportedContextHandlerEntries");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getSupportedContextHandlerEntries())));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      ContextHandlerMBeanImpl otherTyped = (ContextHandlerMBeanImpl)other;
      computeDiff("ActiveContextHandlerEntries", bean.getActiveContextHandlerEntries(), otherTyped.getActiveContextHandlerEntries(), true);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        ContextHandlerMBeanImpl original = (ContextHandlerMBeanImpl)event.getSourceBean();
        ContextHandlerMBeanImpl proposed = (ContextHandlerMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("ActiveContextHandlerEntries")) {
          original.setActiveContextHandlerEntries(proposed.getActiveContextHandlerEntries());
          original._conditionalUnset(update.isUnsetUpdate(), 3);
        } else
        if (prop.equals("SupportedContextHandlerEntries")) {
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        ContextHandlerMBeanImpl copy = (ContextHandlerMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("ActiveContextHandlerEntries")) && bean.isActiveContextHandlerEntriesSet()) {
          o = bean.getActiveContextHandlerEntries();
          copy.setActiveContextHandlerEntries((o == null) ? null : (String[])((String[])o).clone());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
           }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 28:
        if (false) return -1;
        else if (s.equals("active-context-handler-entry"))
          return 3;
        break;
      case 31:
        if (false) return -1;
        else if (s.equals("supported-context-handler-entry"))
          return 2;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 3: return "active-context-handler-entry";
        case 2: return "supported-context-handler-entry";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      case 3:
        return true;
      case 2:
        return true;
      default:
        return super.isArray(propIndex);
      }
    }














  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.audit.ContextHandlerMBean"; 
  }

}
