/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller;

import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.controller.DataEngineSettings;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class AdapEnvironment
implements DataEngineSettings {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public static void initialize() throws Exception {
        AdapEnvironment.initializeBootstrapSettings();
        AdapEnvironment.loadFromConfFile();
        AdapEnvironment.logSettings();
    }

    private static void initializeBootstrapSettings() throws Exception {
        String homeDir = System.getProperty("product.home");
        if (homeDir == null) {
            homeDir = System.getProperty("server.home");
        }
        if (homeDir == null) {
            throw new RuntimeException("product.home or server.home property not set!");
        }
        DE_CTLR_HOME_DIR.set((Object)Paths.get(homeDir, new String[0]));
        DE_CONF_DIR.set((Object)((Path)DE_CTLR_HOME_DIR.value()).resolve("conf").resolve("DataEngine"));
        DE_CONF_FILE_NAME.set(DE_CONF_FILE_NAME.getDefaultValue());
        DE_CONF_FILE.set((Object)((Path)DE_CONF_DIR.value()).resolve((String)DE_CONF_FILE_NAME.value()));
        DE_ENGINES_DIR.set((Object)((Path)DE_CONF_DIR.value()).resolve("engines"));
        DE_XNODE_CONF_DIR.set((Object)((Path)DE_ENGINES_DIR.value()).resolve("xnode"));
        DE_XNODE_CONF_FILE_NAME.set(DE_XNODE_CONF_FILE_NAME.getDefaultValue());
        DE_XNODE_CONF_FILE.set((Object)((Path)DE_XNODE_CONF_DIR.value()).resolve((String)DE_XNODE_CONF_FILE_NAME.value()));
        DE_ELASTIC_CONF_DIR.set((Object)((Path)DE_ENGINES_DIR.value()).resolve("elastic"));
        DE_ELASTIC_CONF_FILE_NAME.set(DE_ELASTIC_CONF_FILE_NAME.getDefaultValue());
        DE_ELASTIC_CONF_FILE.set((Object)((Path)DE_ELASTIC_CONF_DIR.value()).resolve((String)DE_ELASTIC_CONF_FILE_NAME.value()));
        ELASTIC_HOME_DIR.set((Object)((Path)DE_CTLR_HOME_DIR.value()).resolve("apps").resolve("dataengine-elastic"));
        ELASTIC_LIB_DIR.set((Object)((Path)ELASTIC_HOME_DIR.value()).resolve("lib"));
        ELASTIC_BIN_DIR.set((Object)((Path)ELASTIC_HOME_DIR.value()).resolve("bin"));
        ELASTIC_SNAPSHOTS_DIR.set((Object)((Path)ELASTIC_HOME_DIR.value()).resolve("snapshots"));
    }

    private static void loadFromConfFile() throws Exception {
        if (!((Path)DE_CONF_FILE.value()).toFile().exists()) {
            throw new FileNotFoundException("EXCEPTION : " + DE_CONF_FILE.value() + " file not found!");
        }
        PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)DE_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)false);
        String engineType = propFileHandler.getString("de.engine", null);
        if (engineType == null || !engineType.equalsIgnoreCase("xnode") && !engineType.equalsIgnoreCase("elastic")) {
            throw new IllegalArgumentException("EXCEPTION : DataEngine engineType " + engineType + " not supported!");
        }
        DE_ENGINE.set((Object)engineType);
        DE_E_CONF_DIR.set((Object)(((String)DE_ENGINE.value()).equalsIgnoreCase("xnode") ? (Path)DE_XNODE_CONF_DIR.value() : (Path)DE_ELASTIC_CONF_DIR.value()));
        DE_E_CONF_FILE_NAME.set((Object)(((String)DE_ENGINE.value()).equalsIgnoreCase("xnode") ? (String)DE_XNODE_CONF_FILE_NAME.value() : (String)DE_ELASTIC_CONF_FILE_NAME.value()));
        DE_E_CONF_FILE.set((Object)(((String)DE_ENGINE.value()).equalsIgnoreCase("xnode") ? (Path)DE_XNODE_CONF_FILE.value() : (Path)DE_ELASTIC_CONF_FILE.value()));
        DE_E_DR_DIR.set((Object)((Path)DE_E_CONF_DIR.value()).resolve("datarepository"));
        DE_E_DR_SCHEMA_DIR.set((Object)((Path)DE_E_DR_DIR.value()).resolve("schema"));
        DE_E_DR_BLOCK_INFO_DIR.set((Object)((Path)DE_E_DR_DIR.value()).resolve("block-info"));
        DE_E_DR_CONF_FILE_NAME.set(DE_E_DR_CONF_FILE_NAME.getDefaultValue());
        DE_E_DR_CONF_FILE.set((Object)((Path)DE_E_DR_DIR.value()).resolve((String)DE_E_DR_CONF_FILE_NAME.value()));
        DE_E_LOCAL_HOME_DIR.set((Object)((Path)DE_CTLR_HOME_DIR.value()).resolve("apps").resolve(((String)DE_ENGINE.value()).equalsIgnoreCase("xnode") ? "dataengine-xnode" : "dataengine-elastic"));
        DE_E_DATA_MAIN_DIR.set((Object)((Path)DE_E_LOCAL_HOME_DIR.value()).resolve("data").resolve("main"));
        DE_E_DATA_ARCHIVE_DIR.set((Object)((Path)DE_E_LOCAL_HOME_DIR.value()).resolve("data").resolve("archive"));
    }

    private static void logSettings() {
        LOGGER.info(" ---------------------------------------------------------------------- ");
        LOGGER.info(" DataEngine Environment Settings :- ");
        LOGGER.info(" ---------------------------------------------------------------------- ");
        LOGGER.info(" # DE_CTLR_HOME_DIR : " + DE_CTLR_HOME_DIR.value());
        LOGGER.info(" # DE_ENGINE : " + (String)DE_ENGINE.value());
        LOGGER.info(" # DE_CONF_DIR : " + DE_CONF_DIR.value());
        LOGGER.info(" # DE_CONF_FILE : " + DE_CONF_FILE.value());
        LOGGER.info(" # DE_ENGINES_DIR : " + DE_ENGINES_DIR.value());
        LOGGER.info(" # DE_XNODE_CONF_DIR : " + DE_XNODE_CONF_DIR.value());
        LOGGER.info(" # DE_ELASTIC_CONF_DIR : " + DE_ELASTIC_CONF_DIR.value());
        LOGGER.info(" # ELASTIC_HOME : " + ELASTIC_HOME_DIR.value());
        LOGGER.info(" # ELASTIC_LIB : " + ELASTIC_LIB_DIR.value());
        LOGGER.info(" # ELASTIC_BIN : " + ELASTIC_BIN_DIR.value());
        LOGGER.info(" # DE_E_CONF_DIR : " + DE_E_CONF_DIR.value());
        LOGGER.info(" # DE_E_CONF_FILE : " + DE_E_CONF_FILE.value());
        LOGGER.info(" # DE_E_DR_DIR : " + DE_E_DR_DIR.value());
        LOGGER.info(" # DE_E_DR_SCHEMA_DIR : " + DE_E_DR_SCHEMA_DIR.value());
        LOGGER.info(" # DE_E_DR_INDEX_INFO_DIR : " + DE_E_DR_BLOCK_INFO_DIR.value());
        LOGGER.info(" # DE_E_DR_CONF_FILE : " + DE_E_DR_CONF_FILE.value());
        LOGGER.info(" # DE_E_LOCAL_HOME_DIR : " + DE_E_LOCAL_HOME_DIR.value());
        LOGGER.info(" # DE_E_DATA_MAIN_DIR : " + DE_E_DATA_MAIN_DIR.value());
        LOGGER.info(" # DE_E_DATA_ARCHIVE_DIR : " + DE_E_DATA_ARCHIVE_DIR.value());
        LOGGER.info(" ---------------------------------------------------------------------- ");
    }
}

