/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller;

import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.DataEngineController;
import com.manageengine.dataengine.controller.actions.CtlrDataRepositoryActions;
import com.manageengine.dataengine.controller.actions.DEAdminActions;
import com.manageengine.dataengine.controller.actions.QueryConsoleViewActions;
import com.manageengine.dataengine.controller.actions.ReportViewActions;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepositoryManager;
import com.manageengine.dataengine.controller.datarepository.DRGeneralQueryParser;
import com.manageengine.dataengine.controller.datarepository.ElasticCtlrDataRepositoryManager;
import com.manageengine.dataengine.controller.datarepository.XNodeCtlrDataRepositoryManager;
import com.manageengine.dataengine.controller.engine.ElasticController;
import com.manageengine.dataengine.controller.engine.XNodeController;
import com.manageengine.dataengine.controller.engine.node.DENode;
import com.manageengine.dataengine.controller.engine.node.DENodes;
import com.manageengine.dataengine.controller.view.DELegacyViewHandler;

public class DE {
    private static String engineType;
    private static DataEngineController dataEngineController;
    private static CtlrDataRepositoryManager dataRepositoryManager;
    private static CtlrDataRepositoryActions dataRepositoryActions;
    private static DEAdminActions deAdminActions;
    private static ReportViewActions reportViewActions;
    private static QueryConsoleViewActions queryConsoleViewActions;
    private static DELegacyViewHandler deLegacyViewHandler;
    private static DRGeneralQueryParser drGeneralQueryParser;

    public static void initialize() throws Exception {
        AdapEnvironment.initialize();
        engineType = (String)AdapEnvironment.DE_ENGINE.value();
    }

    public static void build() throws Exception {
        if (engineType != null && engineType.equalsIgnoreCase("xnode")) {
            if (plugins.xnodeCtlrDataRepositoryActions == null) {
                throw new Exception("xnodeCtlrDataRepositoryActions plugin not set!");
            }
            if (plugins.xnodeReportViewActions == null) {
                throw new Exception("xnodeReportViewActions plugin not set!");
            }
            if (plugins.xnodeQueryConsoleViewActions == null) {
                throw new Exception("xnodeQueryConsoleViewActions plugin not set!");
            }
            dataEngineController = new XNodeController();
            dataRepositoryManager = new XNodeCtlrDataRepositoryManager();
            reportViewActions = plugins.xnodeReportViewActions.newInstance();
            queryConsoleViewActions = plugins.xnodeQueryConsoleViewActions.newInstance();
            dataRepositoryActions = plugins.xnodeCtlrDataRepositoryActions.getConstructor(CtlrDataRepositoryManager.class).newInstance(dataRepositoryManager);
        } else if (engineType != null && engineType.equalsIgnoreCase("elastic")) {
            if (plugins.elasticCtlrDataRepositoryActions == null) {
                throw new Exception("elasticCtlrDataRepositoryActions plugin not set!");
            }
            if (plugins.elasticReportViewActions == null) {
                throw new Exception("elasticReportViewActions plugin not set!");
            }
            if (plugins.elasticQueryConsoleViewActions == null) {
                throw new Exception("elasticQueryConsoleViewActions plugin not set!");
            }
            dataEngineController = new ElasticController();
            dataRepositoryManager = new ElasticCtlrDataRepositoryManager();
            reportViewActions = plugins.elasticReportViewActions.newInstance();
            queryConsoleViewActions = plugins.elasticQueryConsoleViewActions.newInstance();
            dataRepositoryActions = plugins.elasticCtlrDataRepositoryActions.getConstructor(CtlrDataRepositoryManager.class).newInstance(dataRepositoryManager);
        } else {
            throw new IllegalArgumentException("EXCEPTION : DataEngine engineType " + engineType + " not supported!");
        }
        if (plugins.deLegacyViewHandler == null) {
            throw new Exception("deLegacyViewHandler plugin not set!");
        }
        deLegacyViewHandler = plugins.deLegacyViewHandler.newInstance();
        if (plugins.drGeneralQueryParser == null) {
            throw new Exception("drGeneralQueryParser plugin not set!");
        }
        drGeneralQueryParser = plugins.drGeneralQueryParser.newInstance();
        if (plugins.deAdminActions == null) {
            throw new Exception("deAdminActions plugin not set!");
        }
        deAdminActions = plugins.deAdminActions.newInstance();
    }

    public static DataEngineController controller() {
        return dataEngineController;
    }

    public static CtlrDataRepositoryActions DR() {
        return dataRepositoryActions;
    }

    public static DEAdminActions admin() {
        return deAdminActions;
    }

    public static ReportViewActions reportViewActions() {
        return reportViewActions;
    }

    public static QueryConsoleViewActions queryConsoleViewActions() {
        return queryConsoleViewActions;
    }

    public static DELegacyViewHandler deLegacyViewHandler() {
        return deLegacyViewHandler;
    }

    public static DRGeneralQueryParser drGeneralQueryParser() {
        return drGeneralQueryParser;
    }

    public static DENodes deNodes() {
        return dataEngineController.deNodes();
    }

    public static DENode deNode(String hostName) {
        return dataEngineController.deNodes().node(hostName);
    }

    static {
        dataEngineController = null;
        dataRepositoryManager = null;
        dataRepositoryActions = null;
        deAdminActions = null;
        reportViewActions = null;
        queryConsoleViewActions = null;
        deLegacyViewHandler = null;
        drGeneralQueryParser = null;
    }

    public static class plugins {
        public static Class<? extends DEAdminActions> deAdminActions;
        public static Class<? extends ReportViewActions> xnodeReportViewActions;
        public static Class<? extends ReportViewActions> elasticReportViewActions;
        public static Class<? extends QueryConsoleViewActions> xnodeQueryConsoleViewActions;
        public static Class<? extends QueryConsoleViewActions> elasticQueryConsoleViewActions;
        public static Class<? extends CtlrDataRepositoryActions> xnodeCtlrDataRepositoryActions;
        public static Class<? extends CtlrDataRepositoryActions> elasticCtlrDataRepositoryActions;
        public static Class<? extends DELegacyViewHandler> deLegacyViewHandler;
        public static Class<? extends DRGeneralQueryParser> drGeneralQueryParser;
    }
}

