/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.actions;

import com.manageengine.dataengine.commons.datarepository.DRType;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.connector.netcalls.DRNetCalls;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepositoryManager;
import com.manageengine.dataengine.controller.datarepository.DRQuery;
import com.manageengine.dataengine.controller.engine.node.DENode;
import com.manageengine.dataengine.controller.view.DEParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CtlrDataRepositoryActions {
    private CtlrDataRepositoryManager dataRepositoryManager;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public CtlrDataRepositoryActions(CtlrDataRepositoryManager dataRepositoryManager) {
        this.dataRepositoryManager = dataRepositoryManager;
    }

    public void createDataRepository(JSONObject dataRepoObj) throws Exception {
        this.dataRepositoryManager.createDataRepository(dataRepoObj);
    }

    public void deleteDataRepository(String dataRepoName) throws Exception {
        this.dataRepositoryManager.deleteDataRepository(dataRepoName);
    }

    public void updateDataRepository(JSONArray repoList) throws Exception {
        this.dataRepositoryManager.updateDataRepository(repoList);
    }

    public JSONObject getDRSchemasAsJSON() throws Exception {
        return this.dataRepositoryManager.getDRSchemasAsJSON();
    }

    public CtlrDataRepository getDataRepository(String repositoryName) {
        return this.dataRepositoryManager.getDataRepository(repositoryName);
    }

    public CtlrDataRepository getDataRepositoryByLegacyName(String repositoryName) {
        return this.dataRepositoryManager.getDataRepositoryByLegacyName(repositoryName);
    }

    public CtlrDataRepository getDataRepositoryIfExists(String repositoryName) {
        return this.dataRepositoryManager.getDataRepositoryIfExists(repositoryName);
    }

    public CtlrDataRepository getDataRepositoryWithPrefixIfExists(String repositoryName) {
        return this.dataRepositoryManager.getDataRepositoryWithPrefixIfExists(repositoryName);
    }

    public boolean hasDataRepositoryForLegacyTable(String legacyTableName) {
        return this.dataRepositoryManager.hasDataRepositoryForLegacyTable(legacyTableName);
    }

    public ArrayList<CtlrDataRepository> getDataRepositories() {
        return this.dataRepositoryManager.getDataRepositories();
    }

    public JSONArray getDataRepositoriesAsJSON() throws Exception {
        return this.dataRepositoryManager.getDataRepositoriesAsJSON();
    }

    public void updateDRArchiveLoadedRetentionDays(int retentionDays) throws Exception {
        ArrayList<CtlrDataRepository> repoList = this.getDataRepositories();
        JSONArray jArr = new JSONArray();
        for (CtlrDataRepository repo : repoList) {
            if (repo.getRepositoryType() != DRType.AUDIT_LOG) continue;
            JSONObject recObj = new JSONObject();
            recObj.put("repository_name", (Object)repo.getRepositoryName());
            recObj.put("block_defrost_retention_days", retentionDays);
            jArr.put((Object)recObj);
        }
        this.updateDataRepository(jArr);
    }

    public abstract void migrateLegacyConf() throws Exception;

    public abstract void migrateLegacyData() throws Exception;

    public abstract NodeActions nodeActions() throws Exception;

    public abstract NodeActions nodeActions(DENode var1) throws Exception;

    public abstract class NodeActions
    implements DRNetCalls {
        @Override
        public JSONObject addData(CtlrDataRepository dataRepo, String fileAbsName) throws Exception {
            JSONObject jRes = null;
            ArrayList<String> nodes = dataRepo.getNodes();
            for (String node : nodes) {
                jRes = DE.deNode(node).DR().addData(dataRepo, fileAbsName);
            }
            return jRes;
        }

        @Override
        public JSONObject addData(CtlrDataRepository dataRepo, JSONArray dataArr) throws Exception {
            JSONObject jRes = null;
            ArrayList<String> nodes = dataRepo.getNodes();
            for (String node : nodes) {
                jRes = DE.deNode(node).DR().addData(dataRepo, dataArr);
            }
            return jRes;
        }

        @Override
        public JSONObject addMigrationData(CtlrDataRepository dataRepo, JSONArray fileList, long creationTime, String encoding, Character splitBy) throws Exception {
            JSONObject jRes = null;
            ArrayList<String> nodes = dataRepo.getNodes();
            for (String node : nodes) {
                jRes = DE.deNode(node).DR().addMigrationData(dataRepo, fileList, creationTime, encoding, splitBy);
            }
            return jRes;
        }

        @Override
        public JSONObject validateMigrationData(CtlrDataRepository dataRepo, long creationTime) throws Exception {
            JSONObject jRes = null;
            ArrayList<String> nodes = dataRepo.getNodes();
            for (String node : nodes) {
                jRes = DE.deNode(node).DR().validateMigrationData(dataRepo, creationTime);
            }
            return jRes;
        }

        @Override
        public JSONObject deleteData(CtlrDataRepository dataRepo, String queryText) throws Exception {
            JSONObject jRes = null;
            ArrayList<String> nodes = dataRepo.getNodes();
            for (String node : nodes) {
                jRes = DE.deNode(node).DR().deleteData(dataRepo, queryText);
            }
            return jRes;
        }

        @Override
        public HashMap<String, Object> executeSearchQuery(DEParams deParams) throws Exception {
            HashMap<String, Object> respObj = new HashMap<String, Object>();
            DRQuery drQuery = deParams.viw.query.obj;
            ArrayList<CtlrDataRepository> repoList = drQuery.getRefDataRepositoryList();
            ArrayList<String> nodes = repoList.get(0).getNodes();
            for (String node : nodes) {
                respObj = DE.deNode(node).DR().executeSearchQuery(deParams);
            }
            return respObj;
        }

        @Override
        public JSONObject executeSearchQuery(JSONObject queryObj) throws Exception {
            JSONObject respObj = new JSONObject();
            String drName = null;
            if (queryObj.has("dr_name_list")) {
                JSONArray drInstances = queryObj.getJSONArray("dr_name_list");
                drName = drInstances.getString(0);
            } else if (queryObj.has("dr_name")) {
                drName = queryObj.getString("dr_name");
            } else {
                throw new Exception("Missing mandatory parameter[dr_name_list|dr_name] for executeQuery()");
            }
            ArrayList<String> nodes = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(drName).getNodes();
            for (String node : nodes) {
                respObj = DE.deNode(node).DR().executeSearchQuery(queryObj);
            }
            return respObj;
        }

        @Override
        public JSONObject executeQuery(JSONObject queryObj) throws Exception {
            JSONObject respObj = new JSONObject();
            String drName = null;
            if (queryObj.has("dr_name_list")) {
                JSONArray drInstances = queryObj.getJSONArray("dr_name_list");
                drName = drInstances.getString(0);
            } else if (queryObj.has("dr_name")) {
                drName = queryObj.getString("dr_name");
            } else {
                throw new Exception("Missing mandatory parameter[dr_name_list|dr_name] for executeQuery()");
            }
            ArrayList<String> nodes = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(drName).getNodes();
            for (String node : nodes) {
                respObj = DE.deNode(node).DR().executeQuery(queryObj);
            }
            return respObj;
        }

        @Override
        public JSONObject updateDR(JSONArray drList) throws Exception {
            JSONObject respObj = new JSONObject();
            if (this.getDENode() == null) {
                ArrayList<DENode> nodeList = DE.deNodes().nodes();
                for (DENode deNode : nodeList) {
                    respObj = deNode.DR().updateDR(drList);
                    LOGGER.info("UPDATED datarepository to xnode " + deNode.getNodeHost());
                }
            } else {
                respObj = this.getDENode().DR().updateDR(drList);
                LOGGER.info("UPDATED datarepository to xnode " + this.getDENode().getNodeHost());
            }
            return respObj;
        }

        public JSONObject fetchDRBlocksMetaInfo(CtlrDataRepository repo, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText, boolean isMain) throws Exception {
            return this.fetchDRBlocksMetaInfo(new JSONArray().put((Object)repo.getRepositoryName()), startDate, endDate, from, range, sortColumn, sortOrder, searchText, isMain);
        }

        @Override
        public JSONObject fetchDRBlocksMetaInfo(JSONArray repoList, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText, boolean isMain) throws Exception {
            String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(repoList.getString(0)).getNodes().get(0);
            return DE.deNode(node).DR().fetchDRBlocksMetaInfo(repoList, startDate, endDate, from, range, sortColumn, sortOrder, searchText, isMain);
        }

        public int fetchDRBlocksCount(List<CtlrDataRepository> list, long startDate, long endDate, boolean isMain, String searchText) throws Exception {
            JSONArray repoList = new JSONArray();
            for (CtlrDataRepository repo : list) {
                repoList.put((Object)repo.getRepositoryName());
            }
            return this.fetchDRBlocksCount(repoList, (Long)startDate, (Long)endDate, isMain, searchText);
        }

        @Override
        public int fetchDRBlocksCount(JSONArray repoList, Long startDate, Long endDate, boolean isMain, String searchText) throws Exception {
            String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(repoList.getString(0)).getNodes().get(0);
            return DE.deNode(node).DR().fetchDRBlocksCount(repoList, startDate, endDate, isMain, searchText);
        }

        @Override
        public JSONObject fetchMainDRBlocksDiskSize(JSONArray drList) throws Exception {
            JSONObject respObj = new JSONObject();
            String repoName = drList.getString(0);
            if (repoName.equalsIgnoreCase("all")) {
                respObj = DE.deNodes().nodes().get(0).DR().fetchMainDRBlocksDiskSize(drList);
            } else {
                String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(drList.getString(0)).getNodes().get(0);
                respObj = DE.deNode(node).DR().fetchMainDRBlocksDiskSize(drList);
            }
            return respObj;
        }

        @Override
        public JSONObject fetchMainDRBlocksDiskSizeOlderThan(JSONArray drList) throws Exception {
            JSONObject respObj = new JSONObject();
            String defaultRepo = drList.getJSONObject(0).getString("dr_name");
            if (defaultRepo.equalsIgnoreCase("all")) {
                respObj = DE.deNodes().nodes().get(0).DR().fetchMainDRBlocksDiskSizeOlderThan(drList);
            } else {
                String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(defaultRepo).getNodes().get(0);
                respObj = DE.deNode(node).DR().fetchMainDRBlocksDiskSizeOlderThan(drList);
            }
            return respObj;
        }

        @Override
        public boolean archiveOldBlocks() throws Exception {
            if (this.getDENode() == null) {
                ArrayList<DENode> deNodes = DE.deNodes().nodes();
                for (DENode deNode : deNodes) {
                    deNode.DR().archiveOldBlocks();
                }
            } else {
                this.getDENode().DR().archiveOldBlocks();
            }
            return true;
        }

        @Override
        public boolean loadArchiveBlocks(CtlrDataRepository repo, String fileName, boolean canLoad, String availableSize) throws Exception {
            return this.loadOrUnloadArchiveBlocks(repo, fileName, true, canLoad, availableSize);
        }

        @Override
        public boolean unloadArchiveBlocks(CtlrDataRepository repo, String fileName) throws Exception {
            return this.loadOrUnloadArchiveBlocks(repo, fileName, false, false, "");
        }

        private boolean loadOrUnloadArchiveBlocks(CtlrDataRepository repo, String fileName, boolean isLoad, boolean canLoad, String availableSize) throws Exception {
            boolean isEnabled;
            boolean bl = isEnabled = repo == null ? false : repo.getRepositoryState().equalsIgnoreCase("ENABLED");
            if (isEnabled) {
                ArrayList<String> nodes = repo.getNodes();
                for (String node : nodes) {
                    if (isLoad) {
                        DE.deNode(node).DR().loadArchiveBlocks(repo, fileName, canLoad, availableSize);
                        continue;
                    }
                    DE.deNode(node).DR().unloadArchiveBlocks(repo, fileName);
                }
            }
            return isEnabled;
        }

        @Override
        public boolean updateArchiveLocation(JSONArray locationList, boolean clean, boolean isCurrentPathUpdate) throws Exception {
            LOGGER.info("UPDATING archive locations...");
            if (this.getDENode() == null) {
                ArrayList<DENode> nodeList = DE.deNodes().nodes();
                for (DENode deNode : nodeList) {
                    deNode.DR().updateArchiveLocation(locationList, clean, isCurrentPathUpdate);
                }
            } else {
                this.getDENode().DR().updateArchiveLocation(locationList, clean, isCurrentPathUpdate);
            }
            return true;
        }

        public abstract DENode getDENode();

        @Override
        public JSONObject fetchToBeDeletedBlocksMetaInfo(JSONArray drList, long startTime, long endTime, String searchText) throws Exception {
            JSONObject respObj = new JSONObject();
            String repoName = drList.getString(0);
            if (repoName.equalsIgnoreCase("all")) {
                respObj = DE.deNodes().nodes().get(0).DR().fetchToBeDeletedBlocksMetaInfo(drList, startTime, endTime, searchText);
            } else {
                String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(drList.getString(0)).getNodes().get(0);
                respObj = DE.deNode(node).DR().fetchToBeDeletedBlocksMetaInfo(drList, startTime, endTime, searchText);
            }
            return respObj;
        }

        @Override
        public JSONObject fetchArchivePageInfo(JSONArray drList) throws Exception {
            String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(drList.getString(0)).getNodes().get(0);
            return DE.deNode(node).DR().fetchArchivePageInfo(drList);
        }

        @Override
        public boolean updateSchedulerInterval(int hourOfTheDay) throws Exception {
            LOGGER.info("UPDATING Scheduler Interval...");
            if (this.getDENode() == null) {
                ArrayList<DENode> nodeList = DE.deNodes().nodes();
                for (DENode deNode : nodeList) {
                    deNode.DR().updateSchedulerInterval(hourOfTheDay);
                }
            } else {
                this.getDENode().DR().updateSchedulerInterval(hourOfTheDay);
            }
            return true;
        }

        public JSONObject fetchDeletedBlocksMetaInfo(CtlrDataRepository repo, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText) throws Exception {
            return this.fetchDeletedBlocksMetaInfo(new JSONArray().put((Object)repo.getRepositoryName()), startDate, endDate, from, range, sortColumn, sortOrder, searchText);
        }

        @Override
        public JSONObject fetchDeletedBlocksMetaInfo(JSONArray repoList, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText) throws Exception {
            String node = CtlrDataRepositoryActions.this.dataRepositoryManager.getDataRepository(repoList.getString(0)).getNodes().get(0);
            return DE.deNode(node).DR().fetchDeletedBlocksMetaInfo(repoList, startDate, endDate, from, range, sortColumn, sortOrder, searchText);
        }

        @Override
        public boolean addColumn(String columnName, String columnType, String defaultValue, boolean isMain) throws Exception {
            LOGGER.info("Adding column to DataRepository Meta Information... ");
            if (this.getDENode() == null) {
                ArrayList<DENode> deNodes = DE.deNodes().nodes();
                Iterator<DENode> iterator = deNodes.iterator();
                if (iterator.hasNext()) {
                    DENode deNode = iterator.next();
                    return deNode.DR().addColumn(columnName, columnType, defaultValue, isMain);
                }
            } else {
                return this.getDENode().DR().addColumn(columnName, columnType, defaultValue, isMain);
            }
            return Boolean.FALSE;
        }

        @Override
        public boolean updateColumn(String columnName, String value, boolean isMain) throws Exception {
            LOGGER.info("Updating values in DataRepository Meta Information...");
            if (this.getDENode() == null) {
                ArrayList<DENode> deNodes = DE.deNodes().nodes();
                Iterator<DENode> iterator = deNodes.iterator();
                if (iterator.hasNext()) {
                    DENode deNode = iterator.next();
                    return deNode.DR().updateColumn(columnName, value, isMain);
                }
            } else {
                return this.getDENode().DR().updateColumn(columnName, value, isMain);
            }
            return Boolean.FALSE;
        }
    }
}

