/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.client.rest;

import com.manageengine.dataengine.controller.engine.node.ElasticNode;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticRestClient {
    private RestClient client;
    private ExecutorService executorService;
    private ElasticNode elasticNode;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public ElasticRestClient(ElasticNode elasticNode) throws Exception {
        LOGGER.info("ES :: Going to initialize ES Rest Client...");
        this.elasticNode = elasticNode;
        String host = (String)elasticNode.getSettings().elastic_host.value();
        int port = (Integer)elasticNode.getSettings().elastic_connector_rest_port.value();
        this.client = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port)}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                return httpClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(2).build());
            }
        }).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(300000).setSocketTimeout(300000);
            }
        }).setMaxRetryTimeoutMillis(300000).build();
        LOGGER.info("ES :: ES Rest Client initialized! Host : " + host + ", Port : " + port);
        this.executorService = Executors.newFixedThreadPool(2);
    }

    public RestClient getRestClient() {
        return this.client;
    }
}

