/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.client.rest;

import com.manageengine.dataengine.controller.view.DEParams;
import java.util.ArrayList;

public class ElasticRestQueryBuilder {
    public static String getRestQueryString(DEParams deParams) throws Exception {
        String esRestQueryStr = null;
        if (deParams.viw.query.obj != null) {
            switch (deParams.viw.query.obj.getQueryType()) {
                case SEARCH_ONLY: {
                    esRestQueryStr = ElasticRestQueryBuilder.getSearchOnlyRestQueryString(deParams);
                    break;
                }
                case UNIQUE_COUNT: {
                    esRestQueryStr = ElasticRestQueryBuilder.getUniqueCountRestQueryString(deParams);
                    break;
                }
                case AGGR_STATS: {
                    esRestQueryStr = ElasticRestQueryBuilder.getMinMaxRestQueryString(deParams);
                    break;
                }
                case AGGR_TERMS_COUNT: {
                    esRestQueryStr = ElasticRestQueryBuilder.getNavGroupByRestQueryString(deParams);
                    break;
                }
                case AGGR_TERMS_STATS: 
                case AGGR_TERMS_DATE_HISTOGRAM: 
                case AGGR_TERMS_SUMMARY: 
                case COUNT: 
                case AGGR_DATE_HISTOGRAM: {
                    throw new Exception("Query type not handled!");
                }
            }
        }
        return esRestQueryStr;
    }

    private static String getSearchOnlyRestQueryString(DEParams deParams) {
        String searchAfterStr = "";
        String sortColStr = "";
        if (deParams.viw.query.search_after != null) {
            searchAfterStr = ",\"search_after\":" + deParams.viw.query.search_after.toString();
        }
        int sortColCount = deParams.viw.query.sort_col_list.size();
        for (int i = 0; i < sortColCount; ++i) {
            sortColStr = sortColStr + ",{\"" + deParams.viw.query.sort_col_list.get(i) + "\" : \"" + deParams.viw.query.sort_col_order.get(i) + "\"}";
        }
        if (sortColCount > 0) {
            sortColStr = ",\"sort\" : [" + sortColStr.substring(1) + "]";
        }
        String queryStr = "{\"query\" : {\"query_string\" : {\"query\" : \"" + deParams.viw.query.query_text + "\"}}" + sortColStr + searchAfterStr + ",\"from\" : 0,\"size\" : " + deParams.viw.rtable.page_size + "}";
        return queryStr;
    }

    private static String getUniqueCountRestQueryString(DEParams deParams) {
        String esRestQueryStr = "";
        String queryStr = "";
        String aggStr = "";
        String scriptStr = "";
        if (deParams.viw.query.query_text != null) {
            queryStr = "\"query\" : {\"query_string\" : {\"query\" : \"" + deParams.viw.query.query_text + "\"}},";
        }
        ArrayList<String> groupByColList = deParams.viw.query.obj.getGroupByColList();
        int colCount = groupByColList.size();
        for (int i = 0; i < colCount; ++i) {
            scriptStr = i == 0 ? scriptStr + "doc['" + groupByColList.get(i) + "'].value" : scriptStr + " + ' ' + doc['" + groupByColList.get(i) + "'].value";
        }
        aggStr = aggStr + ",\"aggs\": {\"unique_col_val_count_1\": {\"cardinality\": {\"script\": {\"lang\": \"painless\",\"inline\": \"" + scriptStr + "\"}}}}";
        esRestQueryStr = "{" + queryStr + "\"size\" : 0" + aggStr + "}";
        return esRestQueryStr;
    }

    private static String getGroupByRestQueryString(DEParams deParams) {
        String esRestQueryStr = "";
        String queryStr = "";
        String aggOpenStr = "";
        String aggCloseStr = "";
        String aggStr = "";
        if (deParams.viw.query.query_text != null) {
            queryStr = "\"query\" : {\"query_string\" : {\"query\" : \"" + deParams.viw.query.query_text + "\"}},";
        }
        ArrayList<String> groupByColList = deParams.viw.query.obj.getGroupByColList();
        int colCount = groupByColList.size();
        for (int i = 0; i < colCount; ++i) {
            aggOpenStr = aggOpenStr + ",\"aggs\": {\"group_by_field_" + (i + 1) + "\": {\"terms\": {\"field\": \"" + groupByColList.get(i) + "\",\"size\": " + deParams.viw.rtable.page_size + ",\"order\" : {\"_count\" :\"desc\"}}";
            aggCloseStr = aggCloseStr + "}}";
            if (i != colCount - 1 || !deParams.viw.query.group_by_get_hit_doc) continue;
            aggOpenStr = aggOpenStr + ",\"aggs\": {\"top_doc_hits\": {\"top_hits\": {\"size\" : 1}}}";
        }
        aggStr = aggOpenStr + aggCloseStr;
        esRestQueryStr = "{" + queryStr + "\"size\" : 0" + aggStr + "}";
        return esRestQueryStr;
    }

    private static String getNavGroupByRestQueryString(DEParams deParams) {
        String esRestQueryStr = "";
        String queryStr = "";
        String aggStr = "";
        String scriptStr = "";
        String includeStr = "";
        String excludeStr = "";
        String orderByType = "_count";
        String order = "desc";
        if (deParams.viw.query.query_text != null) {
            queryStr = "\"query\" : {\"query_string\" : {\"query\" : \"" + deParams.viw.query.query_text + "\"}},";
        }
        ArrayList<String> groupByColList = deParams.viw.query.obj.getGroupByColList();
        int sortColCount = deParams.viw.query.sort_col_list.size();
        if (sortColCount > 0 && deParams.viw.query.sort_col_list.get(0).equals(groupByColList.get(0))) {
            order = deParams.viw.query.sort_col_order.get(0).trim();
            if (!groupByColList.get(0).equalsIgnoreCase("count")) {
                orderByType = "_term";
            }
        }
        int colCount = groupByColList.size();
        for (int i = 0; i < colCount; ++i) {
            scriptStr = scriptStr.trim().isEmpty() ? scriptStr + "doc['" + groupByColList.get(i) + "'].value" : scriptStr + " + '-' + doc['" + groupByColList.get(i) + "'].value";
        }
        if (deParams.viw.query.group_by_exclude_list.size() > 0) {
            excludeStr = ",\"exclude\": " + deParams.viw.query.group_by_exclude_list.toString();
        }
        aggStr = aggStr + ",\"aggs\": {\"group_by_field_1\": {\"terms\": {\"script\": \"" + scriptStr + "\",\"size\": " + deParams.viw.rtable.page_size + ",\"shard_size\" : 100000,\"order\" : {\"" + orderByType + "\" : \"" + order + "\"}" + excludeStr + "}}}";
        esRestQueryStr = "{" + queryStr + "\"size\" : 0" + aggStr + "}";
        return esRestQueryStr;
    }

    private static String getMinMaxRestQueryString(DEParams deParams) {
        String esRestQueryStr = "";
        String queryStr = "";
        String aggStr = "";
        if (deParams.viw.query.query_text != null) {
            queryStr = "\"query\" : {\"query_string\" : {\"query\" : \"" + deParams.viw.query.query_text + "\"}},";
        }
        aggStr = aggStr + ",\"aggs\": {\"min_value\": {\"min\": {\"field\": \"" + deParams.viw.query.aggr_field + "\"}},\"max_value\": {\"max\": {\"field\": \"" + deParams.viw.query.aggr_field + "\"}}}";
        esRestQueryStr = "{" + queryStr + "\"size\" : 0" + aggStr + "}";
        return esRestQueryStr;
    }
}

