/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.client.transport;

import com.manageengine.dataengine.controller.connector.client.transport.TransportResponseListener;
import io.netty.handler.codec.TooLongFrameException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class SyncTransportResponseListener
implements TransportResponseListener {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<JSONObject> response = new AtomicReference();
    private final AtomicReference<Exception> exception = new AtomicReference();
    private final long timeout;

    public SyncTransportResponseListener(long timeout) {
        assert (timeout > 0L);
        this.timeout = timeout;
    }

    @Override
    public void onSuccess(JSONObject response) {
        boolean wasResponseNull = this.response.compareAndSet(null, response);
        if (!wasResponseNull) {
            throw new IllegalStateException("response is already set");
        }
        this.latch.countDown();
    }

    @Override
    public void onFailure(Exception exception) {
        boolean wasExceptionNull = this.exception.compareAndSet(null, exception);
        if (!wasExceptionNull) {
            throw new IllegalStateException("exception is already set");
        }
        this.latch.countDown();
    }

    @Override
    public JSONObject get() throws Exception {
        try {
            if (!this.latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                throw new IOException("listener timeout after waiting for [" + this.timeout + "] ms");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("thread waiting for the response was interrupted", e);
        }
        Exception exception = this.exception.get();
        JSONObject response = this.response.get();
        if (exception != null) {
            if (response != null) {
                IllegalStateException e = new IllegalStateException("response and exception are unexpectedly set at the same time");
                e.addSuppressed(exception);
                throw e;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof TooLongFrameException) {
                throw new Exception("Received data larger than buffer size! Increase the size of xnode.connector.tcp.json_decode_size_mb parameter in \\conf\\DataEngine\\engines\\xnode\\dataengine-xnodes.conf file and restart the product.");
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("error while performing request", exception);
        }
        if (response == null) {
            throw new IllegalStateException("response not set and no exception caught either");
        }
        return response;
    }
}

