/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.client.transport;

import com.manageengine.dataengine.controller.connector.client.XNodeClient;
import com.manageengine.dataengine.controller.connector.client.transport.netty.NettyTcpClient;
import com.manageengine.dataengine.controller.engine.node.XNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import org.json.JSONObject;

public class XNodeTcpClient
extends XNodeClient {
    private NettyTcpClient nettyClient = null;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private final Object channelLock = new Object();

    public XNodeTcpClient(XNode xnode) {
        super(xnode);
        this.nettyClient = new NettyTcpClient(xnode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws Exception {
        if (!this.isConnected()) {
            Object object = this.channelLock;
            synchronized (object) {
                if (!this.isConnected()) {
                    this.nettyClient.connect();
                    this.authenticate(true);
                }
            }
        }
    }

    @Override
    public JSONObject sendMessage(JSONObject jMsg) throws Exception {
        return this.nettyClient.sendMessage(jMsg);
    }

    @Override
    public void disConnect() throws Exception {
        this.nettyClient.disConnect();
    }

    @Override
    public boolean isConnected() throws Exception {
        return this.nettyClient.isConnected();
    }

    public void authenticate(boolean retry) throws Exception {
        JSONObject jMsg = new JSONObject();
        jMsg.put("username", this.getSettings().xnode_connector_username.value());
        jMsg.put("password", this.getSettings().xnode_connector_password.value());
        jMsg.put("request_timeout", this.getSettings().xnode_connector_authentication_timeout.value());
        jMsg.put("action", (Object)"session:/authenticate");
        JSONObject jResp = this.sendMessage(jMsg);
        if (jResp == null || !jResp.has("response")) {
            throw new Exception("EXCEPTION while processing request on XNode null/no response received!!");
        }
        if (jResp.has("response") && (jResp = jResp.getJSONObject("response")).has("error_code")) {
            int errorCode = jResp.getInt("error_code");
            if (errorCode != 0 && retry) {
                LOGGER.info("Authentication failed! Retrying once again.");
                this.syncPassword();
                this.authenticate(false);
            } else if (errorCode != 0) {
                if (jResp.has("error_msg")) {
                    throw new Exception("EXCEPTION while processing request on XNode, Msg : " + jResp.getString("error_msg"));
                }
                throw new Exception("EXCEPTION while processing request on XNode, Error Code : " + errorCode);
            }
        }
    }

    private void syncPassword() throws Exception {
        LOGGER.info("Going to sync connector password!");
        if (((String)this.getSettings().xnode_location.value()).equals("native")) {
            String filePath = System.getProperty("server.home") + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "conf" + File.separator + "dataengine-xnode.conf";
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));){
                String line = null;
                String pwd = null;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("xnode.connector.password")) continue;
                    pwd = line.substring(line.indexOf("=") + 1).trim();
                }
                if (pwd != null && !pwd.isEmpty()) {
                    this.xNode().updateConnectorPassword(pwd);
                }
            }
        }
    }
}

