/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.client.transport.netty;

import com.manageengine.dataengine.controller.connector.client.transport.netty.NettyTcpClient;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NettyClientMessageChannelHandler
extends ChannelDuplexHandler {
    private NettyTcpClient nettyClient;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public NettyClientMessageChannelHandler(NettyTcpClient nettyClient) {
        this.nettyClient = nettyClient;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        LOGGER.fine("RESPONSE size in bytes : " + ((String)msg).getBytes("UTF-8").length);
        JSONObject jMsg = new JSONObject((String)msg);
        this.nettyClient.responseReceived(ctx.channel(), jMsg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.severe("NettyClientMessageChannelHandler Error : [" + cause.getMessage() + "]");
        this.nettyClient.exceptionCaught(ctx, cause);
    }
}

