/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.client.transport.netty;

import com.manageengine.dataengine.commons.concurrent.ConcurrentCollections;
import com.manageengine.dataengine.commons.concurrent.ConcurrentMapLong;
import com.manageengine.dataengine.commons.concurrent.FutureUtils;
import com.manageengine.dataengine.controller.connector.client.transport.SyncTransportResponseListener;
import com.manageengine.dataengine.controller.connector.client.transport.TransportResponseHandler;
import com.manageengine.dataengine.controller.connector.client.transport.netty.NettyClientMessageChannelHandler;
import com.manageengine.dataengine.controller.engine.node.XNode;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NettyTcpClient {
    public static final String TCP_CLIENT_BOSS_THREAD_NAME_PREFIX = "tcp_client_boss";
    public static final String TCP_CLIENT_WORKER_THREAD_NAME_PREFIX = "tcp_client_worker";
    private final int workerCount;
    private final int defaultRequestTimeout;
    private final AtomicLong requestIdGenerator = new AtomicLong();
    private ChannelFuture channelFuture;
    private OioEventLoopGroup oioEventLoopGroup = null;
    private NioEventLoopGroup nioEventLoopGroup = null;
    private final ConcurrentMapLong<RequestHolder> clientHandlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private XNode xnode;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public NettyTcpClient(XNode xnode) {
        this.xnode = xnode;
        this.workerCount = 2;
        this.defaultRequestTimeout = (Integer)xnode.getSettings().xnode_connector_request_timeout.value();
    }

    public long newRequestId() {
        return this.requestIdGenerator.incrementAndGet();
    }

    public void connect() throws Exception {
        boolean connectException = false;
        LOGGER.info("Going to connect to DataEngine XNode...");
        Bootstrap bootstrap = this.createBootstrap();
        this.channelFuture = bootstrap.connect((String)this.xnode.getSettings().xnode_host.value(), ((Integer)this.xnode.getSettings().xnode_connector_port.value()).intValue());
        this.channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess() && future.cause() instanceof ConnectException) {
                    LOGGER.info("DataEngine XNode not reachable!");
                    NettyTcpClient.this.disConnect();
                }
            }
        });
        this.channelFuture.channel().closeFuture().addListener((GenericFutureListener)new ChannelCloseListener());
        this.channelFuture.sync();
        LOGGER.info("CONNECTED to DataEngine XNode! channel {" + this.channelFuture.channel() + "}");
    }

    public void disConnect() throws InterruptedException {
        if (this.channelFuture != null && this.channelFuture.channel() != null) {
            this.channelFuture.channel().close();
            this.channelFuture.channel().closeFuture().syncUninterruptibly();
        }
        if (this.nioEventLoopGroup != null) {
            this.nioEventLoopGroup.shutdownGracefully();
        }
        if (this.oioEventLoopGroup != null) {
            this.oioEventLoopGroup.shutdownGracefully();
        }
        LOGGER.info("DISCONNECTED from DataEngine XNode! channel {" + this.channelFuture.channel() + "}");
    }

    public boolean isConnected() throws InterruptedException {
        return this.channelFuture != null && this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
    }

    public JSONObject sendMessage(JSONObject jMsg) throws Exception {
        long requestId = this.newRequestId();
        TimeoutHandler timeoutHandler = new TimeoutHandler(requestId);
        if (this.channelFuture != null && this.channelFuture.channel() != null && this.channelFuture.channel().isActive()) {
            try {
                int requestTimeout = jMsg.optInt("request_timeout", this.defaultRequestTimeout);
                SyncTransportResponseListener listener = new SyncTransportResponseListener(requestTimeout);
                TransportResponseHandler responseHandler = new TransportResponseHandler(listener);
                this.clientHandlers.put(requestId, (Object)new RequestHolder(responseHandler, jMsg.getString("action"), timeoutHandler));
                jMsg.put("request_id", requestId);
                timeoutHandler.future = this.xnode.schedule(timeoutHandler, requestTimeout, TimeUnit.MILLISECONDS);
                Channel channel = this.channelFuture.channel();
                channel.writeAndFlush((Object)jMsg.toString());
                return listener.get();
            }
            catch (Throwable e) {
                RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(requestId);
                if (holderToNotify != null) {
                    holderToNotify.cancelTimeout();
                }
                throw e;
            }
        }
        LOGGER.severe("Netty TCP channel not active!");
        return null;
    }

    public void responseReceived(Channel channel, JSONObject jMsg) throws Exception {
        long requestId = jMsg.getLong("request_id");
        RequestHolder holder = (RequestHolder)this.clientHandlers.remove(requestId);
        if (holder == null) {
            this.checkForTimeout(requestId);
            return;
        }
        holder.cancelTimeout();
        holder.handler().handleResponse(jMsg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.severe("NettyTcpClient Error : [" + cause.getMessage() + "]");
        for (Map.Entry entry : this.clientHandlers.entrySet()) {
            RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
            holderToNotify.cancelTimeout();
            holderToNotify.handler().handleException((Exception)cause);
        }
        cause.printStackTrace();
        ctx.close();
        this.disConnect();
    }

    private Bootstrap createBootstrap() {
        Bootstrap bootstrap = new Bootstrap();
        if (((Boolean)this.xnode.getSettings().xnode_connector_tcp_blocking_client.value()).booleanValue()) {
            this.oioEventLoopGroup = new OioEventLoopGroup(1);
            bootstrap.group((EventLoopGroup)this.oioEventLoopGroup);
            bootstrap.channel(OioSocketChannel.class);
        } else {
            this.nioEventLoopGroup = new NioEventLoopGroup(this.workerCount);
            bootstrap.group((EventLoopGroup)this.nioEventLoopGroup);
            bootstrap.channel(NioSocketChannel.class);
        }
        bootstrap.handler((ChannelHandler)new ClientChannelInitializer());
        bootstrap.validate();
        return bootstrap;
    }

    protected void checkForTimeout(long requestId) {
        if (this.clientHandlers.get(requestId) != null) {
            return;
        }
        TimeoutInfoHolder timeoutInfoHolder = this.timeoutInfoHandlers.remove(requestId);
        if (timeoutInfoHolder != null) {
            long time = System.currentTimeMillis();
            LOGGER.warning("Received response for a request that has timed out, sent [" + (time - timeoutInfoHolder.sentTime()) + "ms] ago, timed out [" + (time - timeoutInfoHolder.timeoutTime()) + "ms] ago, action [" + timeoutInfoHolder.action() + "], id [" + requestId + "]");
        } else {
            LOGGER.warning("Transport response handler not found of id [" + requestId + "]");
        }
    }

    private class ChannelCloseListener
    implements ChannelFutureListener {
        private ChannelCloseListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!NettyTcpClient.this.clientHandlers.isEmpty()) {
                LOGGER.severe("XNODE connection closed with pending requests!");
                for (Map.Entry entry : NettyTcpClient.this.clientHandlers.entrySet()) {
                    RequestHolder holderToNotify = (RequestHolder)NettyTcpClient.this.clientHandlers.remove(entry.getKey());
                    LOGGER.severe("PENDING ACTION : " + holderToNotify.action());
                    holderToNotify.cancelTimeout();
                    holderToNotify.handler().handleException(new Exception("XNODE connection closed abruptly! Check the node logs!"));
                }
            }
        }
    }

    private static class TimeoutInfoHolder {
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(String action, long sentTime, long timeoutTime) {
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    private class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime = System.currentTimeMillis();
        volatile ScheduledFuture future;

        TimeoutHandler(long requestId) {
            this.requestId = requestId;
        }

        @Override
        public void run() {
            RequestHolder holder = (RequestHolder)NettyTcpClient.this.clientHandlers.get(this.requestId);
            if (holder != null) {
                long timeoutTime = System.currentTimeMillis();
                NettyTcpClient.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(holder.action(), this.sentTime, timeoutTime));
                RequestHolder removedHolder = (RequestHolder)NettyTcpClient.this.clientHandlers.remove(this.requestId);
                if (removedHolder != null) {
                    assert (removedHolder == holder) : "two different holder instances for request [" + this.requestId + "]";
                    removedHolder.handler().handleException(new Exception("request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    NettyTcpClient.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        public void cancel() {
            assert (NettyTcpClient.this.clientHandlers.get(this.requestId) == null) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            FutureUtils.cancel((Future)this.future);
        }
    }

    static class RequestHolder {
        private final TransportResponseHandler handler;
        private final String action;
        private final TimeoutHandler timeoutHandler;

        RequestHolder(TransportResponseHandler handler, String action, TimeoutHandler timeoutHandler) {
            this.handler = handler;
            this.action = action;
            this.timeoutHandler = timeoutHandler;
        }

        public TransportResponseHandler handler() {
            return this.handler;
        }

        public String action() {
            return this.action;
        }

        public void cancelTimeout() {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.cancel();
            }
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast(new ChannelHandler[]{new JsonObjectDecoder((Integer)((NettyTcpClient)NettyTcpClient.this).xnode.getSettings().xnode_connector_tcp_json_decode_size_mb.value() * 1024 * 1024)});
            ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()});
            ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder()});
            ch.pipeline().addLast("message_handler", (ChannelHandler)new NettyClientMessageChannelHandler(NettyTcpClient.this));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOGGER.severe("NettyTcpClient-ClientChannelInitializer Error : [" + cause.getMessage() + "]");
            this.exceptionCaught(ctx, cause);
        }
    }
}

