/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.netcalls;

import com.manageengine.dataengine.controller.connector.netcalls.AdminNetCalls;
import com.manageengine.dataengine.controller.engine.node.ElasticNode;
import java.util.Collections;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.json.JSONObject;

public class ElasticRestAdminNetCalls
implements AdminNetCalls {
    private static ElasticNode node = null;
    private static RestClient client = null;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public ElasticRestAdminNetCalls(ElasticNode elasticNode) throws Exception {
        node = elasticNode;
        client = node.getRestClient();
    }

    @Override
    public String fetchNodeState() throws Exception {
        String aStatus = null;
        try {
            LOGGER.info("ES :: Fetching ES cluster status...");
            Response response = client.performRequest("GET", "/_cluster/health", Collections.emptyMap(), new Header[0]);
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObj = new JSONObject(jsonStr);
            aStatus = jsonObj.getString("status");
            LOGGER.info("ES :: Current ES Cluster status : " + aStatus);
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while verifying ES cluster status! :: " + e.getMessage());
            throw e;
        }
        return aStatus;
    }

    @Override
    public JSONObject fetchNodeStateAndNotifications() throws Exception {
        return null;
    }

    @Override
    public boolean verifyNodeState(String eStatus) throws Exception {
        boolean statusMatch = false;
        LOGGER.info("ES :: Checking ES Cluster status, expected status : " + eStatus);
        String aStatus = this.fetchNodeState();
        statusMatch = eStatus.equals(aStatus);
        return statusMatch;
    }

    public Response createSnapshotRepository(String repositoryName, String location) throws Exception {
        Response response = null;
        try {
            LOGGER.info("Going to create snapshot repository '" + repositoryName + "', location : " + location);
            NStringEntity entity = new NStringEntity("{\"type\": \"fs\",\"settings\": {\"compress\" : true,\"location\": \"" + location + "\"}}", ContentType.APPLICATION_JSON);
            response = client.performRequest("PUT", "/_snapshot/" + repositoryName, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            LOGGER.info("Snapshot repository '" + repositoryName + "' created successfully!");
        }
        catch (Exception re) {
            LOGGER.severe("EXCEPTION while creating index snapshot repository '" + repositoryName + "'!");
            throw re;
        }
        return response;
    }

    public Response deleteSnapshotRepository(String repositoryName) throws Exception {
        Response response = null;
        try {
            LOGGER.info("Going to delete snapshot repository '" + repositoryName + "'");
            response = client.performRequest("DELETE", "/_snapshot/" + repositoryName, new Header[0]);
            LOGGER.info("Snapshot repository '" + repositoryName + "' deleted successfully!");
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while deleting snapshot repository '" + repositoryName + "'!");
            throw e;
        }
        return response;
    }

    public boolean checkIfSnapshotRepositoryExists(String repositoryName) throws Exception {
        boolean repoExists = true;
        try {
            LOGGER.info("Checking if snapshot repository '" + repositoryName + "' exists...");
            client.performRequest("GET", "/_snapshot/" + repositoryName, Collections.emptyMap(), new Header[0]);
        }
        catch (ResponseException re) {
            repoExists = re.getResponse().getStatusLine().getStatusCode() != 404;
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while checking snapshot repository status, repository name : '" + repositoryName + "'!");
            LOGGER.severe(e.getMessage());
            repoExists = false;
            throw e;
        }
        LOGGER.info("Snapshot repository '" + repositoryName + "' exists? : " + repoExists);
        return repoExists;
    }

    @Override
    public JSONObject updateSecuritySettings(JSONObject conf) throws Exception {
        return null;
    }

    @Override
    public JSONObject fetchNodeInfo() throws Exception {
        return null;
    }

    @Override
    public void shutdownNode() throws Exception {
    }

    @Override
    public JSONObject isArchiveRunning() throws Exception {
        return null;
    }
}

