/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.netcalls;

import com.manageengine.dataengine.commons.datarepository.DRBlockRotationType;
import com.manageengine.dataengine.commons.datarepository.DRBlockUtil;
import com.manageengine.dataengine.controller.connector.client.rest.ElasticRestQueryBuilder;
import com.manageengine.dataengine.controller.connector.netcalls.DRNetCalls;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.engine.node.ElasticNode;
import com.manageengine.dataengine.controller.view.DEParams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class ElasticRestDRNetCalls
implements DRNetCalls {
    private ElasticNode elasticNode;
    private RestClient client = null;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public ElasticRestDRNetCalls(ElasticNode elasticNode) throws Exception {
        this.elasticNode = elasticNode;
        this.client = elasticNode.getRestClient();
    }

    public JSONObject createIndex(String repoName) throws Exception {
        JSONObject jResponse = null;
        try {
            LOGGER.info("ES :: Going to create index '" + repoName + "'...");
            Response response = this.client.performRequest("PUT", "/" + repoName, Collections.emptyMap(), new Header[0]);
            jResponse = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            LOGGER.info("ES :: Index '" + repoName + "' created succesfully! : " + jResponse);
            response = this.client.performRequest("POST", "/" + repoName + "/_refresh", Collections.emptyMap(), new Header[0]);
        }
        catch (Exception re) {
            LOGGER.severe("EXCEPTION while creating index '" + repoName + "'!");
            throw re;
        }
        return jResponse;
    }

    public JSONObject deleteIndex(String repoName) throws Exception {
        try {
            LOGGER.info("ES :: Going to delete index '" + repoName + "'...");
            this.client.performRequest("DELETE", repoName, new Header[0]);
            LOGGER.info("ES :: Successfully deleted index '" + repoName + "'!");
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while deleting index '" + repoName + "'!");
            throw e;
        }
        return null;
    }

    public JSONObject rolloverIndex(String indexName, int maxDocCount) throws Exception {
        JSONObject jResponse = null;
        try {
            LOGGER.info("ES :: Going to rollover index '" + indexName + "'...");
            NStringEntity entity = new NStringEntity("{\"conditions\" : {\"max_docs\" : " + maxDocCount + "}}", ContentType.APPLICATION_JSON);
            Response response = this.client.performRequest("POST", "/" + indexName + "/_rollover", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            jResponse = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            LOGGER.info("ES :: Index '" + indexName + "' rolled over!! " + jResponse);
        }
        catch (Exception re) {
            LOGGER.severe("EXCEPTION while rolling index '" + indexName + "'!");
            throw re;
        }
        return jResponse;
    }

    public Response snapshotIndex(String indexName, String snapshotName, String repositoryName, boolean waitForCompletion) throws Exception {
        Response response = null;
        try {
            LOGGER.info("Going to take snapshot for index '" + indexName + "'");
            NStringEntity entity = new NStringEntity("{\"indices\": \"" + indexName + "\",\"ignore_unavailable\": true,\"include_global_state\": false}", ContentType.APPLICATION_JSON);
            response = this.client.performRequest("PUT", "/_snapshot/" + repositoryName + "/" + snapshotName + (waitForCompletion ? "?wait_for_completion=true" : ""), Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            LOGGER.info("Snapshot for index '" + indexName + "' taken successfully!");
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while taking index snapshot '" + snapshotName + "'!");
            throw e;
        }
        return response;
    }

    public Response deleteSnapshot(String snapshotName, String repositoryName) throws Exception {
        Response response = null;
        try {
            LOGGER.info("Going to delete index snapshot '" + snapshotName + "' from repository '" + repositoryName + "'");
            response = this.client.performRequest("DELETE", "/_snapshot/" + repositoryName + "/" + snapshotName, new Header[0]);
            LOGGER.info("Index snapshot '" + snapshotName + "' deleted successfully from repository '" + repositoryName + "'");
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while deleting index snapshot, Snapshot name : '" + snapshotName + "'!");
            throw e;
        }
        return response;
    }

    public Response restoreIndex(String indexName, String indexRestoreName, String snapshotName, String repositoryName, boolean waitForCompletion) throws Exception {
        Response response = null;
        try {
            LOGGER.info("Going to restore index '" + indexName + "' from snapshot '" + snapshotName + "'");
            NStringEntity entity = new NStringEntity("{\"indices\": \"" + indexName + "\",\"ignore_unavailable\": true,\"include_global_state\": false,\"rename_pattern\": \"" + indexName + "\",\"rename_replacement\": \"" + indexRestoreName + "\"}", ContentType.APPLICATION_JSON);
            response = this.client.performRequest("POST", "/_snapshot/" + repositoryName + "/" + snapshotName + "/_restore" + (waitForCompletion ? "?wait_for_completion=true" : ""), Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            LOGGER.info("Restored index snapshot '" + snapshotName + "' successfully! Restore Index Name : '" + indexRestoreName + "'");
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while restoring index snapshot, Snapshot name : '" + snapshotName + "'!");
            throw e;
        }
        return response;
    }

    public Response createIndexTemplate(String templateName, String templateStr) throws Exception {
        Response response = null;
        try {
            LOGGER.info("ES :: Going to create index template '" + templateName + "'...");
            NStringEntity entity = new NStringEntity(templateStr, ContentType.APPLICATION_JSON);
            response = this.client.performRequest("PUT", "/_template/" + templateName, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            LOGGER.info("ES :: Index template '" + templateName + "' created succesfully!");
        }
        catch (Exception re) {
            LOGGER.severe("EXCEPTION while creating index template '" + templateName + "'!");
            throw re;
        }
        return response;
    }

    public JSONObject getIndexTemplateList() throws Exception {
        JSONObject templateObj = null;
        try {
            LOGGER.info("ES :: Fetching ES index templates...");
            Response indexResponse = this.client.performRequest("GET", "/_template", Collections.emptyMap(), new Header[0]);
            String jsonStr = EntityUtils.toString((HttpEntity)indexResponse.getEntity());
            templateObj = new JSONObject(jsonStr);
            LOGGER.info(jsonStr);
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while fetching index templates!");
            throw e;
        }
        return templateObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject addData(CtlrDataRepository dataRepo, String fileAbsName) throws Exception {
        JSONObject jRes = new JSONObject();
        BufferedReader br = null;
        StringBuilder bulkStr = null;
        JSONObject docObj = null;
        String line = null;
        String url = "/_bulk";
        String instanceName = "DefaultInstance";
        try {
            NStringEntity entity;
            int batchCount = 1000;
            int processedCount = 0;
            int totalProcessedCount = 0;
            boolean processedCountTotal = false;
            bulkStr = new StringBuilder();
            Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/x-ndjson")};
            Charset encoding = Charset.forName("UTF-8");
            String splitBy = "\\^";
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileAbsName), encoding));
            processedCount = 0;
            while ((line = br.readLine()) != null) {
                docObj = this.getElasticDoc(line, splitBy, dataRepo.getIndexFieldNameList());
                String indexName = dataRepo.getHotBlockRotationType().compareTo((Enum)DRBlockRotationType.SIZE) == 0 ? dataRepo.getHotBlockName(0) : DRBlockUtil.getBlockName((long)Long.parseLong(docObj.getString(dataRepo.getRangeField())), (String)dataRepo.getBlockPrefix(), (DRBlockRotationType)dataRepo.getHotBlockRotationType());
                bulkStr.append("{ \"index\" : { \"_index\" : \"" + indexName + "\", \"_type\" : \"" + instanceName + "\" } }\n");
                bulkStr.append(docObj.toString() + "\n");
                ++totalProcessedCount;
                if (++processedCount < batchCount) continue;
                if (!bulkStr.toString().trim().isEmpty()) {
                    bulkStr.append("\n");
                    entity = new NStringEntity(bulkStr.toString());
                    this.sendRequest(url, (HttpEntity)entity, headers);
                }
                bulkStr = new StringBuilder();
                processedCount = 0;
            }
            if (!bulkStr.toString().trim().isEmpty()) {
                bulkStr.append("\n");
                entity = new NStringEntity(bulkStr.toString());
                this.sendRequest(url, (HttpEntity)entity, headers);
            }
            dataRepo.incrHotBlockDocCount(totalProcessedCount);
            if (dataRepo.reachedMaxBlockDocCount()) {
                dataRepo.rolloverBlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.severe("EXCEPTION indexFiles :: bulkStr :: " + bulkStr);
            LOGGER.severe("EXCEPTION indexFiles :: docObj :: " + docObj);
            LOGGER.severe("EXCEPTION indexFiles :: line :: " + line);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            new File(fileAbsName).delete();
        }
        return jRes;
    }

    @Override
    public JSONObject addData(CtlrDataRepository dataRepo, JSONArray dataArr) throws Exception {
        throw new Exception("index(CtlrDataRepository, JSONArray) method not implemented for elastic!");
    }

    @Override
    public JSONObject deleteData(CtlrDataRepository dataRepo, String queryText) throws Exception {
        throw new Exception("deleteData(CtlrDataRepository, String) method not implemented for elastic!");
    }

    public ArrayList<String> getIndexNameList(String indexPattern) throws Exception {
        ArrayList<String> indexList = new ArrayList<String>();
        try {
            LOGGER.info("ES :: Fetching index list...");
            Response indexResponse = this.client.performRequest("GET", "_cat/indices/" + (indexPattern == null || indexPattern.trim().isEmpty() ? "" : indexPattern), Collections.emptyMap(), new Header[0]);
            if (indexResponse != null) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(indexResponse.getEntity().getContent()));
                while ((line = br.readLine()) != null) {
                    indexList.add(line.split(" ")[2]);
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while fetching index list!");
            throw e;
        }
        return indexList;
    }

    @Override
    public HashMap<String, Object> executeSearchQuery(DEParams deParams) throws Exception {
        HashMap<String, Object> queryResult = null;
        if (deParams.viw.query.obj != null) {
            switch (deParams.viw.query.obj.getQueryType()) {
                case SEARCH_ONLY: {
                    queryResult = this.getSearchOnlyQueryResult(deParams);
                    break;
                }
                case UNIQUE_COUNT: {
                    queryResult = this.getUniqueCountQueryResult(deParams);
                    break;
                }
                case AGGR_STATS: {
                    queryResult = this.getMinMaxQueryResult(deParams);
                    break;
                }
                case AGGR_TERMS_COUNT: {
                    queryResult = this.getNavGroupQueryResult(deParams);
                    break;
                }
                case AGGR_TERMS_STATS: 
                case AGGR_TERMS_DATE_HISTOGRAM: 
                case AGGR_TERMS_SUMMARY: 
                case COUNT: 
                case AGGR_DATE_HISTOGRAM: {
                    throw new Exception("Query type not handled!");
                }
            }
        }
        return queryResult;
    }

    @Override
    public JSONObject executeSearchQuery(JSONObject jsonObject) throws Exception {
        throw new Exception("Elastic query(JSONObject) functionality not implemented!");
    }

    @Override
    public JSONObject executeQuery(JSONObject jsonObject) throws Exception {
        throw new Exception("Elastic query(JSONObject) functionality not implemented!");
    }

    protected HashMap<String, Object> getSearchOnlyQueryResult(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        deParams.viw.query.query_text = deParams.viw.query.obj.getParsedElasticQueryStr(deParams, null);
        JSONObject hitsObj = null;
        JSONArray hitsArr = null;
        int pageSize = deParams.viw.rtable.page_size;
        int reportFrom = deParams.viw.rtable.row_from;
        int reportTo = reportFrom + pageSize - 1;
        int maxResultCount = 10000;
        int queryCount = (reportTo - 1) / maxResultCount + 1;
        int hitsLen = 0;
        this.changeSortColNameByType(deParams);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < queryCount; ++i) {
            deParams.viw.rtable.page_size = reportTo <= (i + 1) * maxResultCount ? Integer.valueOf(reportTo - i * maxResultCount) : Integer.valueOf(maxResultCount);
            hitsObj = this.queryIndex(deParams);
            hitsArr = (hitsObj = hitsObj.getJSONObject("hits")).getJSONArray("hits");
            hitsLen = hitsArr.length();
            if (hitsLen <= 0) continue;
            JSONObject lastRecObj = hitsArr.getJSONObject(hitsLen - 1);
            deParams.viw.query.search_after_arr = lastRecObj.optJSONArray("sort");
        }
        long endTime = System.currentTimeMillis();
        int actualFrom = reportFrom % maxResultCount - 1;
        int actualTo = hitsLen - 1;
        retMap.put("actualFrom", actualFrom);
        retMap.put("actualTo", actualTo);
        retMap.put("hitsObj", hitsObj);
        LOGGER.info("QUERY TIME : [Hits : " + hitsObj.getInt("total") + "] [Total Indices : " + deParams.viw.query.obj.getTotalIndices() + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        return retMap;
    }

    protected HashMap<String, Object> getUniqueCountQueryResult(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        deParams.viw.query.query_text = deParams.viw.query.obj.getParsedElasticQueryStr(deParams, null);
        int count = -1;
        this.changeGroupByColNameByType(deParams);
        long startTime = System.currentTimeMillis();
        JSONObject respObj = this.queryIndex(deParams);
        JSONObject aggsObj = respObj.optJSONObject("aggregations");
        if (aggsObj != null) {
            aggsObj = aggsObj.optJSONObject("unique_col_val_count_1");
            count = aggsObj.optInt("value");
        }
        long endTime = System.currentTimeMillis();
        retMap.put("uniqueColValCount", count);
        LOGGER.info("QUERY TIME : [Hits : " + respObj.optJSONObject("hits").getInt("total") + "] [Total Indices : " + deParams.viw.query.obj.getTotalIndices() + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        return retMap;
    }

    protected HashMap<String, Object> getGroupQueryResult(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        deParams.viw.query.query_text = deParams.viw.query.obj.getParsedElasticQueryStr(deParams, null);
        this.changeGroupByColNameByType(deParams);
        long startTime = System.currentTimeMillis();
        JSONObject respObj = this.queryIndex(deParams);
        JSONObject aggsObj = respObj.optJSONObject("aggregations");
        if (aggsObj != null) {
            aggsObj = aggsObj.optJSONObject("group_by_field_1");
        }
        long endTime = System.currentTimeMillis();
        retMap.put("aggrResult", aggsObj);
        LOGGER.info("QUERY TIME : [Hits : " + respObj.optJSONObject("hits").getInt("total") + "] [Total Indices : " + deParams.viw.query.obj.getTotalIndices() + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        return retMap;
    }

    protected HashMap<String, Object> getNavGroupQueryResult(DEParams deParams) throws Exception {
        int batchSize = 25;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONObject respObj = null;
        JSONObject aggsObj = null;
        JSONArray bucketList = null;
        deParams.viw.query.query_text = deParams.viw.query.obj.getParsedElasticQueryStr(deParams, null);
        this.changeSortColNameByType(deParams);
        this.changeGroupByColNameByType(deParams);
        int pageSize = deParams.viw.rtable.page_size;
        int reportFrom = deParams.viw.rtable.row_from;
        int reportTo = reportFrom + pageSize - 1;
        int queryCount = (reportTo - 1) / batchSize + 1;
        int bucketSize = 0;
        batchSize = deParams.viw.rtable.page_size;
        deParams.viw.query.group_by_exclude_list = new ArrayList();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < queryCount; ++i) {
            deParams.viw.rtable.page_size = reportTo <= (i + 1) * batchSize ? Integer.valueOf(reportTo - i * batchSize) : Integer.valueOf(batchSize);
            respObj = this.queryIndex(deParams);
            aggsObj = respObj.optJSONObject("aggregations");
            bucketSize = 0;
            if (aggsObj != null) {
                aggsObj = aggsObj.optJSONObject("group_by_field_1");
                bucketList = aggsObj.getJSONArray("buckets");
                bucketSize = bucketList.length();
            }
            for (int bi = 0; bi < bucketSize; ++bi) {
                JSONObject bucketObj = bucketList.getJSONObject(bi);
                deParams.viw.query.group_by_exclude_list.add("\"" + bucketObj.getString("key") + "\"");
            }
        }
        long endTime = System.currentTimeMillis();
        int actualFrom = reportFrom % batchSize - 1;
        int actualTo = bucketSize - 1;
        retMap.put("aggrResult", aggsObj);
        retMap.put("actualFrom", actualFrom);
        retMap.put("actualTo", actualTo);
        LOGGER.info("QUERY TIME : [Hits : " + respObj.optJSONObject("hits").getInt("total") + "] [Total Indices : " + deParams.viw.query.obj.getTotalIndices() + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        return retMap;
    }

    protected HashMap<String, Object> getMinMaxQueryResult(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONObject respObj = null;
        retMap.put("minValue", -1L);
        retMap.put("maxValue", -1L);
        if (deParams.viw.query.obj != null) {
            deParams.viw.query.query_text = deParams.viw.query.obj.getParsedElasticQueryStr(deParams, null);
        }
        long startTime = System.currentTimeMillis();
        respObj = this.queryIndex(deParams);
        JSONObject aggsObj = respObj.optJSONObject("aggregations");
        if (aggsObj != null) {
            if (aggsObj.has("min_value") && !aggsObj.getJSONObject("min_value").isNull("value")) {
                retMap.put("minValue", aggsObj.getJSONObject("min_value").getLong("value"));
            }
            if (aggsObj.has("max_value") && !aggsObj.getJSONObject("max_value").isNull("value")) {
                retMap.put("maxValue", aggsObj.getJSONObject("max_value").getLong("value"));
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("QUERY TIME : [Hits : " + respObj.optJSONObject("hits").getInt("total") + "] [Total Indices : " + deParams.viw.query.obj.getTotalIndices() + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        return retMap;
    }

    public JSONObject queryIndex(DEParams deParams) {
        JSONObject respObj = null;
        String esQueryStr = null;
        try {
            esQueryStr = ElasticRestQueryBuilder.getRestQueryString(deParams);
            NStringEntity entity = new NStringEntity(esQueryStr, ContentType.APPLICATION_JSON);
            LOGGER.info("Querying ES, Query(Type " + deParams.viw.query.obj.getQueryType() + ") : " + esQueryStr);
            Response indexResponse = this.client.performRequest("GET", "/_search", Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            respObj = new JSONObject(EntityUtils.toString((HttpEntity)indexResponse.getEntity()));
        }
        catch (Exception e) {
            LOGGER.severe("EXCEPTION while querying ES, Query(Type " + deParams.viw.query.obj.getQueryType() + ") : " + esQueryStr);
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
        return respObj;
    }

    private void sendRequest(String url, HttpEntity entity, Header[] headers) {
        try {
            Response response = this.client.performRequest("POST", url, Collections.emptyMap(), entity, headers);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                LOGGER.severe("Err Entity : " + EntityUtils.toString((HttpEntity)entity));
            }
            catch (Exception er) {
                er.printStackTrace();
            }
        }
    }

    private JSONObject getElasticDoc(String line, String splitBy, ArrayList<String> fieldList) throws Exception {
        int i;
        JSONObject docObj = new JSONObject();
        String[] aColStr = line.split(splitBy, -1);
        int actualColLen = aColStr.length;
        int totalCols = fieldList.size();
        for (i = 0; i < actualColLen; ++i) {
            if (aColStr[i] == null || aColStr[i].isEmpty()) {
                docObj.put(fieldList.get(i), (Object)"-");
                continue;
            }
            docObj.put(fieldList.get(i), (Object)aColStr[i]);
        }
        for (i = actualColLen; i < totalCols; ++i) {
            docObj.put(fieldList.get(i), (Object)"-");
        }
        return docObj;
    }

    private void changeSortColNameByType(DEParams deParams) {
        int sortColCount = deParams.viw.query.sort_col_list.size();
        ArrayList<CtlrDataRepository> refRepoList = deParams.viw.query.obj.getRefDataRepositoryList();
        block0: for (int i = 0; i < sortColCount; ++i) {
            for (CtlrDataRepository deRepo : refRepoList) {
                String type = deRepo.getIndexField(deParams.viw.query.sort_col_list.get(i).toUpperCase()).getDataType();
                if (type == null) continue;
                if (!type.equals("text")) continue block0;
                deParams.viw.query.sort_col_list.set(i, deParams.viw.query.sort_col_list.get(i) + ".NA");
                continue block0;
            }
        }
    }

    private void changeGroupByColNameByType(DEParams deParams) {
        ArrayList<String> groupByColList = deParams.viw.query.obj.getGroupByColList();
        int groupColCount = groupByColList.size();
        ArrayList<CtlrDataRepository> refRepoList = deParams.viw.query.obj.getRefDataRepositoryList();
        block0: for (int i = 0; i < groupColCount; ++i) {
            for (CtlrDataRepository deRepo : refRepoList) {
                String type = deRepo.getIndexField(groupByColList.get(i).toUpperCase()).getDataType();
                if (type == null) continue;
                if (!type.equals("text")) continue block0;
                groupByColList.set(i, groupByColList.get(i).toUpperCase() + ".NA");
                continue block0;
            }
        }
    }

    @Override
    public JSONObject syncDR(JSONArray drList) throws Exception {
        throw new Exception("syncDR(JSONArray) method not implemented for elastic!");
    }

    @Override
    public JSONObject updateDR(JSONArray drList) throws Exception {
        throw new Exception("updateDR method not implemented for elastic!");
    }

    @Override
    public JSONObject syncDRSchema(JSONObject drSchemaList) throws Exception {
        throw new Exception("syncDRSchema method not implemented for elastic!");
    }

    @Override
    public JSONObject syncDRBlocksMetaInfo(JSONObject drList) throws Exception {
        throw new Exception("syncDRBlocksMetaInfo method not implemented for elastic!");
    }

    @Override
    public JSONObject fetchDRBlocksMetaInfo(JSONArray drList, Long startDate, Long endDate, int from, int range, String sortField, String sortOrder, String searchText, boolean isMain) throws Exception {
        throw new Exception("fetchDRBlocksMetaInfo method not implemented for elastic!");
    }

    @Override
    public int fetchDRBlocksCount(JSONArray drList, Long startDate, Long endDate, boolean isMain, String searchText) throws Exception {
        throw new Exception("fetchDRBlocksCount method not implemented for elastic!");
    }

    @Override
    public JSONObject fetchMainDRBlocksDiskSize(JSONArray drList) throws Exception {
        throw new Exception("fetchMainDRBlocksDiskSize method not implemented for elastic!");
    }

    @Override
    public JSONObject fetchMainDRBlocksDiskSizeOlderThan(JSONArray drList) throws Exception {
        throw new Exception("fetchRetentionCrossedMainDRBlocksDiskSize method not implemented for elastic!");
    }

    @Override
    public boolean archiveOldBlocks() throws Exception {
        throw new Exception("archiveOldBlocks method not implemented for elastic!");
    }

    @Override
    public boolean loadArchiveBlocks(CtlrDataRepository dataRepo, String fileName, boolean canLoad, String availableSize) throws Exception {
        throw new Exception("loadArchiveBlocks method not implemented for elastic!");
    }

    @Override
    public boolean unloadArchiveBlocks(CtlrDataRepository dataRepo, String fileName) throws Exception {
        throw new Exception("unloadArchiveBlocks method not implemented for elastic!");
    }

    @Override
    public boolean updateArchiveLocation(JSONArray locationList, boolean clean, boolean isCurrentPathUpdate) throws Exception {
        throw new Exception("updateArchiveLocation method not implemented for elastic!");
    }

    @Override
    public JSONObject addMigrationData(CtlrDataRepository dataRepo, JSONArray fileList, long creationTime, String encoding, Character splitBy) throws Exception {
        throw new Exception("addMigrationData method not implemented for elastic!");
    }

    @Override
    public JSONObject validateMigrationData(CtlrDataRepository dataRepo, long creationTime) throws Exception {
        throw new Exception("validateMigrationData method not implemented for elastic!");
    }

    @Override
    public JSONObject fetchToBeDeletedBlocksMetaInfo(JSONArray drList, long startTime, long endTime, String searchText) throws Exception {
        throw new Exception("fetchToBeDetletedBlocksMetaInfo method not implemented for elastic!");
    }

    @Override
    public JSONObject fetchArchivePageInfo(JSONArray drList) throws Exception {
        throw new Exception("fetchArchivePageInfo method not implemented for elastic");
    }

    @Override
    public boolean updateSchedulerInterval(int hourOfTheDay) throws Exception {
        throw new Exception("updateSchedulerInterval method not implemented for elastic!");
    }

    @Override
    public JSONObject fetchDeletedBlocksMetaInfo(JSONArray drList, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText) throws Exception {
        throw new Exception("fetchDeletedBlocksMetaInfo method not implemented for elastic!");
    }

    @Override
    public boolean addColumn(String columnName, String columnType, String defaultValue, boolean isMain) throws Exception {
        throw new UnsupportedOperationException("Unimplemented method 'addColumn'");
    }

    @Override
    public boolean updateColumn(String columnName, String value, boolean isMain) throws Exception {
        throw new UnsupportedOperationException("Unimplemented method 'updateColumn'");
    }
}

