/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.netcalls;

import com.manageengine.dataengine.controller.connector.client.transport.XNodeTcpClient;
import com.manageengine.dataengine.controller.connector.netcalls.AdminNetCalls;
import com.manageengine.dataengine.controller.engine.node.XNode;
import java.util.logging.Logger;
import org.json.JSONObject;

public class XNodeTcpAdminNetCalls
implements AdminNetCalls {
    private XNode xnode;
    private boolean isLiveConnection;
    private XNodeTcpClient xnodeLiveClient;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public XNodeTcpAdminNetCalls(XNode xnode) {
        this.xnode = xnode;
        this.isLiveConnection = false;
        if (this.isLiveConnection) {
            this.xnodeLiveClient = new XNodeTcpClient(xnode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fetchNodeState() throws Exception {
        XNodeTcpClient client = null;
        String healthStatus = "";
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            JSONObject jReq = new JSONObject();
            jReq.put("action", (Object)"admin:/health");
            jReq.put("de_health", true);
            LOGGER.info("XNode REQUEST : " + jReq);
            JSONObject jResp = client.sendMessage(jReq);
            LOGGER.info("XNode RESPONSE : " + jResp);
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
            if (jResp.has("de_health")) {
                healthStatus = jResp.getString("de_health");
            }
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return healthStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject fetchNodeStateAndNotifications() throws Exception {
        XNodeTcpClient client = null;
        JSONObject response = new JSONObject();
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            JSONObject jReq = new JSONObject();
            jReq.put("action", (Object)"admin:/health");
            jReq.put("de_health", true);
            LOGGER.info("XNode REQUEST : " + jReq);
            JSONObject jResp = client.sendMessage(jReq);
            LOGGER.info("XNode RESPONSE : " + jResp);
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
            if (jResp.has("de_health")) {
                response = jResp;
            }
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return response;
    }

    @Override
    public boolean verifyNodeState(String eStatus) throws Exception {
        boolean statusMatch = false;
        LOGGER.info("Checking XNode state, expected state : " + eStatus);
        String aStatus = this.fetchNodeState();
        statusMatch = eStatus.equals(aStatus);
        return statusMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject fetchNodeInfo() throws Exception {
        XNodeTcpClient client = null;
        JSONObject jResp = new JSONObject();
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            JSONObject jReq = new JSONObject();
            jReq.put("action", (Object)"admin:/xnode_info");
            LOGGER.info("XNode REQUEST : " + jReq);
            jResp = client.sendMessage(jReq);
            LOGGER.info("XNode RESPONSE : " + jResp);
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return jResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject updateSecuritySettings(JSONObject conf) throws Exception {
        XNodeTcpClient client = null;
        JSONObject jResp = new JSONObject();
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            conf.put("action", (Object)"admin:/update_security_settings");
            jResp = client.sendMessage(conf);
            LOGGER.info("XNode RESPONSE : " + jResp);
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return jResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNode() throws Exception {
        XNodeTcpClient client = null;
        JSONObject jResp = new JSONObject();
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            JSONObject jReq = new JSONObject();
            jReq.put("action", (Object)"admin:/shutdown");
            LOGGER.info("XNode REQUEST : " + jReq);
            jResp = client.sendMessage(jReq);
            LOGGER.info("XNode RESPONSE : " + jResp);
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject isArchiveRunning() throws Exception {
        XNodeTcpClient client = null;
        JSONObject jResp = new JSONObject();
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            JSONObject jReq = new JSONObject();
            jReq.put("action", (Object)"admin:/archive_info");
            LOGGER.info("XNode REQUEST : " + jReq);
            jResp = client.sendMessage(jReq);
            LOGGER.info("XNode RESPONSE : " + jResp);
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return jResp;
    }

    private boolean checkForError(JSONObject jResp) throws Exception {
        boolean errStatus = true;
        if (jResp == null || !jResp.has("response")) {
            throw new Exception("EXCEPTION while processing request on XNode null/no response received!!");
        }
        if (jResp.has("response") && (jResp = jResp.getJSONObject("response")).has("error_code")) {
            int errorCode = jResp.getInt("error_code");
            if (errorCode != 0) {
                if (jResp.has("error_msg")) {
                    throw new Exception("EXCEPTION while processing request on XNode, Msg : " + jResp.getString("error_msg"));
                }
                throw new Exception("EXCEPTION while processing request on XNode, Error Code : " + errorCode);
            }
            errStatus = false;
        }
        return errStatus;
    }
}

