/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.connector.netcalls;

import com.csvreader.CsvReader;
import com.manageengine.dataengine.controller.connector.client.transport.XNodeTcpClient;
import com.manageengine.dataengine.controller.connector.netcalls.DRNetCalls;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.engine.node.XNode;
import com.manageengine.dataengine.controller.view.DEParams;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class XNodeTcpDRNetCalls
implements DRNetCalls {
    private XNode xnode;
    private XNodeTcpClient xnodeIndexLiveClient;
    private XNodeTcpClient xnodeQueryLiveClient;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    public static volatile int totalReq = 0;
    public static volatile int totalRecords = 0;
    public static final char DE_SPLIT_BY = '\t';
    public static final String DE_ENCODING = "UTF-8";

    public XNodeTcpDRNetCalls(XNode xnode) {
        this.xnode = xnode;
        this.xnodeIndexLiveClient = new XNodeTcpClient(xnode);
        this.xnodeQueryLiveClient = new XNodeTcpClient(xnode);
    }

    @Override
    public JSONObject syncDR(JSONArray drList) throws Exception {
        JSONObject drSyncObject = new JSONObject();
        drSyncObject.put("dr_list", (Object)drList);
        drSyncObject.put("action", (Object)"dr:/dr_sync");
        return this.executeQuery(drSyncObject);
    }

    @Override
    public JSONObject updateDR(JSONArray drList) throws Exception {
        JSONObject drSyncObject = new JSONObject();
        drSyncObject.put("dr_list", (Object)drList);
        drSyncObject.put("action", (Object)"dr:/dr_update");
        return this.executeQuery(drSyncObject);
    }

    @Override
    public JSONObject syncDRSchema(JSONObject drSchemaList) throws Exception {
        JSONObject schemaSyncObject = new JSONObject();
        schemaSyncObject.put("dr_schema_list", (Object)drSchemaList);
        schemaSyncObject.put("action", (Object)"dr:/dr_schema_sync");
        return this.executeQuery(schemaSyncObject);
    }

    @Override
    public JSONObject syncDRBlocksMetaInfo(JSONObject drBlocksList) throws Exception {
        JSONObject blockSyncObject = new JSONObject();
        blockSyncObject.put("dr_list", (Object)drBlocksList);
        blockSyncObject.put("action", (Object)"dr:/dr_blocks_meta_sync");
        return this.executeQuery(blockSyncObject);
    }

    @Override
    public JSONObject fetchDRBlocksMetaInfo(JSONArray drList, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText, boolean isMain) throws Exception {
        JSONObject fetchObj = new JSONObject();
        fetchObj.put("dr_is_main", isMain);
        fetchObj.put("from_time", (Object)startDate);
        fetchObj.put("to_time", (Object)endDate);
        fetchObj.put("sort_field", (Object)sortColumn);
        fetchObj.put("sort_order", (Object)sortOrder);
        fetchObj.put("size", range);
        fetchObj.put("offset", from);
        fetchObj.put("dr_name_list", (Object)drList);
        if (searchText != null && !searchText.isEmpty()) {
            fetchObj.put("search_text", (Object)searchText);
        }
        fetchObj.put("action", (Object)"dr:/dr_blocks_meta_fetch");
        return this.executeQuery(fetchObj);
    }

    @Override
    public int fetchDRBlocksCount(JSONArray drList, Long startDate, Long endDate, boolean isMain, String searchText) throws Exception {
        JSONObject fetchObj = new JSONObject();
        fetchObj.put("dr_is_main", isMain);
        fetchObj.put("from_time", (Object)startDate);
        fetchObj.put("to_time", (Object)endDate);
        fetchObj.put("dr_name_list", (Object)drList);
        if (searchText != null && !searchText.isEmpty()) {
            fetchObj.put("search_text", (Object)searchText);
        }
        fetchObj.put("action", (Object)"dr:/dr_blocks_count_fetch");
        return this.executeQuery(fetchObj).getInt("dr_blocks_count");
    }

    @Override
    public JSONObject fetchMainDRBlocksDiskSize(JSONArray drList) throws Exception {
        JSONObject fetchObj = new JSONObject();
        fetchObj.put("dr_name_list", (Object)drList);
        fetchObj.put("action", (Object)"dr:/dr_main_blocks_disk_size_fetch");
        return this.executeQuery(fetchObj);
    }

    @Override
    public JSONObject fetchMainDRBlocksDiskSizeOlderThan(JSONArray drList) throws Exception {
        JSONObject fetchObj = new JSONObject();
        fetchObj.put("dr_name_list", (Object)drList);
        fetchObj.put("action", (Object)"dr:/dr_main_blocks_disk_size_older_than_fetch");
        return this.executeQuery(fetchObj);
    }

    @Override
    public boolean archiveOldBlocks() throws Exception {
        this.executeQuery(new JSONObject().put("action", (Object)"dr:/dr_archive_old_blocks"));
        return true;
    }

    @Override
    public boolean loadArchiveBlocks(CtlrDataRepository dataRepo, String fileName, boolean canLoad, String availableSpace) throws Exception {
        return this.loadUnloadArchiveBlocks(dataRepo, fileName, true, canLoad, availableSpace);
    }

    @Override
    public boolean unloadArchiveBlocks(CtlrDataRepository dataRepo, String fileName) throws Exception {
        return this.loadUnloadArchiveBlocks(dataRepo, fileName, false, false, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadUnloadArchiveBlocks(CtlrDataRepository dataRepo, String fileName, boolean isLoad, boolean canLoad, String availableSpace) throws Exception {
        XNodeTcpClient client = null;
        boolean isSuccess = true;
        try {
            JSONObject jobj = new JSONObject();
            jobj.put("action", (Object)(isLoad ? "dr:/dr_archive_blocks_load" : "dr:/dr_archive_blocks_unload"));
            jobj.put("dr_name", (Object)dataRepo.getRepositoryName());
            jobj.put("dr_block_name", (Object)fileName);
            if (isLoad) {
                jobj.put("can_load", canLoad);
                jobj.put("available_disk_space", (Object)availableSpace);
            }
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            JSONObject jResp = client.sendMessage(jobj);
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
            if (jResp.has("error_count") && jResp.getInt("error_count") != 0) {
                isSuccess = false;
                LOGGER.warning("WARNING : Parsing exception while defrosting file : " + fileName + ", error line count : " + jResp.getInt("error_count"));
            }
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return isSuccess;
    }

    @Override
    public boolean updateArchiveLocation(JSONArray locationList, boolean clean, boolean isCurrentPathUpdate) throws Exception {
        boolean isSuccess = true;
        JSONObject locationObj = new JSONObject();
        locationObj.put("archive_location_list", (Object)locationList);
        locationObj.put("action", (Object)"dr:/dr_archive_locations_sync");
        locationObj.put("archive_location_clean", clean);
        locationObj.put("archive_location_current_path_update", isCurrentPathUpdate);
        JSONObject jResp = this.executeQuery(locationObj);
        if (jResp.has("error_code")) {
            isSuccess = jResp.getInt("error_code") == 0;
        }
        return isSuccess;
    }

    @Override
    public JSONObject fetchToBeDeletedBlocksMetaInfo(JSONArray drList, long startTime, long endTime, String searchText) throws Exception {
        JSONObject fetchObj = new JSONObject();
        fetchObj.put("dr_name_list", (Object)drList);
        fetchObj.put("from_time", startTime);
        fetchObj.put("to_time", endTime);
        fetchObj.put("search_text", (Object)searchText);
        fetchObj.put("action", (Object)"dr:/dr_to_delete_blocks_meta_fetch");
        return this.executeQuery(fetchObj);
    }

    @Override
    public boolean updateSchedulerInterval(int hourOfTheDay) throws Exception {
        JSONObject jObj = new JSONObject();
        jObj.put("dr_archive_scheduler_interval", hourOfTheDay);
        jObj.put("action", (Object)"dr:/dr_archive_scheduler_sync");
        this.executeQuery(jObj);
        return true;
    }

    @Override
    public JSONObject fetchArchivePageInfo(JSONArray drList) throws Exception {
        JSONObject jObj = new JSONObject();
        jObj.put("dr_name_list", (Object)drList);
        jObj.put("action", (Object)"dr:/dr_archive_page_info_fetch");
        return this.executeQuery(jObj);
    }

    @Override
    public JSONObject addData(CtlrDataRepository dataRepo, String fileAbsName) throws Exception {
        JSONObject jobj = new JSONObject();
        jobj.put("action", (Object)"dr:/dr_data_add");
        if (this.xnode.isLocal()) {
            jobj.put("data_file_path", (Object)fileAbsName);
        } else {
            jobj.put("data_doc_list", (Object)this.convertFileContentToArray(dataRepo, fileAbsName));
        }
        jobj.put("dr_name", (Object)dataRepo.getRepositoryName());
        jobj.put("file_encoding", (Object)DE_ENCODING);
        jobj.put("file_line_split_by", (Object)"\t");
        return this.addData(dataRepo, jobj);
    }

    @Override
    public JSONObject addData(CtlrDataRepository dataRepo, JSONArray dataArr) throws Exception {
        JSONObject jobj = new JSONObject();
        jobj.put("action", (Object)"dr:/dr_data_add");
        jobj.put("data_doc_list", (Object)dataArr);
        jobj.put("dr_name", (Object)dataRepo.getRepositoryName());
        jobj.put("file_encoding", (Object)DE_ENCODING);
        jobj.put("file_line_split_by", (Object)"\t");
        return this.addData(dataRepo, jobj);
    }

    @Override
    public JSONObject addMigrationData(CtlrDataRepository dataRepo, JSONArray fileList, long creationTime, String encoding, Character splitBy) throws Exception {
        JSONObject jobj = new JSONObject();
        jobj.put("action", (Object)"dr:/dr_migration_data_add");
        jobj.put("data_file_path_list", (Object)fileList);
        jobj.put("dr_name", (Object)dataRepo.getRepositoryName());
        jobj.put("creation_time", creationTime);
        jobj.put("file_encoding", (Object)encoding);
        jobj.put("file_line_split_by", (Object)("" + splitBy));
        return this.executeQuery(jobj);
    }

    @Override
    public JSONObject validateMigrationData(CtlrDataRepository dataRepo, long creationTime) throws Exception {
        JSONObject jobj = new JSONObject();
        jobj.put("action", (Object)"dr:/dr_migration_data_validate");
        jobj.put("dr_name", (Object)dataRepo.getRepositoryName());
        jobj.put("creation_time", creationTime);
        return this.executeQuery(jobj);
    }

    private JSONObject addData(CtlrDataRepository dataRepo, JSONObject jobj) throws Exception {
        if (!this.xnodeIndexLiveClient.isConnected()) {
            this.xnodeIndexLiveClient.connect();
        }
        long startTime = System.currentTimeMillis();
        JSONObject jResp = this.xnodeIndexLiveClient.sendMessage(jobj);
        LOGGER.info("XNode Total Add Time : " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " secs, Count : " + jResp.getJSONObject("response").optInt("indexed_doc_count", 0));
        ++totalReq;
        this.checkForError(jResp);
        jResp = jResp.getJSONObject("response");
        totalRecords += jResp.optInt("indexed_doc_count", 0);
        return jResp;
    }

    @Override
    public JSONObject deleteData(CtlrDataRepository dataRepo, String queryText) throws Exception {
        JSONObject jobj = new JSONObject();
        jobj.put("action", (Object)"dr:/dr_data_delete");
        jobj.put("dr_name", (Object)dataRepo.getRepositoryName());
        jobj.put("query", (Object)queryText);
        return this.executeQuery(jobj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject executeQuery(JSONObject jsonObject) throws Exception {
        XNodeTcpClient client = null;
        JSONObject jResp = null;
        try {
            client = new XNodeTcpClient(this.xnode);
            client.connect();
            long startTime = System.currentTimeMillis();
            LOGGER.fine("XNode REQUEST : " + jsonObject);
            jResp = client.sendMessage(jsonObject);
            LOGGER.fine("XNode RESPONSE : " + jResp);
            LOGGER.info("XNode Total Time : " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " secs");
            this.checkForError(jResp);
            jResp = jResp.getJSONObject("response");
        }
        finally {
            if (client != null) {
                client.disConnect();
            }
        }
        return jResp;
    }

    @Override
    public JSONObject executeSearchQuery(JSONObject jsonObject) throws Exception {
        JSONObject jResp = null;
        if (!this.xnodeQueryLiveClient.isConnected()) {
            this.xnodeQueryLiveClient.connect();
        }
        long startTime = System.currentTimeMillis();
        LOGGER.fine("XNode REQUEST : " + jsonObject);
        jResp = this.xnodeQueryLiveClient.sendMessage(jsonObject);
        LOGGER.fine("XNode RESPONSE : " + jResp);
        LOGGER.info("XNode Total Time : " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " secs");
        this.checkForError(jResp);
        jResp = jResp.getJSONObject("response");
        return jResp;
    }

    @Override
    public HashMap<String, Object> executeSearchQuery(DEParams deParams) throws Exception {
        HashMap<String, Object> queryResult = null;
        if (deParams.viw.query.obj != null) {
            switch (deParams.viw.query.obj.getQueryType()) {
                case SEARCH_ONLY: {
                    queryResult = this.getSearchOnlyQueryResultType(deParams);
                    break;
                }
                case AGGR_TERMS_COUNT: 
                case AGGR_TERMS_STATS: 
                case AGGR_TERMS_SUMMARY: 
                case AGGR_TERMS_DATE_HISTOGRAM: 
                case AGGR_TERMS_SUMMARY_STATS: {
                    queryResult = this.getGroupQueryResultType(deParams);
                    break;
                }
                case AGGR_STATS: {
                    queryResult = this.getAggrQueryResultType(deParams);
                    break;
                }
                case AGGR_DATE_HISTOGRAM: {
                    queryResult = this.getAggrDateHistogramQueryResultType(deParams);
                    break;
                }
                case COUNT: 
                case UNIQUE_COUNT: {
                    throw new Exception("Query type not handled!");
                }
            }
        }
        return queryResult;
    }

    private HashMap<String, Object> getSearchOnlyQueryResultType(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONArray hitsArr = new JSONArray();
        int totalHits = 0;
        JSONArray jSortCols = new JSONArray();
        for (String string : deParams.viw.query.sort_col_list) {
            jSortCols.put((Object)string);
        }
        JSONArray jSortOrders = new JSONArray();
        for (String string : deParams.viw.query.sort_col_order) {
            jSortOrders.put((Object)string);
        }
        JSONArray jSONArray = new JSONArray();
        for (String string : deParams.viw.query.obj.getRefDataRepositoryNameList()) {
            jSONArray.put((Object)string);
        }
        JSONArray jSONArray2 = new JSONArray();
        if (deParams.viw.query.obj.getRefDataRepositoryBlockNameList() != null) {
            for (String dataRepositoryBlockName : deParams.viw.query.obj.getRefDataRepositoryBlockNameList()) {
                jSONArray2.put((Object)dataRepositoryBlockName);
            }
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("action", (Object)"dr:/dr_search");
        jSONObject.put("query", (Object)deParams.viw.query.obj.getParsedQueryStr(deParams));
        jSONObject.put("select_fields", (Object)deParams.viw.rtable.select_cols);
        jSONObject.put("range_from", (Object)(deParams.viw.range_from == null ? deParams.viw.from_time : deParams.viw.range_from));
        jSONObject.put("range_to", (Object)(deParams.viw.range_to == null ? deParams.viw.to_time : deParams.viw.range_to));
        jSONObject.put("offset", deParams.viw.rtable.row_from - 1);
        jSONObject.put("size", (Object)deParams.viw.rtable.page_size);
        jSONObject.put("sort_fields", (Object)jSortCols);
        jSONObject.put("sort_orders", (Object)jSortOrders);
        jSONObject.put("dr_name_list", (Object)jSONArray);
        jSONObject.put("time_zone_id", (Object)deParams.viw.time_zone_id);
        if (deParams.viw.extra_params.containsKey("max_boolean_clause_count")) {
            jSONObject.put("max_boolean_clause_count", deParams.viw.extra_params.get("max_boolean_clause_count"));
        }
        if (jSONArray2.length() > 0) {
            jSONObject.put("dr_block_name_list", (Object)jSONArray2);
        }
        if (deParams.viw.query.search_after != null) {
            jSONObject.put("search_after", (Object)deParams.viw.query.search_after);
        }
        if (deParams.viw.business_hour == 1 || deParams.viw.business_hour == 2) {
            jSONObject.put("business_hour", deParams.viw.business_hour);
            jSONObject.put("business_hour_from", (Object)deParams.viw.business_hour_from);
            jSONObject.put("business_hour_to", (Object)deParams.viw.business_hour_to);
            jSONObject.put("business_days", (Object)deParams.viw.business_days);
        }
        LOGGER.info("XNode REQUEST : search");
        if (!this.xnodeQueryLiveClient.isConnected()) {
            this.xnodeQueryLiveClient.connect();
        }
        long startTime = System.currentTimeMillis();
        JSONObject jResp = this.xnodeQueryLiveClient.sendMessage(jSONObject);
        long endTime = System.currentTimeMillis();
        LOGGER.info("XNode RESPONSE received, Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs");
        this.checkForError(jResp);
        jResp = jResp.getJSONObject("response");
        if (jResp.has("search_result") && jResp.has("total_hits")) {
            hitsArr = jResp.getJSONArray("search_result");
            totalHits = jResp.getInt("total_hits");
            LOGGER.info("QUERY TIME : [Hits : " + totalHits + "] [Total Indices : " + jResp.getInt("index_count") + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        } else {
            LOGGER.info("QUERY : No results for the query! [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        }
        retMap.put("hitsArr", hitsArr);
        retMap.put("totalHits", totalHits);
        retMap.put("searchAfter", jResp.optString("search_after"));
        return retMap;
    }

    private HashMap<String, Object> getGroupQueryResultType(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONObject jReq = new JSONObject();
        String termKey = "terms_count";
        JSONArray jInstances = new JSONArray();
        for (String string : deParams.viw.query.obj.getRefDataRepositoryNameList()) {
            jInstances.put((Object)string);
        }
        JSONArray jBlockInstances = new JSONArray();
        if (deParams.viw.query.obj.getRefDataRepositoryBlockNameList() != null) {
            for (String dataRepositoryBlockName : deParams.viw.query.obj.getRefDataRepositoryBlockNameList()) {
                jBlockInstances.put((Object)dataRepositoryBlockName);
            }
        }
        jReq.put("action", (Object)"dr:/dr_search");
        jReq.put("query", (Object)deParams.viw.query.obj.getParsedQueryStr(deParams));
        jReq.put("range_from", (Object)(deParams.viw.range_from == null ? deParams.viw.from_time : deParams.viw.range_from));
        jReq.put("range_to", (Object)(deParams.viw.range_to == null ? deParams.viw.to_time : deParams.viw.range_to));
        jReq.put("dr_name_list", (Object)jInstances);
        jReq.put("time_zone_id", (Object)deParams.viw.time_zone_id);
        if (jBlockInstances.length() > 0) {
            jReq.put("dr_block_name_list", (Object)jBlockInstances);
        }
        if (deParams.viw.business_hour == 1 || deParams.viw.business_hour == 2) {
            jReq.put("business_hour", deParams.viw.business_hour);
            jReq.put("business_hour_from", (Object)deParams.viw.business_hour_from);
            jReq.put("business_hour_to", (Object)deParams.viw.business_hour_to);
            jReq.put("business_days", (Object)deParams.viw.business_days);
        }
        JSONObject jSONObject = new JSONObject();
        JSONObject jTermsAggr = new JSONObject();
        JSONArray jGroupBy = new JSONArray();
        for (String string : deParams.viw.query.obj.getGroupByColList()) {
            jGroupBy.put((Object)string.toUpperCase());
        }
        jTermsAggr.put("fields", (Object)jGroupBy);
        jTermsAggr.put("count_col_alias", (Object)deParams.viw.query.obj.getCountColAlias());
        if (deParams.viw.query.obj.getStatsColList() != null && deParams.viw.query.obj.getStatsTypeList() != null) {
            JSONArray jstats = new JSONArray();
            for (String string : deParams.viw.query.obj.getStatsColList()) {
                jstats.put((Object)string);
            }
            jTermsAggr.put("stats_fields", (Object)jstats);
            jstats = new JSONArray();
            for (String string : deParams.viw.query.obj.getStatsTypeList()) {
                jstats.put((Object)string);
            }
            jTermsAggr.put("stats_types", (Object)jstats);
            termKey = "terms_stats";
            if (deParams.viw.query.obj.getPrimGroupByCol() != null && deParams.viw.query.obj.getPrimGroupByCol().size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (String primCol : deParams.viw.query.obj.getPrimGroupByCol()) {
                    jSONArray.put((Object)primCol);
                }
                jTermsAggr.put("prime_fields", (Object)jSONArray);
                termKey = "terms_summary_stats";
            }
        } else if (deParams.viw.query.obj.getMinCol() != null) {
            jTermsAggr.put("stats_field", (Object)deParams.viw.query.obj.getMinCol());
            jTermsAggr.put("stats_type", (Object)"min");
            termKey = "terms_stats";
        } else if (deParams.viw.query.obj.getMaxCol() != null) {
            jTermsAggr.put("stats_field", (Object)deParams.viw.query.obj.getMaxCol());
            jTermsAggr.put("stats_type", (Object)"max");
            termKey = "terms_stats";
        } else if (deParams.viw.query.obj.getSumCol() != null) {
            jTermsAggr.put("stats_field", (Object)deParams.viw.query.obj.getSumCol());
            jTermsAggr.put("stats_type", (Object)"sum");
            termKey = "terms_stats";
        } else if (deParams.viw.query.obj.getTimeInterval() != null) {
            jTermsAggr.put("time_field", (Object)deParams.viw.query.obj.getTimeCol());
            jTermsAggr.put("time_interval", (Object)deParams.viw.query.obj.getTimeInterval());
            termKey = "terms_date_histogram";
        } else if (deParams.viw.query.obj.getPrimGroupByCol() != null && deParams.viw.query.obj.getPrimGroupByCol().size() > 0) {
            termKey = "terms_summary";
            JSONArray jPrimeCol = new JSONArray();
            for (String string : deParams.viw.query.obj.getPrimGroupByCol()) {
                jPrimeCol.put((Object)string);
            }
            jTermsAggr.put("prime_fields", (Object)jPrimeCol);
        }
        jTermsAggr.put("sort_field", (Object)"_count");
        if (deParams.viw.query.sort_col_list.size() > 0) {
            String sortCol = deParams.viw.query.sort_col_list.get(0);
            if (deParams.viw.query.obj.getGroupByColList() != null && sortCol.equalsIgnoreCase(deParams.viw.query.obj.getGroupByColList().get(0))) {
                jTermsAggr.put("sort_field", (Object)"_term");
            } else if (deParams.viw.query.obj.getStatsColAliasList() != null && sortCol.equalsIgnoreCase(deParams.viw.query.obj.getStatsColAliasList().get(0))) {
                jTermsAggr.put("sort_field", (Object)"_stat");
            }
        }
        if (deParams.viw.query.sort_col_order.size() > 0 && deParams.viw.query.sort_col_order.get(0).equalsIgnoreCase("asc")) {
            jTermsAggr.put("sort_order", (Object)"ASC");
        } else {
            jTermsAggr.put("sort_order", (Object)"DESC");
        }
        if (deParams.viw.extra_params.containsKey("max_boolean_clause_count")) {
            jReq.put("max_boolean_clause_count", deParams.viw.extra_params.get("max_boolean_clause_count"));
        }
        jTermsAggr.put("offset", deParams.viw.rtable.row_from == -1 ? 0 : deParams.viw.rtable.row_from - 1);
        jTermsAggr.put("size", deParams.viw.rtable.page_size == -1 ? 10 : deParams.viw.rtable.page_size);
        if (deParams.viw.query.obj.getFilterBucketCount() != -1) {
            jTermsAggr.put("filter_bucket_count", deParams.viw.query.obj.getFilterBucketCount());
        }
        if (deParams.viw.query.obj.getFilterMinBucketCount() != -1) {
            jTermsAggr.put("filter_min_bucket_count", deParams.viw.query.obj.getFilterMinBucketCount());
        }
        if (deParams.viw.query.obj.getFilterMaxBucketCount() != -1) {
            jTermsAggr.put("filter_max_bucket_count", deParams.viw.query.obj.getFilterMaxBucketCount());
        }
        if (deParams.viw.query.obj.getFilterDocCount() != -1) {
            jTermsAggr.put("filter_doc_count", deParams.viw.query.obj.getFilterDocCount());
        }
        if (deParams.viw.query.obj.getFilterMinDocCount() != -1) {
            jTermsAggr.put("filter_min_doc_count", deParams.viw.query.obj.getFilterMinDocCount());
        }
        if (deParams.viw.query.obj.getFilterMaxDocCount() != -1) {
            jTermsAggr.put("filter_max_doc_count", deParams.viw.query.obj.getFilterMaxDocCount());
        }
        jSONObject.put(termKey, (Object)jTermsAggr);
        jReq.put("aggr", (Object)jSONObject);
        if (!this.xnodeQueryLiveClient.isConnected()) {
            this.xnodeQueryLiveClient.connect();
        }
        LOGGER.info("XNode REQUEST : search-group");
        long startTime = System.currentTimeMillis();
        JSONObject jResp = this.xnodeQueryLiveClient.sendMessage(jReq);
        long endTime = System.currentTimeMillis();
        this.checkForError(jResp);
        jResp = jResp.getJSONObject("response");
        if (jResp.has("aggr_result") && jResp.getJSONObject("aggr_result").has("total_groups")) {
            LOGGER.info("QUERY(aggr) TIME : [Hits : " + jResp.getJSONObject("aggr_result").getInt("total_groups") + "] [Total Indices : " + jResp.getInt("index_count") + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
            retMap.put("aggrResult", jResp.getJSONObject("aggr_result"));
        } else {
            LOGGER.info("QUERY(aggr) TIME : No results for the query! [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        }
        return retMap;
    }

    private HashMap<String, Object> getAggrDateHistogramQueryResultType(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONObject jReq = new JSONObject();
        String termKey = "date_histogram";
        JSONArray jInstances = new JSONArray();
        for (String string : deParams.viw.query.obj.getRefDataRepositoryNameList()) {
            jInstances.put((Object)string);
        }
        JSONArray jBlockInstances = new JSONArray();
        if (deParams.viw.query.obj.getRefDataRepositoryBlockNameList() != null) {
            for (String dataRepositoryBlockName : deParams.viw.query.obj.getRefDataRepositoryBlockNameList()) {
                jBlockInstances.put((Object)dataRepositoryBlockName);
            }
        }
        jReq.put("action", (Object)"dr:/dr_search");
        jReq.put("query", (Object)deParams.viw.query.obj.getParsedQueryStr(deParams));
        jReq.put("range_from", (Object)(deParams.viw.range_from == null ? deParams.viw.from_time : deParams.viw.range_from));
        jReq.put("range_to", (Object)(deParams.viw.range_to == null ? deParams.viw.to_time : deParams.viw.range_to));
        jReq.put("dr_name_list", (Object)jInstances);
        jReq.put("time_zone_id", (Object)deParams.viw.time_zone_id);
        if (jBlockInstances.length() > 0) {
            jReq.put("dr_block_name_list", (Object)jBlockInstances);
        }
        if (deParams.viw.business_hour == 1 || deParams.viw.business_hour == 2) {
            jReq.put("business_hour", deParams.viw.business_hour);
            jReq.put("business_hour_from", (Object)deParams.viw.business_hour_from);
            jReq.put("business_hour_to", (Object)deParams.viw.business_hour_to);
            jReq.put("business_days", (Object)deParams.viw.business_days);
        }
        if (deParams.viw.extra_params.containsKey("max_boolean_clause_count")) {
            jReq.put("max_boolean_clause_count", deParams.viw.extra_params.get("max_boolean_clause_count"));
        }
        JSONObject jSONObject = new JSONObject();
        JSONObject jTermsAggr = new JSONObject();
        jTermsAggr.put("time_field", (Object)deParams.viw.query.obj.getTimeCol());
        jTermsAggr.put("time_interval", (Object)deParams.viw.query.obj.getTimeInterval());
        jTermsAggr.put("count_col_alias", (Object)deParams.viw.query.obj.getCountColAlias());
        jTermsAggr.put("offset", deParams.viw.rtable.row_from == -1 ? 0 : deParams.viw.rtable.row_from - 1);
        jTermsAggr.put("size", deParams.viw.rtable.page_size == -1 ? 10 : deParams.viw.rtable.page_size);
        jSONObject.put(termKey, (Object)jTermsAggr);
        jReq.put("aggr", (Object)jSONObject);
        if (!this.xnodeQueryLiveClient.isConnected()) {
            this.xnodeQueryLiveClient.connect();
        }
        LOGGER.info("XNode REQUEST : search-group");
        long startTime = System.currentTimeMillis();
        JSONObject jResp = this.xnodeQueryLiveClient.sendMessage(jReq);
        long endTime = System.currentTimeMillis();
        this.checkForError(jResp);
        jResp = jResp.getJSONObject("response");
        if (jResp.has("aggr_result") && jResp.getJSONObject("aggr_result").has("total_groups")) {
            LOGGER.info("QUERY(aggr) TIME : [Hits : " + jResp.getJSONObject("aggr_result").getInt("total_groups") + "] [Total Indices : " + jResp.getInt("index_count") + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
            retMap.put("aggrResult", jResp.getJSONObject("aggr_result"));
        } else {
            LOGGER.info("QUERY(aggr) TIME : No results for the query! [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
        }
        return retMap;
    }

    private HashMap<String, Object> getAggrQueryResultType(DEParams deParams) throws Exception {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        JSONObject jReq = new JSONObject();
        String termKey = "aggr";
        JSONArray jInstances = new JSONArray();
        for (String string : deParams.viw.query.obj.getRefDataRepositoryNameList()) {
            jInstances.put((Object)string);
        }
        JSONArray jBlockInstances = new JSONArray();
        if (deParams.viw.query.obj.getRefDataRepositoryBlockNameList() != null) {
            for (String dataRepositoryBlockName : deParams.viw.query.obj.getRefDataRepositoryBlockNameList()) {
                jBlockInstances.put((Object)dataRepositoryBlockName);
            }
        }
        jReq.put("action", (Object)"dr:/dr_search");
        jReq.put("query", (Object)deParams.viw.query.obj.getParsedQueryStr(deParams));
        jReq.put("range_from", (Object)(deParams.viw.range_from == null ? deParams.viw.from_time : deParams.viw.range_from));
        jReq.put("range_to", (Object)(deParams.viw.range_to == null ? deParams.viw.to_time : deParams.viw.range_to));
        jReq.put("dr_name_list", (Object)jInstances);
        jReq.put("time_zone_id", (Object)deParams.viw.time_zone_id);
        if (jBlockInstances.length() > 0) {
            jReq.put("dr_block_name_list", (Object)jBlockInstances);
        }
        if (deParams.viw.business_hour == 1 || deParams.viw.business_hour == 2) {
            jReq.put("business_hour", deParams.viw.business_hour);
            jReq.put("business_hour_from", (Object)deParams.viw.business_hour_from);
            jReq.put("business_hour_to", (Object)deParams.viw.business_hour_to);
            jReq.put("business_days", (Object)deParams.viw.business_days);
        }
        JSONObject jSONObject = new JSONObject();
        JSONObject jTermsAggr = new JSONObject();
        if (deParams.viw.query.obj.getStatsColList() != null && deParams.viw.query.obj.getStatsTypeList() != null) {
            JSONArray jstats = new JSONArray();
            for (String stats : deParams.viw.query.obj.getStatsColList()) {
                jstats.put((Object)stats);
            }
            jTermsAggr.put("stats_fields", (Object)jstats);
            jstats = new JSONArray();
            for (String stats : deParams.viw.query.obj.getStatsTypeList()) {
                jstats.put((Object)stats);
            }
            jTermsAggr.put("stats_types", (Object)jstats);
            termKey = "stats";
        } else if (deParams.viw.query.obj.getMinCol() != null) {
            jTermsAggr.put("stats_field", (Object)deParams.viw.query.obj.getMinCol());
            jTermsAggr.put("stats_type", (Object)"min");
            termKey = "min";
            jTermsAggr.put("field", (Object)deParams.viw.query.obj.getMinCol());
        } else if (deParams.viw.query.obj.getMaxCol() != null) {
            jTermsAggr.put("stats_field", (Object)deParams.viw.query.obj.getMaxCol());
            jTermsAggr.put("stats_type", (Object)"max");
            termKey = "max";
            jTermsAggr.put("field", (Object)deParams.viw.query.obj.getMaxCol());
        } else if (deParams.viw.query.obj.getSumCol() != null) {
            jTermsAggr.put("stats_field", (Object)deParams.viw.query.obj.getSumCol());
            jTermsAggr.put("stats_type", (Object)"sum");
            termKey = "sum";
            jTermsAggr.put("field", (Object)deParams.viw.query.obj.getSumCol());
        }
        if (deParams.viw.extra_params.containsKey("max_boolean_clause_count")) {
            jReq.put("max_boolean_clause_count", deParams.viw.extra_params.get("max_boolean_clause_count"));
        }
        jTermsAggr.put("offset", deParams.viw.rtable.row_from == -1 ? 0 : deParams.viw.rtable.row_from - 1);
        jTermsAggr.put("size", deParams.viw.rtable.page_size == -1 ? 10 : deParams.viw.rtable.page_size);
        jSONObject.put(termKey, (Object)jTermsAggr);
        jReq.put("aggr", (Object)jSONObject);
        if (!this.xnodeQueryLiveClient.isConnected()) {
            this.xnodeQueryLiveClient.connect();
        }
        LOGGER.info("XNode REQUEST : search-group");
        long startTime = System.currentTimeMillis();
        JSONObject jResp = this.xnodeQueryLiveClient.sendMessage(jReq);
        long endTime = System.currentTimeMillis();
        this.checkForError(jResp);
        jResp = jResp.getJSONObject("response");
        if (jResp.has("aggr_result") && jResp.getJSONObject("aggr_result").has("total_groups")) {
            LOGGER.info("QUERY(aggr) TIME : [Hits : " + jResp.getJSONObject("aggr_result").getInt("total_groups") + "] [Total Indices : " + jResp.getInt("index_count") + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
            retMap.put("aggrResult", jResp.getJSONObject("aggr_result"));
        } else if (jResp.has("aggr_result") && jResp.getJSONObject("aggr_result").has("stats")) {
            LOGGER.info("QUERY(aggr) TIME : [Hits : " + jResp.getJSONObject("aggr_result").getInt("total_hits") + "] [Total Indices : " + jResp.getInt("index_count") + "] [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
            retMap.put("aggrResult", jResp.getJSONObject("aggr_result"));
        } else {
            LOGGER.info("QUERY(aggr) TIME : No results for the query! [Total Time : " + (double)(endTime - startTime) / 1000.0 + " secs]");
            retMap.put("aggrResult", jResp.getJSONObject("aggr_result"));
        }
        return retMap;
    }

    public static void printMetrics() {
        LOGGER.info("INDEX Metrics : totalReq : " + totalReq + " :: totalRecords : " + totalRecords);
    }

    private boolean checkForError(JSONObject jResp) throws Exception {
        boolean errStatus = true;
        if (jResp == null || !jResp.has("response")) {
            throw new Exception("EXCEPTION while processing request on XNode null/no response received!!");
        }
        if (jResp.has("response") && (jResp = jResp.getJSONObject("response")).has("error_code")) {
            int errorCode = jResp.getInt("error_code");
            if (errorCode != 0) {
                if (jResp.has("error_msg")) {
                    throw new Exception("EXCEPTION while processing request on XNode, Msg : " + jResp.getString("error_msg"));
                }
                throw new Exception("EXCEPTION while processing request on XNode, Error Code : " + errorCode);
            }
            errStatus = false;
        }
        return errStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray convertFileContentToArray(CtlrDataRepository dataRepo, String fileAbsName) throws Exception {
        JSONArray retArr = new JSONArray();
        Charset encoding = Charset.forName(DE_ENCODING);
        int READ_BUF_SIZE = 4056;
        BufferedReader br = null;
        CsvReader csvReader = null;
        Object line = null;
        try {
            ArrayList<String> fieldList = dataRepo.getIndexFieldNameList();
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileAbsName), encoding), 4056);
            csvReader = new CsvReader((Reader)br, '\t');
            csvReader.setSafetySwitch(false);
            while (csvReader.readRecord()) {
                String[] colVals = csvReader.getValues();
                if (colVals.length != fieldList.size()) {
                    colVals = this.fillMissingCols(colVals, fieldList.size());
                }
                JSONArray jArr = new JSONArray(Arrays.asList(colVals));
                retArr.put((Object)jArr);
            }
        }
        finally {
            if (csvReader != null) {
                csvReader.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return retArr;
    }

    @Override
    public JSONObject fetchDeletedBlocksMetaInfo(JSONArray drList, Long startDate, Long endDate, int from, int range, String sortColumn, String sortOrder, String searchText) throws Exception {
        JSONObject fetchObj = new JSONObject();
        fetchObj.put("from_time", (Object)startDate);
        fetchObj.put("to_time", (Object)endDate);
        fetchObj.put("sort_field", (Object)sortColumn);
        fetchObj.put("sort_order", (Object)sortOrder);
        fetchObj.put("size", range);
        fetchObj.put("offset", from);
        fetchObj.put("dr_name_list", (Object)drList);
        if (searchText != null && !searchText.isEmpty()) {
            fetchObj.put("search_text", (Object)searchText);
        }
        fetchObj.put("action", (Object)"dr:/dr_deleted_blocks_meta_fetch");
        return this.executeQuery(fetchObj);
    }

    @Override
    public boolean addColumn(String columnName, String columnType, String defaultValue, boolean isMain) throws Exception {
        JSONObject colObj = new JSONObject();
        colObj.put("column_name", (Object)columnName);
        colObj.put("column_type", (Object)columnType);
        colObj.put("default_value", (Object)defaultValue);
        colObj.put("dr_is_main", isMain);
        colObj.put("action", (Object)"dr:/dr_meta_col_add");
        JSONObject resp = this.executeQuery(colObj);
        return resp.optBoolean("add_success", Boolean.FALSE.booleanValue());
    }

    @Override
    public boolean updateColumn(String columnName, String value, boolean isMain) throws Exception {
        JSONObject updateObj = new JSONObject();
        updateObj.put("column_name", (Object)columnName);
        updateObj.put("column_value", (Object)value);
        updateObj.put("dr_is_main", isMain);
        updateObj.put("action", (Object)"dr:/dr_meta_info_update");
        JSONObject resp = this.executeQuery(updateObj);
        return resp.optBoolean("update_success", Boolean.FALSE.booleanValue());
    }

    private String[] fillMissingCols(String[] lineVals, int totalCols) {
        int i;
        String[] aColStr = lineVals;
        String[] rColStr = new String[totalCols];
        int actualColLen = aColStr.length;
        int indexLen = totalCols;
        if (actualColLen < totalCols) {
            indexLen = actualColLen;
        }
        for (i = 0; i < indexLen; ++i) {
            rColStr[i] = aColStr[i] == null || aColStr[i].isEmpty() ? "" : aColStr[i];
        }
        for (i = actualColLen; i < totalCols; ++i) {
            rColStr[i] = "";
        }
        return rColStr;
    }
}

