/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRBlockRotationType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import com.manageengine.dataengine.commons.datarepository.DRType;
import com.manageengine.dataengine.commons.datarepository.ElasticDRConfFile;
import com.manageengine.dataengine.commons.datarepository.XNodeDRConfFile;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.lucene.search.Sort;

public abstract class CtlrDataRepository {
    public static final boolean IS_LEGACY_DV = false;
    public static final boolean STORE_RAW_DATA_DV = true;
    public static final boolean CONTAINS_DUPLICATE_DV = false;
    public static final int BLOCK_MAIN_HOT_COUNT_DV = 1;
    public static final int BLOCK_MAIN_HOT_REFRESH_INTERVAL_DV = 0;
    public static final String BLOCK_MAIN_HOT_ROTATION_TYPE_DV = "SIZE";
    public static final int BLOCK_MAIN_HOT_ROTATION_SIZE_DV = 3000000;
    public static final String BLOCK_MAIN_HOT_ROTATION_PERIOD_DV = null;
    public static final int BLOCK_MAIN_RETENTION_DAYS_DV = 150;
    public static final int BLOCK_FROZEN_RETENTION_DAYS_DV = 1500;
    public static final int BLOCK_DEFROST_RETENTION_DAYS_DV = 7;
    private String repositoryName;
    private String repositoryState;
    private String description;
    private DRType repositoryType;
    private String containerName;
    private boolean isLegacy;
    private String legacyTableName;
    private DRSchema schema;
    private boolean storeRawData;
    private boolean containsDuplicate;
    private String blockPrefix;
    private int hotBlockCount;
    private int hotBlockRefreshInterval;
    private DRBlockRotationType hotBlockRotationType;
    private int hotBlockRotationSize;
    private String hotBlockRotationPeriod;
    private int mainBlockRetentionDays;
    private int frozenBlockRetentionDays;
    private int defrostBlockRetentionDays;
    private ArrayList<String> nodes;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public CtlrDataRepository(XNodeDRConfFile.DataRepositoryBean drBean, DRSchema schema) throws Exception {
        this.repositoryName = drBean.repositoryName();
        this.repositoryState = drBean.repositoryState();
        this.description = drBean.description();
        this.repositoryType = DRType.get((String)drBean.repositoryType());
        this.containerName = drBean.containerName() == null ? "default-container" : drBean.containerName();
        this.isLegacy = drBean.isLegacy();
        this.legacyTableName = drBean.legacyTableName();
        this.schema = schema;
        this.storeRawData = this.repositoryType == DRType.GENERIC ? false : drBean.storeRawData();
        this.blockPrefix = drBean.blockPrefix();
        this.hotBlockCount = drBean.blockMainHotCount() == null ? 1 : drBean.blockMainHotCount();
        this.hotBlockRefreshInterval = drBean.blockMainHotRefreshInterval() == null ? 0 : drBean.blockMainHotRefreshInterval();
        this.hotBlockRotationType = drBean.blockMainHotRotationType() == null ? DRBlockRotationType.SIZE : DRBlockRotationType.valueOf((String)drBean.blockMainHotRotationType());
        this.hotBlockRotationSize = drBean.blockMainHotRotationSize() == null ? 3000000 : drBean.blockMainHotRotationSize();
        this.hotBlockRotationPeriod = drBean.blockMainHotRotationPeriod();
        this.mainBlockRetentionDays = drBean.blockMainRetentionDays() == null ? 150 : drBean.blockMainRetentionDays();
        this.frozenBlockRetentionDays = drBean.blockFrozenRetentionDays() == null ? 99999 : drBean.blockFrozenRetentionDays();
        this.defrostBlockRetentionDays = drBean.blockDefrostRetentionDays() == null ? 7 : drBean.blockDefrostRetentionDays();
        this.nodes = drBean.nodes();
        if (this.repositoryName == null || schema == null) {
            throw new NullPointerException("Trying to initialize DataRepository with null parameters!");
        }
        if (this.repositoryType == null) {
            throw new IllegalStateException("Repository type '" + this.repositoryType + "' not supported!");
        }
        if (this.hotBlockCount < 1) {
            LOGGER.severe("EXCEPTION : hotBlocksCount value for DataRepository '" + this.repositoryName + "' is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
            throw new Exception("hotBlocksCount value for DataRepository '" + this.repositoryName + "' is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
        }
        this.validateSchema();
    }

    public CtlrDataRepository(ElasticDRConfFile.DataRepositoryBean drBean, DRSchema schema) throws Exception {
        this.repositoryName = drBean.repositoryName();
        this.repositoryState = drBean.repositoryState();
        this.description = drBean.description();
        this.repositoryType = DRType.get((String)drBean.repositoryType());
        this.containerName = drBean.containerName() == null ? "default-container" : drBean.containerName();
        this.isLegacy = drBean.isLegacy();
        this.legacyTableName = drBean.legacyTableName();
        this.schema = schema;
        this.storeRawData = this.repositoryType == DRType.GENERIC ? false : drBean.storeRawData();
        this.blockPrefix = drBean.blockPrefix();
        this.hotBlockCount = drBean.blockMainHotCount() == null ? 1 : drBean.blockMainHotCount();
        this.hotBlockRefreshInterval = drBean.blockMainHotRefreshInterval() == null ? 0 : drBean.blockMainHotRefreshInterval();
        this.hotBlockRotationType = drBean.blockMainHotRotationType() == null ? DRBlockRotationType.SIZE : DRBlockRotationType.valueOf((String)drBean.blockMainHotRotationType());
        this.hotBlockRotationSize = drBean.blockMainHotRotationSize() == null ? 3000000 : drBean.blockMainHotRotationSize();
        this.hotBlockRotationPeriod = drBean.blockMainHotRotationPeriod();
        this.mainBlockRetentionDays = drBean.blockMainRetentionDays() == null ? 150 : drBean.blockMainRetentionDays();
        this.frozenBlockRetentionDays = drBean.blockFrozenRetentionDays() == null ? 99999 : drBean.blockFrozenRetentionDays();
        this.defrostBlockRetentionDays = drBean.blockDefrostRetentionDays() == null ? 7 : drBean.blockDefrostRetentionDays();
        this.nodes = drBean.nodes();
        if (this.repositoryName == null || schema == null) {
            throw new NullPointerException("Trying to initialize DataRepository with null parameters!");
        }
        if (this.repositoryType == null) {
            throw new Exception("Repository type '" + this.repositoryType + "' not supported!");
        }
        if (this.hotBlockCount < 1) {
            LOGGER.severe("EXCEPTION : hotBlocksCount value for DataRepository '" + this.repositoryName + "' is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
            throw new Exception("hotBlocksCount value for DataRepository '" + this.repositoryName + "' is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
        }
        this.validateSchema();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public DRType getRepositoryType() {
        return this.repositoryType;
    }

    public String getRepositoryState() {
        return this.repositoryState;
    }

    public void setRepositoryState(String repositoryState) {
        this.repositoryState = repositoryState;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public void setLegacy(boolean isLegacy) {
        this.isLegacy = isLegacy;
    }

    public String getLegacyTableName() {
        return this.legacyTableName;
    }

    public void setLegacyTableName(String legacyTableName) {
        this.legacyTableName = legacyTableName;
    }

    public DRSchema getSchema() {
        return this.schema;
    }

    public void setSchema(DRSchema schema) {
        this.schema = schema;
    }

    public String getBlockPrefix() {
        return this.blockPrefix;
    }

    public void setBlockPrefix(String blockPrefix) {
        this.blockPrefix = blockPrefix;
    }

    public int getHotBlockCount() {
        return this.hotBlockCount;
    }

    public void setHotBlockCount(int hotBlockCount) {
        this.hotBlockCount = hotBlockCount;
    }

    public DRBlockRotationType getHotBlockRotationType() {
        return this.hotBlockRotationType;
    }

    public void setHotBlockRotationType(DRBlockRotationType hotBlockRotationType) {
        this.hotBlockRotationType = hotBlockRotationType;
    }

    public int getHotBlockRotationSize() {
        return this.hotBlockRotationSize;
    }

    public void setHotBlockRotationSize(int hotBlockRotationSize) {
        this.hotBlockRotationSize = hotBlockRotationSize;
    }

    public int getMainBlockRetentionDays() {
        return this.mainBlockRetentionDays;
    }

    public void setMainBlockRetentionDays(int mainBlockRetentionDays) {
        this.mainBlockRetentionDays = mainBlockRetentionDays;
    }

    public ArrayList<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(ArrayList<String> nodes) {
        this.nodes = nodes;
    }

    public boolean hasIndexField(String fieldName) {
        return this.schema.hasIndexField(fieldName);
    }

    public DRIndexField getIndexField(String fieldName) {
        return this.schema.getIndexField(fieldName);
    }

    public ArrayList<DRIndexField> getIndexFieldList() {
        return this.schema.getIndexFields();
    }

    public ArrayList<String> getIndexFieldNameList() {
        return this.schema.getIndexFieldNames();
    }

    public ArrayList<String> getIndexFieldAliasNameList() {
        return this.schema.getIndexFieldAliasNames();
    }

    public Sort getIndexSortObj() {
        return this.schema.getIndexSortObj();
    }

    public ArrayList<DRIndexField> getIndexSortFields() {
        return this.schema.getIndexSortFields();
    }

    public String getRangeField() {
        return this.schema.getRangeField();
    }

    private void validateSchema() throws Exception {
        if (this.repositoryType == DRType.AUDIT_LOG) {
            if (!this.schema.getRangeField().equalsIgnoreCase(DRType.AUDIT_LOG.getDefaultTimeField())) {
                throw new Exception("Schema '" + this.schema.getSchemaName() + "' of DataRepository '" + this.repositoryName + "' should have the default range field '" + DRType.AUDIT_LOG.getDefaultTimeField() + "'!");
            }
            ArrayList fieldList = this.schema.getIndexFieldNames();
            boolean timeFieldFound = false;
            for (String field : fieldList) {
                if (!field.equalsIgnoreCase(DRType.AUDIT_LOG.getDefaultTimeField())) continue;
                timeFieldFound = true;
                break;
            }
            if (!timeFieldFound) {
                throw new Exception("Schema '" + this.schema.getSchemaName() + "' of DataRepository '" + this.repositoryName + "' should have the time field '" + DRType.AUDIT_LOG.getDefaultTimeField() + "'!");
            }
        }
    }

    public abstract void rolloverBlock() throws Exception;

    public abstract String getHotBlockName(int var1);

    public abstract void incrHotBlockDocCount(int var1);

    public abstract boolean reachedMaxBlockDocCount();

    public abstract ArrayList<String> getElasticIndexList(Long var1, Long var2);

    public abstract String getElasticIndexListStr(Long var1, Long var2, AtomicInteger var3);
}

