/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import com.manageengine.dataengine.commons.datarepository.ElasticDRSchema;
import com.manageengine.dataengine.commons.datarepository.XNodeDRSchema;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CtlrDataRepositoryManager {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private static String deEngine;
    private static ConcurrentHashMap<String, DRSchema> schemaMap;

    public CtlrDataRepositoryManager() throws Exception {
        deEngine = (String)AdapEnvironment.DE_ENGINE.value();
        this.loadDRSchemas();
    }

    protected abstract void loadDataRepositories() throws Exception;

    public abstract void createDataRepository(JSONObject var1) throws Exception;

    public abstract void deleteDataRepository(String var1) throws Exception;

    public abstract boolean updateDataRepository(JSONArray var1) throws Exception;

    public abstract JSONArray getDataRepositoriesAsJSON() throws Exception;

    public abstract ConcurrentHashMap<String, CtlrDataRepository> getDataRepositoryMap();

    public abstract boolean addDRMetaColumn(String var1, String var2, String var3, boolean var4) throws Exception;

    public abstract boolean updateDRMetaColumn(String var1, String var2, boolean var3) throws Exception;

    public DRIndexField getDataRepositoryIndexField(String repoName, String fieldName) {
        return this.getDataRepository(repoName).getIndexField(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDRSchemas() throws Exception {
        File schemasFolder = ((Path)AdapEnvironment.DE_E_DR_SCHEMA_DIR.value()).toFile();
        if (!schemasFolder.exists()) {
            schemasFolder.mkdirs();
        }
        schemaMap = new ConcurrentHashMap();
        if (schemasFolder.isDirectory()) {
            File[] schemaFileList = schemasFolder.listFiles();
            BufferedReader br = null;
            for (File schemaFile : schemaFileList) {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(schemaFile)));
                    StringBuilder fileStr = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        fileStr.append(line);
                    }
                    JSONObject fileContentObj = new JSONObject(fileStr.toString());
                    Object schema = deEngine.equalsIgnoreCase("xnode") ? new XNodeDRSchema(schemaFile.getName().replace(".json", ""), fileContentObj) : new ElasticDRSchema(schemaFile.getName().replace(".json", ""), fileContentObj);
                    schemaMap.put(schema.getSchemaName(), (DRSchema)schema);
                    LOGGER.info("LOADED : DataRepository Schema '" + schemaFile.getName() + "'");
                }
                catch (Exception e) {
                    LOGGER.severe("EXCEPTION : Error while parsing Schema file '" + schemaFile.getName() + "'");
                    e.printStackTrace();
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
        } else {
            throw new Exception("Schema '" + AdapEnvironment.DE_E_DR_SCHEMA_DIR.value() + "' file path does not exist!");
        }
        this.checkFieldWithMultipleDataTypes();
    }

    private void checkFieldWithMultipleDataTypes() throws Exception {
        HashMap<String, String> valMap = new HashMap<String, String>();
        for (DRSchema schema : schemaMap.values()) {
            ArrayList fieldList = schema.getIndexFields();
            for (DRIndexField field : fieldList) {
                if (valMap.containsKey(field.getFieldName().toLowerCase()) && !((String)valMap.get(field.getFieldName().toLowerCase())).equals(field.getDataType())) {
                    LOGGER.severe("EXCEPTION : Field with multiple datatypes detected! " + schema.getSchemaName() + "." + field.getFieldName());
                    throw new Exception("Field with multiple datatypes detected! " + schema.getSchemaName() + "." + field.getFieldName());
                }
                valMap.put(field.getFieldName().toLowerCase(), field.getDataType());
            }
        }
    }

    public DRSchema getDRSchema(String schemaName) {
        DRSchema schema = schemaMap.get(schemaName);
        if (schema == null) {
            throw new NoSuchElementException("Schema '" + schemaName + "' not found!");
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getDRSchemasAsJSON() throws Exception {
        JSONObject schemaObjs = new JSONObject();
        File schemasFolder = ((Path)AdapEnvironment.DE_E_DR_SCHEMA_DIR.value()).toFile();
        if (!schemasFolder.exists()) {
            schemasFolder.mkdirs();
        }
        if (schemasFolder.isDirectory()) {
            File[] schemaFileList = schemasFolder.listFiles();
            BufferedReader br = null;
            for (File schemaFile : schemaFileList) {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(schemaFile)));
                    StringBuilder fileStr = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        fileStr.append(line);
                    }
                    JSONObject fileContentObj = new JSONObject(fileStr.toString());
                    schemaObjs.put(schemaFile.getName(), (Object)fileContentObj);
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
        }
        return schemaObjs;
    }

    public CtlrDataRepository getDataRepository(String repositoryName) {
        CtlrDataRepository repository = this.getDataRepositoryMap().get(repositoryName.toLowerCase());
        if (repository == null) {
            throw new NoSuchElementException("DataRepository for '" + repositoryName + "' not found!");
        }
        return repository;
    }

    public CtlrDataRepository getDataRepositoryByLegacyName(String repositoryName) {
        for (CtlrDataRepository dataRepository : this.getDataRepositoryMap().values()) {
            String repoLegacyTableName = dataRepository.getLegacyTableName();
            if (repoLegacyTableName == null || !repoLegacyTableName.equalsIgnoreCase(repositoryName)) continue;
            return dataRepository;
        }
        throw new NoSuchElementException("DataRepository for '" + repositoryName + "' not found!");
    }

    public CtlrDataRepository getDataRepositoryWithPrefixIfExists(String repositoryName) {
        if (repositoryName == null || repositoryName.isEmpty()) {
            return null;
        }
        int indexOfUnderscore = repositoryName.indexOf("_");
        if (indexOfUnderscore >= 0) {
            repositoryName = repositoryName.substring(0, indexOfUnderscore);
        }
        return this.getDataRepositoryIfExists(repositoryName);
    }

    public CtlrDataRepository getDataRepositoryIfExists(String repositoryName) {
        if (repositoryName == null || repositoryName.isEmpty()) {
            return null;
        }
        CtlrDataRepository dataRepo = this.getDataRepositoryMap().get(repositoryName.toLowerCase());
        if (dataRepo != null) {
            return dataRepo;
        }
        for (CtlrDataRepository dataRepository : this.getDataRepositoryMap().values()) {
            String repoLegacyTableName = dataRepository.getLegacyTableName();
            if (repoLegacyTableName == null || !repoLegacyTableName.equalsIgnoreCase(repositoryName)) continue;
            return dataRepository;
        }
        return null;
    }

    public boolean hasDataRepositoryForLegacyTable(String legacyTableName) {
        return this.getDataRepositoryIfExists(legacyTableName) != null;
    }

    public ArrayList<CtlrDataRepository> getDataRepositories() {
        return new ArrayList<CtlrDataRepository>(this.getDataRepositoryMap().values());
    }

    public boolean isEnabled(String repositoryName) throws Exception {
        CtlrDataRepository dataRepository = this.getDataRepositoryIfExists(repositoryName);
        return dataRepository == null ? false : dataRepository.getRepositoryState().equalsIgnoreCase("ENABLED");
    }

    static {
        schemaMap = new ConcurrentHashMap();
    }
}

