/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRQueryType;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.view.DEParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.json.JSONObject;

public class DRQuery {
    private long queryId;
    private String queryStr;
    private DRQueryType queryType;
    private ArrayList<CtlrDataRepository> refDataRepositoryList = null;
    private ArrayList<String> refDataRepositoryNameList = null;
    private ArrayList<String> refDataRepositoryBlockNameList = null;
    private JSONObject queryParams;
    private String secondarySearchClause = null;
    private ArrayList<String> primGroupCol;
    private ArrayList<String> groupByColList;
    private ArrayList<String> statsColList;
    private ArrayList<String> statsTypeList;
    private ArrayList<String> statsColAliasList;
    private ArrayList<String> selectColList;
    private HashMap<String, ArrayList<HashMap<String, String>>> colCaseMap = null;
    private HashMap<String, String> colRefCaseMap = null;
    private String minCol = null;
    private String maxCol = null;
    private String sumCol = null;
    private String timeCol = null;
    private String statsCol = null;
    private String countColAlias = "COUNT";
    private String minColAlias = "MIN";
    private String maxColAlias = "MAX";
    private String sumColAlias = "SUM";
    private String timeInterval = null;
    private AtomicInteger totalIndices = new AtomicInteger(0);
    private int filterMinBucketCount = -1;
    private int filterMaxBucketCount = -1;
    private int filterBucketCount = -1;
    private int filterMinDocCount = -1;
    private int filterMaxDocCount = -1;
    private int filterDocCount = -1;
    private static final Pattern SELECT_PATTERN = Pattern.compile("SELECT[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern GROUP_PRIME_COL_PATTERN = Pattern.compile("GROUP_PRIME[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern GROUP_PATTERN = Pattern.compile("GROUP[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern MIN_COL_PATTERN = Pattern.compile("MIN[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern MAX_COL_PATTERN = Pattern.compile("MAX[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern SUM_COL_PATTERN = Pattern.compile("SUM[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern STATS_COL_PATTERN = Pattern.compile("STATS[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern STATS_COL_ARR_PATTERN = Pattern.compile("STATS_COL[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern STATS_TYPE_ARR_PATTERN = Pattern.compile("STATS_TYPE[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern STATS_COL_ALIAS_PATTERN = Pattern.compile("STATS_COL_ALIAS[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern COUNT_COL_ALIAS_PATTERN = Pattern.compile("COUNT_COL_ALIAS[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern MIN_COL_ALIAS_PATTERN = Pattern.compile("MIN_COL_ALIAS[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern MAX_COL_ALIAS_PATTERN = Pattern.compile("MAX_COL_ALIAS[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern SUM_COL_ALIAS_PATTERN = Pattern.compile("SUM_COL_ALIAS[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern HOUR_SERIES_PATTERN = Pattern.compile("HOUR_SERIES[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern DAY_SERIES_PATTERN = Pattern.compile("DAY_SERIES[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern MONTH_SERIES_PATTERN = Pattern.compile("MONTH_SERIES[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern QUARTERLY_SERIES_PATTERN = Pattern.compile("QUARTERLY_SERIES[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern HALFYEARLY_SERIES_PATTERN = Pattern.compile("HALFYEARLY_SERIES[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern YEAR_SERIES_PATTERN = Pattern.compile("YEAR_SERIES[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern COL_CASE_PATTERN = Pattern.compile("COL_CASE[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern COL_REF_CASE_PATTERN = Pattern.compile("COL_REF_CASE[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern COL_CASE_CLAUSE_PATTERN = Pattern.compile("(AND|OR)?[\\s]*\\{(.*?)\\}");
    private static final Pattern FILTER_MIN_DOC_COUNT = Pattern.compile("FILTER_MIN_DOC_COUNT[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern FILTER_MAX_DOC_COUNT = Pattern.compile("FILTER_MAX_DOC_COUNT[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern FILTER_DOC_COUNT = Pattern.compile("FILTER_DOC_COUNT[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern FILTER_MIN_BUCKET_COUNT = Pattern.compile("FILTER_MIN_BUCKET_COUNT[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern FILTER_MAX_BUCKET_COUNT = Pattern.compile("FILTER_MAX_BUCKET_COUNT[\\s]*\\(([^\\(]*)\\)");
    private static final Pattern FILTER_BUCKET_COUNT = Pattern.compile("FILTER_BUCKET_COUNT[\\s]*\\(([^\\(]*)\\)");

    private DRQuery(long queryId, String queryStr) throws Exception {
        this.queryId = queryId;
        this.queryType = DRQueryType.SEARCH_ONLY;
        this.queryStr = queryStr.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DRQuery build(String queryStr, String secondaryClause, Object refDataRepositoryList) throws Exception {
        DRQuery drQuery = null;
        if (queryStr == null || queryStr.isEmpty() || refDataRepositoryList == null) throw new Exception("Trying to build DRQuery with queryStr|refDataRepositoryList as null!");
        drQuery = new DRQuery(0L, queryStr);
        if (secondaryClause != null && !secondaryClause.trim().isEmpty()) {
            drQuery.setSecondarySearchClause(secondaryClause.trim());
        }
        if (refDataRepositoryList instanceof String) {
            drQuery.setRefDataRepositoryList((String)refDataRepositoryList);
            return drQuery;
        } else {
            if (!(refDataRepositoryList instanceof ArrayList)) throw new Exception("DataType of refDataRepositoryList not supported!");
            drQuery.setRefDataRepositoryList((ArrayList)refDataRepositoryList);
        }
        return drQuery;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public void setQueryId(long queryId) {
        this.queryId = queryId;
    }

    public String getQueryStr() {
        return this.queryStr;
    }

    public void setQueryStr(String queryStr) {
        this.queryStr = queryStr;
    }

    public String addSearchStr(String searchStr, String operator) {
        if (searchStr != null && !searchStr.trim().isEmpty()) {
            operator = operator == null ? "AND" : operator.toUpperCase();
            this.queryStr = this.queryStr == null || this.queryStr.isEmpty() ? "(" + searchStr + ")" : this.queryStr + " " + operator + " (" + searchStr + ")";
        }
        return this.queryStr;
    }

    public ArrayList<CtlrDataRepository> getRefDataRepositoryList() {
        return this.refDataRepositoryList;
    }

    public void setRefDataRepositoryList(ArrayList<CtlrDataRepository> refDataRepositoryList) {
        this.refDataRepositoryList = refDataRepositoryList;
        this.refDataRepositoryNameList = new ArrayList();
        for (CtlrDataRepository ctlrDataRepository : refDataRepositoryList) {
            this.refDataRepositoryNameList.add(ctlrDataRepository.getRepositoryName());
        }
    }

    public void setRefDataRepositoryList(String refDataRepositoryListStr) throws Exception {
        if (refDataRepositoryListStr != null) {
            String[] repoArr = refDataRepositoryListStr.trim().split(",");
            int len = repoArr.length;
            this.refDataRepositoryList = new ArrayList();
            for (int i = 0; i < len; ++i) {
                if (repoArr[i] == null || repoArr[i].trim().isEmpty()) continue;
                this.refDataRepositoryList.add(DE.DR().getDataRepository(repoArr[i].trim()));
            }
            this.setRefDataRepositoryNameList(refDataRepositoryListStr);
        }
    }

    public ArrayList<String> getRefDataRepositoryNameList() {
        return this.refDataRepositoryNameList;
    }

    private void setRefDataRepositoryNameList(String refDataRepositoryNameListStr) throws Exception {
        String[] indexArr = refDataRepositoryNameListStr.split(",");
        int len = indexArr.length;
        this.refDataRepositoryNameList = new ArrayList();
        for (int i = 0; i < len; ++i) {
            if (indexArr[i] == null || indexArr[i].trim().isEmpty()) continue;
            this.refDataRepositoryNameList.add(indexArr[i].trim());
        }
    }

    public ArrayList<String> getRefDataRepositoryBlockNameList() {
        return this.refDataRepositoryBlockNameList;
    }

    public void setRefDataRepositoryBlockNameList(String refDataRepositoryBlockNameListStr) {
        String[] indexArr = refDataRepositoryBlockNameListStr.split(",");
        int len = indexArr.length;
        this.refDataRepositoryBlockNameList = new ArrayList();
        for (int i = 0; i < len; ++i) {
            if (indexArr[i] == null || indexArr[i].trim().isEmpty()) continue;
            this.refDataRepositoryBlockNameList.add(indexArr[i].trim());
        }
    }

    public JSONObject getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(JSONObject queryParams) {
        this.queryParams = queryParams;
    }

    public void setQueryType(DRQueryType queryType) {
        this.queryType = queryType;
    }

    public DRQueryType getQueryType() {
        return this.queryType;
    }

    public void setSecondarySearchClause(String secondarySearchClause) throws Exception {
        int i;
        int len;
        this.secondarySearchClause = secondarySearchClause;
        int bitMask = 1;
        Matcher match = SELECT_PATTERN.matcher(secondarySearchClause);
        if (match.find()) {
            String selectStr = match.group(1);
            String[] selectArr = selectStr.split(",");
            len = selectArr.length;
            this.selectColList = new ArrayList();
            for (i = 0; i < len; ++i) {
                if (selectArr[i] == null || selectArr[i].trim().isEmpty()) continue;
                this.selectColList.add(selectArr[i].trim());
            }
        }
        if ((match = GROUP_PRIME_COL_PATTERN.matcher(secondarySearchClause)).find()) {
            this.primGroupCol = new ArrayList();
            String primGroupStr = match.group(1);
            String[] primGroupArr = primGroupStr.split(",");
            for (int i2 = 0; i2 < primGroupArr.length; ++i2) {
                if (primGroupArr[i2] == null || primGroupArr[i2].trim().isEmpty()) continue;
                this.primGroupCol.add(primGroupArr[i2].trim());
            }
            bitMask |= DRQueryType.AGGR_TERMS_SUMMARY.bitMask();
        }
        match = COL_CASE_PATTERN.matcher(secondarySearchClause);
        this.colCaseMap = new HashMap();
        while (match.find()) {
            ArrayList colCaseList = new ArrayList();
            String[] colCaseStr = match.group(1).trim().split(" AS ");
            String colCaseAlias = colCaseStr[1].trim();
            if (!colCaseStr[0].trim().equals("*")) {
                Matcher clauseMatch = COL_CASE_CLAUSE_PATTERN.matcher(colCaseStr[0].trim());
                while (clauseMatch.find()) {
                    HashMap<String, String> colCaseClause = new HashMap<String, String>();
                    String operator = clauseMatch.group(1);
                    String[] keyVal = clauseMatch.group(2).trim().split("=");
                    colCaseClause.put("operator", operator);
                    colCaseClause.put("column", keyVal[0]);
                    colCaseClause.put("value", keyVal[1]);
                    colCaseList.add(colCaseClause);
                }
            }
            this.colCaseMap.put(colCaseAlias, colCaseList);
        }
        match = COL_REF_CASE_PATTERN.matcher(secondarySearchClause);
        this.colRefCaseMap = new HashMap();
        while (match.find()) {
            String[] colCaseStr = match.group(1).trim().split(" AS ");
            String colCaseAlias = colCaseStr[1].trim();
            this.colRefCaseMap.put(colCaseAlias, colCaseStr[0].trim());
        }
        match = GROUP_PATTERN.matcher(secondarySearchClause);
        if (match.find()) {
            String groupStr = match.group(1);
            String[] groupArr = groupStr.split(",");
            len = groupArr.length;
            this.groupByColList = new ArrayList();
            if (this.primGroupCol != null) {
                for (i = 0; i < this.primGroupCol.size(); ++i) {
                    this.groupByColList.add(this.primGroupCol.get(i));
                }
            }
            for (i = 0; i < len; ++i) {
                if (groupArr[i] == null || groupArr[i].trim().isEmpty()) continue;
                this.groupByColList.add(groupArr[i].trim());
            }
            bitMask |= DRQueryType.AGGR_TERMS_COUNT.bitMask();
        }
        if (STATS_COL_ARR_PATTERN.matcher(secondarySearchClause).find() || STATS_TYPE_ARR_PATTERN.matcher(secondarySearchClause).find() || STATS_COL_ALIAS_PATTERN.matcher(secondarySearchClause).find()) {
            String[] statsArr;
            String statsStr;
            try {
                match = STATS_COL_ARR_PATTERN.matcher(secondarySearchClause);
                if (match.find()) {
                    statsStr = match.group(1);
                    statsArr = statsStr.split(",");
                    len = statsArr.length;
                    this.statsColList = new ArrayList();
                    for (i = 0; i < len; ++i) {
                        if (statsArr[i] == null || statsArr[i].trim().isEmpty()) continue;
                        this.statsColList.add(statsArr[i].trim());
                    }
                    bitMask |= DRQueryType.AGGR_STATS.bitMask();
                }
            }
            catch (Exception e) {
                throw new Exception("Problem in Parsing STATS_COL params in DE_QUERY_2");
            }
            try {
                match = STATS_TYPE_ARR_PATTERN.matcher(secondarySearchClause);
                if (match.find()) {
                    statsStr = match.group(1);
                    statsArr = statsStr.split(",");
                    len = statsArr.length;
                    this.statsTypeList = new ArrayList();
                    for (i = 0; i < len; ++i) {
                        if (statsArr[i] == null || statsArr[i].trim().isEmpty()) continue;
                        this.statsTypeList.add(statsArr[i].trim());
                    }
                    bitMask |= DRQueryType.AGGR_STATS.bitMask();
                }
            }
            catch (Exception e) {
                throw new Exception("Problem in Parsing STATS_TYPE params in DE_QUERY_2");
            }
            try {
                match = STATS_COL_ALIAS_PATTERN.matcher(secondarySearchClause);
                if (match.find()) {
                    statsStr = match.group(1);
                    statsArr = statsStr.split(",");
                    len = statsArr.length;
                    this.statsColAliasList = new ArrayList();
                    for (i = 0; i < len; ++i) {
                        if (statsArr[i] == null || statsArr[i].trim().isEmpty()) continue;
                        this.statsColAliasList.add(statsArr[i].trim());
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Problem in Parsing STATS_COL_ALIAS params in DE_QUERY_2");
            }
            if (this.statsColList.size() != this.statsTypeList.size() || this.statsColList.size() != this.statsColAliasList.size()) {
                throw new Exception("The length of STATS_COL , STATS_TYPE , STATS_COL_ALIAS are not same");
            }
        }
        if ((match = MIN_COL_PATTERN.matcher(secondarySearchClause)).find()) {
            this.minCol = match.group(1).trim();
            bitMask |= DRQueryType.AGGR_STATS.bitMask();
        }
        if ((match = MAX_COL_PATTERN.matcher(secondarySearchClause)).find()) {
            this.maxCol = match.group(1).trim();
            bitMask |= DRQueryType.AGGR_STATS.bitMask();
        }
        if ((match = SUM_COL_PATTERN.matcher(secondarySearchClause)).find()) {
            this.sumCol = match.group(1).trim();
            bitMask |= DRQueryType.AGGR_STATS.bitMask();
        }
        if ((match = STATS_COL_PATTERN.matcher(secondarySearchClause)).find()) {
            this.statsCol = match.group(1).trim();
            bitMask |= DRQueryType.AGGR_STATS.bitMask();
        }
        if ((match = COUNT_COL_ALIAS_PATTERN.matcher(secondarySearchClause)).find()) {
            this.countColAlias = match.group(1).trim();
        }
        if ((match = MIN_COL_ALIAS_PATTERN.matcher(secondarySearchClause)).find()) {
            this.minColAlias = match.group(1).trim();
        }
        if ((match = MAX_COL_ALIAS_PATTERN.matcher(secondarySearchClause)).find()) {
            this.maxColAlias = match.group(1).trim();
        }
        if ((match = SUM_COL_ALIAS_PATTERN.matcher(secondarySearchClause)).find()) {
            this.sumColAlias = match.group(1).trim();
        }
        if ((match = FILTER_MIN_BUCKET_COUNT.matcher(secondarySearchClause)).find()) {
            this.filterMinBucketCount = Integer.parseInt(match.group(1).trim());
        }
        if ((match = FILTER_MAX_BUCKET_COUNT.matcher(secondarySearchClause)).find()) {
            this.filterMaxBucketCount = Integer.parseInt(match.group(1).trim());
        }
        if ((match = FILTER_BUCKET_COUNT.matcher(secondarySearchClause)).find()) {
            this.filterBucketCount = Integer.parseInt(match.group(1).trim());
        }
        if ((match = FILTER_MIN_DOC_COUNT.matcher(secondarySearchClause)).find()) {
            this.filterMinDocCount = Integer.parseInt(match.group(1).trim());
        }
        if ((match = FILTER_MAX_DOC_COUNT.matcher(secondarySearchClause)).find()) {
            this.filterMaxDocCount = Integer.parseInt(match.group(1).trim());
        }
        if ((match = FILTER_DOC_COUNT.matcher(secondarySearchClause)).find()) {
            this.filterDocCount = Integer.parseInt(match.group(1).trim());
        }
        if ((match = HOUR_SERIES_PATTERN.matcher(secondarySearchClause)).find()) {
            this.timeCol = match.group(1).trim();
            this.timeInterval = "HOUR";
            bitMask |= DRQueryType.AGGR_DATE_HISTOGRAM.bitMask();
        }
        if ((match = DAY_SERIES_PATTERN.matcher(secondarySearchClause)).find()) {
            this.timeCol = match.group(1).trim();
            this.timeInterval = "DAY";
            bitMask |= DRQueryType.AGGR_DATE_HISTOGRAM.bitMask();
        }
        if ((match = MONTH_SERIES_PATTERN.matcher(secondarySearchClause)).find()) {
            this.timeCol = match.group(1).trim();
            this.timeInterval = "MONTH";
            bitMask |= DRQueryType.AGGR_DATE_HISTOGRAM.bitMask();
        }
        if ((match = QUARTERLY_SERIES_PATTERN.matcher(secondarySearchClause)).find()) {
            this.timeCol = match.group(1).trim();
            this.timeInterval = "QUARTERLY";
            bitMask |= DRQueryType.AGGR_DATE_HISTOGRAM.bitMask();
        }
        if ((match = HALFYEARLY_SERIES_PATTERN.matcher(secondarySearchClause)).find()) {
            this.timeCol = match.group(1).trim();
            this.timeInterval = "HALFYEARLY";
            bitMask |= DRQueryType.AGGR_DATE_HISTOGRAM.bitMask();
        }
        if ((match = YEAR_SERIES_PATTERN.matcher(secondarySearchClause)).find()) {
            this.timeCol = match.group(1).trim();
            this.timeInterval = "YEAR";
            bitMask |= DRQueryType.AGGR_DATE_HISTOGRAM.bitMask();
        }
        this.queryType = DRQueryType.get((int)bitMask);
    }

    public String secondarySearchClause() {
        return this.secondarySearchClause;
    }

    public ArrayList<String> getPrimGroupByCol() {
        return this.primGroupCol;
    }

    public ArrayList<String> getGroupByColList() {
        return this.groupByColList;
    }

    public ArrayList<String> getStatsColList() {
        return this.statsColList;
    }

    public ArrayList<String> getStatsTypeList() {
        return this.statsTypeList;
    }

    public ArrayList<String> getStatsColAliasList() {
        return this.statsColAliasList;
    }

    public ArrayList<String> getSelectColList() {
        return this.selectColList;
    }

    public String getMinCol() {
        return this.minCol;
    }

    public String getMaxCol() {
        return this.maxCol;
    }

    public String getSumCol() {
        return this.sumCol;
    }

    public String getTimeCol() {
        return this.timeCol;
    }

    public String getCountColAlias() {
        return this.countColAlias;
    }

    public String getMinColAlias() {
        return this.minColAlias;
    }

    public String getMaxColAlias() {
        return this.maxColAlias;
    }

    public String getSumColAlias() {
        return this.sumColAlias;
    }

    public AtomicInteger getTotalIndices() {
        return this.totalIndices;
    }

    public String getTimeInterval() {
        return this.timeInterval;
    }

    public HashMap<String, ArrayList<HashMap<String, String>>> getColCases() {
        return this.colCaseMap;
    }

    public HashMap<String, String> getColRefCases() {
        return this.colRefCaseMap;
    }

    public int getFilterMinBucketCount() {
        return this.filterMinBucketCount;
    }

    public int getFilterMaxBucketCount() {
        return this.filterMaxBucketCount;
    }

    public int getFilterBucketCount() {
        return this.filterBucketCount;
    }

    public int getFilterMinDocCount() {
        return this.filterMinDocCount;
    }

    public int getFilterMaxDocCount() {
        return this.filterMaxDocCount;
    }

    public int getFilterDocCount() {
        return this.filterDocCount;
    }

    public String getParsedElasticQueryStr(DEParams deParams, ArrayList<String> typeList) throws Exception {
        String parsedQuery = null;
        this.totalIndices = new AtomicInteger(0);
        if (this.queryStr != null && !this.queryStr.isEmpty()) {
            parsedQuery = "(" + this.getParsedQueryStr(deParams) + ")";
            String indexListStr = "";
            String typeListStr = "";
            if (this.refDataRepositoryList == null) {
                for (String indexName : this.refDataRepositoryNameList) {
                    indexListStr = indexListStr + " OR " + indexName;
                    this.totalIndices.incrementAndGet();
                }
                indexListStr = indexListStr.replaceFirst(" OR ", "");
            } else {
                for (CtlrDataRepository repo : this.refDataRepositoryList) {
                    indexListStr = indexListStr + " OR " + repo.getElasticIndexListStr(deParams.viw.from_time, deParams.viw.to_time, this.totalIndices);
                }
                indexListStr = indexListStr.replaceFirst(" OR ", "");
            }
            if (typeList != null) {
                for (String typeName : typeList) {
                    typeListStr = typeListStr + " OR " + typeName;
                }
                typeListStr = typeListStr.replaceFirst(" OR ", "");
            }
            if (!indexListStr.isEmpty()) {
                parsedQuery = parsedQuery + " AND _index:(" + indexListStr + ")";
            }
            if (!typeListStr.isEmpty()) {
                parsedQuery = parsedQuery + " AND _type:(" + typeListStr + ")";
            }
        }
        return parsedQuery;
    }

    public String getParsedQueryStr(DEParams deParams) throws Exception {
        String parsedQuery = null;
        if (this.queryStr != null && !this.queryStr.isEmpty()) {
            parsedQuery = DE.drGeneralQueryParser().parseQuery(this.queryStr, deParams);
        }
        return parsedQuery;
    }

    public static String buildSingleQueryClauseStr(String key, String value, int operator, boolean quoted, boolean escape) {
        key = key.toUpperCase();
        value = escape ? QueryParser.escape((String)value) : value;
        value = quoted ? "\"" + value + "\"" : value;
        value = value.contains(" ") ? value.replaceAll(" ", "\\\\ ") : value;
        switch (operator) {
            case 1: {
                return key + ":" + value;
            }
            case 2: {
                return "NOT " + key + ":" + value;
            }
            case 11: 
            case 13: {
                return key + ":*" + value + "*";
            }
            case 12: 
            case 14: {
                return "NOT " + key + ":*" + value + "*";
            }
            case 7: {
                return key + ":" + value + "*";
            }
            case 9: {
                return "NOT " + key + ":" + value + "*";
            }
            case 8: {
                return key + ":*" + value;
            }
            case 10: {
                return "NOT " + key + ":*" + value;
            }
            case 3: {
                return key + ":<" + value;
            }
            case 4: {
                return key + ":<=" + value;
            }
            case 5: {
                return key + ":>" + value;
            }
            case 6: {
                return key + ":>=" + value;
            }
        }
        return key + ":" + value;
    }

    public static String buildContainsStr(String value, boolean escape) throws Exception {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int len = value.length();
        String string = value = escape ? QueryParser.escape((String)value) : value;
        if (value.charAt(0) == '*' && value.charAt(len - 1) == '*') {
            value = value.substring(1, len - 1);
            value = "*" + (escape ? QueryParser.escape((String)value) : value) + "*";
        } else if (value.charAt(len - 1) == '*') {
            value = value.substring(0, len - 1);
            value = (escape ? QueryParser.escape((String)value) : value) + "*";
        } else if (value.charAt(0) == '*') {
            value = value.substring(1, len);
            value = "*" + (escape ? QueryParser.escape((String)value) : value);
        } else {
            value = "*" + (escape ? QueryParser.escape((String)value) : value) + "*";
        }
        return value;
    }

    public static class Operator {
        public static final int INVALID = 0;
        public static final int EQUALS = 1;
        public static final int NOT_EQUALS = 2;
        public static final int LESS_THAN = 3;
        public static final int LESS_THAN_OR_EQUAL = 4;
        public static final int GREATER_THAN = 5;
        public static final int GREATER_THAN_OR_EQUAL = 6;
        public static final int STARTS_WITH = 7;
        public static final int ENDS_WITH = 8;
        public static final int NOT_STARTS_WITH = 9;
        public static final int NOT_ENDS_WITH = 10;
        public static final int LIKE = 11;
        public static final int NOTLIKE = 12;
        public static final int CONTAINS = 13;
        public static final int NOTCONTAINS = 14;
        public static final int AND = 101;
        public static final int OR = 102;
        public static final int NOT = 103;
    }
}

