/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRBlockRotationType;
import com.manageengine.dataengine.commons.datarepository.DRBlockUtil;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import com.manageengine.dataengine.commons.datarepository.ElasticDRConfFile;
import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.commons.file.ZipUtil;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.connector.netcalls.ElasticRestDRNetCalls;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.datarepository.DRQuery;
import com.manageengine.dataengine.controller.datarepository.ElasticBlock;
import com.manageengine.dataengine.controller.engine.node.ElasticNode;
import com.manageengine.dataengine.controller.view.DEParams;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.elasticsearch.client.Response;
import org.json.JSONObject;

public class ElasticCtlrDataRepository
extends CtlrDataRepository {
    private String elasticIndexTemplateName;
    private int hotBlockDocCount = 0;
    private String hotBlockName = "";
    private int blockCount = 0;
    private PropertiesFileUtil.PropertiesFileHandle blockInfoFileHandle;
    private HashMap<String, ElasticBlock> blockMap;
    private volatile Object hotBlockLock = new Object();
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public ElasticCtlrDataRepository(ElasticDRConfFile.DataRepositoryBean drBean, DRSchema schema) throws Exception {
        super(drBean, schema);
        this.elasticIndexTemplateName = this.getBlockPrefix().toLowerCase() + "_template_1";
        if (!((Path)AdapEnvironment.DE_E_DR_BLOCK_INFO_DIR.value()).toFile().exists()) {
            ((Path)AdapEnvironment.DE_E_DR_BLOCK_INFO_DIR.value()).toFile().mkdirs();
        }
        this.blockInfoFileHandle = PropertiesFileUtil.getPropertiesFileHandle((String)(AdapEnvironment.DE_E_DR_BLOCK_INFO_DIR.value() + File.separator + this.getRepositoryName() + "-Block.meta"), (boolean)true);
    }

    public String getElasticIndexTemplateName() {
        return this.elasticIndexTemplateName;
    }

    @Override
    public void setBlockPrefix(String blockPrefix) {
        super.setBlockPrefix(blockPrefix);
        this.elasticIndexTemplateName = blockPrefix.toLowerCase() + "_template_1";
    }

    public void setHotBlockRotationSize(String hotIndexRotationSize) {
        this.setHotBlockRotationSize(Integer.parseInt(hotIndexRotationSize.replace("SIZE_", "")));
    }

    public int getHotBlockDocCount() {
        return this.hotBlockDocCount;
    }

    public void setHotBlockDocCount(int hotBlockDocCount) {
        this.hotBlockDocCount = hotBlockDocCount;
    }

    @Override
    public void incrHotBlockDocCount(int newBlockDocCount) {
        this.hotBlockDocCount += newBlockDocCount;
    }

    @Override
    public boolean reachedMaxBlockDocCount() {
        return this.hotBlockDocCount >= this.getHotBlockRotationSize();
    }

    public PropertiesFileUtil.PropertiesFileHandle getBlockInfoFileHandle() {
        return this.blockInfoFileHandle;
    }

    @Override
    public String getHotBlockName(int index) {
        return this.hotBlockName;
    }

    public String getIndexAlias() {
        return this.getSchema().getElasticIndexAlias();
    }

    public String getElasticIndexTemplateContent() throws Exception {
        String templateStr = "{\"template\" : \"" + this.getBlockPrefix() + "_*\"}";
        JSONObject templateObj = new JSONObject(templateStr);
        templateObj.put("settings", (Object)this.getSchema().getElasticIndexSettingsObj());
        templateObj.put("mappings", (Object)this.getSchema().getElasticFieldMappingObj());
        templateObj.put("aliases", (Object)this.getSchema().getElasticAliasesObj());
        return templateObj.toString();
    }

    public void indexFiles(String fileAbsName, String instanceName) throws Exception {
        DE.deNodes().nodes().get(0).DR().addData((CtlrDataRepository)this, fileAbsName);
    }

    public void archiveBlock() throws Exception {
        ElasticNode deNode = (ElasticNode)DE.deNodes().nodes().get(0);
        ArrayList<String> blockList = deNode.DR().getIndexNameList(this.getBlockPrefix() + "*");
        for (String blockActualName : blockList) {
            try {
                if (DRBlockUtil.canArchiveBlock((String)blockActualName, (int)this.getMainBlockRetentionDays(), (DRBlockRotationType)this.getHotBlockRotationType())) {
                    long startTime = System.currentTimeMillis();
                    LOGGER.info("ARCH :: Going to archive block : " + blockActualName);
                    long curTimestamp = System.currentTimeMillis();
                    String repoName = "repo_" + blockActualName + "_" + curTimestamp;
                    String snapshotName = "snap_" + blockActualName + "_" + curTimestamp;
                    String repoLocation = blockActualName + "_" + curTimestamp;
                    String repoAbsLocation = ((Path)AdapEnvironment.ELASTIC_HOME_DIR.value()).toAbsolutePath() + File.separator + blockActualName + "_" + curTimestamp;
                    String archLocation = ((Path)AdapEnvironment.DE_E_DATA_ARCHIVE_DIR.value()).toAbsolutePath() + File.separator + this.getBlockPrefix() + File.separator;
                    deNode.admin().createSnapshotRepository(repoName, repoLocation);
                    Response resp = deNode.DR().snapshotIndex(blockActualName, snapshotName, repoName, true);
                    if (resp != null && resp.getStatusLine().getStatusCode() == 200) {
                        if (!new File(archLocation).exists()) {
                            new File(archLocation).mkdirs();
                        }
                        ZipUtil.zip((String)repoAbsLocation, (String)(archLocation + blockActualName + "_" + curTimestamp + ".zip"));
                        deNode.DR().deleteIndex(blockActualName);
                        deNode.DR().deleteSnapshot(snapshotName, repoName);
                        deNode.admin().deleteSnapshotRepository(repoName);
                        this.deleteDir(new File(repoAbsLocation));
                    }
                    long endTime = System.currentTimeMillis();
                    LOGGER.info("ARCH :: Total time to archive block '" + blockActualName + "' : " + (float)(endTime - startTime) / 1000.0f + " secs");
                    continue;
                }
                LOGGER.info("ARCH :: Block '" + blockActualName + "' is within retention count, so skipping archive...");
            }
            catch (Exception e) {
                LOGGER.severe("EXCEPTION while archiving block '" + blockActualName + "'!");
                LOGGER.severe(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void findRestoreBlock(long fromTimestamp, long toTimestamp) {
        String archLocation = ((Path)AdapEnvironment.DE_E_DATA_ARCHIVE_DIR.value()).toAbsolutePath() + File.separator + this.getBlockPrefix() + File.separator;
        File archFolder = new File(archLocation);
        File[] archIndexZipFiles = archFolder.listFiles();
    }

    public void restoreBlock(ArrayList<String> blockList) {
        ElasticNode deNode = (ElasticNode)DE.deNodes().nodes().get(0);
        for (String blockActualNameTS : blockList) {
            try {
                long startTime = System.currentTimeMillis();
                LOGGER.info("ARCH :: Going to restore block : " + blockActualNameTS);
                String blockActualName = blockActualNameTS.substring(0, blockActualNameTS.lastIndexOf("_"));
                String repoName = "repo_" + blockActualNameTS;
                String snapshotName = "snap_" + blockActualNameTS;
                String repoLocation = ((Path)AdapEnvironment.ELASTIC_HOME_DIR.value()).toAbsolutePath() + File.separator + blockActualNameTS;
                String archLocation = ((Path)AdapEnvironment.DE_E_DATA_ARCHIVE_DIR.value()).toAbsolutePath() + File.separator + this.getBlockPrefix() + File.separator;
                String zipFile = archLocation + blockActualNameTS + ".zip";
                repoLocation = repoLocation.replace("\\", "\\\\");
                deNode.admin().createSnapshotRepository(repoName, repoLocation);
                ZipUtil.unZip((String)zipFile, (String)repoLocation);
                Response resp = deNode.DR().restoreIndex(blockActualName, "arch_" + blockActualNameTS, snapshotName, repoName, true);
                if (resp != null && resp.getStatusLine().getStatusCode() == 200) {
                    deNode.DR().deleteSnapshot(snapshotName, repoName);
                    deNode.admin().deleteSnapshotRepository(repoName);
                    this.deleteDir(new File(repoLocation));
                }
                long endTime = System.currentTimeMillis();
                LOGGER.info("ARCH :: Total time to restore block '" + blockActualNameTS + "' : " + (float)(endTime - startTime) / 1000.0f + " secs");
            }
            catch (Exception e) {
                LOGGER.severe("EXCEPTION while restoring block '" + blockActualNameTS + "'!");
                LOGGER.severe(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public ArrayList<String> getElasticIndexList(Long fromTimestamp, Long toTimestamp) {
        ArrayList indexList = new ArrayList();
        if (this.getHotBlockRotationType().compareTo((Enum)DRBlockRotationType.SIZE) == 0) {
            for (ElasticBlock drIndex : this.blockMap.values()) {
                Long startTime = drIndex.getStartTime();
                Long endTime = drIndex.getEndTime();
                if (fromTimestamp != null && toTimestamp != null && startTime != null && endTime != null && drIndex.getState().equals("COLD")) {
                    if (!(startTime >= fromTimestamp && endTime <= toTimestamp || startTime <= fromTimestamp && endTime >= toTimestamp || startTime >= fromTimestamp && startTime <= toTimestamp) && (endTime < fromTimestamp || endTime > toTimestamp)) continue;
                    indexList.add(drIndex.getBlockName());
                    continue;
                }
                if (!drIndex.getState().equals("HOT")) continue;
                indexList.add(drIndex.getBlockName());
            }
        } else {
            indexList = DRBlockUtil.getBlockList((long)fromTimestamp, (long)toTimestamp, (String)this.getBlockPrefix(), (DRBlockRotationType)this.getHotBlockRotationType());
        }
        return indexList;
    }

    @Override
    public String getElasticIndexListStr(Long fromTimestamp, Long toTimestamp, AtomicInteger totalIndices) {
        ArrayList<String> indexList = this.getElasticIndexList(fromTimestamp, toTimestamp);
        String indexListStr = "";
        for (String indexName : indexList) {
            indexListStr = indexListStr + " OR " + indexName;
            totalIndices.incrementAndGet();
        }
        indexListStr = indexListStr.replaceFirst(" OR ", "");
        return indexListStr;
    }

    public void initBlockInfoFile() throws Exception {
        this.blockInfoFileHandle.clear();
        this.blockInfoFileHandle.updateProperty("BLOCK_COUNT", "0");
        this.blockInfoFileHandle.saveFile();
        this.blockCount = 0;
        this.blockMap = new HashMap();
    }

    public void createBlock(String blockName, long startTime, long endTime, long docCount, String state, boolean createInRepo) throws Exception {
        if (createInRepo) {
            JSONObject jSONObject = ((ElasticRestDRNetCalls)DE.deNodes().nodes().get(0).DR()).createIndex(blockName);
        }
        this.blockInfoFileHandle.setBlancLinesBefore("BLOCK." + this.blockCount + "." + "NAME", 2);
        this.blockInfoFileHandle.setComment("BLOCK." + this.blockCount + "." + "NAME", blockName);
        this.blockInfoFileHandle.updateProperty("BLOCK." + this.blockCount + "." + "NAME", blockName);
        this.blockInfoFileHandle.updateProperty("BLOCK." + this.blockCount + "." + "STATE", state);
        this.blockInfoFileHandle.updateProperty("BLOCK." + this.blockCount + "." + "START_TIME", "" + startTime);
        this.blockInfoFileHandle.updateProperty("BLOCK." + this.blockCount + "." + "END_TIME", "" + endTime);
        this.blockInfoFileHandle.updateProperty("BLOCK." + this.blockCount + "." + "DOC_COUNT", "" + docCount);
        this.blockInfoFileHandle.updateProperty("BLOCK_COUNT", "" + ++this.blockCount);
        this.blockInfoFileHandle.saveFile();
        ElasticBlock indexInfo = new ElasticBlock(blockName, startTime, endTime, docCount, state, this.blockCount - 1);
        this.blockMap.put(blockName, indexInfo);
        if (state.equals("HOT") && !this.hotBlockName.equals(blockName)) {
            this.hotBlockName = blockName;
            this.hotBlockDocCount = 0;
        }
    }

    public void updateBlock(String blockName, long startTime, long endTime, long docCount, String state) throws Exception {
        if (this.blockMap.containsKey(blockName)) {
            ElasticBlock blockInfo = this.blockMap.get(blockName);
            int seqNo = blockInfo.getseqNo();
            this.blockInfoFileHandle.updateProperty("BLOCK." + seqNo + "." + "STATE", state);
            this.blockInfoFileHandle.updateProperty("BLOCK." + seqNo + "." + "START_TIME", "" + startTime);
            this.blockInfoFileHandle.updateProperty("BLOCK." + seqNo + "." + "END_TIME", "" + endTime);
            this.blockInfoFileHandle.updateProperty("BLOCK." + seqNo + "." + "DOC_COUNT", "" + docCount);
            this.blockInfoFileHandle.saveFile();
            blockInfo.setStartTime(startTime);
            blockInfo.setEndTime(endTime);
            blockInfo.setDocCount(docCount);
            blockInfo.setState(state);
            this.blockMap.put(blockName, blockInfo);
            if (state.equals("HOT") && !this.hotBlockName.equals(blockName)) {
                this.hotBlockName = blockName;
                this.hotBlockDocCount = 0;
            }
        } else {
            throw new Exception("Trying to update non-existent ElasticBlock info : " + blockName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rolloverBlock() throws Exception {
        if (this.reachedMaxBlockDocCount()) {
            Object object = this.hotBlockLock;
            synchronized (object) {
                if (this.reachedMaxBlockDocCount()) {
                    LOGGER.info("Going to rollover block, blockName : " + this.hotBlockName + " :: curIndexDocCount : " + this.hotBlockDocCount + " :: hotIndexRotationSize : " + this.getHotBlockRotationSize());
                    String oldBlockName = this.hotBlockName;
                    String newBlockName = this.getSchema().getElasticIndexAlias() + "_" + this.blockCount;
                    DEParams deParams = new DEParams();
                    deParams.viw.query.obj = DRQuery.build("*:*", "MIN_MAX(TIME_GENERATED)", this.getRepositoryName());
                    deParams.viw.query.aggr_field = "TIME_GENERATED";
                    HashMap<String, Object> resMap = DE.deNodes().nodes().get(0).DR().executeSearchQuery(deParams);
                    long minValue = (Long)resMap.get("minValue");
                    long maxValue = (Long)resMap.get("maxValue");
                    this.updateBlock(oldBlockName, minValue, maxValue, this.hotBlockDocCount, "COLD");
                    this.createBlock(newBlockName, 0L, 0L, 0L, "HOT", true);
                }
            }
        }
    }

    public void fetchBlockInfo() throws Exception {
        this.blockMap = new HashMap();
        this.blockCount = this.blockInfoFileHandle.getInt("BLOCK_COUNT", Integer.valueOf(0));
        for (int i = 0; i < this.blockCount; ++i) {
            String blockName = this.blockInfoFileHandle.getString("BLOCK." + i + "." + "NAME", null);
            long startTime = this.blockInfoFileHandle.getLong("BLOCK." + i + "." + "START_TIME", Long.valueOf(0L));
            long endTime = this.blockInfoFileHandle.getLong("BLOCK." + i + "." + "END_TIME", Long.valueOf(0L));
            long docCount = this.blockInfoFileHandle.getLong("BLOCK." + i + "." + "DOC_COUNT", Long.valueOf(0L));
            String state = this.blockInfoFileHandle.getString("BLOCK." + i + "." + "STATE", "COLD");
            ElasticBlock blockInfo = new ElasticBlock(blockName, startTime, endTime, docCount, state, i);
            this.blockMap.put(blockName, blockInfo);
            if (!state.equals("HOT")) continue;
            DEParams deParams = new DEParams();
            deParams.viw.query.obj = DRQuery.build("*:*", null, this.getRepositoryName());
            deParams.viw.rtable.row_from = 0;
            deParams.viw.rtable.page_size = 2;
            HashMap<String, Object> resMap = DE.deNodes().nodes().get(0).DR().executeSearchQuery(deParams);
            JSONObject hitsObj = (JSONObject)resMap.get("hitsObj");
            this.hotBlockName = blockName;
            this.hotBlockDocCount = hitsObj.getInt("total");
            LOGGER.info("HOT BLOCK : DataRepositoryName : " + this.getRepositoryName() + " :: HotBlockName : " + this.hotBlockName + " :: HotBlockCount : " + this.hotBlockDocCount);
        }
    }

    private boolean deleteDir(File dir) throws Exception {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

