/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.datarepository;

import com.manageengine.dataengine.commons.datarepository.ElasticDRConfFile;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepositoryManager;
import com.manageengine.dataengine.controller.datarepository.ElasticCtlrDataRepository;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ElasticCtlrDataRepositoryManager
extends CtlrDataRepositoryManager {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private ConcurrentHashMap<String, CtlrDataRepository> dataRepositoryMap = new ConcurrentHashMap();

    public ElasticCtlrDataRepositoryManager() throws Exception {
        this.loadDataRepositories();
        ArrayList<CtlrDataRepository> repos = this.getDataRepositories();
        for (CtlrDataRepository repo : repos) {
            ((ElasticCtlrDataRepository)repo).fetchBlockInfo();
        }
    }

    @Override
    public void loadDataRepositories() throws Exception {
        File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
        LOGGER.info("Loading DataRepository info from : " + confFile.getAbsolutePath());
        ElasticDRConfFile drFileObj = ElasticDRConfFile.load((File)confFile);
        this.updateElasticDataRepositories(drFileObj.getDataRepositories());
    }

    @Override
    public void createDataRepository(JSONObject dataRepoObj) throws Exception {
        throw new Exception("CREATE DataRepository for elastic not implemented!");
    }

    @Override
    public void deleteDataRepository(String dataRepoName) throws Exception {
        throw new Exception("DELETE DataRepository for elastic not implemented!");
    }

    @Override
    public boolean updateDataRepository(JSONArray repoList) throws Exception {
        File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
        LOGGER.info("UPDATING DataRepository info...");
        ElasticDRConfFile drFileObj = ElasticDRConfFile.load((File)confFile);
        drFileObj.update(repoList);
        this.updateElasticDataRepositories(drFileObj.getDataRepositories());
        return Boolean.TRUE;
    }

    @Override
    public JSONArray getDataRepositoriesAsJSON() throws Exception {
        File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
        LOGGER.info("Reading DataRepository info from : " + confFile.getAbsolutePath());
        ElasticDRConfFile drFileObj = ElasticDRConfFile.load((File)confFile);
        JSONArray repoObj = drFileObj.toJSON();
        return repoObj;
    }

    @Override
    public ConcurrentHashMap<String, CtlrDataRepository> getDataRepositoryMap() {
        return this.dataRepositoryMap;
    }

    private void updateElasticDataRepositories(List<ElasticDRConfFile.DataRepositoryBean> drList) throws Exception {
        this.dataRepositoryMap = new ConcurrentHashMap();
        for (ElasticDRConfFile.DataRepositoryBean datarepository : drList) {
            this.dataRepositoryMap.put(datarepository.repositoryName(), new ElasticCtlrDataRepository(datarepository, this.getDRSchema(datarepository.schemaName())));
            datarepository.logDataRepositoryInfo();
        }
    }

    @Override
    public boolean addDRMetaColumn(String columnName, String columnType, String defaultValue, boolean isMain) throws Exception {
        throw new Exception("ADD DataRepository metadata for elastic not implemented!");
    }

    @Override
    public boolean updateDRMetaColumn(String columnName, String value, boolean isMain) throws Exception {
        throw new Exception("UPDATE DataRepository metadata for elastic not implemented!");
    }
}

