/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.datarepository;

import com.manageengine.dataengine.commons.datarepository.XNodeDRConfFile;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepositoryManager;
import com.manageengine.dataengine.controller.datarepository.XNodeCtlrDataRepository;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class XNodeCtlrDataRepositoryManager
extends CtlrDataRepositoryManager {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private ConcurrentHashMap<String, CtlrDataRepository> dataRepositoryMap = new ConcurrentHashMap();
    private final Object data_repository_lock = new Object();

    public XNodeCtlrDataRepositoryManager() throws Exception {
        this.loadDataRepositories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataRepositories() throws Exception {
        Object object = this.data_repository_lock;
        synchronized (object) {
            File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
            LOGGER.info("Loading DataRepository info from : " + confFile.getAbsolutePath());
            XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)confFile);
            this.updateDataRepositories(drFileObj.getDataRepositories());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataRepository(JSONObject dataRepoObj) throws Exception {
        Object object = this.data_repository_lock;
        synchronized (object) {
            LOGGER.info("CREATING DataRepository...");
            if (this.checkIfDataRepositoryExists(dataRepoObj.getString("repository_name"))) {
                throw new Exception("Trying to add duplicate DataRepository entry : " + dataRepoObj.getString("repository_name"));
            }
            File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
            XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)confFile);
            XNodeDRConfFile.DataRepositoryBean bean = XNodeDRConfFile.DataRepositoryBean.load((JSONObject)dataRepoObj);
            drFileObj.add(bean);
            this.updateDataRepositories(drFileObj.getDataRepositories());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataRepository(String dataRepoName) throws Exception {
        Object object = this.data_repository_lock;
        synchronized (object) {
            LOGGER.info("DELETING DataRepository : " + dataRepoName);
            File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
            XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)confFile);
            drFileObj.delete(dataRepoName);
            this.updateDataRepositories(drFileObj.getDataRepositories());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDataRepository(JSONArray repoList) throws Exception {
        Object object = this.data_repository_lock;
        synchronized (object) {
            File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
            LOGGER.info("UPDATING DataRepository info...");
            XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)confFile);
            drFileObj.update(repoList);
            this.updateDataRepositories(drFileObj.getDataRepositories());
            JSONObject resp = DE.DR().nodeActions().updateDR(repoList);
            return resp.optInt("error_code", -1) == 0;
        }
    }

    @Override
    public JSONArray getDataRepositoriesAsJSON() throws Exception {
        File confFile = ((Path)AdapEnvironment.DE_E_DR_CONF_FILE.value()).toFile();
        LOGGER.info("Reading DataRepository info from : " + confFile.getAbsolutePath());
        XNodeDRConfFile drFileObj = XNodeDRConfFile.load((File)confFile);
        JSONArray repoObj = drFileObj.toJSON();
        return repoObj;
    }

    @Override
    public ConcurrentHashMap<String, CtlrDataRepository> getDataRepositoryMap() {
        return this.dataRepositoryMap;
    }

    private void updateDataRepositories(List<XNodeDRConfFile.DataRepositoryBean> drList) throws Exception {
        this.validateDataRepositories(drList);
        ConcurrentHashMap<String, XNodeCtlrDataRepository> newDataRepositoryMap = new ConcurrentHashMap<String, XNodeCtlrDataRepository>();
        for (XNodeDRConfFile.DataRepositoryBean datarepository : drList) {
            newDataRepositoryMap.put(datarepository.repositoryName().toLowerCase(), new XNodeCtlrDataRepository(datarepository, this.getDRSchema(datarepository.schemaName())));
            datarepository.logMinDataRepositoryInfo();
        }
        this.dataRepositoryMap = newDataRepositoryMap;
    }

    private void validateDataRepositories(List<XNodeDRConfFile.DataRepositoryBean> drList) throws Exception {
        HashMap<String, Integer> duplicateCheckMap = new HashMap<String, Integer>();
        for (XNodeDRConfFile.DataRepositoryBean datarepository : drList) {
            if (duplicateCheckMap.containsKey(datarepository.repositoryName().toLowerCase())) {
                throw new Exception("Trying to add duplicate DataRepository entry : " + datarepository.repositoryName());
            }
            duplicateCheckMap.put(datarepository.repositoryName().toLowerCase(), 0);
        }
    }

    private boolean checkIfDataRepositoryExists(String dataRepoName) throws Exception {
        return this.dataRepositoryMap.containsKey(dataRepoName.toLowerCase());
    }

    @Override
    public boolean addDRMetaColumn(String columnName, String columnType, String defaultValue, boolean isMain) throws Exception {
        LOGGER.info("Adding DataRepository metatables with new column");
        return DE.DR().nodeActions().addColumn(columnName, columnType, defaultValue, isMain);
    }

    @Override
    public boolean updateDRMetaColumn(String columnName, String value, boolean isMain) throws Exception {
        LOGGER.info("Updating DataRepository metatables with new value for the column");
        return DE.DR().nodeActions().updateColumn(columnName, value, isMain);
    }
}

