/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine;

import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.DataEngineController;
import com.manageengine.dataengine.controller.engine.node.ElasticNodes;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ElasticController
extends DataEngineController {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    public static final String ELASTIC_CONF_NODE_COUNT = "elastic.nodes.count";
    private ElasticNodes elasticNodes;

    public ElasticController() throws Exception {
        if (!((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toFile().exists()) {
            throw new FileNotFoundException("EXCEPTION : " + AdapEnvironment.DE_E_CONF_FILE.value() + " file not found!");
        }
        PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)false);
        this.elasticNodes = new ElasticNodes();
        int nodeCount = propFileHandler.getInt(ELASTIC_CONF_NODE_COUNT, Integer.valueOf(1));
        for (int i = 1; i <= nodeCount; ++i) {
            this.elasticNodes.addNode(propFileHandler, i);
        }
    }

    @Override
    public void create() throws Exception {
        LOGGER.log(Level.INFO, "CREATED Elastic Controller!");
    }

    @Override
    public void destroy() throws Exception {
        LOGGER.log(Level.INFO, "DESTROYED Elastic Controller!");
    }

    @Override
    public void start() throws Exception {
        LOGGER.log(Level.INFO, "STARTING ALL Elastic nodes...");
        this.elasticNodes.start();
        this.setStateAndNotifications(this.elasticNodes.refreshStateAndNotifications());
        LOGGER.log(Level.INFO, "STARTED ALL Elastic nodes!");
    }

    @Override
    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "STOPPING ALL Elastic nodes...");
        this.elasticNodes.stop();
        LOGGER.log(Level.INFO, "STOPPED ALL Elastic nodes!");
    }

    @Override
    public JSONObject refreshStateAndNotifications() {
        return this.elasticNodes.refreshStateAndNotifications();
    }

    @Override
    public ElasticNodes deNodes() {
        return this.elasticNodes;
    }
}

