/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine;

import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.DataEngineController;
import com.manageengine.dataengine.controller.engine.node.XNodes;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class XNodeController
extends DataEngineController {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    public static final String XNODE_CONF_NODE_COUNT = "xnodes.count";
    private XNodes xnodes;

    public XNodeController() throws Exception {
        if (!((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toFile().exists()) {
            throw new FileNotFoundException("EXCEPTION : " + AdapEnvironment.DE_E_CONF_FILE.value() + " file not found!");
        }
        PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)false);
        this.xnodes = new XNodes();
        int nodeCount = propFileHandler.getInt(XNODE_CONF_NODE_COUNT, Integer.valueOf(1));
        for (int i = 1; i <= nodeCount; ++i) {
            this.xnodes.addNode(propFileHandler, i);
        }
    }

    @Override
    public void create() throws Exception {
        LOGGER.log(Level.INFO, "CREATED DataEngine-XNode Controller!");
    }

    @Override
    public void start() throws Exception {
        LOGGER.log(Level.INFO, "STARTING All DataEngine-XNode Services...");
        this.xnodes.start();
        this.setStateAndNotifications(this.xnodes.refreshStateAndNotifications());
        LOGGER.log(Level.INFO, "STARTED All DataEngine-XNode Services!");
    }

    @Override
    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "STOPPING All DataEngine-XNode Services...");
        this.xnodes.stop();
        LOGGER.log(Level.INFO, "STOPPED All DataEngine-XNode Services!");
    }

    @Override
    public void destroy() throws Exception {
        LOGGER.log(Level.INFO, "DESTROYED DataEngine-XNode Controller!");
    }

    @Override
    public JSONObject refreshStateAndNotifications() {
        this.setStateAndNotifications(this.xnodes.refreshStateAndNotifications());
        return this.getStateAndNotifications();
    }

    @Override
    public XNodes deNodes() {
        return this.xnodes;
    }
}

