/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine.node;

import com.manageengine.dataengine.commons.connector.ConnectorType;
import com.manageengine.dataengine.commons.datarepository.DRBlockRotationType;
import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.connector.client.rest.ElasticRestClient;
import com.manageengine.dataengine.controller.connector.netcalls.ElasticRestAdminNetCalls;
import com.manageengine.dataengine.controller.connector.netcalls.ElasticRestDRNetCalls;
import com.manageengine.dataengine.controller.datarepository.CtlrDataRepository;
import com.manageengine.dataengine.controller.datarepository.ElasticCtlrDataRepository;
import com.manageengine.dataengine.controller.engine.node.DENode;
import com.manageengine.dataengine.controller.engine.node.ElasticNodeSettings;
import com.manageengine.dataengine.controller.engine.node.winservice.DENodeWinService;
import com.manageengine.dataengine.controller.engine.node.winservice.ElasticNodeWinService;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.elasticsearch.client.RestClient;
import org.json.JSONObject;

public class ElasticNode
implements DENode {
    private String nodeHost;
    private String location;
    private String serviceName;
    private boolean isLocal;
    private ConnectorType connectorType;
    private int connectorPort;
    private ElasticRestClient restClient;
    private ElasticNodeWinService winService;
    private ElasticNodeSettings settings;
    private ElasticRestAdminNetCalls adminNetCalls;
    private ElasticRestDRNetCalls drNetCalls;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    private ElasticNode(ElasticNodeSettings settings) throws Exception {
        this.nodeHost = (String)settings.elastic_host.value();
        this.location = (String)settings.elastic_location.value();
        this.serviceName = (String)settings.elastic_service_name.value();
        this.winService = new ElasticNodeWinService(this);
        this.settings = settings;
        this.restClient = new ElasticRestClient(this);
        this.adminNetCalls = new ElasticRestAdminNetCalls(this);
        this.drNetCalls = new ElasticRestDRNetCalls(this);
        boolean bl = this.isLocal = this.nodeHost.equalsIgnoreCase("localhost") || this.nodeHost.equalsIgnoreCase("local") || this.nodeHost.equalsIgnoreCase("127.0.0.1");
        if (!((String)settings.elastic_connector_type.value()).equalsIgnoreCase(ConnectorType.REST.name())) {
            throw new IllegalArgumentException("EXCEPTION : Elastic connector type '" + this.connectorType + "' not supported!");
        }
        this.connectorType = ConnectorType.REST;
        this.connectorPort = (Integer)settings.elastic_connector_rest_port.value();
    }

    @Override
    public String getNodeHost() {
        return this.nodeHost;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    @Override
    public int getConnectorPort() {
        return this.connectorPort;
    }

    public ElasticNodeSettings getSettings() {
        return this.settings;
    }

    public RestClient getRestClient() {
        return this.restClient.getRestClient();
    }

    @Override
    public ElasticRestAdminNetCalls admin() {
        return this.adminNetCalls;
    }

    @Override
    public ElasticRestDRNetCalls DR() {
        return this.drNetCalls;
    }

    @Override
    public DENodeWinService getWinService() {
        return this.winService;
    }

    public static ElasticNode build(PropertiesFileUtil.PropertiesFileHandle propFileHandler, int index) throws Exception {
        ElasticNodeSettings settings = new ElasticNodeSettings();
        settings.elastic_host.set((Object)propFileHandler.getString(index + "." + "elastic.host", (String)settings.elastic_host.getDefaultValue()));
        settings.elastic_service_name.set((Object)propFileHandler.getString(index + "." + "elastic.service_name", (String)settings.elastic_service_name.getDefaultValue()));
        settings.elastic_connector_type.set((Object)propFileHandler.getString(index + "." + "elastic.connector.type", (String)settings.elastic_connector_type.getDefaultValue()));
        settings.elastic_connector_rest_port.set((Object)propFileHandler.getInt(index + "." + "elastic.connector.rest.port", (Integer)settings.elastic_connector_rest_port.getDefaultValue()));
        settings.elastic_dr_sync_onstartup.set((Object)propFileHandler.getBoolean(index + "." + "elastic.dr.sync.on_startup", (Boolean)settings.elastic_dr_sync_onstartup.getDefaultValue()));
        return new ElasticNode(settings);
    }

    public static ElasticNode build(String host, String connectorType, int port) throws Exception {
        ElasticNodeSettings settings = new ElasticNodeSettings();
        settings.elastic_host.set((Object)host);
        settings.elastic_service_name.set(settings.elastic_service_name.getDefaultValue());
        settings.elastic_connector_type.set((Object)connectorType);
        settings.elastic_connector_rest_port.set((Object)port);
        settings.elastic_dr_sync_onstartup.set(settings.elastic_dr_sync_onstartup.getDefaultValue());
        return new ElasticNode(settings);
    }

    public void createIndexTemplates() throws Exception {
        JSONObject templateList = this.drNetCalls.getIndexTemplateList();
        ArrayList<CtlrDataRepository> repoList = DE.DR().getDataRepositories();
        for (CtlrDataRepository dataRepo : repoList) {
            ElasticCtlrDataRepository elasticDataRepo = (ElasticCtlrDataRepository)dataRepo;
            if (!templateList.has(elasticDataRepo.getElasticIndexTemplateName())) {
                LOGGER.info("Index Template '" + elasticDataRepo.getElasticIndexTemplateName() + "' does not exist!!");
                this.drNetCalls.createIndexTemplate(elasticDataRepo.getElasticIndexTemplateName(), elasticDataRepo.getElasticIndexTemplateContent());
                if (elasticDataRepo.getHotBlockRotationType().compareTo((Enum)DRBlockRotationType.SIZE) != 0) continue;
                elasticDataRepo.initBlockInfoFile();
                elasticDataRepo.createBlock(URLEncoder.encode(elasticDataRepo.getIndexAlias() + "_0", "UTF-8"), 0L, 0L, 0L, "HOT", true);
                continue;
            }
            LOGGER.info("Index Template '" + elasticDataRepo.getElasticIndexTemplateName() + "' already exists!");
        }
    }

    @Override
    public void start() throws Exception {
        this.getWinService().start();
    }

    @Override
    public void stop() throws Exception {
        this.getWinService().stop();
    }

    @Override
    public JSONObject getStateAndNotifications() {
        return null;
    }

    @Override
    public JSONObject refreshStateAndNotifications() {
        return null;
    }

    @Override
    public long getDownTime() {
        return 0L;
    }
}

