/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine.node;

import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.controller.connector.netcalls.ElasticRestAdminNetCalls;
import com.manageengine.dataengine.controller.connector.netcalls.ElasticRestDRNetCalls;
import com.manageengine.dataengine.controller.engine.node.DENode;
import com.manageengine.dataengine.controller.engine.node.DENodes;
import com.manageengine.dataengine.controller.engine.node.ElasticNode;
import com.manageengine.dataengine.controller.engine.node.winservice.WinServiceState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ElasticNodes
extends DENodes {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private static String elasticNodesState = "red";
    private static HashMap<String, ElasticNode> elasticNodes;
    private static ElasticNode localNode;

    public ElasticNodes() {
        elasticNodes = new HashMap();
    }

    @Override
    public JSONObject getStateAndNotifications() {
        return null;
    }

    @Override
    public JSONObject refreshStateAndNotifications() {
        return null;
    }

    @Override
    public void start() throws Exception {
        int upCount = 0;
        for (ElasticNode node : elasticNodes.values()) {
            node.start();
            if (node.getWinService().getServiceState() != WinServiceState.RUNNING) continue;
            ++upCount;
            LOGGER.info("Going to SYNC datarepository with node " + node.getNodeHost());
            if (((Boolean)node.getSettings().elastic_dr_sync_onstartup.value()).booleanValue()) {
                node.createIndexTemplates();
                LOGGER.info("SYNCED datarepository with node " + node.getNodeHost());
                continue;
            }
            LOGGER.info("Datarepository SYNC DISABLED for node " + node.getNodeHost());
        }
        elasticNodesState = elasticNodes.size() == upCount ? "GREEN" : (upCount == 0 ? "RED" : "ORANGE");
    }

    @Override
    public void stop() throws Exception {
        for (ElasticNode node : elasticNodes.values()) {
            node.stop();
        }
    }

    @Override
    public void start(String host) throws Exception {
        this.node(host).start();
    }

    @Override
    public void stop(String host) throws Exception {
        this.node(host).stop();
    }

    @Override
    public ElasticRestAdminNetCalls admin(String host) {
        return this.node(host).admin();
    }

    @Override
    public ElasticRestDRNetCalls DR(String host) {
        return this.node(host).DR();
    }

    @Override
    public ElasticNode node(String host) {
        ElasticNode node = elasticNodes.get(host);
        if (node == null) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("local") || host.equalsIgnoreCase("127.0.0.1")) {
                node = localNode;
            } else {
                throw new NoSuchElementException("EXCEPTION : Elastic Node for " + host + " not found!");
            }
        }
        return node;
    }

    @Override
    public ElasticNode localNode() {
        return localNode;
    }

    @Override
    public ArrayList<DENode> nodes() {
        return new ArrayList<DENode>(elasticNodes.values());
    }

    @Override
    public void addNode(PropertiesFileUtil.PropertiesFileHandle propFileHandler, int index) throws Exception {
        ElasticNode node = ElasticNode.build(propFileHandler, index);
        elasticNodes.put(node.getNodeHost(), node);
        if (node.isLocal()) {
            localNode = node;
        }
    }

    static {
        localNode = null;
    }
}

